/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.deployment.main;

import com.sun.ejb.ejbql.EjbQLParseException;
import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.ApplicationArchivist;
import com.sun.enterprise.deployment.ConnectorArchivist;
import com.sun.enterprise.resource.ConfigurationPropertyException;
import com.sun.enterprise.resource.ConnectorInfo;
import com.sun.enterprise.resource.DuplicateNameException;
import com.sun.enterprise.resource.NameNotFoundException;
import com.sun.enterprise.tools.deployment.backend.JarInstaller;
import com.sun.enterprise.tools.deployment.main.DeployTool;
import com.sun.enterprise.tools.deployment.main.Log;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.enterprise.util.Utility;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;

public class Main {
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(class$com$sun$enterprise$tools$deployment$main$Main == null ? (class$com$sun$enterprise$tools$deployment$main$Main = Main.class$("com.sun.enterprise.tools.deployment.main.Main")) : class$com$sun$enterprise$tools$deployment$main$Main);
    private static String VERSION = localStrings.getLocalString("enterprise.tools.deployment.main.version", "1.3");
    private static String NAME = localStrings.getLocalString("enterprise.tools.deployment.main.name", "Deployment tool version {0}.", new Object[]{VERSION});
    private static String DEFAULT_STARTUP_MESSAGE = localStrings.getLocalString("enterprise.tools.deployment.main.defaultstartupmessage", "{0} Type deploytool -help for command line options. Starting...", new Object[]{NAME});
    public static String DEPLOY_APPLICATION = "-deploy";
    private static String EJB_WIZARD = "-ejbWizard";
    private static String PACKAGE_EJBS = "-packageEjbs";
    private static String LIST_APPLICATIONS = "-listApps";
    private static String NO_OVER_WRITE = "-noOverWrite";
    private static String DEPLOY_CONNECTOR = "-deployConnector";
    private static String UNDEPLOY_CONNECTOR = "-undeployConnector";
    private static String LIST_CONNECTORS = "-listConnectors";
    private static String ADD_FACTORY = "-addConnectionFactory";
    private static String REMOVE_FACTORY = "-removeConnectionFactory";
    public static String UNINSTALL = "-uninstall";
    public static String GENERATE_SQL = "-generateSQL";
    public static String DONT_OVER_WRITE_SQL = "-noOverWrite";
    public static String UI = "-ui";
    public static String HELP = "-help";
    private static String LOG_NAME = localStrings.getLocalString("enterprise.tools.deployment.main.logname", "Deploytool");
    static /* synthetic */ Class class$com$sun$enterprise$tools$deployment$main$Main;

    public static void main(String[] args) {
        JarInstaller backend;
        String serverName;
        String serverName2;
        Utility.checkJVMVersion();
        if (args.length == 0) {
            System.out.println(DEFAULT_STARTUP_MESSAGE);
            new DeployTool(true);
            return;
        }
        if (args[0].equals(UI)) {
            new DeployTool(true);
            return;
        }
        if (args[0].equals(LIST_APPLICATIONS)) {
            if (args.length >= 2) {
                String server = args[1];
                Main.listApplications(server);
                return;
            }
            Main.help();
            return;
        }
        if (args[0].equals(HELP)) {
            Main.help();
            return;
        }
        if (args[0].equals(EJB_WIZARD)) {
            return;
        }
        DeployTool deployTool = new DeployTool(false);
        if (args[0].equals(DEPLOY_APPLICATION)) {
            int argIndex = 1;
            boolean allowRedeploy = true;
            if (args.length <= argIndex) {
                Main.help();
                return;
            }
            if (args[argIndex].equals(NO_OVER_WRITE)) {
                allowRedeploy = false;
                ++argIndex;
            }
            if (args.length < argIndex + 2) {
                Main.help();
                return;
            }
            String applicationJar = args[argIndex];
            serverName2 = args[++argIndex];
            File clientCodeFile = null;
            if (args.length > ++argIndex) {
                clientCodeFile = new File(args[argIndex]);
            }
            Application toDeploy = null;
            try {
                toDeploy = ApplicationArchivist.open(new File(applicationJar));
            }
            catch (Exception ioe) {
                ioe.printStackTrace();
                Log.print(LOG_NAME, localStrings.getLocalString("enterprise.tools.deployment.main.warning", "{0}", new Object[]{ioe.getMessage()}));
                System.exit(1);
            }
            try {
                boolean isInstalled = deployTool.getServerManager().isInstalled(toDeploy.getName(), serverName2);
                if (isInstalled) {
                    if (!allowRedeploy) {
                        Log.print(LOG_NAME, localStrings.getLocalString("enterprise.tools.deployment.main.logmessagetodeploy", "To deploy the application {0} must be uninstalled before it can be re-deployed", new Object[]{toDeploy.getName()}));
                        System.exit(1);
                    } else {
                        System.out.println("Note : application " + toDeploy.getName() + " is already installed.  Redeploying...");
                    }
                }
                deployTool.deploy(toDeploy, serverName2, null, clientCodeFile);
            }
            catch (Exception t2) {
                Log.print(LOG_NAME, localStrings.getLocalString("enterprise.tools.deployment.main.warning", "{0}", new Object[]{t2.getMessage()}));
                System.exit(1);
            }
            System.exit(0);
        }
        if (args[0].equals(PACKAGE_EJBS)) {
            if (args.length < 5) {
                Main.help();
                return;
            }
            String codebase = args[1];
            String classes = args[2];
            String descriptorFile = args[3];
            String jarFile = args[4];
            Vector<String> classNames = new Vector<String>();
            StringTokenizer st = new StringTokenizer(classes, ":");
            while (st.hasMoreTokens()) {
                classNames.addElement(st.nextToken());
            }
            String optionalEjbBundleFilename = "";
            String optionalRuntimeFiename = "";
            if (args.length > 5) {
                if (args[5] != null) {
                    optionalEjbBundleFilename = args[5];
                }
                if (args[6] != null) {
                    optionalRuntimeFiename = args[6];
                }
            }
            try {
                deployTool.getComponentPackager().packageEjbs(codebase, classNames, descriptorFile, jarFile, optionalEjbBundleFilename, optionalRuntimeFiename);
            }
            catch (Exception e10) {
                deployTool.getComponentPackager().handlePackagingException(e10);
                System.exit(1);
            }
            System.exit(0);
        }
        if (args[0].equals(UNINSTALL)) {
            if (args.length < 3) {
                Main.help();
                return;
            }
            String applicationName = args[1];
            String serverName3 = args[2];
            try {
                if (deployTool.getServerManager().isInstalled(applicationName, serverName3)) {
                    deployTool.getServerManager().undeployApplication(applicationName, serverName3);
                    Log.print(LOG_NAME, localStrings.getLocalString("enterprise.tools.deployment.main.applicationuninstalledfromserver", "The application {0} was uninstalled from {1}", new Object[]{applicationName, serverName3}));
                } else {
                    Log.print(LOG_NAME, localStrings.getLocalString("enterprise.tools.deployment.main.applicationnotdeployed", "The application {0} is not deployed on {1}", new Object[]{applicationName, serverName3}));
                }
                return;
            }
            catch (Exception e11) {
                Log.print(LOG_NAME, e11.getMessage());
                System.exit(1);
            }
        }
        if (args[0].equals(GENERATE_SQL)) {
            String applicationFilename = args[1];
            String serverName4 = args[2];
            boolean overWrite = true;
            if (args.length > 3 && args[3].equals(DONT_OVER_WRITE_SQL)) {
                overWrite = false;
            }
            try {
                deployTool.doGenerateSQL(applicationFilename, serverName4, overWrite);
            }
            catch (EjbQLParseException e12) {
                e12.printStackTrace();
                System.exit(1);
            }
            catch (Throwable t3) {
                t3.printStackTrace();
                System.exit(2);
            }
            return;
        }
        if (args[0].equals(DEPLOY_CONNECTOR)) {
            if (args.length != 3) {
                Main.help();
            }
            int i2 = 1;
            String rarFilename = args[i2++];
            serverName = args[i2++];
            try {
                backend = deployTool.getServerManager().getServerForName(serverName);
                File file = new File(rarFilename);
                if (!file.exists()) {
                    System.out.println(localStrings.getLocalString("deploytool.msg001", "File does not exist: {0}", new Object[]{file.toString()}));
                    System.exit(1);
                }
                if (!ConnectorArchivist.isConnector(file)) {
                    System.out.println(localStrings.getLocalString("deploytool.msg002", "File is not a resource archive: {0}", new Object[]{file.toString()}));
                    System.exit(1);
                }
                byte[] data = new byte[(int)file.length()];
                DataInputStream ds2 = new DataInputStream(new BufferedInputStream(new FileInputStream(file)));
                ds2.readFully(data);
                String name = file.getName();
                backend.deployConnector(data, name);
                System.out.println(localStrings.getLocalString("deploytool.msg003", "Resource adapter {0} is deployed successfully", new Object[]{name}));
            }
            catch (Exception ex2) {
                Main.handleDeploymentException(ex2);
            }
            return;
        }
        if (args[0].equals(ADD_FACTORY)) {
            if (args.length < 4) {
                Main.help();
            }
            int i3 = 1;
            String name = args[i3++];
            String jndiName = args[i3++];
            serverName2 = args[i3++];
            Properties props = new Properties();
            while (i3 < args.length) {
                String str = args[i3++];
                int idx = str.indexOf(61);
                String propName = str.substring(0, idx);
                String val = str.substring(idx + 1);
                if (val.startsWith("\"") && val.endsWith("\"")) {
                    val = val.substring(1, val.length() - 1);
                }
                if (val.startsWith("'") && val.endsWith("'")) {
                    val = val.substring(1, val.length() - 1);
                }
                ((Hashtable)props).put(propName, val);
            }
            try {
                JarInstaller backend2 = deployTool.getServerManager().getServerForName(serverName2);
                String appName = null;
                String connectorName = name;
                int index = name.indexOf(58);
                if (index != -1) {
                    appName = name.substring(0, index);
                    connectorName = name.substring(index + 1);
                }
                backend2.addConnectionFactory(appName, connectorName, jndiName, null, null, props);
                System.out.println("Connector factory " + jndiName + " is added successfully");
            }
            catch (Exception ex3) {
                Main.handleDeploymentException(ex3);
            }
            return;
        }
        if (args[0].equals(REMOVE_FACTORY)) {
            if (args.length != 3) {
                Main.help();
            }
            int i4 = 1;
            String jndiName = args[i4++];
            serverName = args[i4++];
            try {
                backend = deployTool.getServerManager().getServerForName(serverName);
                backend.removeConnectionFactory(jndiName);
                System.out.println("Connector factory " + jndiName + " is removed successfully");
            }
            catch (Exception ex4) {
                Main.handleDeploymentException(ex4);
            }
            return;
        }
        if (args[0].equals(UNDEPLOY_CONNECTOR)) {
            if (args.length != 3) {
                Main.help();
            }
            int i5 = 1;
            String name = args[i5++];
            serverName = args[i5++];
            try {
                backend = deployTool.getServerManager().getServerForName(serverName);
                backend.undeployConnector(name);
                System.out.println(localStrings.getLocalString("deploytool.msg004", "Resource adapter {0} is undeployed successfully", new Object[]{name}));
            }
            catch (NameNotFoundException ex5) {
                String msg = localStrings.getLocalString("connector.not.found", "", new Object[]{name});
                System.out.println(msg);
            }
            catch (Exception ex6) {
                Main.handleDeploymentException(ex6);
            }
            return;
        }
        if (args[0].equals(LIST_CONNECTORS)) {
            if (args.length != 2) {
                Main.help();
            }
            int j2 = 1;
            String serverName5 = args[j2++];
            try {
                JarInstaller backend3 = deployTool.getServerManager().getServerForName(serverName5);
                ConnectorInfo v2 = backend3.listConnectors();
                if (v2.connectors.length == 0) {
                    System.out.println(localStrings.getLocalString("no.connector.installed", ""));
                } else {
                    System.out.println(localStrings.getLocalString("installed.connectors", ""));
                    int size = v2.connectors.length;
                    int i6 = 0;
                    while (i6 < size) {
                        String msg = localStrings.getLocalString("connector.info", "", new Object[]{v2.connectors[i6]});
                        System.out.println(msg);
                        ++i6;
                    }
                }
                System.out.println();
                if (v2.connectionFactories.length == 0) {
                    System.out.println(localStrings.getLocalString("no.factories.installed", ""));
                } else {
                    System.out.println(localStrings.getLocalString("installed.factories", ""));
                    int size = v2.connectionFactories.length;
                    int i7 = 0;
                    while (i7 < size) {
                        String msg = localStrings.getLocalString("factory.info", "", new Object[]{v2.connectionFactories[i7]});
                        System.out.println(msg);
                        ++i7;
                    }
                }
            }
            catch (Exception ex7) {
                Main.handleDeploymentException(ex7);
            }
            return;
        }
        Main.help();
    }

    public static void help() {
        System.out.println(localStrings.getLocalString("enterprise.tools.deployment.main.deploymenttoolversion", "The deployment tool version is {0}", new Object[]{VERSION}));
        System.out.println(localStrings.getLocalString("enterprise.tools.deployment.main.options", "Options:"));
        System.out.print("    ");
        System.out.println(localStrings.getLocalString("enterprise.tools.deployment.main.runstoolwithUI", "{0}    Runs the tool with a UI (default mode)", new Object[]{UI}));
        System.out.print("    ");
        System.out.println(localStrings.getLocalString("enterprise.tools.deployment.main.displayhelpmessage", "{0}    Display this help message", new Object[]{HELP}));
        System.out.print("    ");
        System.out.println(localStrings.getLocalString("enterprise.tools.deployment.main.lastparameteroptional", "{0} <ear file> <server name> [<client jar>]", new Object[]{DEPLOY_APPLICATION}));
        System.out.print("    ");
        System.out.println(localStrings.getLocalString("enterprise.tools.deployment.main.uninstallapplicationfromserver", "{0} <application name> <server name>", new Object[]{UNINSTALL}));
        System.out.print("    ");
        System.out.println(localStrings.getLocalString("enterprise.tools.deployment.main.listApps", "{0} <server name>", new Object[]{LIST_APPLICATIONS}));
        System.out.print("    ");
        System.out.println(localStrings.getLocalString("enterprise.tools.deployment.main.deployConnector", "{0} <rar filename> <server name>", new Object[]{DEPLOY_CONNECTOR}));
        System.out.print("    ");
        System.out.println(localStrings.getLocalString("enterprise.tools.deployment.main.undeployConnector", "{0} <rar filename> <server name>", new Object[]{UNDEPLOY_CONNECTOR}));
        System.out.print("    ");
        System.out.println(localStrings.getLocalString("enterprise.tools.deployment.main.listConnectors", "{0} <server name>", new Object[]{LIST_CONNECTORS}));
        System.exit(1);
    }

    public static void listApplications(String serverName) {
        try {
            DeployTool deployTool = new DeployTool(false);
            JarInstaller backend = deployTool.getServerManager().getServerForName(serverName);
            Vector deployedApps = backend.getApplicationNames();
            if (deployedApps.size() > 0) {
                System.out.println(localStrings.getLocalString("enterprise.tools.deployment.main.followingapps", "The following apps are deployed on ") + serverName + ":");
                int appIndex = 0;
                while (appIndex < deployedApps.size()) {
                    System.out.println("\t" + (String)deployedApps.elementAt(appIndex));
                    ++appIndex;
                }
            } else {
                System.out.println(localStrings.getLocalString("enterprise.tools.deployment.main.nodeployedapps", "There are no deployed applications on ") + serverName);
            }
        }
        catch (Exception e10) {
            Log.print(LOG_NAME, e10.getMessage());
        }
    }

    private static void handleDeploymentException(Exception ex2) {
        if (ex2 instanceof DuplicateNameException) {
            String msg = localStrings.getLocalString("duplicatename.exception", "", new Object[]{ex2.getMessage()});
            System.err.println(msg);
        } else if (ex2 instanceof NameNotFoundException) {
            String msg = localStrings.getLocalString("namenotfound.exception", "", new Object[]{ex2.getMessage()});
            System.err.println(msg);
        } else if (ex2 instanceof ConfigurationPropertyException) {
            String msg = localStrings.getLocalString("configproperty.exception", "", new Object[]{ex2.getMessage()});
            System.err.println(msg);
        } else {
            String msg = localStrings.getLocalString("generic.exception", "", new Object[]{ex2.toString()});
            System.err.println(msg);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

