/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.deployment.backend;

import com.sun.enterprise.tools.deployment.backend.BufferedRemoteByteArray;
import java.rmi.RemoteException;

public class BufferedRemoteByteArrayImpl
implements BufferedRemoteByteArray {
    private static int CHUNK_LENGTH = 4096;
    private int currentReadIndex = 0;
    private transient byte[] bytes;

    public BufferedRemoteByteArrayImpl(byte[] bytes) {
        if (bytes == null) {
            throw new IllegalArgumentException("Cannot initialize on null bytes");
        }
        this.bytes = bytes;
    }

    public byte[] getBytes() throws RemoteException {
        return this.bytes;
    }

    public int getNextChunkLength() throws RemoteException {
        int length = 0;
        if (this.currentReadIndex == this.bytes.length) {
            length = -1;
        } else if (this.bytes.length - this.currentReadIndex < CHUNK_LENGTH) {
            length = this.bytes.length - this.currentReadIndex;
        } else {
            if (this.currentReadIndex > this.bytes.length) {
                throw new RuntimeException("read index > bytesLength " + this.currentReadIndex + " > " + this.bytes.length);
            }
            length = CHUNK_LENGTH;
        }
        return length;
    }

    public byte[] readNextChunk() throws RemoteException {
        if (this.getNextChunkLength() == -1) {
            throw new RemoteException("Reading off the end of the buffer");
        }
        byte[] nextChunk = new byte[this.getNextChunkLength()];
        System.arraycopy(this.bytes, this.currentReadIndex, nextChunk, 0, nextChunk.length);
        this.currentReadIndex += nextChunk.length;
        return nextChunk;
    }

    public int getLength() throws RemoteException {
        return this.bytes.length;
    }

    public static byte[] getBytesUtility(BufferedRemoteByteArray brba) throws RemoteException {
        byte[] getBytes = new byte[brba.getLength()];
        int index = 0;
        int nextChunkLength = 0;
        while (brba.getNextChunkLength() != -1) {
            nextChunkLength = brba.getNextChunkLength();
            byte[] nextChunk = brba.readNextChunk();
            System.arraycopy(nextChunk, 0, getBytes, index, nextChunkLength);
            index += nextChunkLength;
        }
        return getBytes;
    }
}

