/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.resource;

import com.sun.enterprise.resource.ResourcePrincipal;
import com.sun.enterprise.security.SecurityContext;
import java.io.Serializable;
import java.security.Principal;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class ResourcePrincipalMapper
implements Serializable {
    private Hashtable mapTable = new Hashtable();
    private ResourcePrincipal defaultRP = null;

    public void setDefaultResourcePrincipal(ResourcePrincipal rprinc) {
        this.defaultRP = rprinc;
    }

    public ResourcePrincipal getDefaultResourcePrincipal() {
        return this.defaultRP;
    }

    public void assignResourcePrincipal(Principal p2, ResourcePrincipal rp) {
        this.mapTable.put(p2, rp);
    }

    public Enumeration getPrincipals() {
        return this.mapTable.keys();
    }

    public Enumeration getResourcePrincipals() {
        Vector<ResourcePrincipal> resourcePrincipals = new Vector<ResourcePrincipal>();
        Enumeration e10 = this.mapTable.elements();
        while (e10.hasMoreElements()) {
            ResourcePrincipal nextResourcePrincipal = (ResourcePrincipal)e10.nextElement();
            if (resourcePrincipals.contains(nextResourcePrincipal)) continue;
            resourcePrincipals.addElement(nextResourcePrincipal);
        }
        return resourcePrincipals.elements();
    }

    public Enumeration getPrincipalsFor(ResourcePrincipal resourcePrincipal) {
        Vector<Principal> principals = new Vector<Principal>();
        Enumeration e10 = this.getPrincipals();
        while (e10.hasMoreElements()) {
            Principal nextPrincipal = (Principal)e10.nextElement();
            ResourcePrincipal nextResourcePrincipal = (ResourcePrincipal)this.mapTable.get(nextPrincipal);
            if (!nextResourcePrincipal.equals(resourcePrincipal) || principals.contains(nextPrincipal)) continue;
            principals.addElement(nextPrincipal);
        }
        return principals.elements();
    }

    public ResourcePrincipal getResourcePrincipalFor(Principal principal) {
        return (ResourcePrincipal)this.mapTable.get(principal);
    }

    public void removePrincipal(Principal p2) {
        this.mapTable.remove(p2);
    }

    public ResourcePrincipal getResourcePrincipal() {
        ResourcePrincipal rp;
        Principal p2;
        SecurityContext sc = SecurityContext.getCurrent();
        if (sc != null && (p2 = sc.getCallerPrincipal()) != null && (rp = (ResourcePrincipal)this.mapTable.get(p2)) != null) {
            return rp;
        }
        return this.defaultRP;
    }

    public String toString() {
        String s2 = "ResourcePrincipaMapper: ";
        if (this.defaultRP != null) {
            s2 = s2 + "dflt:" + this.defaultRP.getName();
        }
        Enumeration e10 = this.getPrincipals();
        while (e10.hasMoreElements()) {
            Principal nextPrincipal = (Principal)e10.nextElement();
            ResourcePrincipal resourcePrincipal = this.getResourcePrincipalFor(nextPrincipal);
            s2 = s2 + "," + nextPrincipal.getName() + "->" + resourcePrincipal.getName();
        }
        return s2;
    }
}

