/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.resource;

import com.sun.enterprise.PoolManager;
import com.sun.enterprise.resource.ClientSecurityInfo;
import com.sun.enterprise.resource.JdbcXAConnection;
import com.sun.enterprise.resource.PoolingException;
import com.sun.enterprise.resource.ResourceAllocator;
import com.sun.enterprise.resource.ResourceHandle;
import com.sun.enterprise.resource.ResourceSpec;
import java.sql.Connection;
import java.sql.SQLException;
import javax.sql.ConnectionEvent;
import javax.sql.ConnectionEventListener;
import javax.sql.XAConnection;
import javax.transaction.xa.XAResource;

public class Jdbc10XaAllocator
implements ResourceAllocator {
    private String jdbcUrl;
    private PoolManager poolMgr;
    private ResourceSpec spec;
    private ClientSecurityInfo info;

    public Jdbc10XaAllocator(PoolManager poolMgr, String jdbcUrl, ResourceSpec spec, ClientSecurityInfo info) {
        this.poolMgr = poolMgr;
        this.spec = spec;
        this.info = info;
        this.jdbcUrl = jdbcUrl;
    }

    public ResourceHandle createResource() throws PoolingException {
        try {
            ResourceSpec newspec = new ResourceSpec(this.jdbcUrl, 0);
            JdbcXAConnection xacon = new JdbcXAConnection(newspec, this.jdbcUrl, this.info, this.poolMgr);
            ResourceHandle resource = new ResourceHandle(xacon, this.spec, this, this.info);
            ConnectionListenerImpl l2 = new ConnectionListenerImpl(resource);
            xacon.addConnectionEventListener(l2);
            return resource;
        }
        catch (Exception ex2) {
            if (ex2 instanceof PoolingException) {
                throw (PoolingException)ex2;
            }
            throw new PoolingException(ex2);
        }
    }

    public void fillInResourceObjects(ResourceHandle resource) throws PoolingException {
        try {
            XAConnection xacon = (XAConnection)resource.getResource();
            Connection con = xacon.getConnection();
            XAResource xares = xacon.getXAResource();
            resource.fillInResourceObjects(con, xares);
        }
        catch (SQLException ex2) {
            throw new PoolingException(ex2);
        }
    }

    public void closeUserConnection(ResourceHandle resource) throws PoolingException {
        try {
            Connection con = (Connection)resource.getUserConnection();
            con.close();
        }
        catch (SQLException ex2) {
            throw new PoolingException(ex2);
        }
    }

    public void destroyResource(ResourceHandle resource) throws PoolingException {
        try {
            this.closeUserConnection(resource);
        }
        catch (Exception ex2) {
            // empty catch block
        }
        try {
            XAConnection xacon = (XAConnection)resource.getResource();
            xacon.close();
        }
        catch (SQLException ex3) {
            throw new PoolingException(ex3);
        }
    }

    public boolean matchConnection(ResourceHandle h2) {
        return h2.getClientSecurityInfo().equals(this.info);
    }

    public boolean supportsReauthentication() {
        return false;
    }

    public void cleanup(ResourceHandle h2) throws PoolingException {
    }

    public boolean isTransactional() {
        return true;
    }

    public boolean shareableWithinComponent() {
        return false;
    }

    public Object getSharedConnection(ResourceHandle h2) throws PoolingException {
        throw new IllegalStateException("getSharedConnection not supported");
    }

    class ConnectionListenerImpl
    implements ConnectionEventListener {
        private ResourceHandle resource;

        public ConnectionListenerImpl(ResourceHandle resource) {
            this.resource = resource;
        }

        public void connectionClosed(ConnectionEvent evt) {
            Jdbc10XaAllocator.this.poolMgr.resourceClosed(this.resource);
        }

        public void connectionErrorOccurred(ConnectionEvent evt) {
            XAConnection con = (XAConnection)evt.getSource();
            con.removeConnectionEventListener(this);
            Jdbc10XaAllocator.this.poolMgr.resourceErrorOccurred(this.resource);
            try {
                con.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }
}

