/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.jms;

import com.sun.enterprise.ComponentInvocation;
import com.sun.enterprise.InvocationException;
import com.sun.enterprise.InvocationManager;
import com.sun.enterprise.Switch;
import com.sun.enterprise.jms.JmsUtil;
import com.sun.enterprise.jms.JmsWrapperFactory;
import com.sun.enterprise.log.Log;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.io.Serializable;
import javax.jms.ConnectionFactory;
import javax.jms.JMSException;
import javax.jms.QueueConnection;
import javax.jms.QueueConnectionFactory;
import javax.jms.TopicConnection;
import javax.jms.TopicConnectionFactory;

public class ConnectionFactoryWrapperStandalone
implements QueueConnectionFactory,
TopicConnectionFactory,
Serializable {
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(class$com$sun$enterprise$jms$ConnectionFactoryWrapperStandalone == null ? (class$com$sun$enterprise$jms$ConnectionFactoryWrapperStandalone = ConnectionFactoryWrapperStandalone.class$("com.sun.enterprise.jms.ConnectionFactoryWrapperStandalone")) : class$com$sun$enterprise$jms$ConnectionFactoryWrapperStandalone);
    private static final boolean debug = false;
    private ConnectionFactory delegate_;
    private String connectionFactoryJndiName_;
    static /* synthetic */ Class class$com$sun$enterprise$jms$ConnectionFactoryWrapperStandalone;

    public ConnectionFactoryWrapperStandalone(String connectionFactoryJndiName, ConnectionFactory delegate) {
        this.connectionFactoryJndiName_ = connectionFactoryJndiName;
        this.delegate_ = delegate;
    }

    public QueueConnection createQueueConnection() throws JMSException {
        return this.getQueueConnectionFactory().createQueueConnection();
    }

    public QueueConnection createQueueConnection(String userName, String password) throws JMSException {
        return this.getQueueConnectionFactory().createQueueConnection(userName, password);
    }

    public TopicConnection createTopicConnection() throws JMSException {
        return this.getTopicConnectionFactory().createTopicConnection();
    }

    public TopicConnection createTopicConnection(String userName, String password) throws JMSException {
        return this.getTopicConnectionFactory().createTopicConnection(userName, password);
    }

    public ConnectionFactory getDelegate() {
        return this.delegate_;
    }

    private QueueConnectionFactory getQueueConnectionFactory() {
        return (QueueConnectionFactory)this.getDelegate(true);
    }

    private TopicConnectionFactory getTopicConnectionFactory() {
        return (TopicConnectionFactory)this.getDelegate(false);
    }

    private ConnectionFactory getDelegate(boolean pointToPoint) {
        ConnectionFactory connectionFactoryToUse = this.delegate_;
        ComponentInvocation invocation = null;
        InvocationManager invocationMgr = Switch.getSwitch().getInvocationManager();
        if (invocationMgr != null) {
            try {
                invocation = invocationMgr.getCurrentInvocation();
            }
            catch (InvocationException ie) {
                // empty catch block
            }
        }
        if (invocation != null) {
            String errorMsg = localStrings.getLocalString("jms.incorrect.cf.access", "Illegal connection factory access to {0}. J2EE Components should access JMS Connection Factories through a resource-ref in java:comp/env", new Object[]{this.connectionFactoryJndiName_});
            Log.err.println(errorMsg);
            System.err.println(errorMsg);
            JmsWrapperFactory wrapperFactory = null;
            switch (invocation.getInvocationType()) {
                case 0: {
                    wrapperFactory = JmsWrapperFactory.getFactoryForWeb();
                    break;
                }
                case 1: {
                    wrapperFactory = JmsWrapperFactory.getFactoryForEjb();
                    break;
                }
                case 2: {
                    wrapperFactory = JmsWrapperFactory.getFactoryForJavaClient();
                    break;
                }
                default: {
                    throw new IllegalStateException("unknown comp type = " + invocation.getInvocationType());
                }
            }
            String xaConnectionFactoryName = JmsUtil.getXAConnectionFactoryName(this.connectionFactoryJndiName_);
            connectionFactoryToUse = pointToPoint ? wrapperFactory.createQueueConnectionFactoryWrapper(xaConnectionFactoryName) : wrapperFactory.createTopicConnectionFactoryWrapper(xaConnectionFactoryName);
        }
        return connectionFactoryToUse;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

