/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment.xml;

import com.sun.enterprise.deployment.AuthMechanism;
import com.sun.enterprise.deployment.ConnectorDescriptor;
import com.sun.enterprise.deployment.EnvironmentProperty;
import com.sun.enterprise.deployment.SecurityPermission;
import com.sun.enterprise.deployment.xml.ConnectorTagNames;
import com.sun.enterprise.deployment.xml.ContentTransformationException;
import com.sun.enterprise.deployment.xml.DescriptorNodeUtils;
import com.sun.enterprise.deployment.xml.ParseException;
import com.sun.enterprise.deployment.xml.XMLUtils;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.apache.crimson.tree.ElementNode;
import org.apache.crimson.tree.XmlDocument;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class ConnectorNode
extends ElementNode
implements ConnectorTagNames {
    public static String PUBLIC_DTD_ID = "-//Sun Microsystems, Inc.//DTD Connector 1.0//EN";
    public static String SYSTEM_ID = "http://java.sun.com/dtd/connector_1_0.dtd";
    public static String DD_BASIC_PASSWORD = "BasicPassword";
    public static String DD_KERBEROS = "Kerbv5";
    public static String DD_NO_TRANSACTION = "NoTransaction";
    public static String DD_LOCAL_TRANSACTION = "LocalTransaction";
    public static String DD_XA_TRANSACTION = "XATransaction";
    static /* synthetic */ Class class$com$sun$enterprise$deployment$xml$ConnectorNode;

    public ConnectorNode() {
        this.setTag("connector");
    }

    public void setDescriptor(ConnectorDescriptor descriptor) {
        if (this.getOwnerDocument() == null) {
            throw new IllegalArgumentException("Cannot set the descriptor unless this node has been added to a document");
        }
        XMLUtils factory = new XMLUtils(this.getOwnerDocument());
        DescriptorNodeUtils.appendDescriptorAttributes(factory, descriptor, this, DescriptorNodeUtils.CONNECTOR_STYLE);
        DescriptorNodeUtils.appendOtherDescriptorAttribs(factory, descriptor, this);
        DescriptorNodeUtils.appendResourceAdapter(factory, descriptor, this);
    }

    public ConnectorDescriptor getDescriptor() throws ContentTransformationException {
        ElementNode currentNode = this;
        try {
            String type;
            String desc;
            ConnectorDescriptor descriptor = new ConnectorDescriptor();
            descriptor.setConnectionFactoryInterface(XMLUtils.getTextFor(this, "connectionfactory-interface"));
            descriptor.setConnectionFactoryImpl(XMLUtils.getTextFor(this, "connectionfactory-impl-class"));
            descriptor.setConnectionInterface(XMLUtils.getTextFor(this, "connection-interface"));
            descriptor.setConnectionImpl(XMLUtils.getTextFor(this, "connection-impl-class"));
            descriptor.setManagedConnectionFactoryImpl(XMLUtils.getTextFor(this, "managedconnectionfactory-class"));
            String reauth = XMLUtils.getTextFor(this, "reauthentication-support");
            descriptor.setReauthenticationSupport(Boolean.valueOf(reauth));
            descriptor.setName(XMLUtils.getTextFor(this, "display-name"));
            ElementNode node = XMLUtils.getFirstNodeUnder(this, "license");
            if (node != null) {
                String licenseReq = XMLUtils.getTextFor(node, "license-required");
                descriptor.setLicenseRequired(Boolean.valueOf(licenseReq));
                if (XMLUtils.hasNodesUnder(node, "description")) {
                    descriptor.setLicenseDescription(XMLUtils.getTextFor(node, "description"));
                }
            }
            if (XMLUtils.hasNodesUnder(this, "description")) {
                descriptor.setConnectorDescription(XMLUtils.getTextFor(this, "description"));
            }
            descriptor.setEisType(XMLUtils.getTextFor(this, "eis-type"));
            if (XMLUtils.hasNodesUnder(this, "large-icon")) {
                descriptor.setLargeIconUri(XMLUtils.getTextFor(this, "large-icon"));
            }
            if (XMLUtils.hasNodesUnder(this, "small-icon")) {
                descriptor.setSmallIconUri(XMLUtils.getTextFor(this, "small-icon"));
            }
            descriptor.setSpecVersion(XMLUtils.getTextFor(this, "spec-version"));
            descriptor.setVendorName(XMLUtils.getTextFor(this, "vendor-name"));
            descriptor.setVersion(XMLUtils.getTextFor(this, "version"));
            String tx = XMLUtils.getTextFor(this, "transaction-support");
            int txVal = 0;
            if (tx.equals(DD_XA_TRANSACTION)) {
                txVal = 2;
            } else if (tx.equals(DD_LOCAL_TRANSACTION)) {
                txVal = 1;
            } else if (tx.equals(DD_NO_TRANSACTION)) {
                txVal = 0;
            } else {
                throw new IllegalArgumentException("Invalid transaction support value");
            }
            descriptor.setTransactionSupport(txVal);
            Enumeration e10 = XMLUtils.getNodesUnder((Node)this, "config-property");
            while (e10.hasMoreElements()) {
                node = (ElementNode)e10.nextElement();
                currentNode = node;
                desc = "";
                if (XMLUtils.hasNodesUnder(node, "description")) {
                    desc = XMLUtils.getTextFor(node, "description");
                }
                type = XMLUtils.getTextFor(node, "config-property-type");
                String name = XMLUtils.getTextFor(node, "config-property-name");
                String value = "";
                if (XMLUtils.hasNodesUnder(node, "config-property-value")) {
                    value = XMLUtils.getTextFor(node, "config-property-value");
                }
                EnvironmentProperty env = new EnvironmentProperty(name, value, desc, type);
                descriptor.addConfigProperty(env);
            }
            e10 = XMLUtils.getNodesUnder((Node)this, "security-permission");
            while (e10.hasMoreElements()) {
                node = (ElementNode)e10.nextElement();
                currentNode = node;
                desc = "";
                if (XMLUtils.hasNodesUnder(node, "description")) {
                    desc = XMLUtils.getTextFor(node, "description");
                }
                type = XMLUtils.getTextFor(node, "security-permission-spec");
                SecurityPermission sec = new SecurityPermission(desc, type);
                descriptor.addSecurityPermission(sec);
            }
            e10 = XMLUtils.getNodesUnder((Node)this, "authentication-mechanism");
            while (e10.hasMoreElements()) {
                node = (ElementNode)e10.nextElement();
                currentNode = node;
                desc = "";
                if (XMLUtils.hasNodesUnder(node, "description")) {
                    desc = XMLUtils.getTextFor(node, "description");
                }
                type = XMLUtils.getTextFor(node, "authentication-mechanism-type");
                int mechVal = 0;
                if (type.equals(DD_BASIC_PASSWORD)) {
                    mechVal = 0;
                } else if (type.equals(DD_KERBEROS)) {
                    mechVal = 1;
                } else {
                    throw new IllegalArgumentException("Invalid auth-mech-type");
                }
                String credInfVal = XMLUtils.getTextFor(node, "credential-interface");
                AuthMechanism auth = new AuthMechanism(desc, mechVal, credInfVal);
                descriptor.addAuthMechanism(auth);
            }
            return descriptor;
        }
        catch (IllegalArgumentException iae) {
            throw new ContentTransformationException(iae.getMessage(), currentNode.toString());
        }
    }

    public static Vector readConnectorNodes(InputStream is) throws ParseException {
        try {
            Hashtable<String, String> nodeToClass = new Hashtable<String, String>();
            nodeToClass.put("connector", "com.sun.enterprise.deployment.xml.ConnectorNode");
            return XMLUtils.getNodesByType(class$com$sun$enterprise$deployment$xml$ConnectorNode == null ? (class$com$sun$enterprise$deployment$xml$ConnectorNode = ConnectorNode.class$("com.sun.enterprise.deployment.xml.ConnectorNode")) : class$com$sun$enterprise$deployment$xml$ConnectorNode, nodeToClass, is);
        }
        catch (SAXException se) {
            throw new ParseException(se);
        }
        catch (Throwable t2) {
            throw new ParseException(t2.getMessage());
        }
    }

    public static XmlDocument getDocument(ConnectorDescriptor descriptor) {
        XmlDocument xmlDocument = new XmlDocument();
        xmlDocument.setDoctype(PUBLIC_DTD_ID, SYSTEM_ID, null);
        ConnectorNode n2 = new ConnectorNode();
        xmlDocument.appendChild(n2);
        n2.setDescriptor(descriptor);
        return xmlDocument;
    }

    public static ConnectorNode read(InputStream is) throws ParseException {
        Vector acNodes = ConnectorNode.readConnectorNodes(is);
        if (acNodes.size() > 0) {
            return (ConnectorNode)acNodes.elementAt(0);
        }
        throw new ParseException("No connector nodes could be found");
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

