/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment.web;

import com.sun.enterprise.deployment.JmsDestinationReferenceDescriptor;
import com.sun.enterprise.deployment.RunAsIdentityDescriptor;
import com.sun.enterprise.deployment.WritableJndiNameEnvironment;
import com.sun.enterprise.deployment.web.AppListenerDescriptor;
import com.sun.enterprise.deployment.web.AuthorizationConstraint;
import com.sun.enterprise.deployment.web.Constants;
import com.sun.enterprise.deployment.web.ContextParameter;
import com.sun.enterprise.deployment.web.EjbReference;
import com.sun.enterprise.deployment.web.EnvironmentEntry;
import com.sun.enterprise.deployment.web.ErrorPageDescriptor;
import com.sun.enterprise.deployment.web.InitializationParameter;
import com.sun.enterprise.deployment.web.JspDescriptor;
import com.sun.enterprise.deployment.web.LoginConfiguration;
import com.sun.enterprise.deployment.web.MimeMapping;
import com.sun.enterprise.deployment.web.ResourceReference;
import com.sun.enterprise.deployment.web.SecurityConstraint;
import com.sun.enterprise.deployment.web.SecurityRole;
import com.sun.enterprise.deployment.web.SecurityRoleReference;
import com.sun.enterprise.deployment.web.ServletDescriptor;
import com.sun.enterprise.deployment.web.ServletFilter;
import com.sun.enterprise.deployment.web.ServletFilterMapping;
import com.sun.enterprise.deployment.web.TagLibConfig;
import com.sun.enterprise.deployment.web.UserDataConstraint;
import com.sun.enterprise.deployment.web.WebApplicationDescriptor;
import com.sun.enterprise.deployment.web.WebComponentDescriptor;
import com.sun.enterprise.deployment.web.WebDescriptorFactory;
import com.sun.enterprise.deployment.web.WebResourceCollection;
import com.sun.enterprise.deployment.xml.XMLParser;
import com.sun.enterprise.deployment.xml.XMLTree;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Vector;

public class WebApplicationReader {
    private WebDescriptorFactory factory = null;
    private WebApplicationDescriptor webApplicationDescriptor = null;
    private XMLTree config = null;
    private static final boolean DefaultXMLValidation = true;
    static /* synthetic */ Class class$com$sun$enterprise$deployment$web$WebApplicationDescriptor;
    static /* synthetic */ Class class$com$sun$enterprise$deployment$web$ContextParameter;
    static /* synthetic */ Class class$com$sun$enterprise$deployment$web$TagLibConfig;
    static /* synthetic */ Class class$com$sun$enterprise$deployment$web$ErrorPageDescriptor;
    static /* synthetic */ Class class$com$sun$enterprise$deployment$web$AppListenerDescriptor;
    static /* synthetic */ Class class$com$sun$enterprise$deployment$web$ResourceReference;
    static /* synthetic */ Class class$com$sun$enterprise$deployment$web$SecurityConstraint;
    static /* synthetic */ Class class$com$sun$enterprise$deployment$web$WebResourceCollection;
    static /* synthetic */ Class class$com$sun$enterprise$deployment$web$AuthorizationConstraint;
    static /* synthetic */ Class class$com$sun$enterprise$deployment$web$SecurityRole;
    static /* synthetic */ Class class$com$sun$enterprise$deployment$web$UserDataConstraint;
    static /* synthetic */ Class class$com$sun$enterprise$deployment$web$LoginConfiguration;
    static /* synthetic */ Class class$com$sun$enterprise$deployment$web$EnvironmentEntry;
    static /* synthetic */ Class class$com$sun$enterprise$deployment$web$EjbReference;
    static /* synthetic */ Class class$com$sun$enterprise$deployment$web$MimeMapping;
    static /* synthetic */ Class class$com$sun$enterprise$deployment$web$ServletDescriptor;
    static /* synthetic */ Class class$com$sun$enterprise$deployment$web$JspDescriptor;
    static /* synthetic */ Class class$com$sun$enterprise$deployment$web$InitializationParameter;
    static /* synthetic */ Class class$com$sun$enterprise$deployment$web$SecurityRoleReference;
    static /* synthetic */ Class class$com$sun$enterprise$deployment$web$ServletFilter;
    static /* synthetic */ Class class$com$sun$enterprise$deployment$web$ServletFilterMapping;

    public WebApplicationDescriptor getDescriptor(InputStream inputStream, WebDescriptorFactory factory) throws Exception {
        return this.getDescriptor(inputStream, factory, true);
    }

    public WebApplicationDescriptor getDescriptor(InputStream inputStream, WebDescriptorFactory factory, boolean validate) throws Exception {
        if (inputStream == null) {
            String msg = "null inputStream";
            throw new NullPointerException(msg);
        }
        if (factory == null) {
            String msg = "null factory";
            throw new NullPointerException(msg);
        }
        this.factory = factory;
        try {
            this.config = new XMLParser().process(inputStream, validate);
        }
        catch (Exception e10) {
            String msg = "can't read config: " + e10.getMessage();
            throw new IllegalStateException(msg);
        }
        try {
            this.webApplicationDescriptor = (WebApplicationDescriptor)factory.createDescriptor(class$com$sun$enterprise$deployment$web$WebApplicationDescriptor == null ? (class$com$sun$enterprise$deployment$web$WebApplicationDescriptor = WebApplicationReader.class$("com.sun.enterprise.deployment.web.WebApplicationDescriptor")) : class$com$sun$enterprise$deployment$web$WebApplicationDescriptor);
            if (!this.config.getName().equals("web-app")) {
                String msg = "parsing error";
                throw new IllegalStateException(msg);
            }
            this.processIcon();
            this.processDisplayName();
            this.processDescription();
            this.processDistributable();
            this.processContextParameters();
            this.processServletFilters();
            this.processServletFilterMappings();
            this.processListeners();
            this.processServlets();
            this.processServletMappings();
            this.processSessionTimeOut();
            this.processMIMEMappings();
            this.processWelcomeFiles();
            this.processErrorPages();
            this.processResourceReferences();
            this.processSecurityConstraints();
            this.processLoginConfig();
            this.processSecurityRoles();
            this.processEnvironmentEntries();
            this.processEjbReferences();
            this.processJmsDestinationReferences();
            this.processTagLibConfigs();
            return this.webApplicationDescriptor;
        }
        catch (Throwable t2) {
            String msg = "parsing error: " + t2.getMessage();
            throw new Exception(msg);
        }
    }

    private void processIcon() {
        XMLTree iconTree = this.config.getFirstElement(Constants.ICON);
        if (iconTree != null) {
            XMLTree largeIconTree;
            XMLTree smallIconTree = iconTree.getFirstElement(Constants.SMALL_ICON);
            if (smallIconTree != null) {
                this.webApplicationDescriptor.setSmallIconUri(smallIconTree.getValue());
            }
            if ((largeIconTree = iconTree.getFirstElement(Constants.LARGE_ICON)) != null) {
                this.webApplicationDescriptor.setLargeIconUri(largeIconTree.getValue());
            }
        }
    }

    private void processDisplayName() {
        XMLTree displayNameTree = this.config.getFirstElement(Constants.DISPLAY_NAME);
        if (displayNameTree != null) {
            this.webApplicationDescriptor.setName(displayNameTree.getValue());
        }
    }

    private void processDescription() {
        XMLTree descriptionTree = this.config.getFirstElement(Constants.DESCRIPTION);
        if (descriptionTree != null) {
            this.webApplicationDescriptor.setDescription(descriptionTree.getValue());
        }
    }

    private void processDistributable() {
        this.webApplicationDescriptor.setDistributable(this.config.getFirstElement(Constants.DISTRIBUTABLE) != null);
    }

    private void processContextParameters() {
        Enumeration enumeration = this.config.elements(Constants.CONTEXT_PARAMETER);
        while (enumeration.hasMoreElements()) {
            XMLTree next = (XMLTree)enumeration.nextElement();
            ContextParameter param = (ContextParameter)this.factory.createDescriptor(class$com$sun$enterprise$deployment$web$ContextParameter == null ? WebApplicationReader.class$("com.sun.enterprise.deployment.web.ContextParameter") : class$com$sun$enterprise$deployment$web$ContextParameter);
            if (next.getFirstElement(Constants.DESCRIPTION) != null) {
                param.setDescription(next.getFirstElement(Constants.DESCRIPTION).getValue());
            }
            param.setName(next.getFirstElement("param-name").getValue());
            param.setValue(next.getFirstElement("param-value").getValue());
            this.webApplicationDescriptor.addContextParameter(param);
        }
    }

    private void processTagLibConfigs() {
        Enumeration enumeration = this.config.elements("taglib");
        while (enumeration.hasMoreElements()) {
            XMLTree next = (XMLTree)enumeration.nextElement();
            TagLibConfig config = (TagLibConfig)this.factory.createDescriptor(class$com$sun$enterprise$deployment$web$TagLibConfig == null ? WebApplicationReader.class$("com.sun.enterprise.deployment.web.TagLibConfig") : class$com$sun$enterprise$deployment$web$TagLibConfig);
            config.setTagLibURI(next.getFirstElement("taglib-uri").getValue());
            config.setTagLibLocation(next.getFirstElement("taglib-location").getValue());
            this.webApplicationDescriptor.addTagLibConfig(config);
        }
    }

    private void processErrorPages() {
        Enumeration enumeration = this.config.elements(Constants.ERROR_PAGE);
        while (enumeration.hasMoreElements()) {
            XMLTree next = (XMLTree)enumeration.nextElement();
            ErrorPageDescriptor epd = (ErrorPageDescriptor)this.factory.createDescriptor(class$com$sun$enterprise$deployment$web$ErrorPageDescriptor == null ? WebApplicationReader.class$("com.sun.enterprise.deployment.web.ErrorPageDescriptor") : class$com$sun$enterprise$deployment$web$ErrorPageDescriptor);
            if (next.getFirstElement(Constants.ERROR_CODE) != null) {
                Integer errorCode = new Integer(next.getFirstElement(Constants.ERROR_CODE).getValue());
                epd.setErrorCode(errorCode);
            } else if (next.getFirstElement(Constants.EXCEPTION_TYPE) != null) {
                epd.setExceptionType(next.getFirstElement(Constants.EXCEPTION_TYPE).getValue());
            }
            epd.setLocation(next.getFirstElement(Constants.LOCATION).getValue());
            this.webApplicationDescriptor.addErrorPageDescriptor(epd);
        }
    }

    private void processListeners() {
        Enumeration enumeration = this.config.elements(Constants.LISTENER);
        while (enumeration.hasMoreElements()) {
            XMLTree next = (XMLTree)enumeration.nextElement();
            AppListenerDescriptor epd = (AppListenerDescriptor)this.factory.createDescriptor(class$com$sun$enterprise$deployment$web$AppListenerDescriptor == null ? WebApplicationReader.class$("com.sun.enterprise.deployment.web.AppListenerDescriptor") : class$com$sun$enterprise$deployment$web$AppListenerDescriptor);
            if (next.getFirstElement(Constants.LISTENER_CLASS) != null) {
                epd.setListener(next.getFirstElement(Constants.LISTENER_CLASS).getValue());
            }
            this.webApplicationDescriptor.addAppListenerDescriptor(epd);
        }
    }

    private void processResourceReferences() {
        Enumeration enumeration = this.config.elements(Constants.RESOURCE_REFERENCE);
        while (enumeration.hasMoreElements()) {
            XMLTree next = (XMLTree)enumeration.nextElement();
            ResourceReference rrd = (ResourceReference)this.factory.createDescriptor(class$com$sun$enterprise$deployment$web$ResourceReference == null ? WebApplicationReader.class$("com.sun.enterprise.deployment.web.ResourceReference") : class$com$sun$enterprise$deployment$web$ResourceReference);
            rrd.setName(next.getFirstElement(Constants.RESOURCE_REFERENCE_NAME).getValue());
            if (next.getFirstElement(Constants.DESCRIPTION) != null) {
                rrd.setDescription(next.getFirstElement(Constants.DESCRIPTION).getValue());
            }
            rrd.setType(next.getFirstElement(Constants.RESOURCE_TYPE).getValue());
            rrd.setAuthorization(next.getFirstElement(Constants.RESOURCE_AUTHORIZATION).getValue());
            this.webApplicationDescriptor.addResourceReference(rrd);
        }
    }

    private void processSecurityConstraints() {
        Enumeration e10 = this.config.elements(Constants.SECURITY_CONSTRAINT);
        while (e10.hasMoreElements()) {
            XMLTree udcTree;
            XMLTree scTree = (XMLTree)e10.nextElement();
            SecurityConstraint sc = (SecurityConstraint)this.factory.createDescriptor(class$com$sun$enterprise$deployment$web$SecurityConstraint == null ? WebApplicationReader.class$("com.sun.enterprise.deployment.web.SecurityConstraint") : class$com$sun$enterprise$deployment$web$SecurityConstraint);
            Enumeration ee2 = scTree.elements(Constants.WEB_RESOURCE_COLLECTION);
            while (ee2.hasMoreElements()) {
                XMLTree wrcTree = (XMLTree)ee2.nextElement();
                WebResourceCollection wrc = (WebResourceCollection)this.factory.createDescriptor(class$com$sun$enterprise$deployment$web$WebResourceCollection == null ? WebApplicationReader.class$("com.sun.enterprise.deployment.web.WebResourceCollection") : class$com$sun$enterprise$deployment$web$WebResourceCollection);
                wrc.setName(wrcTree.getFirstElement(Constants.WEB_RESOURCE_NAME).getValue());
                if (wrcTree.getFirstElement(Constants.DESCRIPTION) != null) {
                    wrc.setDescription(wrcTree.getFirstElement(Constants.DESCRIPTION).getValue());
                }
                Enumeration eee = wrcTree.elements(Constants.URL_PATTERN);
                while (eee.hasMoreElements()) {
                    XMLTree upTree = (XMLTree)eee.nextElement();
                    wrc.addUrlPattern(upTree.getValue());
                }
                Enumeration eee2 = wrcTree.elements(Constants.HTTP_METHOD);
                while (eee2.hasMoreElements()) {
                    XMLTree hmTree = (XMLTree)eee2.nextElement();
                    wrc.addHttpMethod(hmTree.getValue());
                }
                sc.addWebResourceCollection(wrc);
            }
            XMLTree acTree = scTree.getFirstElement(Constants.AUTH_CONSTRAINT);
            if (acTree != null) {
                AuthorizationConstraint ac2 = (AuthorizationConstraint)this.factory.createDescriptor(class$com$sun$enterprise$deployment$web$AuthorizationConstraint == null ? WebApplicationReader.class$("com.sun.enterprise.deployment.web.AuthorizationConstraint") : class$com$sun$enterprise$deployment$web$AuthorizationConstraint);
                if (acTree.getFirstElement(Constants.DESCRIPTION) != null) {
                    ac2.setDescription(acTree.getFirstElement(Constants.DESCRIPTION).getValue());
                }
                Enumeration eeee = acTree.elements(Constants.ROLE_NAME);
                while (eeee.hasMoreElements()) {
                    XMLTree roleNameTree = (XMLTree)eeee.nextElement();
                    SecurityRole sr = (SecurityRole)this.factory.createDescriptor(class$com$sun$enterprise$deployment$web$SecurityRole == null ? WebApplicationReader.class$("com.sun.enterprise.deployment.web.SecurityRole") : class$com$sun$enterprise$deployment$web$SecurityRole);
                    sr.setName(roleNameTree.getValue());
                    ac2.addSecurityRole(sr);
                }
                sc.setAuthorizationConstraint(ac2);
            }
            if ((udcTree = scTree.getFirstElement(Constants.USERDATA_CONSTRAINT)) != null) {
                UserDataConstraint udc = (UserDataConstraint)this.factory.createDescriptor(class$com$sun$enterprise$deployment$web$UserDataConstraint == null ? WebApplicationReader.class$("com.sun.enterprise.deployment.web.UserDataConstraint") : class$com$sun$enterprise$deployment$web$UserDataConstraint);
                if (udcTree.getFirstElement(Constants.DESCRIPTION) != null) {
                    udc.setDescription(udcTree.getFirstElement(Constants.DESCRIPTION).getValue());
                }
                udc.setTransportGuarantee(udcTree.getFirstElement(Constants.TRANSPORT_GUARANTEE).getValue());
                sc.setUserDataConstraint(udc);
            }
            this.webApplicationDescriptor.addSecurityConstraint(sc);
        }
    }

    private void processLoginConfig() {
        XMLTree flTree = this.config.getFirstElement(Constants.LOGIN_CONFIG);
        if (flTree != null) {
            LoginConfiguration lc = (LoginConfiguration)this.factory.createDescriptor(class$com$sun$enterprise$deployment$web$LoginConfiguration == null ? (class$com$sun$enterprise$deployment$web$LoginConfiguration = WebApplicationReader.class$("com.sun.enterprise.deployment.web.LoginConfiguration")) : class$com$sun$enterprise$deployment$web$LoginConfiguration);
            if (flTree.getFirstElement(Constants.AUTH_METHOD) != null) {
                lc.setAuthenticationMethod(flTree.getFirstElement(Constants.AUTH_METHOD).getValue());
            }
            if (flTree.getFirstElement(Constants.REALM_NAME) != null) {
                lc.setRealmName(flTree.getFirstElement(Constants.REALM_NAME).getValue());
            }
            if (flTree.getFirstElement(Constants.FORM_LOGIN_CONFIG) != null) {
                XMLTree formTree = flTree.getFirstElement(Constants.FORM_LOGIN_CONFIG);
                lc.setFormLoginPage(formTree.getFirstElement(Constants.FORM_LOGIN_PAGE).getValue());
                lc.setFormErrorPage(formTree.getFirstElement(Constants.FORM_ERROR_PAGE).getValue());
            }
            this.webApplicationDescriptor.setLoginConfiguration(lc);
        }
    }

    private void processSecurityRoles() {
        Enumeration enumeration = this.config.elements(Constants.SECURITY_ROLE);
        while (enumeration.hasMoreElements()) {
            XMLTree next = (XMLTree)enumeration.nextElement();
            SecurityRole sr = (SecurityRole)this.factory.createDescriptor(class$com$sun$enterprise$deployment$web$SecurityRole == null ? WebApplicationReader.class$("com.sun.enterprise.deployment.web.SecurityRole") : class$com$sun$enterprise$deployment$web$SecurityRole);
            if (next.getFirstElement(Constants.DESCRIPTION) != null) {
                sr.setDescription(next.getFirstElement(Constants.DESCRIPTION).getValue());
            }
            sr.setName(next.getFirstElement(Constants.ROLE_NAME).getValue());
            this.webApplicationDescriptor.addSecurityRole(sr);
        }
    }

    private void processEnvironmentEntries() {
        Enumeration enumeration = this.config.elements(Constants.ENVIRONMENT_ENTRY);
        while (enumeration.hasMoreElements()) {
            XMLTree next = (XMLTree)enumeration.nextElement();
            EnvironmentEntry ee2 = (EnvironmentEntry)this.factory.createDescriptor(class$com$sun$enterprise$deployment$web$EnvironmentEntry == null ? WebApplicationReader.class$("com.sun.enterprise.deployment.web.EnvironmentEntry") : class$com$sun$enterprise$deployment$web$EnvironmentEntry);
            if (next.getFirstElement(Constants.DESCRIPTION) != null) {
                ee2.setDescription(next.getFirstElement(Constants.DESCRIPTION).getValue());
            }
            ee2.setName(next.getFirstElement(Constants.ENVIRONMENT_NAME).getValue());
            if (next.getFirstElement(Constants.ENVIRONMENT_VALUE) != null) {
                ee2.setValue(next.getFirstElement(Constants.ENVIRONMENT_VALUE).getValue());
            }
            ee2.setType(next.getFirstElement(Constants.ENVIRONMENT_TYPE).getValue());
            this.webApplicationDescriptor.addEnvironmentEntry(ee2);
        }
    }

    private void processJmsDestinationReferences() {
        Enumeration enumeration = this.config.elements(Constants.RESOURCE_ENV_REFERENCE);
        while (enumeration.hasMoreElements()) {
            XMLTree next = (XMLTree)enumeration.nextElement();
            String optionalDescription = "";
            if (next.getFirstElement(Constants.DESCRIPTION) != null) {
                optionalDescription = next.getFirstElement(Constants.DESCRIPTION).getValue();
            }
            String jmsDestRefName = next.getFirstElement(Constants.RESOURCE_ENV_REFERENCE_NAME).getValue();
            String jmsDestType = next.getFirstElement(Constants.RESOURCE_ENV_REFERENCE_TYPE).getValue();
            JmsDestinationReferenceDescriptor jmsDestRef = new JmsDestinationReferenceDescriptor(jmsDestRefName, optionalDescription, jmsDestType);
            ((WritableJndiNameEnvironment)((Object)this.webApplicationDescriptor)).addJmsDestinationReferenceDescriptor(jmsDestRef);
        }
    }

    private void processEjbReferences() {
        Enumeration enumeration = this.config.elements(Constants.EJB_REFERENCE);
        this.processEjbReferences(enumeration, false);
        enumeration = this.config.elements(Constants.EJB_LOCAL_REFERENCE);
        this.processEjbReferences(enumeration, true);
    }

    private void processEjbReferences(Enumeration enumeration, boolean isLocal) {
        while (enumeration.hasMoreElements()) {
            XMLTree next = (XMLTree)enumeration.nextElement();
            EjbReference ejbr = (EjbReference)this.factory.createDescriptor(class$com$sun$enterprise$deployment$web$EjbReference == null ? WebApplicationReader.class$("com.sun.enterprise.deployment.web.EjbReference") : class$com$sun$enterprise$deployment$web$EjbReference);
            if (next.getFirstElement(Constants.DESCRIPTION) != null) {
                ejbr.setDescription(next.getFirstElement(Constants.DESCRIPTION).getValue());
            }
            ejbr.setLocal(isLocal);
            ejbr.setName(next.getFirstElement(Constants.EJB_NAME).getValue());
            ejbr.setType(next.getFirstElement(Constants.EJB_TYPE).getValue());
            if (isLocal) {
                ejbr.setHomeClassName(next.getFirstElement(Constants.EJB_LOCAL_HOME).getValue());
                ejbr.setBeanClassName(next.getFirstElement(Constants.EJB_LOCAL).getValue());
            } else {
                ejbr.setHomeClassName(next.getFirstElement(Constants.EJB_HOME).getValue());
                ejbr.setBeanClassName(next.getFirstElement(Constants.EJB_REMOTE).getValue());
            }
            if (next.getFirstElement(Constants.EJB_LINK) != null) {
                ejbr.setLinkName(next.getFirstElement(Constants.EJB_LINK).getValue());
            }
            this.webApplicationDescriptor.addEjbReference(ejbr);
        }
    }

    private void processMIMEMappings() {
        Enumeration enumeration = this.parseMIMEMappings(this.config.elements("mime-mapping")).elements();
        try {
            while (enumeration.hasMoreElements()) {
                this.webApplicationDescriptor.addMimeMapping((MimeMapping)enumeration.nextElement());
            }
        }
        catch (Exception e10) {
            System.out.println("parser error: MIMEMappings");
        }
    }

    private Vector parseMIMEMappings(Enumeration mimeMaps) {
        Vector<MimeMapping> mimeMappings = new Vector<MimeMapping>();
        while (mimeMaps.hasMoreElements()) {
            XMLTree x2 = (XMLTree)mimeMaps.nextElement();
            String extension = null;
            String mimeType = null;
            Enumeration enumeration = x2.getElements("extension").elements();
            while (enumeration.hasMoreElements()) {
                extension = ((XMLTree)enumeration.nextElement()).getValue().trim();
            }
            enumeration = x2.getElements("mime-type").elements();
            while (enumeration.hasMoreElements()) {
                mimeType = ((XMLTree)enumeration.nextElement()).getValue().trim();
            }
            if (extension == null || extension.length() <= 0 || mimeType == null || mimeType.length() <= 0) continue;
            try {
                MimeMapping mimeMapping = (MimeMapping)this.factory.createDescriptor(class$com$sun$enterprise$deployment$web$MimeMapping == null ? WebApplicationReader.class$("com.sun.enterprise.deployment.web.MimeMapping") : class$com$sun$enterprise$deployment$web$MimeMapping);
                mimeMapping.setExtension(extension);
                mimeMapping.setMimeType(mimeType);
                mimeMappings.addElement(mimeMapping);
            }
            catch (Exception e10) {
                // empty catch block
            }
        }
        return mimeMappings;
    }

    private void processServlets() {
        Enumeration enumeration = this.config.elements("servlet");
        while (enumeration.hasMoreElements()) {
            XMLTree descriptionTree;
            XMLTree displayNameTree;
            XMLTree next = (XMLTree)enumeration.nextElement();
            WebComponentDescriptor descriptor = null;
            if (next.getFirstElement("servlet-class") != null) {
                descriptor = (ServletDescriptor)this.factory.createDescriptor(class$com$sun$enterprise$deployment$web$ServletDescriptor == null ? WebApplicationReader.class$("com.sun.enterprise.deployment.web.ServletDescriptor") : class$com$sun$enterprise$deployment$web$ServletDescriptor);
                descriptor.setClassName(next.getFirstElement("servlet-class").getValue());
            } else {
                descriptor = (JspDescriptor)this.factory.createDescriptor(class$com$sun$enterprise$deployment$web$JspDescriptor == null ? WebApplicationReader.class$("com.sun.enterprise.deployment.web.JspDescriptor") : class$com$sun$enterprise$deployment$web$JspDescriptor);
                ((JspDescriptor)descriptor).setJspFileName(next.getFirstElement(Constants.JSP_FILENAME).getValue());
            }
            if (next.getFirstElement(Constants.LOAD_ON_START_UP) != null) {
                Integer loadOnStartUp = new Integer(Integer.MAX_VALUE);
                try {
                    loadOnStartUp = new Integer(next.getFirstElement(Constants.LOAD_ON_START_UP).getValue());
                }
                catch (NumberFormatException nfe) {
                    // empty catch block
                }
                descriptor.setLoadOnStartUp(loadOnStartUp);
            }
            if (next.getFirstElement(Constants.RUN_AS) != null) {
                RunAsIdentityDescriptor raid = new RunAsIdentityDescriptor();
                XMLTree runAsNode = next.getFirstElement(Constants.RUN_AS);
                raid.setRoleName(runAsNode.getFirstElement(Constants.ROLE_NAME).getValue());
                descriptor.setRunAsIdentity(raid);
            }
            Enumeration initParamTrees = next.getElements("init-param").elements();
            while (initParamTrees.hasMoreElements()) {
                XMLTree paramTree = (XMLTree)initParamTrees.nextElement();
                Object parameterName = null;
                Object parameterValue = null;
                InitializationParameter ip = (InitializationParameter)this.factory.createDescriptor(class$com$sun$enterprise$deployment$web$InitializationParameter == null ? WebApplicationReader.class$("com.sun.enterprise.deployment.web.InitializationParameter") : class$com$sun$enterprise$deployment$web$InitializationParameter);
                ip.setName(paramTree.getFirstElement("param-name").getValue());
                ip.setValue(paramTree.getFirstElement("param-value").getValue());
                if (paramTree.getFirstElement(Constants.DESCRIPTION) != null) {
                    ip.setDescription(paramTree.getFirstElement(Constants.DESCRIPTION).getValue());
                }
                descriptor.addInitializationParameter(ip);
            }
            Enumeration roleRefsTree = next.getElements(Constants.SECURITY_ROLE_REFERENCE).elements();
            while (roleRefsTree.hasMoreElements()) {
                XMLTree roleRefTree = (XMLTree)roleRefsTree.nextElement();
                SecurityRoleReference srr = (SecurityRoleReference)this.factory.createDescriptor(class$com$sun$enterprise$deployment$web$SecurityRoleReference == null ? WebApplicationReader.class$("com.sun.enterprise.deployment.web.SecurityRoleReference") : class$com$sun$enterprise$deployment$web$SecurityRoleReference);
                if (roleRefTree.getFirstElement(Constants.DESCRIPTION) != null) {
                    srr.setDescription(roleRefTree.getFirstElement(Constants.DESCRIPTION).getValue());
                }
                SecurityRole sr = (SecurityRole)this.factory.createDescriptor(class$com$sun$enterprise$deployment$web$SecurityRole == null ? WebApplicationReader.class$("com.sun.enterprise.deployment.web.SecurityRole") : class$com$sun$enterprise$deployment$web$SecurityRole);
                sr.setName(roleRefTree.getFirstElement(Constants.ROLE_LINK).getValue());
                srr.setSecurityRoleLink(sr);
                srr.setRolename(roleRefTree.getFirstElement(Constants.ROLE_NAME).getValue());
                if (roleRefTree.getFirstElement(Constants.DESCRIPTION) != null) {
                    srr.setDescription(roleRefTree.getFirstElement(Constants.DESCRIPTION).getValue());
                }
                descriptor.addSecurityRoleReference(srr);
            }
            XMLTree iconTree = next.getFirstElement(Constants.ICON);
            if (iconTree != null) {
                XMLTree largeIconTree;
                XMLTree smallIconTree = iconTree.getFirstElement(Constants.SMALL_ICON);
                if (smallIconTree != null) {
                    descriptor.setSmallIconUri(smallIconTree.getValue());
                }
                if ((largeIconTree = iconTree.getFirstElement(Constants.LARGE_ICON)) != null) {
                    descriptor.setLargeIconUri(largeIconTree.getValue());
                }
            }
            if ((displayNameTree = next.getFirstElement(Constants.DISPLAY_NAME)) != null) {
                descriptor.setName(displayNameTree.getValue());
            }
            if ((descriptionTree = next.getFirstElement(Constants.DESCRIPTION)) != null) {
                descriptor.setDescription(descriptionTree.getValue());
            }
            descriptor.setCanonicalName(next.getFirstElement("servlet-name").getValue());
            this.webApplicationDescriptor.addWebComponentDescriptor(descriptor);
        }
    }

    private void processServletMappings() {
        Enumeration enumeration = this.config.elements("servlet-mapping");
        while (enumeration.hasMoreElements()) {
            XMLTree next = (XMLTree)enumeration.nextElement();
            WebComponentDescriptor descriptor = this.getWebComponentDescriptorByName(next.getFirstElement("servlet-name").getValue());
            descriptor.addUrlPattern(next.getFirstElement("url-pattern").getValue());
        }
    }

    private WebComponentDescriptor getWebComponentDescriptorByName(String name) {
        Enumeration e10 = this.webApplicationDescriptor.getWebComponentDescriptors();
        while (e10.hasMoreElements()) {
            WebComponentDescriptor next = (WebComponentDescriptor)e10.nextElement();
            if (!next.getCanonicalName().equals(name)) continue;
            return next;
        }
        throw new RuntimeException("There is no web component by the name of " + name + " here.");
    }

    private void processServletFilters() {
        Enumeration enumeration = this.config.elements("filter");
        while (enumeration.hasMoreElements()) {
            XMLTree iconTree;
            XMLTree descTree;
            XMLTree next = (XMLTree)enumeration.nextElement();
            ServletFilter descriptor = (ServletFilter)this.factory.createDescriptor(class$com$sun$enterprise$deployment$web$ServletFilter == null ? WebApplicationReader.class$("com.sun.enterprise.deployment.web.ServletFilter") : class$com$sun$enterprise$deployment$web$ServletFilter);
            descriptor.setName(next.getFirstElement("filter-name").getValue());
            descriptor.setClassName(next.getFirstElement("filter-class").getValue());
            XMLTree dispNameTree = next.getFirstElement(Constants.DISPLAY_NAME);
            if (dispNameTree != null) {
                descriptor.setDisplayName(dispNameTree.getValue());
            }
            if ((descTree = next.getFirstElement(Constants.DESCRIPTION)) != null) {
                descriptor.setDescription(descTree.getValue());
            }
            if ((iconTree = next.getFirstElement(Constants.ICON)) != null) {
                XMLTree largeIconTree;
                XMLTree smallIconTree = iconTree.getFirstElement(Constants.SMALL_ICON);
                if (smallIconTree != null) {
                    descriptor.setSmallIconUri(smallIconTree.getValue());
                }
                if ((largeIconTree = iconTree.getFirstElement(Constants.LARGE_ICON)) != null) {
                    descriptor.setLargeIconUri(largeIconTree.getValue());
                }
            }
            Enumeration initParmTrees = next.getElements("init-param").elements();
            while (initParmTrees.hasMoreElements()) {
                InitializationParameter ip = (InitializationParameter)this.factory.createDescriptor(class$com$sun$enterprise$deployment$web$InitializationParameter == null ? WebApplicationReader.class$("com.sun.enterprise.deployment.web.InitializationParameter") : class$com$sun$enterprise$deployment$web$InitializationParameter);
                XMLTree parmTree = (XMLTree)initParmTrees.nextElement();
                ip.setName(parmTree.getFirstElement("param-name").getValue());
                ip.setValue(parmTree.getFirstElement("param-value").getValue());
                if (parmTree.getFirstElement(Constants.DESCRIPTION) != null) {
                    ip.setDescription(parmTree.getFirstElement(Constants.DESCRIPTION).getValue());
                }
                descriptor.addInitializationParameter(ip);
            }
            this.webApplicationDescriptor.addServletFilter(descriptor);
        }
    }

    private void processServletFilterMappings() {
        Enumeration enumeration = this.config.elements("filter-mapping");
        while (enumeration.hasMoreElements()) {
            XMLTree next = (XMLTree)enumeration.nextElement();
            ServletFilterMapping descriptor = (ServletFilterMapping)this.factory.createDescriptor(class$com$sun$enterprise$deployment$web$ServletFilterMapping == null ? WebApplicationReader.class$("com.sun.enterprise.deployment.web.ServletFilterMapping") : class$com$sun$enterprise$deployment$web$ServletFilterMapping);
            descriptor.setName(next.getFirstElement("filter-name").getValue());
            XMLTree target = null;
            target = next.getFirstElement(Constants.URL_PATTERN);
            if (target != null) {
                descriptor.setTargetType("URLPattern");
                descriptor.setTarget(target.getValue());
            } else {
                target = next.getFirstElement("servlet-name");
                if (target != null) {
                    descriptor.setTargetType("Servlet");
                    descriptor.setTarget(target.getValue());
                }
            }
            this.webApplicationDescriptor.addServletFilterMapping(descriptor);
        }
    }

    private void processWelcomeFiles() {
        XMLTree wflTree = this.config.getFirstElement("welcome-file-list");
        if (wflTree != null) {
            Enumeration enumeration = wflTree.elements("welcome-file");
            while (enumeration.hasMoreElements()) {
                XMLTree next = (XMLTree)enumeration.nextElement();
                this.webApplicationDescriptor.addWelcomeFile(next.getValue());
            }
        }
    }

    private Vector parseWelcomeFiles(Enumeration welcomeFiles) {
        Vector<String> welcomeFilesV = new Vector<String>();
        while (welcomeFiles.hasMoreElements()) {
            XMLTree x2 = (XMLTree)welcomeFiles.nextElement();
            welcomeFilesV.addElement(x2.getValue().trim());
        }
        return welcomeFilesV;
    }

    private void processSessionTimeOut() {
        if (this.config.getFirstElement("session-config") != null) {
            this.webApplicationDescriptor.setSessionTimeout(this.getSessionTimeOut(this.config.getFirstElement("session-config").elements("session-timeout")));
        }
    }

    private int getSessionTimeOut(Enumeration sessionTimeOuts) {
        Integer sessionTimeOut = new Integer(-1);
        while (sessionTimeOuts.hasMoreElements()) {
            XMLTree x2 = (XMLTree)sessionTimeOuts.nextElement();
            try {
                sessionTimeOut = new Integer(x2.getValue().trim());
            }
            catch (Exception e10) {
                // empty catch block
            }
        }
        return sessionTimeOut;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

