/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment;

import com.sun.enterprise.util.FileUtil;
import com.sun.enterprise.util.JarClassLoader;
import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Set;
import java.util.Vector;

public class FileContentsDescriptor {
    private Hashtable fileDirectoryMap = new Hashtable();
    private Set libraryJars = new HashSet();

    public FileContentsDescriptor() {
    }

    public FileContentsDescriptor(String baseDirectory, Vector files) {
        File directory = new File(baseDirectory);
        Enumeration e10 = files.elements();
        while (e10.hasMoreElements()) {
            Object next = e10.nextElement();
            if (next instanceof File) {
                this.fileDirectoryMap.put(next, directory);
                continue;
            }
            File nextFile = new File((String)next);
            this.fileDirectoryMap.put(nextFile, directory);
        }
    }

    public FileContentsDescriptor(FileContentsDescriptor fcd) {
        this.fileDirectoryMap.putAll(fcd.fileDirectoryMap);
        this.libraryJars.addAll(fcd.libraryJars);
    }

    public void addLibraryJar(File libraryJar) {
        this.getLibraryJars().add(new File(libraryJar.getAbsolutePath()));
    }

    public void removeLibraryJar(File libraryJar) {
        this.getLibraryJars().remove(new File(libraryJar.getAbsolutePath()));
    }

    public Set getLibraryJars() {
        if (this.libraryJars == null) {
            this.libraryJars = new HashSet();
        }
        return this.libraryJars;
    }

    public void removeFile(File file) {
        this.fileDirectoryMap.remove(file);
    }

    public void add(File file, File directory) {
        this.fileDirectoryMap.put(file, directory);
    }

    public void addAll(FileContentsDescriptor fcd) {
        this.addFiles(fcd);
        this.libraryJars.addAll(fcd.libraryJars);
    }

    public void addFiles(FileContentsDescriptor fcd) {
        this.fileDirectoryMap.putAll(fcd.fileDirectoryMap);
    }

    public Enumeration getFiles() {
        return this.fileDirectoryMap.keys();
    }

    public Set getFilesSet() {
        HashSet<File> s2 = new HashSet<File>();
        Enumeration e10 = this.getFiles();
        while (e10.hasMoreElements()) {
            File f2 = (File)e10.nextElement();
            s2.add(f2);
        }
        return s2;
    }

    public Set getClassNamesSet() {
        HashSet<String> classNamesSet = new HashSet<String>();
        Enumeration e10 = this.getFiles();
        while (e10.hasMoreElements()) {
            File f2 = (File)e10.nextElement();
            if (!f2.toString().endsWith(".class")) continue;
            classNamesSet.add(FileUtil.classNameFromFile(f2));
        }
        return classNamesSet;
    }

    public Iterator getDirectories() {
        HashSet directories = new HashSet();
        Enumeration e10 = this.fileDirectoryMap.elements();
        while (e10.hasMoreElements()) {
            directories.add(e10.nextElement());
        }
        return directories.iterator();
    }

    public File getDirectoryFor(File file) {
        Object o2 = this.fileDirectoryMap.get(file);
        if (o2 == null) {
            return null;
        }
        return (File)o2;
    }

    public File getFullFileFor(File file) {
        Object o2 = this.fileDirectoryMap.get(file);
        if (o2 == null) {
            return null;
        }
        if (((File)o2).toString().equals("")) {
            return new File(file.toString());
        }
        return new File((File)o2, file.toString());
    }

    protected JarClassLoader getClassLoaderInstance() {
        return new JarClassLoader();
    }

    public ClassLoader getClassLoader() throws IOException {
        JarClassLoader jcl = this.getClassLoaderInstance();
        Iterator itr = this.getDirectories();
        while (itr.hasNext()) {
            File next = (File)itr.next();
            jcl.addJar(next.getAbsolutePath());
        }
        Iterator itr2 = this.getLibraryJars().iterator();
        while (itr2.hasNext()) {
            File next = (File)itr2.next();
            jcl.addJar(next.getAbsolutePath());
        }
        return jcl;
    }

    public String toString() {
        return this.fileDirectoryMap.toString();
    }
}

