/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment;

import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.ApplicationClientArchivist;
import com.sun.enterprise.deployment.ApplicationClientDescriptor;
import com.sun.enterprise.deployment.ArchiveException;
import com.sun.enterprise.deployment.Archivist;
import com.sun.enterprise.deployment.BundleDescriptor;
import com.sun.enterprise.deployment.ConnectorArchivist;
import com.sun.enterprise.deployment.ConnectorDescriptor;
import com.sun.enterprise.deployment.Descriptor;
import com.sun.enterprise.deployment.EjbBundleArchivist;
import com.sun.enterprise.deployment.EjbBundleDescriptor;
import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.FileContentsDescriptor;
import com.sun.enterprise.deployment.WebBundleArchivist;
import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.enterprise.deployment.WebComponentDescriptorImpl;
import com.sun.enterprise.deployment.web.WebComponentDescriptor;
import com.sun.enterprise.deployment.xml.ApplicationNode;
import com.sun.enterprise.deployment.xml.EjbBundleNode;
import com.sun.enterprise.deployment.xml.RuntimeDescriptorNode;
import com.sun.enterprise.util.FileClassLoader;
import com.sun.enterprise.util.FileUtil;
import com.sun.enterprise.util.JarClassLoader;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Random;
import java.util.Set;
import java.util.Vector;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarInputStream;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipOutputStream;

public class ApplicationArchivist
extends Archivist {
    public static final boolean debug = true;
    public static final String DEPLOYMENT_DESCRIPTOR_ENTRY = "META-INF/application.xml";
    public static final String RI_SPECIFIC_DESCRIPTOR_ENTRY = "META-INF/sun-j2ee-ri.xml";
    private static final String LIBRARY_JAR_URI_ROOT = "library/";
    private File applicationFile = null;
    private ClassLoader classLoader;
    private Application application;
    private boolean isClassLoadable = false;
    private static boolean saveApplicationClientRuntime = true;
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(class$com$sun$enterprise$deployment$ApplicationArchivist == null ? (class$com$sun$enterprise$deployment$ApplicationArchivist = ApplicationArchivist.class$("com.sun.enterprise.deployment.ApplicationArchivist")) : class$com$sun$enterprise$deployment$ApplicationArchivist);
    static /* synthetic */ Class class$com$sun$enterprise$deployment$ApplicationArchivist;

    ApplicationArchivist(File applicationFile, Application application) {
        this(applicationFile, application, false);
    }

    ApplicationArchivist(File applicationFile, Application application, boolean isClassLoadable) {
        super(applicationFile.toString(), true);
        this.applicationFile = applicationFile;
        this.application = application;
        this.isClassLoadable = isClassLoadable;
    }

    public void setClassLoadable(boolean b10) {
        this.isClassLoadable = b10;
    }

    public boolean getClassLoadable() {
        return this.isClassLoadable;
    }

    protected File getArchiveFile() throws IOException {
        return this.applicationFile;
    }

    public void updateFiles(Hashtable newFiles) throws IOException {
        super.updateFiles(newFiles);
        this.application.changed(true);
    }

    public Set getLibraryJarUris() throws IOException {
        HashSet<String> libraryJarUris = new HashSet<String>();
        HashSet<String> appModuleJarUris = new HashSet<String>();
        Set appModules = this.application.getArchivableDescriptors();
        Iterator itr = appModules.iterator();
        while (itr.hasNext()) {
            BundleDescriptor module = (BundleDescriptor)itr.next();
            Archivist archivist = module.getArchivist();
            String archiveUri = archivist.getArchiveUri();
            if (!archiveUri.endsWith(".jar")) continue;
            appModuleJarUris.add(archiveUri);
        }
        Vector allEntryNames = this.getEntryNames();
        int entryIndex = 0;
        while (entryIndex < allEntryNames.size()) {
            String currentEntry = (String)allEntryNames.elementAt(entryIndex);
            if (currentEntry.endsWith(".jar") && !appModuleJarUris.contains(currentEntry)) {
                libraryJarUris.add(currentEntry);
            }
            ++entryIndex;
        }
        return libraryJarUris;
    }

    public ClassLoader getClassLoader() {
        if (this.classLoader == null) {
            try {
                if (this.isClassLoadable) {
                    JarClassLoader jcl = new JarClassLoader();
                    jcl.addJar(this.getApplicationFile().toString());
                    this.classLoader = jcl;
                } else {
                    File classesDir = new File(FileUtil.getTempDirectory(), this.application.getName());
                    String dir = this.extractClassloadableSubJarsTo(classesDir, "ejbJars");
                    this.classLoader = new FileClassLoader(dir);
                }
            }
            catch (Exception e10) {
                e10.printStackTrace();
                throw new RuntimeException(localStrings.getLocalString("enterprise.deployment.exceptionclassloadercouldnotbemade", "Class loader could not be made"));
            }
        }
        return this.classLoader;
    }

    private String extractClassloadableSubJarsTo(File directory, String subdir) throws IOException {
        Archivist archivist;
        JarFile jar = new JarFile(this.getApplicationFile());
        File base = new File(directory, subdir);
        HashSet<String> classLoadableEntries = new HashSet<String>();
        HashSet filesToBeRemoved = new HashSet();
        Hashtable filesToBeAdded = new Hashtable();
        Enumeration<JarEntry> appEntries = jar.entries();
        while (appEntries.hasMoreElements()) {
            JarEntry entry = appEntries.nextElement();
            String n2 = entry.getName();
            if (!n2.endsWith(".jar") && !n2.endsWith(".war")) continue;
            classLoadableEntries.add(n2);
        }
        Iterator itr = this.application.getEjbBundleDescriptors().iterator();
        while (itr.hasNext()) {
            EjbBundleDescriptor ejbBundleDescriptor = (EjbBundleDescriptor)itr.next();
            archivist = ejbBundleDescriptor.getArchivist();
            filesToBeRemoved.addAll(archivist.getFilesToBeRemoved());
            filesToBeAdded.putAll(archivist.getFilesToBeAdded());
        }
        itr = this.application.getWebBundleDescriptors().iterator();
        while (itr.hasNext()) {
            WebBundleDescriptor webBundleDescriptor = (WebBundleDescriptor)itr.next();
            archivist = webBundleDescriptor.getArchivist();
            filesToBeRemoved.addAll(archivist.getFilesToBeRemoved());
            filesToBeAdded.putAll(archivist.getFilesToBeAdded());
        }
        itr = classLoadableEntries.iterator();
        while (itr.hasNext()) {
            String entryName = (String)itr.next();
            String filename = entryName.replace('/', File.separatorChar);
            File extractedJar = new File(directory, filename);
            extractedJar.deleteOnExit();
            ApplicationArchivist.extractJar(entryName, jar, extractedJar);
            Archivist.extractJarFile(extractedJar, base);
        }
        itr = filesToBeRemoved.iterator();
        while (itr.hasNext()) {
            String fileEntryName = (String)itr.next();
            String fileName = fileEntryName.replace('/', File.separatorChar);
            File classFileToDelete = new File(base, fileName);
            boolean deleted = classFileToDelete.delete();
            if (deleted) continue;
            System.out.println("App Archivist : Couldn't delete " + classFileToDelete);
        }
        Enumeration e10 = filesToBeAdded.keys();
        while (e10.hasMoreElements()) {
            boolean madeDirs;
            String entryName = (String)e10.nextElement();
            File nextFile = (File)filesToBeAdded.get(entryName);
            if (!nextFile.exists()) {
                System.out.println(localStrings.getLocalString("enterprise.deployment.exceptionfiledoesnotexist", "{0} does not exist", new Object[]{nextFile.toString()}));
                continue;
            }
            String relativeFile = entryName.replace('/', File.separatorChar);
            File destinationFile = new File(base, relativeFile);
            if (!destinationFile.getParentFile().exists() && !(madeDirs = destinationFile.getParentFile().mkdirs())) {
                throw new IOException(localStrings.getLocalString("enterprise.deployment.exceptionunpackingarchivefailed", "Unpacking archive failed: could not make parent file for {0}", new Object[]{destinationFile}));
            }
            FileInputStream is = new FileInputStream(nextFile);
            FileOutputStream os = new FileOutputStream(destinationFile);
            Archivist.copy(is, os);
            is.close();
            os.close();
        }
        jar.close();
        return base.getAbsolutePath();
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public File getApplicationFile() {
        return this.applicationFile;
    }

    public Descriptor getDescriptor() {
        return this.application;
    }

    public void setApplicationFile(File applicationFile) {
        this.setArchiveUri(applicationFile.toString());
        this.applicationFile = applicationFile;
        this.setClassLoader(null);
    }

    public static Application open(File jarFile) throws IOException, ArchiveException {
        return ApplicationArchivist.open(jarFile, false, null);
    }

    public static Application open(File jarFile, ClassLoader loader) throws IOException, ArchiveException {
        return ApplicationArchivist.open(jarFile, false, loader);
    }

    public static Application open(File jarFile, boolean classLoadable) throws IOException, ArchiveException {
        return ApplicationArchivist.open(jarFile, classLoadable, null);
    }

    private static Application open(File jarFile, boolean classLoadable, ClassLoader loader) throws IOException, ArchiveException {
        if (!jarFile.exists()) {
            throw new IOException(localStrings.getLocalString("enterprise.deployment.exceptionjarfiledoesn'texist", "{0} does not exist", new Object[]{jarFile}));
        }
        JarFile jar = new JarFile(jarFile);
        ZipEntry deploymentEntry = jar.getEntry(DEPLOYMENT_DESCRIPTOR_ENTRY);
        if (deploymentEntry != null) {
            InputStream fis = jar.getInputStream(deploymentEntry);
            ApplicationNode node = ApplicationNode.read(fis);
            fis.close();
            Application application = node.getApplication(null);
            ApplicationArchivist applicationArchivist = new ApplicationArchivist(jarFile, application, classLoadable);
            if (loader != null) {
                applicationArchivist.setClassLoader(loader);
            }
            application.setApplicationArchivist(applicationArchivist);
            Enumeration e10 = node.getEjbBundleArchiveMap().keys();
            while (e10.hasMoreElements()) {
                String archiveEntryName = (String)e10.nextElement();
                String alternativeDescriptorEntryName = (String)node.getEjbBundleArchiveMap().get(archiveEntryName);
                File temp = Archivist.getEjbTemp(Archivist.getDirectory(jarFile));
                ApplicationArchivist.extractJar(archiveEntryName, jar, temp);
                EjbBundleDescriptor ejbBundleDescriptor = null;
                if ("".equals(alternativeDescriptorEntryName)) {
                    ejbBundleDescriptor = EjbBundleArchivist.open(temp, applicationArchivist);
                } else {
                    ejbBundleDescriptor = EjbBundleArchivist.open(temp, alternativeDescriptorEntryName, jar, applicationArchivist);
                    ejbBundleDescriptor.getArchivist().setExternalDescriptorArchiveUri(alternativeDescriptorEntryName);
                }
                temp.delete();
                ejbBundleDescriptor.getArchivist().setArchiveUri(archiveEntryName);
                application.addEjbBundleDescriptor(ejbBundleDescriptor);
            }
            Enumeration e11 = node.getWebBundleArchiveMap().keys();
            while (e11.hasMoreElements()) {
                String archiveEntryName = (String)e11.nextElement();
                String alternativeDescriptorEntryName = (String)node.getWebBundleArchiveMap().get(archiveEntryName);
                File temp = Archivist.getWebTemp(Archivist.getDirectory(jarFile));
                ApplicationArchivist.extractJar(archiveEntryName, jar, temp);
                WebBundleDescriptor webBundleDescriptor = null;
                if ("".equals(alternativeDescriptorEntryName)) {
                    webBundleDescriptor = WebBundleArchivist.open(temp);
                } else {
                    webBundleDescriptor = WebBundleArchivist.open(temp, alternativeDescriptorEntryName, jar);
                    webBundleDescriptor.getArchivist().setExternalDescriptorArchiveUri(alternativeDescriptorEntryName);
                }
                temp.delete();
                webBundleDescriptor.getArchivist().setArchiveUri(archiveEntryName);
                String contextRoot = node.getContextRootFor(archiveEntryName);
                webBundleDescriptor.setContextRoot(contextRoot);
                application.addWebBundleDescriptor(webBundleDescriptor);
            }
            Enumeration e12 = node.getApplicationClientDescriptorArchiveMap().keys();
            while (e12.hasMoreElements()) {
                String archiveEntryName = (String)e12.nextElement();
                String alternativeDescriptorEntryName = (String)node.getApplicationClientDescriptorArchiveMap().get(archiveEntryName);
                File temp = Archivist.getApplicationClientTemp(Archivist.getDirectory(jarFile));
                ApplicationArchivist.extractJar(archiveEntryName, jar, temp);
                ApplicationClientDescriptor applicationClientDescriptor = null;
                if ("".equals(alternativeDescriptorEntryName)) {
                    applicationClientDescriptor = ApplicationClientArchivist.open(temp);
                } else {
                    applicationClientDescriptor = ApplicationClientArchivist.open(temp, alternativeDescriptorEntryName, jar);
                    applicationClientDescriptor.getArchivist().setExternalDescriptorArchiveUri(alternativeDescriptorEntryName);
                }
                temp.delete();
                applicationClientDescriptor.getArchivist().setArchiveUri(archiveEntryName);
                application.addApplicationClientDescriptor(applicationClientDescriptor);
            }
            Enumeration e13 = node.getRarDescriptorArchiveMap().keys();
            while (e13.hasMoreElements()) {
                String archiveEntryName = (String)e13.nextElement();
                String alternativeDescriptorEntryName = (String)node.getRarDescriptorArchiveMap().get(archiveEntryName);
                File temp = Archivist.getRarTemp(Archivist.getDirectory(jarFile));
                ApplicationArchivist.extractJar(archiveEntryName, jar, temp);
                ConnectorDescriptor connectorDescriptor = null;
                if ("".equals(alternativeDescriptorEntryName)) {
                    connectorDescriptor = ConnectorArchivist.open(temp);
                } else {
                    connectorDescriptor = ConnectorArchivist.open(temp, alternativeDescriptorEntryName, jar);
                    connectorDescriptor.getArchivist().setExternalDescriptorArchiveUri(alternativeDescriptorEntryName);
                }
                temp.delete();
                connectorDescriptor.getArchivist().setArchiveUri(archiveEntryName);
                application.addRarDescriptor(connectorDescriptor);
            }
            ZipEntry runtimeDescriptorEntry = jar.getEntry(RI_SPECIFIC_DESCRIPTOR_ENTRY);
            if (runtimeDescriptorEntry != null) {
                fis = jar.getInputStream(runtimeDescriptorEntry);
                RuntimeDescriptorNode rdn = RuntimeDescriptorNode.read(fis);
                fis.close();
                rdn.updateRuntimeInformation(application);
            }
            ApplicationNode.resolveInterJarEjbReferences(application);
            jar.close();
            return application;
        }
        jar.close();
        throw new IOException(localStrings.getLocalString("enterprise.deployment.exceptionnodeploymentinfofound", "No deployment info found - invalid format"));
    }

    public void save(boolean saveRuntimeInfo) throws IOException {
        this.save(this.getApplicationFile(), saveRuntimeInfo);
    }

    public void save(File destinationFile, boolean saveRuntimeInfo) throws IOException {
        File tmpFile = Archivist.createTempFile(Archivist.getDirectory(destinationFile));
        ZipOutputStream zos = new ZipOutputStream(new FileOutputStream(tmpFile));
        Vector<String> appEntriesToSkip = new Vector<String>();
        HashSet<String> allLibraryJarUris = new HashSet<String>();
        JarFile existingApplicationJar = null;
        if (this.getApplicationFile().exists()) {
            existingApplicationJar = new JarFile(this.getApplicationFile());
            Iterator itr = this.application.getEjbBundleDescriptors().iterator();
            while (itr.hasNext()) {
                EjbBundleDescriptor ejbBundleDescriptor = (EjbBundleDescriptor)itr.next();
                EjbBundleArchivist oldArchivist = (EjbBundleArchivist)ejbBundleDescriptor.getArchivist();
                File temp = File.createTempFile("ejb-jar", ".jar");
                String ejbBundleEntryName = oldArchivist.getArchiveUri();
                if (oldArchivist.hasArchive()) {
                    ApplicationArchivist.extractJar(ejbBundleEntryName, existingApplicationJar, temp);
                    oldArchivist.setArchiveUri(temp.toString());
                }
                ejbBundleDescriptor.setApplication(null);
                if (oldArchivist.hasExternalDescriptor()) {
                    oldArchivist.save(temp, oldArchivist.getExternalDescriptorArchiveUri(), zos);
                    appEntriesToSkip.add(oldArchivist.getExternalDescriptorArchiveUri());
                } else {
                    oldArchivist.save(temp);
                }
                ejbBundleDescriptor.setApplication(this.application);
                oldArchivist.setHasArchive(true, ejbBundleEntryName);
                FileInputStream ejbJarInput = new FileInputStream(temp);
                zos.putNextEntry(new ZipEntry(ejbBundleEntryName));
                Archivist.copy(ejbJarInput, zos);
                zos.closeEntry();
                ((InputStream)ejbJarInput).close();
                appEntriesToSkip.add(ejbBundleEntryName);
                if (this.isClassLoadable) {
                    Vector<String> ejbEntryNamesToSkip = new Vector<String>();
                    ejbEntryNamesToSkip.addElement("META-INF/MANIFEST.MF");
                    ejbEntryNamesToSkip.addElement(EjbBundleArchivist.DEPLOYMENT_DESCRIPTOR_ENTRY);
                    Archivist.addJarToOutput(zos, new JarFile(temp), ejbEntryNamesToSkip);
                    String ejbClientJarUri = ejbBundleDescriptor.getEjbClientJarUri();
                    if (!"".equals(ejbClientJarUri)) {
                        JarFile app = new JarFile(this.getApplicationFile());
                        ZipEntry clientJarEntry = app.getEntry(ejbClientJarUri);
                        app.close();
                        if (clientJarEntry != null) {
                            allLibraryJarUris.add(ejbClientJarUri);
                        } else {
                            System.out.println(localStrings.getLocalString("enterprise.deployment.noclientjarentry", "Warning: {0} not found as a client jar entry.", new Object[]{ejbClientJarUri}));
                        }
                    }
                }
                temp.delete();
            }
            Iterator itr2 = this.application.getWebBundleDescriptors().iterator();
            while (itr2.hasNext()) {
                WebBundleDescriptor webBundleDescriptor = (WebBundleDescriptor)itr2.next();
                WebBundleArchivist oldArchivist = (WebBundleArchivist)webBundleDescriptor.getArchivist();
                File temp = File.createTempFile("war", ".war");
                String webBundleArchiveName = oldArchivist.getArchiveUri();
                if (oldArchivist.hasArchive()) {
                    ApplicationArchivist.extractJar(webBundleArchiveName, existingApplicationJar, temp);
                    oldArchivist.setArchiveUri(temp.toString());
                }
                webBundleDescriptor.setApplication(null);
                if (oldArchivist.hasExternalDescriptor()) {
                    oldArchivist.save(temp, oldArchivist.getExternalDescriptorArchiveUri(), zos);
                    appEntriesToSkip.add(oldArchivist.getExternalDescriptorArchiveUri());
                } else {
                    oldArchivist.save(temp);
                }
                webBundleDescriptor.setApplication(this.application);
                oldArchivist.setHasArchive(true, webBundleArchiveName);
                FileInputStream webJarInput = new FileInputStream(temp);
                zos.putNextEntry(new ZipEntry(webBundleArchiveName));
                Archivist.copy(webJarInput, zos);
                zos.closeEntry();
                ((InputStream)webJarInput).close();
                temp.delete();
                appEntriesToSkip.add(webBundleArchiveName);
            }
            Iterator itr3 = this.application.getApplicationClientDescriptors().iterator();
            while (itr3.hasNext()) {
                ApplicationClientDescriptor appClientDescriptor = (ApplicationClientDescriptor)itr3.next();
                ApplicationClientArchivist oldArchivist = (ApplicationClientArchivist)appClientDescriptor.getArchivist();
                File temp = File.createTempFile("application-client", ".jar");
                String appClientArchiveName = oldArchivist.getArchiveUri();
                if (oldArchivist.hasArchive()) {
                    ApplicationArchivist.extractJar(appClientArchiveName, existingApplicationJar, temp);
                    oldArchivist.setArchiveUri(temp.toString());
                }
                appClientDescriptor.setApplication(null);
                if (oldArchivist.hasExternalDescriptor()) {
                    oldArchivist.save(temp, saveApplicationClientRuntime, oldArchivist.getExternalDescriptorArchiveUri(), zos);
                    appEntriesToSkip.add(oldArchivist.getExternalDescriptorArchiveUri());
                } else {
                    oldArchivist.save(temp, saveApplicationClientRuntime);
                }
                appClientDescriptor.setApplication(this.application);
                oldArchivist.setHasArchive(true, appClientArchiveName);
                FileInputStream appClientJarInput = new FileInputStream(temp);
                zos.putNextEntry(new ZipEntry(appClientArchiveName));
                Archivist.copy(appClientJarInput, zos);
                zos.closeEntry();
                ((InputStream)appClientJarInput).close();
                appEntriesToSkip.add(appClientArchiveName);
                if (this.isClassLoadable) {
                    Vector<String> appClientEntryNamesToSkip = new Vector<String>();
                    appClientEntryNamesToSkip.addElement("META-INF/MANIFEST.MF");
                    appClientEntryNamesToSkip.addElement("META-INF/application-client.xml");
                    appClientEntryNamesToSkip.addElement(RI_SPECIFIC_DESCRIPTOR_ENTRY);
                    Archivist.addJarToOutput(zos, new JarFile(temp), appClientEntryNamesToSkip);
                }
                temp.delete();
            }
            Iterator itr4 = this.application.getRarDescriptors().iterator();
            while (itr4.hasNext()) {
                ConnectorDescriptor connectorDescriptor = (ConnectorDescriptor)itr4.next();
                ConnectorArchivist oldArchivist = (ConnectorArchivist)connectorDescriptor.getArchivist();
                File temp = File.createTempFile("connector", ".rar");
                String connectorArchiveName = oldArchivist.getArchiveUri();
                if (oldArchivist.hasArchive()) {
                    ApplicationArchivist.extractJar(connectorArchiveName, existingApplicationJar, temp);
                    oldArchivist.setArchiveUri(temp.toString());
                }
                connectorDescriptor.setApplication(null);
                oldArchivist.save(temp);
                connectorDescriptor.setApplication(this.application);
                oldArchivist.setHasArchive(true, connectorArchiveName);
                FileInputStream connectorJarInput = new FileInputStream(temp);
                zos.putNextEntry(new ZipEntry(connectorArchiveName));
                Archivist.copy(connectorJarInput, zos);
                zos.closeEntry();
                ((InputStream)connectorJarInput).close();
                appEntriesToSkip.add(connectorArchiveName);
                if (this.isClassLoadable) {
                    ApplicationArchivist.expandRarFile(new JarFile(temp), zos);
                }
                temp.delete();
            }
            Vector<File> classLoadableLibJars = new Vector<File>();
            if (this.isClassLoadable) {
                Hashtable toBeAdded = this.getFilesToBeAdded();
                allLibraryJarUris.addAll(this.getLibraryJarUris());
                Iterator itr5 = allLibraryJarUris.iterator();
                while (itr5.hasNext()) {
                    String nextUri = (String)itr5.next();
                    if (toBeAdded.contains(nextUri)) {
                        File theFile = (File)toBeAdded.get(nextUri);
                        classLoadableLibJars.add(theFile);
                        continue;
                    }
                    File libTemp = Archivist.getLibraryTemp(this.getApplicationDirectory());
                    libTemp.deleteOnExit();
                    ApplicationArchivist.extractJar(nextUri, existingApplicationJar, libTemp);
                    classLoadableLibJars.add(libTemp);
                }
            }
            appEntriesToSkip.add(DEPLOYMENT_DESCRIPTOR_ENTRY);
            appEntriesToSkip.add(RI_SPECIFIC_DESCRIPTOR_ENTRY);
            appEntriesToSkip.add("META-INF/MANIFEST.MF");
            this.writeEntriesToOutput(zos, appEntriesToSkip, classLoadableLibJars);
        }
        Manifest applicationManifest = this.createApplicationManifest();
        ApplicationArchivist.writeManifest(applicationManifest, zos);
        this.writeApplicationDeploymentInfo(zos, saveRuntimeInfo);
        zos.close();
        if (existingApplicationJar != null) {
            existingApplicationJar.close();
        }
        destinationFile.delete();
        boolean renamed = tmpFile.renameTo(destinationFile);
        if (!renamed) {
            throw new IOException(localStrings.getLocalString("enterprise.deployment.exceptionerrorsavingjar", "Error saving JAR"));
        }
        this.setApplicationFile(destinationFile);
        this.setClassLoader(null);
        if (this.isClassLoadable) {
            // empty if block
        }
        this.application.doneSaving();
    }

    public void addLibraryJar(File jarFile) throws IOException {
        Hashtable<String, File> filesToAdd = new Hashtable<String, File>();
        String libraryJarEntryName = LIBRARY_JAR_URI_ROOT + jarFile.getName();
        filesToAdd.put(libraryJarEntryName, jarFile);
        this.addFiles(filesToAdd);
        HashSet allJarBundleDescriptors = new HashSet();
        allJarBundleDescriptors.addAll(this.application.getEjbBundleDescriptors());
        allJarBundleDescriptors.addAll(this.application.getApplicationClientDescriptors());
        Iterator itr = allJarBundleDescriptors.iterator();
        while (itr.hasNext()) {
            BundleDescriptor next = (BundleDescriptor)itr.next();
            next.getArchivist().addManfiestClasspath(libraryJarEntryName);
        }
    }

    public void removeLibraryJar(String libraryJarEntryName) throws IOException {
        this.removeEntry(libraryJarEntryName);
        HashSet allJarBundleDescriptors = new HashSet();
        allJarBundleDescriptors.addAll(this.application.getEjbBundleDescriptors());
        allJarBundleDescriptors.addAll(this.application.getApplicationClientDescriptors());
        Iterator itr = allJarBundleDescriptors.iterator();
        while (itr.hasNext()) {
            BundleDescriptor next = (BundleDescriptor)itr.next();
            next.getArchivist().removeManifestClasspath(libraryJarEntryName);
        }
    }

    public String createUniqueURI(String base, String end) throws IOException {
        Vector entryNames = this.getEntryNames();
        Vector<String> matchingURIs = new Vector<String>();
        String newURI = base;
        int entryIndex = 0;
        while (entryIndex < entryNames.size()) {
            String nextEntryName = (String)entryNames.elementAt(entryIndex);
            if (nextEntryName.startsWith(base) && nextEntryName.endsWith(end)) {
                int indexOfEnd = nextEntryName.lastIndexOf(end);
                matchingURIs.add(nextEntryName.substring(0, indexOfEnd));
            }
            ++entryIndex;
        }
        if (matchingURIs.size() > 0) {
            String longest = "";
            int entryIndex2 = 0;
            while (entryIndex2 < matchingURIs.size()) {
                String nextEntryName = (String)matchingURIs.elementAt(entryIndex2);
                if (nextEntryName.length() > longest.length()) {
                    longest = nextEntryName;
                }
                ++entryIndex2;
            }
            Random random = new Random();
            newURI = longest + random.nextInt(10);
        }
        return newURI + end;
    }

    public String createUniqueAppClientURI() throws IOException {
        return this.createUniqueURI("app-client-ic", ".jar");
    }

    public String createUniqueRarURI() throws IOException {
        return this.createUniqueURI("connector-ic", ".rar");
    }

    public String createUniqueWarURI() throws IOException {
        return this.createUniqueURI("war-ic", ".war");
    }

    public String createUniqueEjbURI() throws IOException {
        return this.createUniqueURI("ejb-jar-ic", ".jar");
    }

    public static Application readApplicationFromXmlFiles(String xmlFilename) throws IOException, ArchiveException {
        FileInputStream fis = new FileInputStream(new File(xmlFilename));
        ApplicationNode applicationNode = ApplicationNode.read(fis);
        Application application = applicationNode.getApplication(null);
        fis.close();
        Enumeration e10 = applicationNode.getEjbBundleArchiveMap().keys();
        while (e10.hasMoreElements()) {
            String ejbBundleFilename = (String)e10.nextElement();
            fis = new FileInputStream(new File(ejbBundleFilename));
            EjbBundleNode ejbBundleNode = EjbBundleNode.read(fis);
            EjbBundleDescriptor bundleDescriptor = ejbBundleNode.getDescriptor();
            application.addEjbBundleDescriptor(bundleDescriptor);
            fis.close();
        }
        return application;
    }

    public void writeApplicationDeploymentInfo(ZipOutputStream zos, boolean saveRuntimeInfo) throws IOException {
        Archivist.writeDocumentToJar(ApplicationNode.getDocument(this.application), DEPLOYMENT_DESCRIPTOR_ENTRY, zos);
        if (saveRuntimeInfo && this.application.hasRuntimeInformation()) {
            Archivist.writeDocumentToJar(RuntimeDescriptorNode.getDocument(this.application), RI_SPECIFIC_DESCRIPTOR_ENTRY, zos);
        }
    }

    public Manifest createApplicationManifest() {
        Manifest m2 = new Manifest();
        return m2;
    }

    public void add16Icon(File iconFile) throws IOException {
        this.addIcon(iconFile, true);
    }

    private void addIcon(File iconFile, boolean small) throws IOException {
        ApplicationArchivist.addIcon(this.application, this, iconFile, small);
    }

    private static void addIcon(Descriptor descriptor, Archivist archivist, File iconFile, boolean small) throws IOException {
        Vector names = archivist.getEntryNames();
        Hashtable<String, File> ht = new Hashtable<String, File>();
        String iconName = Descriptor.createUniqueNameAmongst(iconFile.getName(), names);
        ht.put(iconName, iconFile);
        String existingIcon = null;
        existingIcon = small ? descriptor.getSmallIconUri() : descriptor.getLargeIconUri();
        if (!"".equals(existingIcon)) {
            Vector<String> toRemove = new Vector<String>();
            toRemove.add(existingIcon);
            archivist.removeEntries(toRemove);
        }
        archivist.addFiles(ht);
        if (small) {
            descriptor.setSmallIconUri(iconName);
        } else {
            descriptor.setLargeIconUri(iconName);
        }
    }

    public void add16Icon(BundleDescriptor container, Descriptor component, File iconFile) throws IOException {
        this.addIcon(container, component, iconFile, true);
    }

    public void add32Icon(BundleDescriptor container, Descriptor component, File iconFile) throws IOException {
        this.addIcon(container, component, iconFile, false);
    }

    private void addIcon(BundleDescriptor container, Descriptor component, File iconFile, boolean small) throws IOException {
        try {
            ApplicationArchivist.addIcon(component, container.getArchivist(), iconFile, small);
        }
        catch (Throwable t2) {
            t2.printStackTrace();
        }
    }

    public void add32Icon(File iconFile) throws IOException {
        this.addIcon(iconFile, false);
    }

    public void addApplicationJar(File applicationJarFile) throws IOException, ArchiveException {
        Application applicationToAdd = ApplicationArchivist.open(applicationJarFile);
        File scratchFile = Archivist.createTempFile(this.getApplicationDirectory());
        FileOutputStream fos = new FileOutputStream(scratchFile);
        ZipOutputStream outZipStream = new ZipOutputStream(fos);
        Vector<String> entriesNotToAdd = new Vector<String>();
        entriesNotToAdd.addElement(DEPLOYMENT_DESCRIPTOR_ENTRY);
        entriesNotToAdd.addElement("META-INF/MANIFEST.MF");
        entriesNotToAdd.addElement(RI_SPECIFIC_DESCRIPTOR_ENTRY);
        JarFile thisJar = new JarFile(this.getApplicationFile());
        Archivist.addJarToOutput(outZipStream, thisJar, entriesNotToAdd);
        thisJar.close();
        JarFile thatJar = new JarFile(applicationJarFile);
        Archivist.addJarToOutput(outZipStream, thatJar, entriesNotToAdd);
        thatJar.close();
        this.application.addApplication(applicationToAdd);
        Manifest manifest = new Manifest();
        ApplicationArchivist.writeManifest(manifest, outZipStream);
        this.writeApplicationDeploymentInfo(outZipStream, true);
        outZipStream.close();
        fos.close();
        this.getApplicationFile().delete();
        if (!scratchFile.renameTo(this.getApplicationFile())) {
            System.out.println(localStrings.getLocalString("enterprise.deployment.errorrenamingjarfiletoappfile", "Error renaming JAR {0} to {1}", new Object[]{scratchFile, this.getApplicationFile()}));
        }
        this.setClassLoader(null);
        this.application.changed();
    }

    private Hashtable createLibraryJarHashtable(Set libraryJars) {
        Hashtable<String, File> ht = new Hashtable<String, File>();
        Iterator itr = libraryJars.iterator();
        while (itr.hasNext()) {
            File next = (File)itr.next();
            ht.put(LIBRARY_JAR_URI_ROOT + next.getName(), next);
        }
        return ht;
    }

    public EjbBundleDescriptor addEjbJar(File ejbJarFile, String externalDescriptorEntryName) throws IOException, ArchiveException {
        this.save(this.getApplicationFile(), true);
        EjbBundleDescriptor ejbBundleDescriptor = EjbBundleArchivist.open(ejbJarFile);
        String ejbJarEntryName = super.getUniqueEntryFilenameFor(this.getApplicationFile(), ejbJarFile.getName());
        EjbBundleArchivist ejbArchivist = (EjbBundleArchivist)ejbBundleDescriptor.getArchivist();
        ejbArchivist.setArchiveUri(ejbJarEntryName);
        String ejbClientJarUri = ejbBundleDescriptor.getEjbClientJarUri();
        if (!ejbClientJarUri.equals("")) {
            String ejbClientJarPath = ejbClientJarUri.replace('/', File.separatorChar);
            File ejbClientJar = new File(ejbJarFile.getParentFile(), ejbClientJarPath);
            if (ejbClientJar.exists()) {
                Hashtable<String, File> libJarHashtable = new Hashtable<String, File>();
                libJarHashtable.put(ejbClientJarUri, ejbClientJar);
                super.addFiles(libJarHashtable, this.getApplicationFile());
                ejbArchivist.addManfiestClasspath(ejbClientJarUri);
            } else {
                throw new FileNotFoundException(localStrings.getLocalString("enterprise.deployment.noclientjarentry", "Warning: {0} not found as a client jar entry.", new Object[]{ejbClientJar.toString()}));
            }
        }
        if (externalDescriptorEntryName != null && !"".equals(externalDescriptorEntryName)) {
            ejbArchivist.setExternalDescriptorArchiveUri(externalDescriptorEntryName);
        }
        File scratchFile = Archivist.createTempFile(this.getApplicationDirectory());
        JarFile applicationJar = new JarFile(this.getApplicationFile());
        FileOutputStream fos = new FileOutputStream(scratchFile);
        ZipOutputStream outZipStream = new ZipOutputStream(fos);
        Vector<String> entriesNotToAdd = new Vector<String>();
        entriesNotToAdd.addElement(DEPLOYMENT_DESCRIPTOR_ENTRY);
        entriesNotToAdd.addElement("META-INF/MANIFEST.MF");
        entriesNotToAdd.addElement(RI_SPECIFIC_DESCRIPTOR_ENTRY);
        Archivist.addJarToOutput(outZipStream, applicationJar, entriesNotToAdd);
        FileInputStream fis = new FileInputStream(ejbJarFile);
        ZipEntry ejbJarEntry = new ZipEntry(ejbJarEntryName);
        outZipStream.putNextEntry(ejbJarEntry);
        Archivist.copy(fis, outZipStream);
        fis.close();
        applicationJar.close();
        this.getApplicationFile().delete();
        Manifest manifest = new Manifest();
        ApplicationArchivist.writeManifest(manifest, outZipStream);
        this.application.addEjbBundleDescriptor(ejbBundleDescriptor);
        this.writeApplicationDeploymentInfo(outZipStream, true);
        outZipStream.close();
        fos.close();
        this.getApplicationFile().delete();
        if (!scratchFile.renameTo(this.getApplicationFile())) {
            System.out.println(localStrings.getLocalString("enterprise.deployment.errorrenamingjar", "Error renaming JAR"));
        }
        this.setApplicationFile(this.getApplicationFile());
        this.application.changed();
        return ejbBundleDescriptor;
    }

    public EjbBundleDescriptor addEjbJar(File ejbJarFile) throws IOException, ArchiveException {
        return this.addEjbJar(ejbJarFile, null);
    }

    public void addEjbJar(EjbBundleDescriptor newEjbBundleDescriptor, FileContentsDescriptor fcd, Set libraryJarURIs, Descriptor target) throws IOException {
        Application app;
        Archivist archivist = null;
        if (target instanceof Application) {
            app = (Application)target;
            String archiveUri = app.getApplicationArchivist().createUniqueEjbURI();
            archivist = new EjbBundleArchivist(false, archiveUri, newEjbBundleDescriptor, new HashSet());
            app.addEjbBundleDescriptor(newEjbBundleDescriptor);
        } else {
            EjbBundleDescriptor ejbBundle = (EjbBundleDescriptor)target;
            app = ejbBundle.getApplication();
            archivist = ejbBundle.getArchivist();
            ejbBundle.addEjbBundleDescriptor(newEjbBundleDescriptor);
        }
        Hashtable entriesToFileNames = archivist.createEntryNameMap(fcd);
        archivist.addFiles(entriesToFileNames);
        Iterator iter = libraryJarURIs.iterator();
        while (iter.hasNext()) {
            archivist.addManfiestClasspath((String)iter.next());
        }
        app.getApplicationArchivist().save(true);
    }

    public void removeDescriptor(Descriptor descriptor) throws IOException {
        if (descriptor instanceof EjbDescriptor) {
            EjbDescriptor ejbDescriptor = (EjbDescriptor)descriptor;
            EjbBundleDescriptor bundle = ejbDescriptor.getEjbBundleDescriptor();
            bundle.removeEjb(ejbDescriptor);
        } else if (descriptor instanceof WebComponentDescriptor) {
            WebComponentDescriptorImpl componentDesc = (WebComponentDescriptorImpl)descriptor;
            WebBundleDescriptor bundle = componentDesc.getWebBundleDescriptor();
            bundle.removeWebComponentDescriptor(componentDesc);
        } else {
            throw new RuntimeException(localStrings.getLocalString("enterprise.deployment.exceptionbundledescriptorunknowntype", "{0} is an unknown type for removing", new Object[]{descriptor}));
        }
        this.save(true);
    }

    public void removeBundleDescriptor(BundleDescriptor bundleDescriptor) throws IOException {
        if (bundleDescriptor instanceof EjbBundleDescriptor) {
            this.application.removeEjbBundleDescriptor((EjbBundleDescriptor)bundleDescriptor);
        } else if (bundleDescriptor instanceof WebBundleDescriptor) {
            this.application.removeWebBundleDescriptor((WebBundleDescriptor)bundleDescriptor);
        } else if (bundleDescriptor instanceof ApplicationClientDescriptor) {
            this.application.removeApplicationClientDescriptor((ApplicationClientDescriptor)bundleDescriptor);
        } else if (bundleDescriptor instanceof ConnectorDescriptor) {
            this.application.removeRarDescriptor((ConnectorDescriptor)bundleDescriptor);
        } else {
            throw new RuntimeException(localStrings.getLocalString("enterprise.deployment.exceptionbundledescriptorunknowntype", "{0} is an unknown type for removing", new Object[]{bundleDescriptor}));
        }
        super.removeEntry(bundleDescriptor.getArchivist().getArchiveUri());
        this.save(true);
    }

    public void addWebComponent(WebBundleDescriptor newWebBundleDescriptor, FileContentsDescriptor classes, FileContentsDescriptor staticContent, Descriptor target) throws IOException {
        Application app;
        Archivist archivist = null;
        WebBundleDescriptor targetBundle = null;
        if (target instanceof Application) {
            app = (Application)target;
            String archiveUri = app.getApplicationArchivist().createUniqueWarURI();
            archivist = new WebBundleArchivist(false, archiveUri, newWebBundleDescriptor);
            app.addWebBundleDescriptor(newWebBundleDescriptor);
        } else {
            targetBundle = (WebBundleDescriptor)target;
            app = targetBundle.getApplication();
            archivist = targetBundle.getArchivist();
            targetBundle.addWebBundleDescriptor(newWebBundleDescriptor);
        }
        Hashtable entriesToFileNames = ((WebBundleArchivist)archivist).createEntryNameMap(classes, staticContent);
        archivist.addFiles(entriesToFileNames);
        app.getApplicationArchivist().save(true);
    }

    public void addWebJar(File webJarFile, String externalDescriptorEntryName) throws IOException, ArchiveException {
        this.save(this.getApplicationFile(), true);
        WebBundleDescriptor webBundleDescriptor = WebBundleArchivist.open(webJarFile);
        String webJarEntryName = super.getUniqueEntryFilenameFor(this.getApplicationFile(), webJarFile.getName());
        Archivist webArchivist = webBundleDescriptor.getArchivist();
        webArchivist.setArchiveUri(webJarEntryName);
        if (externalDescriptorEntryName != null && !"".equals(externalDescriptorEntryName)) {
            webArchivist.setExternalDescriptorArchiveUri(externalDescriptorEntryName);
        }
        File scratchFile = Archivist.createTempFile(this.getApplicationDirectory());
        JarFile applicationJar = new JarFile(this.getApplicationFile());
        FileOutputStream fos = new FileOutputStream(scratchFile);
        ZipOutputStream outZipStream = new ZipOutputStream(fos);
        Vector<String> entriesNotToAdd = new Vector<String>();
        entriesNotToAdd.addElement(DEPLOYMENT_DESCRIPTOR_ENTRY);
        entriesNotToAdd.addElement("META-INF/MANIFEST.MF");
        entriesNotToAdd.addElement(RI_SPECIFIC_DESCRIPTOR_ENTRY);
        Archivist.addJarToOutput(outZipStream, applicationJar, entriesNotToAdd);
        FileInputStream fis = new FileInputStream(webJarFile);
        ZipEntry webJarEntry = new ZipEntry(webJarEntryName);
        outZipStream.putNextEntry(webJarEntry);
        Archivist.copy(fis, outZipStream);
        fis.close();
        applicationJar.close();
        this.getApplicationFile().delete();
        Manifest manifest = new Manifest();
        ApplicationArchivist.writeManifest(manifest, outZipStream);
        this.application.addWebBundleDescriptor(webBundleDescriptor);
        this.writeApplicationDeploymentInfo(outZipStream, true);
        outZipStream.close();
        fos.close();
        this.getApplicationFile().delete();
        if (!scratchFile.renameTo(this.getApplicationFile())) {
            System.out.println(localStrings.getLocalString("enterprise.deployment.errorrenamingjar", "Error renaming JAR"));
        }
        this.setApplicationFile(this.getApplicationFile());
        this.application.changed();
    }

    public void addWebJar(File webJarFile) throws IOException, ArchiveException {
        this.addWebJar(webJarFile, null);
    }

    public void addApplicationClient(ApplicationClientDescriptor descriptor, FileContentsDescriptor fcd, Set libraryJarURIs, Application application) throws IOException {
        String archiveUri = application.getApplicationArchivist().createUniqueAppClientURI();
        ApplicationClientArchivist archivist = new ApplicationClientArchivist(false, archiveUri, descriptor, libraryJarURIs);
        application.addApplicationClientDescriptor(descriptor);
        Hashtable entriesToFileNames = ((Archivist)archivist).createEntryNameMap(fcd);
        archivist.addFiles(entriesToFileNames);
        application.getApplicationArchivist().save(true);
    }

    public ApplicationClientDescriptor addApplicationClientJar(File appClientJarFile, Set libraryJars) throws IOException, ArchiveException {
        return this.addApplicationClientJar(appClientJarFile, libraryJars, null);
    }

    public ApplicationClientDescriptor addApplicationClientJar(File appClientJarFile, Set libraryJars, String externalDescriptorEntry) throws IOException, ArchiveException {
        this.save(this.getApplicationFile(), true);
        ApplicationClientDescriptor descriptor = ApplicationClientArchivist.open(appClientJarFile);
        String acArchiveName = super.getUniqueEntryFilenameFor(this.getApplicationFile(), appClientJarFile.getName());
        ApplicationClientArchivist acArchivist = (ApplicationClientArchivist)descriptor.getArchivist();
        acArchivist.setArchiveUri(acArchiveName);
        if (externalDescriptorEntry != null && !"".equals(externalDescriptorEntry)) {
            acArchivist.setExternalDescriptorArchiveUri(externalDescriptorEntry);
        }
        if (!libraryJars.isEmpty()) {
            Hashtable libraryJarMap = this.createLibraryJarHashtable(libraryJars);
            libraryJarMap = super.addFiles(libraryJarMap, this.getApplicationFile());
            Enumeration e10 = libraryJarMap.keys();
            while (e10.hasMoreElements()) {
                String libUri = (String)e10.nextElement();
                acArchivist.addManfiestClasspath(libUri);
            }
            acArchivist.save(acArchivist.getApplicationClientJarFile(), true);
        }
        File scratchFile = Archivist.createTempFile(this.getApplicationDirectory());
        JarFile applicationJar = new JarFile(this.getApplicationFile());
        FileOutputStream fos = new FileOutputStream(scratchFile);
        ZipOutputStream outZipStream = new ZipOutputStream(fos);
        Vector<String> entriesNotToAdd = new Vector<String>();
        entriesNotToAdd.addElement(DEPLOYMENT_DESCRIPTOR_ENTRY);
        entriesNotToAdd.addElement("META-INF/MANIFEST.MF");
        entriesNotToAdd.addElement(RI_SPECIFIC_DESCRIPTOR_ENTRY);
        Archivist.addJarToOutput(outZipStream, applicationJar, entriesNotToAdd);
        FileInputStream fis = new FileInputStream(appClientJarFile);
        ZipEntry acJarEntry = new ZipEntry(acArchiveName);
        outZipStream.putNextEntry(acJarEntry);
        Archivist.copy(fis, outZipStream);
        fis.close();
        applicationJar.close();
        this.getApplicationFile().delete();
        Manifest manifest = new Manifest();
        ApplicationArchivist.writeManifest(manifest, outZipStream);
        this.application.addApplicationClientDescriptor(descriptor);
        this.writeApplicationDeploymentInfo(outZipStream, true);
        outZipStream.close();
        fos.close();
        if (!scratchFile.renameTo(this.getApplicationFile())) {
            System.out.println(localStrings.getLocalString("enterprise.deployment.errorrenamingjar", "Error renaming JAR"));
        }
        this.setApplicationFile(this.getApplicationFile());
        this.application.changed();
        return descriptor;
    }

    public ConnectorDescriptor addRar(File rarFile, Set libraryJars) throws IOException, ArchiveException {
        return this.addRar(rarFile, libraryJars, null);
    }

    public ConnectorDescriptor addRar(File rarFile, Set libraryJars, String externalDescriptorEntry) throws IOException, ArchiveException {
        this.save(this.getApplicationFile(), true);
        ConnectorDescriptor descriptor = ConnectorArchivist.open(rarFile);
        String rarArchiveName = super.getUniqueEntryFilenameFor(this.getApplicationFile(), rarFile.getName());
        ConnectorArchivist rarArchivist = (ConnectorArchivist)descriptor.getArchivist();
        rarArchivist.setArchiveUri(rarArchiveName);
        if (externalDescriptorEntry != null && !"".equals(externalDescriptorEntry)) {
            rarArchivist.setExternalDescriptorArchiveUri(externalDescriptorEntry);
        }
        if (!libraryJars.isEmpty()) {
            Hashtable libraryJarMap = this.createLibraryJarHashtable(libraryJars);
            libraryJarMap = super.addFiles(libraryJarMap, this.getApplicationFile());
            Enumeration e10 = libraryJarMap.keys();
            while (e10.hasMoreElements()) {
                String libUri = (String)e10.nextElement();
                rarArchivist.addManfiestClasspath(libUri);
            }
            rarArchivist.save(rarArchivist.getRarFile());
        }
        File scratchFile = Archivist.createTempFile(this.getApplicationDirectory());
        JarFile applicationRar = new JarFile(this.getApplicationFile());
        FileOutputStream fos = new FileOutputStream(scratchFile);
        ZipOutputStream outZipStream = new ZipOutputStream(fos);
        Vector<String> entriesNotToAdd = new Vector<String>();
        entriesNotToAdd.addElement(DEPLOYMENT_DESCRIPTOR_ENTRY);
        entriesNotToAdd.addElement("META-INF/MANIFEST.MF");
        entriesNotToAdd.addElement(RI_SPECIFIC_DESCRIPTOR_ENTRY);
        Archivist.addJarToOutput(outZipStream, applicationRar, entriesNotToAdd);
        FileInputStream fis = new FileInputStream(rarFile);
        ZipEntry rarEntry = new ZipEntry(rarArchiveName);
        outZipStream.putNextEntry(rarEntry);
        Archivist.copy(fis, outZipStream);
        fis.close();
        applicationRar.close();
        this.getApplicationFile().delete();
        Manifest manifest = new Manifest();
        ApplicationArchivist.writeManifest(manifest, outZipStream);
        this.application.addRarDescriptor(descriptor);
        this.writeApplicationDeploymentInfo(outZipStream, false);
        outZipStream.close();
        fos.close();
        if (!scratchFile.renameTo(this.getApplicationFile())) {
            System.out.println(localStrings.getLocalString("enterprise.deployment.errorrenamingrar", "Error renaming RAR"));
        }
        this.setApplicationFile(this.getApplicationFile());
        this.application.changed();
        return descriptor;
    }

    public void addRar(ConnectorDescriptor descriptor, FileContentsDescriptor fcd, Set libraryJarURIs, Application application) throws IOException {
        String archiveUri = application.getApplicationArchivist().createUniqueRarURI();
        ConnectorArchivist archivist = new ConnectorArchivist(false, archiveUri, descriptor, libraryJarURIs);
        application.addRarDescriptor(descriptor);
        Hashtable entriesToFileNames = archivist.createEntryNameMap(fcd);
        archivist.addFiles(entriesToFileNames);
        application.getApplicationArchivist().save(true);
    }

    private void extractEjbJar(EjbBundleDescriptor ejbBundleDescriptor, File filename) throws IOException {
        this.extractBundleToFile(ejbBundleDescriptor, filename);
    }

    private static void extractJar(String archiveUri, JarFile applicationJar, File filename) throws IOException {
        String fullFilename = filename.getAbsolutePath();
        String parent = new File(fullFilename).getParent();
        new File(parent).mkdirs();
        ZipEntry ejbBundleEntry = applicationJar.getEntry(archiveUri);
        if (ejbBundleEntry == null) {
            throw new IOException(localStrings.getLocalString("enterprise.deployment.exceptionarchiveurinotfoundinappjar", "{0} not found in {1}", new Object[]{archiveUri, applicationJar.getName()}));
        }
        InputStream is = applicationJar.getInputStream(ejbBundleEntry);
        FileOutputStream fos = new FileOutputStream(filename);
        Archivist.copy(is, fos);
        is.close();
        fos.close();
    }

    public void extractBundleToFile(BundleDescriptor descriptor, File filename) throws IOException {
        Archivist archivist = descriptor.getArchivist();
        JarFile applicationJar = new JarFile(this.getApplicationFile());
        ApplicationArchivist.extractJar(archivist.getArchiveUri(), applicationJar, filename);
        applicationJar.close();
    }

    private void extractWebJar(WebBundleDescriptor webBundleDescriptor, File filename) throws IOException {
        this.extractBundleToFile(webBundleDescriptor, filename);
    }

    private void extractApplicationClientJar(ApplicationClientDescriptor descriptor, File filename) throws IOException {
        this.extractBundleToFile(descriptor, filename);
    }

    private void extractRar(ConnectorDescriptor descriptor, File filename) throws IOException {
        this.extractBundleToFile(descriptor, filename);
    }

    public static boolean isApplication(File jarFile) throws IOException {
        Archivist.checkExists(jarFile);
        JarFile jar = new JarFile(jarFile);
        ZipEntry ze = jar.getEntry(DEPLOYMENT_DESCRIPTOR_ENTRY);
        boolean isApplication = ze != null;
        jar.close();
        return isApplication;
    }

    public static void writeManifest(Manifest manifest, ZipOutputStream zos) throws IOException {
        ZipEntry manifestEntry = new ZipEntry("META-INF/MANIFEST.MF");
        manifestEntry.setTime(System.currentTimeMillis());
        zos.putNextEntry(manifestEntry);
        manifest.write(zos);
        zos.closeEntry();
    }

    private File getApplicationDirectory() {
        return Archivist.getDirectory(this.getApplicationFile());
    }

    public String toString() {
        return "ApplicationArchivist " + this.applicationFile;
    }

    public static void expandRarFile(JarFile jarFile, ZipOutputStream zout) throws IOException {
        Enumeration<JarEntry> e10 = jarFile.entries();
        while (e10.hasMoreElements()) {
            ZipEntry entry1;
            ZipEntry entry = e10.nextElement();
            if (!entry.getName().endsWith(".jar")) continue;
            InputStream entryIn = jarFile.getInputStream(entry);
            JarInputStream jarIn = new JarInputStream(entryIn);
            while ((entry1 = jarIn.getNextEntry()) != null) {
                try {
                    zout.putNextEntry(new ZipEntry(entry1.getName()));
                    Archivist.copyWithoutClose(jarIn, zout);
                    zout.closeEntry();
                }
                catch (ZipException ex2) {}
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

