/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.activation;

import com.sun.enterprise.activation.CommandHandler;
import com.sun.enterprise.activation.Repository;
import com.sun.enterprise.activation.ServerDef;
import com.sun.enterprise.activation.ServerNotRegisteredException;
import com.sun.enterprise.util.Utility;
import java.io.PrintStream;

class ListServers
implements CommandHandler {
    static final int illegalServerId = -1;
    static /* synthetic */ Class class$com$sun$enterprise$activation$Repository;

    ListServers() {
    }

    public String getCommandName() {
        return "list";
    }

    public void printCommandHelp(PrintStream out, boolean helpType) {
        if (!helpType) {
            out.println("\tlist\n");
        } else {
            out.println("list all registered servers");
        }
    }

    public boolean processCommand(String[] cmdArgs, PrintStream out) {
        block13: {
            int serverId = -1;
            boolean listOneServer = false;
            if (cmdArgs.length == 0) {
                listOneServer = false;
            } else if (cmdArgs.length == 2 && cmdArgs[0].equals("-serverid")) {
                serverId = Integer.valueOf(cmdArgs[1]);
                if (serverId == -1) {
                    return true;
                }
                listOneServer = true;
            } else {
                return true;
            }
            try {
                Repository repository = (Repository)Utility.lookupObject("AppRepository", class$com$sun$enterprise$activation$Repository == null ? (class$com$sun$enterprise$activation$Repository = ListServers.class$("com.sun.enterprise.activation.Repository")) : class$com$sun$enterprise$activation$Repository);
                if (listOneServer) {
                    try {
                        ServerDef serverDef = repository.getServer(serverId);
                        out.println();
                        ListServers.printServerDef(serverDef, serverId, out);
                        out.println();
                    }
                    catch (ServerNotRegisteredException e10) {
                        out.println("no such server found.");
                    }
                    break block13;
                }
                int[] servers = repository.listRegisteredServers();
                out.println("\tServer Id\tServer Name\tServer Class Name");
                out.println("\t---------\t---------\t-----------------");
                ListServers.sortServers(servers);
                int i2 = 0;
                while (i2 < servers.length) {
                    try {
                        ServerDef serverDef = repository.getServer(servers[i2]);
                        out.println("\t   " + servers[i2] + "\t\t" + serverDef.alias + "\t\t" + serverDef.serverName);
                    }
                    catch (ServerNotRegisteredException e11) {
                        // empty catch block
                    }
                    ++i2;
                }
            }
            catch (Exception ex2) {
                out.println("Cannot list servers:" + ex2);
            }
        }
        return false;
    }

    static void printServerDef(ServerDef serverDef, int serverId, PrintStream out) {
        out.println("\talias      - " + serverDef.alias);
        out.println("\tname      - " + serverDef.serverName);
        out.println("\tclasspath - " + serverDef.serverClassPath);
        out.println("\targs      - " + serverDef.serverArgs);
        out.println("\tvmargs    - " + serverDef.serverVmArgs);
        out.println("\tserver id - " + serverId);
    }

    static void sortServers(int[] serverIds) {
        int size = serverIds.length;
        int i2 = 0;
        while (i2 < size) {
            int lowest = i2;
            int j2 = i2 + 1;
            while (j2 < size) {
                if (serverIds[j2] < serverIds[lowest]) {
                    lowest = j2;
                }
                ++j2;
            }
            if (lowest != i2) {
                int temp = serverIds[i2];
                serverIds[i2] = serverIds[lowest];
                serverIds[lowest] = temp;
            }
            ++i2;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

