/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ejb.ejbql;

import com.sun.ejb.ejbql.ExpressionBase;
import com.sun.ejb.ejbql.Literal;
import com.sun.ejb.ejbql.Visitor;

public class StringLiteral
extends ExpressionBase
implements Literal {
    private String sqlLiteral_;
    private String javaLiteral_;

    public StringLiteral(String sqlLiteral) {
        this.sqlLiteral_ = sqlLiteral;
        this.javaLiteral_ = this.stripQuotes(sqlLiteral);
    }

    public Object getLiteral() {
        return this.javaLiteral_;
    }

    public String getJavaType() {
        return this.sqlLiteral_.getClass().getName();
    }

    public void accept(Visitor visitor) {
        visitor.visitLiteral(this);
    }

    public String toSql() {
        return this.sqlLiteral_;
    }

    public String toString() {
        return this.toSql();
    }

    private String stripQuotes(String sqlLiteral) {
        String literal = sqlLiteral.substring(1, sqlLiteral.length() - 1);
        int charIndex = 0;
        StringBuffer newLiteral = new StringBuffer();
        while (charIndex < literal.length()) {
            char thisChar = literal.charAt(charIndex);
            int nextChar = charIndex + 1 < literal.length() ? (int)literal.charAt(charIndex + 1) : 32;
            newLiteral.append(thisChar);
            if (literal.charAt(charIndex) == '\'' && literal.charAt(charIndex + 1) == '\'') {
                ++charIndex;
            }
            ++charIndex;
        }
        return newLiteral.toString();
    }

    public boolean equals(Object other) {
        boolean equal = false;
        if (other instanceof StringLiteral) {
            StringLiteral otherLiteral = (StringLiteral)other;
            equal = this.sqlLiteral_.equals(otherLiteral.sqlLiteral_);
        }
        return equal;
    }
}

