/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ejb.ejbql;

import com.sun.ejb.ejbql.ExpressionBase;
import com.sun.ejb.ejbql.Symbol;
import com.sun.ejb.ejbql.Visitor;
import com.sun.enterprise.deployment.CMRFieldInfo;
import com.sun.enterprise.deployment.EjbCMPEntityDescriptor;
import com.sun.enterprise.deployment.PersistenceDescriptor;
import com.sun.enterprise.deployment.PersistentFieldInfo;
import com.sun.enterprise.deployment.RelationRoleDescriptor;
import com.sun.enterprise.deployment.RelationshipDescriptor;
import java.util.AbstractList;
import java.util.Iterator;
import java.util.Vector;

public abstract class CmrField
extends ExpressionBase
implements Symbol {
    private String name_;
    private RelationRoleDescriptor sourceRoleDescriptor_;
    private PersistenceDescriptor sinkPersistenceDescriptor_;
    private PersistenceDescriptor sourcePersistenceDescriptor_;
    private CMRFieldInfo cmrFieldInfo_;

    public CmrField(String name, RelationRoleDescriptor sourceRoleDescriptor) {
        this.name_ = name;
        this.sourceRoleDescriptor_ = sourceRoleDescriptor;
        EjbCMPEntityDescriptor owner = this.sourceRoleDescriptor_.getOwner();
        this.sourcePersistenceDescriptor_ = owner.getPersistenceDescriptor();
        EjbCMPEntityDescriptor partnerOwner = sourceRoleDescriptor.getPartner().getOwner();
        this.sinkPersistenceDescriptor_ = partnerOwner.getPersistenceDescriptor();
        try {
            this.cmrFieldInfo_ = this.sourcePersistenceDescriptor_.getCMRFieldInfoByName(this.name_);
        }
        catch (Exception e10) {
            throw new IllegalArgumentException("Can't find cmr field : " + this.name_);
        }
    }

    public boolean hasJoinTable() {
        return this.getRelationshipDescriptor().getJoinDescriptor() != null;
    }

    public RelationshipDescriptor getRelationshipDescriptor() {
        return this.sourceRoleDescriptor_.getRelationshipDescriptor();
    }

    public RelationRoleDescriptor getSourceRoleDescriptor() {
        return this.sourceRoleDescriptor_;
    }

    public PersistenceDescriptor getSourcePersistenceDescriptor() {
        return this.sourcePersistenceDescriptor_;
    }

    public PersistenceDescriptor getSinkPersistenceDescriptor() {
        return this.sinkPersistenceDescriptor_;
    }

    public CMRFieldInfo getCMRFieldInfo() {
        return this.cmrFieldInfo_;
    }

    public String toSql() {
        return this.name_;
    }

    public String getTableName() {
        return this.sinkPersistenceDescriptor_.getTableName();
    }

    public Iterator getFieldNames() {
        Vector<String> fields = new Vector<String>();
        if (this.hasJoinTable()) {
            PersistenceDescriptor joinTablePersistenceDesc = this.getRelationshipDescriptor().getJoinDescriptor().getPersistenceDescriptor();
            PersistentFieldInfo[] joinTableFields = joinTablePersistenceDesc.getPersistentFieldInfo();
            int i2 = 0;
            while (i2 < joinTableFields.length) {
                PersistentFieldInfo next = joinTableFields[i2];
                if (next.relatedObj == null) {
                    fields.add(next.columnName);
                } else if (this.sinkPersistenceDescriptor_ != null && next.relatedObj.getTableName().equals(this.sinkPersistenceDescriptor_.getTableName())) {
                    fields.add(next.columnName);
                }
                ++i2;
            }
        } else {
            int i3 = 0;
            while (i3 < this.cmrFieldInfo_.fkeyFields.length) {
                PersistentFieldInfo next = this.cmrFieldInfo_.fkeyFields[i3];
                fields.add(next.columnName);
                ++i3;
            }
        }
        return ((AbstractList)fields).iterator();
    }

    public String getName() {
        return this.name_;
    }

    public String toString() {
        return this.getName();
    }

    public void accept(Visitor visitor) {
        visitor.visitSymbol(this);
    }

    public boolean isCmrField() {
        return true;
    }

    public boolean isSingleValued() {
        return !this.isCollectionValued();
    }

    public boolean isCollectionValued() {
        return this.sourceRoleDescriptor_.getPartner().getIsMany();
    }

    public abstract String getTargetName();

    public boolean equals(Object other) {
        boolean equal = false;
        if (other instanceof CmrField) {
            CmrField otherCmr = (CmrField)other;
            equal = this.getTargetName().equals(otherCmr.getTargetName()) && this.getName().equals(otherCmr.getName());
        }
        return equal;
    }
}

