/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ejb.containers;

import com.sun.ejb.containers.BaseContainer;
import com.sun.ejb.containers.ContainerFactoryImpl;
import com.sun.ejb.containers.EJBContextImpl;
import com.sun.ejb.containers.StatefulSessionContainer;
import com.sun.enterprise.ServerConfiguration;
import com.sun.enterprise.log.Log;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.util.Enumeration;

final class RecyclerImpl {
    private static final boolean debug = false;
    private static final int DEFAULT_PASSIVATION_THRESHOLD = 128000000;
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(class$com$sun$ejb$containers$RecyclerImpl == null ? (class$com$sun$ejb$containers$RecyclerImpl = RecyclerImpl.class$("com.sun.ejb.containers.RecyclerImpl")) : class$com$sun$ejb$containers$RecyclerImpl);
    private ReferenceQueue refQ;
    private int sessionTimeout;
    private ContainerFactoryImpl containerFactory;
    private long counter;
    private long threshold;
    private Runtime runtime;
    static /* synthetic */ Class class$com$sun$ejb$containers$RecyclerImpl;

    RecyclerImpl(ContainerFactoryImpl containerFactory) {
        block5: {
            this.counter = 0L;
            this.runtime = Runtime.getRuntime();
            this.containerFactory = containerFactory;
            this.refQ = new ReferenceQueue();
            new RecyclerThread(this).start();
            ServerConfiguration config = ServerConfiguration.getConfiguration();
            String tim = config.getProperty("sessionbean.timeout");
            this.sessionTimeout = tim == null || tim.equals("") || tim.equals("0") ? 0 : Integer.parseInt(tim);
            if (this.sessionTimeout < 0) {
                this.sessionTimeout = 0;
            }
            String thresh = config.getProperty("passivation.threshold.memory");
            String ex2 = localStrings.getLocalString("containers.passivation_threshold_memory_error", "The value of passivation.threshold.memory in the default.properties file should be a positive integer.");
            if (thresh != null) {
                try {
                    this.threshold = Long.parseLong(thresh);
                    if (this.threshold < 0L) {
                        throw new RuntimeException(ex2);
                    }
                    break block5;
                }
                catch (NumberFormatException nfe) {
                    Log.err.println(ex2);
                    throw new RuntimeException(ex2);
                }
            }
            this.threshold = 128000000L;
        }
    }

    void initSoftRef(EJBContextImpl ctx) {
        Object referent = new Object();
        ctx.setSoftRef(new SoftRef(referent, this.refQ, ctx));
        ctx.setHardRef(referent);
        this.checkMemory();
    }

    private synchronized void checkMemory() {
        ++this.counter;
        if ((this.counter & 0xFL) != 0L) {
            return;
        }
        long free = this.runtime.freeMemory();
        long total = this.runtime.totalMemory();
        if (total - free < this.threshold) {
            return;
        }
        Enumeration containers = this.containerFactory.listContainers();
        while (containers.hasMoreElements()) {
            BaseContainer container = (BaseContainer)containers.nextElement();
            Enumeration beans = container.listActiveEJBs();
            if (beans == null) continue;
            long totlife = 0L;
            int count = 0;
            while (beans.hasMoreElements()) {
                EJBContextImpl ctx = (EJBContextImpl)beans.nextElement();
                totlife += ctx.getLastTimeUsed();
                ++count;
            }
            if (count == 0) continue;
            long averageTime = (long)((double)totlife / (double)count);
            beans = container.listActiveEJBs();
            while (beans.hasMoreElements()) {
                EJBContextImpl ctx = (EJBContextImpl)beans.nextElement();
                if (ctx.getLastTimeUsed() >= averageTime) continue;
                ctx.setHardRef(null);
            }
        }
    }

    private void removeTimedoutSessionEJBs() {
        Enumeration containers = this.containerFactory.listContainers();
        while (containers.hasMoreElements()) {
            Object container = containers.nextElement();
            if (!(container instanceof StatefulSessionContainer)) continue;
            ((StatefulSessionContainer)container).timeoutBeans(this.sessionTimeout);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    class RecyclerThread
    extends Thread {
        private static final int SLEEPTIME = 60000;
        RecyclerImpl recycler;

        RecyclerThread(RecyclerImpl r2) {
            this.recycler = r2;
        }

        public void run() {
            while (true) {
                Reference ref = null;
                try {
                    ref = this.recycler.refQ.remove(60000L);
                }
                catch (InterruptedException ex2) {
                    // empty catch block
                }
                try {
                    if (ref == null) {
                        this.recycler.removeTimedoutSessionEJBs();
                        continue;
                    }
                    SoftRef softRef = (SoftRef)ref;
                    EJBContextImpl ctx = softRef.context;
                    BaseContainer container = (BaseContainer)ctx.getContainer();
                    container.passivateEJB(ctx);
                }
                catch (Exception exception) {
                }
            }
        }
    }

    class SoftRef
    extends SoftReference {
        private EJBContextImpl context;

        SoftRef(Object referent, ReferenceQueue q2, EJBContextImpl context) {
            super(referent, q2);
            this.context = context;
        }
    }
}

