/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ejb.codegen;

import com.sun.ejb.codegen.CMPClassGenerator;
import com.sun.ejb.codegen.Generator;
import com.sun.ejb.codegen.GeneratorException;
import com.sun.ejb.codegen.HomeGenerator;
import com.sun.ejb.codegen.PersistentStateGenerator;
import com.sun.ejb.codegen.WrapperGenerator;
import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.ApplicationArchivist;
import com.sun.enterprise.deployment.Archivist;
import com.sun.enterprise.deployment.EjbBundleDescriptor;
import com.sun.enterprise.deployment.EjbCMPEntityDescriptor;
import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.EjbMessageBeanDescriptor;
import com.sun.enterprise.deployment.JoinObjectDescriptor;
import com.sun.enterprise.deployment.RelationshipDescriptor;
import com.sun.enterprise.log.Log;
import com.sun.enterprise.tools.deployment.backend.DeploymentSession;
import com.sun.enterprise.util.FileUtil;
import com.sun.enterprise.util.JarAccess;
import com.sun.enterprise.util.JarClassLoader;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.enterprise.util.NotificationEvent;
import com.sun.enterprise.util.ORBManager;
import com.sun.enterprise.util.TypeUtil;
import com.sun.enterprise.util.Utility;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Set;
import java.util.Vector;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import sun.tools.javac.Main;

public final class GeneratorDriver {
    private static final boolean debug = false;
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(class$com$sun$ejb$codegen$GeneratorDriver == null ? (class$com$sun$ejb$codegen$GeneratorDriver = GeneratorDriver.class$("com.sun.ejb.codegen.GeneratorDriver")) : class$com$sun$ejb$codegen$GeneratorDriver);
    private static DeploymentSession session;
    private static String applicationName;
    private static final String fs;
    private static final char fsc;
    private static final String ps;
    private static final String ORG_OMG_STUB_PREFIX = "org.omg.stub.";
    private static final String COM_SUN_PREFIX = "com.sun.";
    private static File tmpDir;
    private static File appTmpDir;
    static /* synthetic */ Class class$com$sun$ejb$codegen$GeneratorDriver;
    static /* synthetic */ Class class$javax$ejb$EJBHome;
    static /* synthetic */ Class class$javax$ejb$EJBObject;

    private GeneratorDriver() {
    }

    public static File getTempDirectory() {
        return appTmpDir;
    }

    public static File getTempDirectory(String appName) {
        return new File(tmpDir, appName);
    }

    private static String getApplicationName() {
        return applicationName;
    }

    static String getFileName(String className) {
        return GeneratorDriver.getTempDirectory() + fs + className.replace('.', fsc) + ".java";
    }

    static String getClassName(String fileName) {
        String className = fileName;
        if (className.startsWith(GeneratorDriver.getTempDirectory().toString())) {
            className = className.substring(GeneratorDriver.getTempDirectory().toString().length());
        }
        if (className.indexOf(".java") != -1) {
            className = className.substring(0, className.indexOf(".java"));
        } else if (className.indexOf(".class") != -1) {
            className = className.substring(0, className.indexOf(".class"));
        }
        className = className.replace(fsc, '.');
        if (className.charAt(0) == '.') {
            className = className.substring(1);
        }
        return className;
    }

    private static void setSession(DeploymentSession sessionObject, String appName) {
        session = sessionObject;
        applicationName = appName;
        appTmpDir = new File(tmpDir, applicationName);
        appTmpDir.mkdirs();
    }

    private static OutputStream createOutputStream(String className) throws IOException {
        String fileName = GeneratorDriver.getFileName(className);
        File file = new File(fileName);
        if (file.getParent() != null) {
            new File(file.getParent()).mkdirs();
        }
        return new FileOutputStream(fileName);
    }

    private static void generateCode(Generator gen, Vector files) throws Exception {
        try {
            String genClass = gen.getGeneratedClass();
            OutputStream out = GeneratorDriver.createOutputStream(genClass);
            gen.generate(out);
            out.close();
            String genFile = GeneratorDriver.getFileName(genClass);
            if (!files.contains(genFile)) {
                files.addElement(genFile);
            }
        }
        catch (Exception ex2) {
            Log.err.println(ex2);
        }
    }

    private static void compileAndRmic(File jarFile, Vector files, Set extraStubClasses) throws GeneratorException, IOException {
        sun.rmi.rmic.Main comp;
        if (files.size() == 0 && extraStubClasses.size() == 0) {
            System.out.println(localStrings.getLocalString("generator.nothing_to_compile", "No code generation required"));
            GeneratorDriver.progressEvent("Ejb Compilation complete", session);
            GeneratorDriver.progressEvent("Ejb Compilation complete", session);
            return;
        }
        GeneratorDriver.progress(localStrings.getLocalString("generator.compiling_wrapper", "Compiling wrapper code."));
        if (files.size() > 0) {
            GeneratorDriver.compileClasses(jarFile, files);
            if (session.isCancelled()) {
                return;
            }
            GeneratorDriver.progressEvent("Ejb Compilation complete", session);
        }
        GeneratorDriver.progress(localStrings.getLocalString("generator.compiling_rmi_iiop", "Compiling RMI-IIOP code."));
        int numRmicArgs = 9 + files.size() + extraStubClasses.size();
        String[] rmicArgs = new String[numRmicArgs];
        int rmicCnt = 0;
        rmicArgs[rmicCnt++] = "-iiop";
        rmicArgs[rmicCnt++] = "-poa";
        rmicArgs[rmicCnt++] = "-alwaysgenerate";
        rmicArgs[rmicCnt++] = "-keepgenerated";
        rmicArgs[rmicCnt++] = "-nolocalstubs";
        rmicArgs[rmicCnt++] = "-classpath";
        rmicArgs[rmicCnt++] = System.getProperty("java.class.path") + ps + jarFile + ps + GeneratorDriver.getTempDirectory();
        rmicArgs[rmicCnt++] = "-d";
        rmicArgs[rmicCnt++] = GeneratorDriver.getTempDirectory().toString();
        String cname = "";
        Enumeration e12 = files.elements();
        while (e12.hasMoreElements()) {
            String file = (String)e12.nextElement();
            String className = GeneratorDriver.getClassName(file);
            System.out.println("rmic " + className + "...");
            rmicArgs[rmicCnt++] = className;
            cname = cname + " " + className;
        }
        Iterator extraIter = extraStubClasses.iterator();
        while (extraIter.hasNext()) {
            String next = (String)extraIter.next();
            System.out.println("rmic " + next + "...");
            rmicArgs[rmicCnt++] = next;
        }
        try {
            comp = new sun.rmi.rmic.Main(System.err, "rmic");
        }
        catch (Throwable t2) {
            t2.printStackTrace();
            System.err.println("Could not invoke rmic..");
            throw new GeneratorException("Could not invoke rmic");
        }
        if (!comp.compile(rmicArgs)) {
            System.err.println("rmic compilation failed...");
            throw new GeneratorException("rmic compilation failed.");
        }
        if (session.isCancelled()) {
            return;
        }
        GeneratorDriver.progressEvent("Ejb Compilation complete", session);
    }

    private static void compileClasses(File jarFile, Vector files) throws GeneratorException {
        Main compiler;
        int size = files.size();
        if (size == 0) {
            return;
        }
        Enumeration e10 = files.elements();
        String[] javacArgs = new String[4 + size];
        int cnt = 0;
        javacArgs[cnt++] = "-d";
        javacArgs[cnt++] = GeneratorDriver.getTempDirectory().toString();
        javacArgs[cnt++] = "-classpath";
        javacArgs[cnt++] = System.getProperty("java.class.path") + ps + jarFile + ps + GeneratorDriver.getTempDirectory().toString();
        while (e10.hasMoreElements()) {
            String file = (String)e10.nextElement();
            javacArgs[cnt++] = file;
            System.out.println(localStrings.getLocalString("generator.compile", "Compiling {0} ...", new Object[]{file}));
        }
        try {
            compiler = new Main((OutputStream)System.err, "javac");
        }
        catch (Throwable t2) {
            System.err.println(t2);
            System.err.println(localStrings.getLocalString("generator.compile_failed", "Compilation failed..."));
            throw new GeneratorException("Could not invoke javac.");
        }
        if (!compiler.compile(javacArgs)) {
            System.err.println(localStrings.getLocalString("generator.compile_failed", "Compilation failed..."));
            throw new GeneratorException("Compilation failed.");
        }
        int i2 = 0;
        while (i2 < files.size()) {
            String javaFile = (String)files.elementAt(i2);
            String classFile = javaFile.substring(0, javaFile.indexOf(".java")) + ".class";
            files.setElementAt(classFile, i2);
            ++i2;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void processReusableGeneratedFiles(Vector descriptors, Vector allFiles, File oldServerJar) throws IOException {
        if (oldServerJar == null || descriptors.size() == 0) {
            return;
        }
        int FILES_PER_DESC = 6;
        int totalNumFiles = descriptors.size() * 6;
        String[] files = new String[totalNumFiles];
        int i2 = 0;
        while (i2 < descriptors.size()) {
            EjbDescriptor desc = (EjbDescriptor)descriptors.elementAt(i2);
            GeneratedNames names = new GeneratedNames(desc);
            allFiles.add(GeneratorDriver.getTempDirectory() + fs + names.getEjbObjectImplClass());
            allFiles.add(GeneratorDriver.getTempDirectory() + fs + names.getHomeImplClass());
            int baseFileIndex = i2 * 6;
            files[baseFileIndex + 0] = names.getEjbObjectImplClass();
            files[baseFileIndex + 1] = names.getHomeImplClass();
            files[baseFileIndex + 2] = names.getHomeTieClass();
            files[baseFileIndex + 3] = names.getHomeStubClass();
            files[baseFileIndex + 4] = names.getRemoteStubClass();
            files[baseFileIndex + 5] = names.getEjbObjectTieClass();
            ++i2;
        }
        FileInputStream inputStream = null;
        try {
            inputStream = new FileInputStream(oldServerJar);
            JarAccess.extract(inputStream, files, GeneratorDriver.getTempDirectory().toString());
            Object var11_10 = null;
            if (inputStream == null) return;
        }
        catch (Throwable throwable) {
            Object var11_11 = null;
            if (inputStream == null) throw throwable;
            ((InputStream)inputStream).close();
            throw throwable;
        }
        ((InputStream)inputStream).close();
    }

    private static void addGeneratedFiles(Vector dds, Set extraStubClasses, Vector serverFiles, Vector allClientFiles) {
        int ddIndex = 0;
        while (ddIndex < dds.size()) {
            EjbDescriptor dd2 = (EjbDescriptor)dds.elementAt(ddIndex);
            GeneratedNames names = new GeneratedNames(dd2);
            String homeStubClass = GeneratorDriver.getTempDirectory() + fs + names.getHomeStubClass();
            serverFiles.addElement(homeStubClass);
            allClientFiles.addElement(homeStubClass);
            String tieClassName = GeneratorDriver.getTempDirectory() + fs + names.getHomeTieClass();
            serverFiles.addElement(tieClassName);
            String remoteStub = GeneratorDriver.getTempDirectory() + fs + names.getRemoteStubClass();
            serverFiles.addElement(remoteStub);
            allClientFiles.addElement(remoteStub);
            String ejbObjectTie = GeneratorDriver.getTempDirectory() + fs + names.getEjbObjectTieClass();
            serverFiles.addElement(ejbObjectTie);
            ++ddIndex;
        }
        Iterator iter = extraStubClasses.iterator();
        while (iter.hasNext()) {
            String next = (String)iter.next();
            String stubFile = GeneratorDriver.getTempDirectory() + fs + GeneratedNames.getStubName(next).replace('.', fsc) + ".class";
            serverFiles.add(stubFile);
            allClientFiles.add(stubFile);
        }
    }

    private static boolean ddHasUniqueInterfaces(Vector deploymentDescriptors, EjbDescriptor ddToCheck) {
        boolean hasUniqueInterfaces = true;
        if (!ddToCheck.isRemoteInterfacesSupported()) {
            return false;
        }
        int i2 = 0;
        while (i2 < deploymentDescriptors.size()) {
            EjbDescriptor currentDD = (EjbDescriptor)deploymentDescriptors.elementAt(i2);
            if (currentDD.isRemoteInterfacesSupported() && currentDD.getHomeClassName().equals(ddToCheck.getHomeClassName()) && currentDD.getRemoteClassName().equals(ddToCheck.getRemoteClassName()) && currentDD.getEjbClassName().equals(ddToCheck.getEjbClassName())) {
                hasUniqueInterfaces = false;
                break;
            }
            ++i2;
        }
        return hasUniqueInterfaces;
    }

    private static String cookJar(String appName, File original, File dst, File clientDst, Vector allServerFiles, Vector allClientFiles) throws IOException {
        int sz = allServerFiles.size();
        int clientSz = allClientFiles.size();
        boolean index = false;
        boolean clientIndex = false;
        Vector<String> genFilesUnique = new Vector<String>();
        Vector<String> clientGenFilesUnique = new Vector<String>();
        int i2 = 0;
        while (i2 < allServerFiles.size()) {
            String nextFileToAdd = (String)allServerFiles.elementAt(i2);
            if (!genFilesUnique.contains(nextFileToAdd)) {
                genFilesUnique.addElement(nextFileToAdd);
            }
            ++i2;
        }
        int k2 = 0;
        while (k2 < allClientFiles.size()) {
            String nextFileToAdd = (String)allClientFiles.elementAt(k2);
            if (!clientGenFilesUnique.contains(nextFileToAdd)) {
                clientGenFilesUnique.addElement(nextFileToAdd);
            }
            ++k2;
        }
        GeneratorDriver.progress(localStrings.getLocalString("generator.making_client_jars", "making client JARs"));
        GeneratorDriver.progressEvent("Client JARs made", session);
        GeneratorDriver.makeJar(appName, original, dst, genFilesUnique);
        GeneratorDriver.progress(localStrings.getLocalString("generator.making_server_jars", "making server JARs"));
        GeneratorDriver.makeJar(appName, original, clientDst, clientGenFilesUnique);
        GeneratorDriver.progressEvent("Server JARs made", session);
        return dst.toString();
    }

    private static void makeJar(String appName, File inputJarFile, File outputJarFile, Vector files) throws IOException {
        if (outputJarFile.exists()) {
            System.out.println("Warning: " + outputJarFile + " already exists.");
        }
        FileOutputStream fos = new FileOutputStream(outputJarFile);
        ZipOutputStream zos = new ZipOutputStream(fos);
        Archivist.addJarToOutput(zos, new JarFile(inputJarFile), new Vector());
        Enumeration e10 = files.elements();
        while (e10.hasMoreElements()) {
            String longName = (String)e10.nextElement();
            File file = new File(longName);
            String entryName = "";
            if (longName.startsWith(GeneratorDriver.getTempDirectory(appName).toString())) {
                entryName = longName.substring(GeneratorDriver.getTempDirectory(appName).toString().length());
                if (entryName.charAt(0) == fsc) {
                    entryName = entryName.substring(1);
                }
            } else {
                throw new RuntimeException("error");
            }
            entryName = entryName.replace(fsc, '/');
            FileInputStream fis = new FileInputStream(file);
            zos.putNextEntry(new ZipEntry(entryName));
            Archivist.copy(fis, zos);
            zos.closeEntry();
            fis.close();
        }
        zos.close();
        fos.close();
    }

    private static boolean descriptorRequiresCodeGen(EjbDescriptor desc, File oldServerJar, File ejbJar) {
        boolean codeGenRequired = false;
        HashSet<String> allInterfaces = new HashSet<String>();
        String homeName = desc.getHomeClassName();
        String remoteName = desc.getRemoteClassName();
        String bean = desc.getEjbClassName();
        allInterfaces.add(homeName);
        allInterfaces.add(remoteName);
        allInterfaces.add(bean);
        try {
            JarClassLoader jcl = new JarClassLoader(ejbJar.toString());
            Set homeSuperInterfaces = TypeUtil.getSuperInterfaces(jcl, homeName, "javax.ejb.EJBHome");
            Set remoteSuperInterfaces = TypeUtil.getSuperInterfaces(jcl, remoteName, "javax.ejb.EJBObject");
            allInterfaces.addAll(homeSuperInterfaces);
            allInterfaces.addAll(remoteSuperInterfaces);
            Iterator iter = allInterfaces.iterator();
            while (iter.hasNext()) {
                String className = (String)iter.next();
                String entryName = className.replace('.', fsc) + ".class";
                if (FileUtil.jarEntriesEqual(oldServerJar, entryName, ejbJar, entryName)) continue;
                codeGenRequired = true;
                break;
            }
        }
        catch (Exception e10) {
            codeGenRequired = true;
        }
        return codeGenRequired;
    }

    public static String preDeploy(String appName, File srcJar, File dstJar, File clientDstJar, DeploymentSession session, File oldServerJar) throws GeneratorException, ClassNotFoundException, IOException, Exception {
        GeneratorDriver.setSession(session, appName);
        final JarClassLoader jcl = new JarClassLoader();
        jcl.addJar(srcJar.toString());
        File gntrDir = GeneratorDriver.getTempDirectory();
        gntrDir.mkdirs();
        jcl.addDir(GeneratorDriver.getTempDirectory().toURL());
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                Thread.currentThread().setContextClassLoader(jcl);
                return null;
            }
        });
        Vector<EjbDescriptor> deploymentDescriptors = new Vector<EjbDescriptor>();
        HashSet<String> ejbHomeInterfaces = new HashSet<String>();
        HashSet<String> ejbRemoteInterfaces = new HashSet<String>();
        Application application = ApplicationArchivist.open(srcJar, jcl);
        Enumeration e10 = application.getEjbDescriptors().elements();
        int ejbCount = 0;
        while (e10.hasMoreElements()) {
            ++ejbCount;
            EjbDescriptor next = (EjbDescriptor)e10.nextElement();
            if (next instanceof EjbMessageBeanDescriptor) continue;
            ejbHomeInterfaces.add(next.getHomeClassName());
            ejbRemoteInterfaces.add(next.getRemoteClassName());
            deploymentDescriptors.addElement(next);
        }
        GeneratorDriver.progress(localStrings.getLocalString("generator.processing_beans", "Processing beans..."));
        Vector cmpFiles = new Vector();
        int i2 = 0;
        while (i2 < deploymentDescriptors.size()) {
            EjbDescriptor desc = (EjbDescriptor)deploymentDescriptors.elementAt(i2);
            if (desc instanceof EjbCMPEntityDescriptor) {
                CMPClassGenerator gen = new CMPClassGenerator(desc, jcl, cmpFiles);
                GeneratorDriver.generateCode(gen, cmpFiles);
                String concreteClassName = ((Generator)gen).getGeneratedClass();
                EjbCMPEntityDescriptor entd = (EjbCMPEntityDescriptor)desc;
                if (entd.isEJB20()) {
                    PersistentStateGenerator pgen = new PersistentStateGenerator(desc, jcl, cmpFiles, concreteClassName);
                    GeneratorDriver.generateCode(pgen, cmpFiles);
                    entd.setStateImplClassName(((Generator)pgen).getGeneratedClass());
                }
                desc.setEjbClassName(concreteClassName);
            }
            ++i2;
        }
        Iterator itr = application.getEjbBundleDescriptors().iterator();
        while (itr.hasNext()) {
            EjbBundleDescriptor bundle = (EjbBundleDescriptor)itr.next();
            Iterator rels = bundle.getRelationships().iterator();
            while (rels.hasNext()) {
                RelationshipDescriptor rd = (RelationshipDescriptor)rels.next();
                if (rd.isOneOne()) continue;
                JoinObjectDescriptor desc = rd.getJoinDescriptor();
                if (desc == null) {
                    throw new RuntimeException("ERROR: no JoinObjectDescriptor for 1-many/many-many relationship. Possible cause: SQL generator has not been run.");
                }
                CMPClassGenerator gen = new CMPClassGenerator(desc, jcl, cmpFiles);
                GeneratorDriver.generateCode(gen, cmpFiles);
                desc.setJoinObjectClass(((Generator)gen).getGeneratedClass());
            }
        }
        GeneratorDriver.compileClasses(srcJar, cmpFiles);
        Vector localFiles = new Vector();
        int i3 = 0;
        while (i3 < deploymentDescriptors.size()) {
            EjbDescriptor desc = (EjbDescriptor)deploymentDescriptors.elementAt(i3);
            if (desc.isLocalInterfacesSupported()) {
                Generator gen = new HomeGenerator(desc, jcl, true, localFiles);
                GeneratorDriver.generateCode(gen, localFiles);
                desc.setLocalHomeImplClassName(gen.getGeneratedClass());
                gen = new WrapperGenerator(desc, jcl, true, localFiles);
                GeneratorDriver.generateCode(gen, localFiles);
                desc.setEJBLocalObjectImplClassName(gen.getGeneratedClass());
            }
            ++i3;
        }
        GeneratorDriver.compileClasses(srcJar, localFiles);
        Vector<EjbDescriptor> descriptorsEligibleForCodegen = new Vector<EjbDescriptor>();
        Vector<EjbDescriptor> duplicateDescs = new Vector<EjbDescriptor>();
        int i4 = 0;
        while (i4 < deploymentDescriptors.size()) {
            EjbDescriptor dd2 = (EjbDescriptor)deploymentDescriptors.elementAt(i4);
            if (!(dd2 instanceof EjbMessageBeanDescriptor)) {
                if (GeneratorDriver.ddHasUniqueInterfaces(descriptorsEligibleForCodegen, dd2)) {
                    descriptorsEligibleForCodegen.add(dd2);
                } else {
                    duplicateDescs.add(dd2);
                }
            }
            ++i4;
        }
        Vector<EjbDescriptor> descriptorsRequiringCodeGen = new Vector<EjbDescriptor>();
        Vector<EjbDescriptor> reusableDescriptors = new Vector<EjbDescriptor>();
        boolean reuse = true;
        if (oldServerJar != null) {
            Hashtable<EjbBundleDescriptor, File> allEjbJars = new Hashtable<EjbBundleDescriptor, File>();
            Application app = ApplicationArchivist.open(srcJar);
            Vector<String> existingClasses = new Vector<String>();
            int i5 = 0;
            while (i5 < descriptorsEligibleForCodegen.size()) {
                EjbDescriptor desc = (EjbDescriptor)descriptorsEligibleForCodegen.elementAt(i5);
                if (existingClasses.contains(desc.getHomeClassName()) || existingClasses.contains(desc.getRemoteClassName()) || existingClasses.contains(desc.getEjbClassName())) {
                    reuse = false;
                    break;
                }
                existingClasses.add(desc.getHomeClassName());
                existingClasses.add(desc.getRemoteClassName());
                existingClasses.add(desc.getEjbClassName());
                ++i5;
            }
            if (reuse) {
                int i6 = 0;
                while (i6 < descriptorsEligibleForCodegen.size()) {
                    EjbDescriptor desc = (EjbDescriptor)descriptorsEligibleForCodegen.elementAt(i6);
                    EjbBundleDescriptor bundleDesc = desc.getEjbBundleDescriptor();
                    File ejbJar = (File)allEjbJars.get(bundleDesc);
                    if (ejbJar == null) {
                        ejbJar = new File(GeneratorDriver.getTempDirectory() + fs + "temp__ejb" + i6);
                        app.getApplicationArchivist().extractBundleToFile(bundleDesc, ejbJar);
                        allEjbJars.put(bundleDesc, ejbJar);
                    }
                    if (GeneratorDriver.descriptorRequiresCodeGen(desc, oldServerJar, ejbJar)) {
                        descriptorsRequiringCodeGen.add(desc);
                    } else {
                        reusableDescriptors.add(desc);
                        desc.setEJBObjectImplClassName(WrapperGenerator.getDefaultEJBObjectImplClassName(desc));
                        desc.setRemoteHomeImplClassName(HomeGenerator.getDefaultRemoteHomeImplClassName(desc));
                    }
                    ++i6;
                }
            }
        } else {
            reuse = false;
        }
        if (!reuse) {
            descriptorsRequiringCodeGen = descriptorsEligibleForCodegen;
        }
        HashSet<String> extraStubClasses = new HashSet<String>();
        ApplicationArchivist archivist = application.getApplicationArchivist();
        Vector classNames = archivist.getClassNames();
        String nextClassName = null;
        int i7 = 0;
        while (i7 < classNames.size()) {
            nextClassName = (String)classNames.elementAt(i7);
            try {
                Class<?> nextClass = jcl.loadClass(nextClassName);
                if (((class$javax$ejb$EJBHome == null ? GeneratorDriver.class$("javax.ejb.EJBHome") : class$javax$ejb$EJBHome).isAssignableFrom(nextClass) || (class$javax$ejb$EJBObject == null ? GeneratorDriver.class$("javax.ejb.EJBObject") : class$javax$ejb$EJBObject).isAssignableFrom(nextClass)) && !ejbHomeInterfaces.contains(nextClassName) && !ejbRemoteInterfaces.contains(nextClassName)) {
                    extraStubClasses.add(nextClassName);
                }
            }
            catch (Throwable t2) {
                // empty catch block
            }
            ++i7;
        }
        Vector homeRemoteFiles = new Vector();
        int i8 = 0;
        while (i8 < descriptorsRequiringCodeGen.size()) {
            EjbDescriptor desc = (EjbDescriptor)descriptorsRequiringCodeGen.elementAt(i8);
            if (desc.isRemoteInterfacesSupported()) {
                Generator gen = new HomeGenerator(desc, jcl, false, homeRemoteFiles);
                GeneratorDriver.generateCode(gen, homeRemoteFiles);
                desc.setRemoteHomeImplClassName(gen.getGeneratedClass());
                gen = new WrapperGenerator(desc, jcl, false, homeRemoteFiles);
                GeneratorDriver.generateCode(gen, homeRemoteFiles);
                desc.setEJBObjectImplClassName(gen.getGeneratedClass());
            }
            if (session.isCancelled()) {
                return "";
            }
            ++i8;
        }
        if (ejbCount > 0) {
            GeneratorDriver.progressEvent("Ejb Code Generation complete", session);
        }
        GeneratorDriver.compileAndRmic(srcJar, homeRemoteFiles, extraStubClasses);
        if (reuse) {
            GeneratorDriver.processReusableGeneratedFiles(reusableDescriptors, homeRemoteFiles, oldServerJar);
        }
        int i9 = 0;
        while (i9 < duplicateDescs.size()) {
            int j2 = 0;
            while (j2 < descriptorsEligibleForCodegen.size()) {
                EjbDescriptor dupDD = (EjbDescriptor)duplicateDescs.elementAt(i9);
                EjbDescriptor genDD = (EjbDescriptor)descriptorsEligibleForCodegen.elementAt(j2);
                if (dupDD.isRemoteInterfacesSupported() && genDD.isRemoteInterfacesSupported() && dupDD.getHomeClassName().equals(genDD.getHomeClassName()) && dupDD.getRemoteClassName().equals(genDD.getRemoteClassName()) && dupDD.getEjbClassName().equals(genDD.getEjbClassName())) {
                    dupDD.setRemoteHomeImplClassName(genDD.getRemoteHomeImplClassName());
                    dupDD.setEJBObjectImplClassName(genDD.getEJBObjectImplClassName());
                }
                ++j2;
            }
            ++i9;
        }
        if (session.isCancelled()) {
            return "";
        }
        Vector allClientFiles = new Vector();
        Vector allServerFiles = new Vector();
        allServerFiles.addAll(homeRemoteFiles);
        GeneratorDriver.addGeneratedFiles(descriptorsEligibleForCodegen, extraStubClasses, allServerFiles, allClientFiles);
        allServerFiles.addAll(cmpFiles);
        allServerFiles.addAll(localFiles);
        if (session.isCancelled()) {
            return "";
        }
        File newSrcJar = new File(srcJar.getAbsolutePath() + ".new");
        application.getApplicationArchivist().save(newSrcJar, true);
        String s2 = GeneratorDriver.cookJar(appName, newSrcJar, dstJar, clientDstJar, allServerFiles, allClientFiles);
        newSrcJar.delete();
        GeneratorDriver.setSession(null, "");
        return s2;
    }

    public static void main(String[] args) {
        ORBManager.init(args, null);
        int i2 = 0;
        while (i2 < args.length) {
            try {
                String cookedJar = args[i2].substring(0, args[i2].lastIndexOf(46));
                String clientJar = cookedJar + "Client.jar";
                cookedJar = cookedJar + "Cooked.jar";
                File file = new File(cookedJar);
                File clientFile = new File(clientJar);
                GeneratorDriver.preDeploy("main", new File(args[i2]), file, clientFile, null, null);
            }
            catch (GeneratorException ex2) {
                System.out.println(ex2);
            }
            catch (ClassNotFoundException ex3) {
                System.err.println(ex3);
            }
            catch (IOException ex4) {
                System.err.println(ex4);
            }
            catch (Exception ex5) {
                ex5.printStackTrace();
            }
            ++i2;
        }
        System.exit(0);
    }

    private static void progress(String message) {
        if (session != null) {
            try {
                session.setStatusMessage(message);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    private static void progressEvent(String eventType, DeploymentSession session) {
        if (session != null) {
            try {
                session.notification(new NotificationEvent("", eventType, ""));
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        fs = System.getProperty("file.separator");
        fsc = fs.charAt(0);
        ps = System.getProperty("path.separator");
        String eHome = System.getProperty("com.sun.enterprise.home");
        if (eHome == null) {
            eHome = "tmp";
        }
        String hostname = Utility.getLocalHost();
        String tmpDirName = eHome + File.separator + "repository" + File.separator + hostname + File.separator + "gnrtrTMP";
        tmpDir = new File(tmpDirName == null ? "tmp" : tmpDirName);
        if (!tmpDir.exists()) {
            tmpDir.mkdir();
        }
    }

    private static class GeneratedNames {
        private String homeImplClass;
        private String homeTieClass;
        private String homeStubClass;
        private String remoteStubClass;
        private String ejbObjectTieClass;
        private String ejbObjectImplClass;

        static String getStubName(String fullName) {
            String className = fullName;
            String packageName = "";
            int lastDot = fullName.lastIndexOf(46);
            if (lastDot != -1) {
                className = fullName.substring(lastDot + 1, fullName.length());
                packageName = fullName.substring(0, lastDot + 1);
            }
            String stubName = packageName + "_" + className + "_Stub";
            if (fullName.startsWith(GeneratorDriver.COM_SUN_PREFIX)) {
                stubName = GeneratorDriver.ORG_OMG_STUB_PREFIX + stubName;
            }
            return stubName;
        }

        private String getTieName(String fullName) {
            String className = fullName;
            String packageName = "";
            int lastDot = fullName.lastIndexOf(46);
            if (lastDot != -1) {
                className = fullName.substring(lastDot + 1, fullName.length());
                packageName = fullName.substring(0, lastDot + 1);
            }
            String tieName = packageName + "_" + className + "_Tie";
            if (fullName.startsWith(GeneratorDriver.COM_SUN_PREFIX)) {
                tieName = GeneratorDriver.ORG_OMG_STUB_PREFIX + tieName;
            }
            return tieName;
        }

        public GeneratedNames(EjbDescriptor desc) {
            this.ejbObjectImplClass = desc.getEJBObjectImplClassName().replace('.', fsc) + ".class";
            this.ejbObjectTieClass = this.getTieName(desc.getEJBObjectImplClassName()).replace('.', fsc) + ".class";
            this.homeImplClass = desc.getRemoteHomeImplClassName().replace('.', fsc) + ".class";
            this.homeTieClass = this.getTieName(desc.getRemoteHomeImplClassName()).replace('.', fsc) + ".class";
            this.homeStubClass = GeneratedNames.getStubName(desc.getHomeClassName()).replace('.', fsc) + ".class";
            this.remoteStubClass = GeneratedNames.getStubName(desc.getRemoteClassName()).replace('.', fsc) + ".class";
        }

        public String getEjbObjectImplClass() {
            return this.ejbObjectImplClass;
        }

        public String getHomeImplClass() {
            return this.homeImplClass;
        }

        public String getHomeTieClass() {
            return this.homeTieClass;
        }

        public String getHomeStubClass() {
            return this.homeStubClass;
        }

        public String getRemoteStubClass() {
            return this.remoteStubClass;
        }

        public String getEjbObjectTieClass() {
            return this.ejbObjectTieClass;
        }
    }
}

