/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.ee.internal.ior;

import com.sun.corba.ee.internal.corba.EncapsInputStream;
import com.sun.corba.ee.internal.corba.EncapsOutputStream;
import com.sun.corba.ee.internal.iiop.CDRInputStream;
import com.sun.corba.ee.internal.ior.IIOPAddressImpl;
import com.sun.corba.ee.internal.ior.IIOPProfileTemplate;
import com.sun.corba.ee.internal.ior.IdEncapsulationBase;
import com.sun.corba.ee.internal.ior.ObjectId;
import com.sun.corba.ee.internal.ior.ObjectKey;
import com.sun.corba.ee.internal.ior.ObjectKeyFactory;
import com.sun.corba.ee.internal.ior.ObjectKeyTemplate;
import com.sun.corba.ee.internal.ior.TaggedComponent;
import com.sun.corba.ee.internal.ior.TaggedComponentFactoryFinder;
import com.sun.corba.ee.internal.ior.TaggedProfile;
import java.util.Iterator;
import org.omg.CORBA.BAD_PARAM;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.ORB;
import org.omg.CORBA_2_3.portable.InputStream;
import org.omg.CORBA_2_3.portable.OutputStream;
import org.omg.IOP.TaggedProfileHelper;

public class IIOPProfile
extends IdEncapsulationBase
implements TaggedProfile {
    private ObjectId id;
    private final IIOPProfileTemplate template;

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (!(object instanceof IIOPProfile)) {
            return false;
        }
        IIOPProfile iIOPProfile = (IIOPProfile)object;
        return this.id.equals(iIOPProfile.id) && this.template.equals(iIOPProfile.template);
    }

    public ObjectId getObjectId() {
        return this.id;
    }

    public IIOPProfileTemplate getTemplate() {
        return this.template;
    }

    public IIOPProfile(ObjectId objectId, IIOPProfileTemplate iIOPProfileTemplate) {
        this.id = objectId;
        this.template = iIOPProfileTemplate;
    }

    public IIOPProfile(InputStream inputStream) {
        InputStream inputStream2 = IdEncapsulationBase.getEncapsulationStream(inputStream);
        byte by2 = inputStream2.read_octet();
        byte by3 = inputStream2.read_octet();
        IIOPAddressImpl iIOPAddressImpl = new IIOPAddressImpl(inputStream2);
        byte[] byArray = IdEncapsulationBase.readOctets(inputStream2);
        ORB oRB = ((CDRInputStream)inputStream).orb();
        ObjectKey objectKey = ObjectKeyFactory.get().create(oRB, byArray);
        this.id = objectKey.getId();
        this.template = new IIOPProfileTemplate(by2, by3, iIOPAddressImpl, objectKey.getTemplate());
        if (by3 > 0) {
            this.template.readIdEncapsulationSequence(TaggedComponentFactoryFinder.getFinder(), inputStream2);
        }
    }

    public IIOPProfile(ORB oRB, org.omg.IOP.TaggedProfile taggedProfile) {
        if (taggedProfile == null || taggedProfile.tag != 0 || taggedProfile.profile_data == null) {
            throw new BAD_PARAM(1398079692, CompletionStatus.COMPLETED_NO);
        }
        EncapsInputStream encapsInputStream = new EncapsInputStream(oRB, taggedProfile.profile_data, taggedProfile.profile_data.length);
        encapsInputStream.consumeEndian();
        byte by2 = encapsInputStream.read_octet();
        byte by3 = encapsInputStream.read_octet();
        IIOPAddressImpl iIOPAddressImpl = new IIOPAddressImpl(encapsInputStream);
        byte[] byArray = IdEncapsulationBase.readOctets(encapsInputStream);
        ObjectKey objectKey = ObjectKeyFactory.get().create(oRB, byArray);
        this.id = objectKey.getId();
        this.template = new IIOPProfileTemplate(by2, by3, iIOPAddressImpl, objectKey.getTemplate());
        if (by3 > 0) {
            this.template.readIdEncapsulationSequence(TaggedComponentFactoryFinder.getFinder(), encapsInputStream);
        }
    }

    public void writeContents(OutputStream outputStream) {
        this.template.write(this.id, outputStream);
    }

    public int getId() {
        return this.template.getId();
    }

    public boolean isEquivalent(IIOPProfile iIOPProfile) {
        return this.id.equals(iIOPProfile.id) && this.template.isEquivalent(iIOPProfile.template);
    }

    public ObjectKey getObjectKey() {
        ObjectKeyTemplate objectKeyTemplate = this.template.getObjectKeyTemplate();
        ObjectKey objectKey = new ObjectKey(objectKeyTemplate, this.id);
        return objectKey;
    }

    public org.omg.IOP.TaggedProfile getIOPProfile(ORB oRB) {
        EncapsOutputStream encapsOutputStream = new EncapsOutputStream(oRB);
        encapsOutputStream.write_long(this.getId());
        this.write(encapsOutputStream);
        InputStream inputStream = (InputStream)encapsOutputStream.create_input_stream();
        return TaggedProfileHelper.read((org.omg.CORBA.portable.InputStream)inputStream);
    }

    public org.omg.IOP.TaggedComponent[] getIOPComponents(ORB oRB, int n2) {
        int n3 = 0;
        Iterator iterator = this.template.iteratorById(n2);
        while (iterator.hasNext()) {
            iterator.next();
            ++n3;
        }
        org.omg.IOP.TaggedComponent[] taggedComponentArray = new org.omg.IOP.TaggedComponent[n3];
        int n4 = 0;
        iterator = this.template.iteratorById(n2);
        while (iterator.hasNext()) {
            TaggedComponent taggedComponent = (TaggedComponent)iterator.next();
            taggedComponentArray[n4++] = taggedComponent.getIOPComponent(oRB);
        }
        return taggedComponentArray;
    }
}

