/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.ee.internal.iiop;

import com.sun.corba.ee.internal.core.EndPoint;
import com.sun.corba.ee.internal.core.GIOPVersion;
import com.sun.corba.ee.internal.core.IOR;
import com.sun.corba.ee.internal.core.ServerGIOP;
import com.sun.corba.ee.internal.iiop.CachedCodeBase;
import com.sun.corba.ee.internal.iiop.ClientResponseImpl;
import com.sun.corba.ee.internal.iiop.Connection;
import com.sun.corba.ee.internal.iiop.ConnectionTable;
import com.sun.corba.ee.internal.iiop.IIOPInputStream;
import com.sun.corba.ee.internal.iiop.IIOPOutputStream;
import com.sun.corba.ee.internal.iiop.MessageMediator;
import com.sun.corba.ee.internal.iiop.ORB;
import com.sun.corba.ee.internal.iiop.ReaderThread;
import com.sun.corba.ee.internal.iiop.ServerRequestImpl;
import com.sun.corba.ee.internal.iiop.messages.CancelRequestMessage;
import com.sun.corba.ee.internal.iiop.messages.Message;
import com.sun.corba.ee.internal.iiop.messages.MessageBase;
import com.sun.org.omg.SendingContext.CodeBase;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import org.omg.CORBA.COMM_FAILURE;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.SystemException;

public final class IIOPConnection
extends Connection {
    private static final int OPENING = 1;
    private static final int ESTABLISHED = 2;
    private static final int CLOSE_SENT = 3;
    private static final int CLOSE_RECVD = 4;
    private static final int ABORT = 5;
    Hashtable out_calls = null;
    ClientResponseImpl theOnly1_1ClientResponseImpl = null;
    Map clientReplyMap = null;
    private MessageMediator mediator;
    private String threadName;
    protected EndPoint endpoint;
    protected int requestCount = 0;
    private ServerGIOP server;
    Map serverRequestMap = null;
    ServerRequestImpl theOnly1_1ServerRequestImpl = null;
    private boolean postInitialContexts = false;
    private IOR codeBaseServerIOR;
    private CachedCodeBase cachedCodeBase = new CachedCodeBase(this);
    Thread reader;
    int state;
    private Object stateEvent = new Object();
    private Object writeEvent = new Object();
    private boolean writeLocked;
    InputStream inputStream;
    OutputStream outputStream;

    private String getStateString(int n2) {
        Object object = this.stateEvent;
        synchronized (object) {
            switch (n2) {
                case 1: {
                    String string = "OPENING";
                    return string;
                }
                case 2: {
                    String string = "ESTABLISHED";
                    return string;
                }
                case 3: {
                    String string = "CLOSE_SENT";
                    return string;
                }
                case 4: {
                    String string = "CLOSE_RECVD";
                    return string;
                }
                case 5: {
                    String string = "ABORT";
                    return string;
                }
            }
            String string = "???";
            return string;
        }
    }

    public String toString() {
        Object object = this.stateEvent;
        synchronized (object) {
            String string = "Connection[type=" + this.endpoint.getType() + " remote_host=" + this.endpoint.getHostName() + " remote_port=" + this.endpoint.getPort() + " state=" + this.getStateString(this.state) + "]";
            return string;
        }
    }

    public IIOPConnection(ORB oRB, ServerGIOP serverGIOP, ConnectionTable connectionTable, EndPoint endPoint) {
        this.orb = oRB;
        this.server = serverGIOP;
        this.connectionTable = connectionTable;
        this.endpoint = endPoint;
        this.codeBaseServerIOR = null;
        String string = this.endpoint.getHostName();
        int n2 = this.endpoint.getPort();
        this.threadName = "JavaIDL Reader for " + string + ":" + n2;
        this.mediator = new MessageMediator(this);
        this.clientReplyMap = new HashMap();
        this.out_calls = new Hashtable();
        final ThreadGroup threadGroup = oRB.threadGroup;
        final String string2 = this.threadName;
        final IIOPConnection iIOPConnection = this;
        final boolean bl2 = oRB.transportDebugFlag;
        try {
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    IIOPConnection.this.reader = new ReaderThread(threadGroup, iIOPConnection, string2, bl2);
                    return null;
                }
            });
        }
        catch (SecurityException securityException) {
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    IIOPConnection.this.reader = new ReaderThread(iIOPConnection, string2, bl2);
                    return null;
                }
            });
        }
        Object object = this.stateEvent;
        synchronized (object) {
            this.state = 1;
        }
    }

    public IIOPConnection(ORB oRB, ServerGIOP serverGIOP, EndPoint endPoint, Socket socket, InputStream inputStream, OutputStream outputStream, ConnectionTable connectionTable) {
        this(oRB, serverGIOP, connectionTable, endPoint);
        this.mediator = new MessageMediator(this);
        this.socket = socket;
        this.inputStream = inputStream;
        this.outputStream = outputStream;
        this.connectionTable = connectionTable;
        this.isServer = true;
        this.serverRequestMap = Collections.synchronizedMap(new HashMap());
        this.state = 2;
        try {
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    IIOPConnection.this.reader.setDaemon(true);
                    return null;
                }
            });
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.reader.start();
    }

    public synchronized boolean isPostInitialContexts() {
        return this.postInitialContexts;
    }

    public synchronized void setPostInitialContexts() {
        this.postInitialContexts = true;
    }

    public InputStream getInputStream() {
        return this.inputStream;
    }

    public ServerGIOP getServerGIOP() {
        return this.server;
    }

    String getHost() {
        return this.endpoint.getHostName();
    }

    int getPort() {
        return this.endpoint.getPort();
    }

    EndPoint getEndpoint() {
        return this.endpoint;
    }

    public final void processInput() throws Exception {
        this.mediator.processRequest();
    }

    void signalReplyReceived(int n2, IIOPInputStream iIOPInputStream) {
        Integer n3 = new Integer(n2);
        OutCallDesc outCallDesc = (OutCallDesc)this.out_calls.get(n3);
        if (outCallDesc == null) {
            return;
        }
        Object object = outCallDesc.done;
        synchronized (object) {
            outCallDesc.s = iIOPInputStream;
            outCallDesc.done.notify();
        }
    }

    void purge_calls(int n2, boolean bl2, boolean bl3) {
        CompletionStatus completionStatus;
        block21: {
            if (this.orb.transportDebugFlag) {
                this.dprint("purge_calls: starting: code = " + n2 + " die = " + bl2);
            }
            Object object = this.stateEvent;
            synchronized (object) {
                if (this.state == 5 || this.state == 4) {
                    if (this.orb.transportDebugFlag) {
                        this.dprint("purge_calls: exiting duplicate invocation");
                    }
                    return;
                }
            }
            try {
                if (!bl3) {
                    this.writeLock();
                }
            }
            catch (SystemException systemException) {
                if (!this.orb.transportDebugFlag) break block21;
                this.dprint("purge_calls: caught exception " + (Object)((Object)systemException) + "; continuing");
            }
        }
        Object object = this.stateEvent;
        synchronized (object) {
            if (n2 == 1398079697) {
                this.state = 4;
                completionStatus = CompletionStatus.COMPLETED_NO;
            } else {
                this.state = 5;
                completionStatus = CompletionStatus.COMPLETED_MAYBE;
            }
            this.stateEvent.notifyAll();
        }
        try {
            this.inputStream.close();
            this.outputStream.close();
            this.socket.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        COMM_FAILURE cOMM_FAILURE = new COMM_FAILURE(n2, completionStatus);
        Enumeration enumeration = this.out_calls.elements();
        while (enumeration.hasMoreElements()) {
            OutCallDesc outCallDesc = (OutCallDesc)enumeration.nextElement();
            Object object2 = outCallDesc.done;
            synchronized (object2) {
                outCallDesc.s = null;
                outCallDesc.exc = cOMM_FAILURE;
                outCallDesc.done.notify();
            }
        }
        this.out_calls.clear();
        this.connectionTable.deleteConn(this.endpoint);
        this.writeUnlock();
        if (bl2) {
            Thread.currentThread().stop();
        }
    }

    public void setConnection(Socket socket, ConnectionTable connectionTable) throws Exception {
        this.socket = socket;
        this.inputStream = this.socket.getInputStream();
        this.outputStream = this.socket.getOutputStream();
        this.connectionTable = connectionTable;
        Object object = this.stateEvent;
        synchronized (object) {
            this.state = 2;
            try {
                AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        IIOPConnection.this.reader.setDaemon(true);
                        return null;
                    }
                });
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.reader.start();
            this.stateEvent.notifyAll();
        }
    }

    public void abortConnection() {
        Object object = this.stateEvent;
        synchronized (object) {
            this.state = 5;
            this.stateEvent.notifyAll();
        }
    }

    protected boolean writeLock() {
        while (true) {
            Object object = this.stateEvent;
            synchronized (object) {
                switch (this.state) {
                    case 1: {
                        try {
                            this.stateEvent.wait();
                        }
                        catch (InterruptedException interruptedException) {}
                        break;
                    }
                    case 2: {
                        Object object2 = this.writeEvent;
                        synchronized (object2) {
                            if (!this.writeLocked) {
                                this.writeLocked = true;
                                boolean bl2 = true;
                                return bl2;
                            }
                            try {
                                this.writeEvent.wait();
                            }
                            catch (InterruptedException interruptedException) {
                                // empty catch block
                            }
                            break;
                        }
                    }
                    case 5: {
                        throw new COMM_FAILURE(1398079691, CompletionStatus.COMPLETED_NO);
                    }
                    case 4: {
                        throw new COMM_FAILURE(1398079690, CompletionStatus.COMPLETED_NO);
                    }
                    default: {
                        if (this.orb.transportDebugFlag) {
                            this.dprint("Connection:writeLock: weird state");
                        }
                        this.delete(1398079696);
                        boolean bl3 = false;
                        return bl3;
                    }
                }
            }
        }
    }

    protected void writeUnlock() {
        Object object = this.writeEvent;
        synchronized (object) {
            this.writeLocked = false;
            this.writeEvent.notify();
        }
    }

    public void delete() {
        this.delete(1398079696);
    }

    void delete(int n2) {
        DeleteConn deleteConn = new DeleteConn(n2);
        this.reader.stop(deleteConn);
    }

    public IIOPInputStream invoke(IIOPOutputStream iIOPOutputStream) throws SystemException {
        return this.send(iIOPOutputStream, false);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    IIOPInputStream getResponse(boolean bl2, int n2) {
        IIOPInputStream iIOPInputStream = null;
        Integer n3 = new Integer(n2);
        OutCallDesc outCallDesc = (OutCallDesc)this.out_calls.get(n3);
        if (bl2) {
            this.out_calls.remove(n3);
            return null;
        }
        Object object = outCallDesc.done;
        // MONITORENTER : object
        while (outCallDesc.s == null && outCallDesc.exc == null) {
            try {
                outCallDesc.done.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        this.out_calls.remove(n3);
        if (outCallDesc.exc != null) {
            throw outCallDesc.exc;
        }
        iIOPInputStream = outCallDesc.s;
        // MONITOREXIT : object
        if (iIOPInputStream == null) return iIOPInputStream;
        iIOPInputStream.unmarshalHeader();
        return iIOPInputStream;
    }

    void createOutCallDescriptor(int n2) {
        if (!this.isServer) {
            Integer n3 = new Integer(n2);
            OutCallDesc outCallDesc = new OutCallDesc();
            outCallDesc.thd = Thread.currentThread();
            this.out_calls.put(n3, outCallDesc);
        }
    }

    void sendWithoutLock(IIOPOutputStream iIOPOutputStream) {
        try {
            iIOPOutputStream.writeTo(this.outputStream);
            this.outputStream.flush();
        }
        catch (IOException iOException) {
            Message message = iIOPOutputStream.getMessage();
            if (message.getType() == 0 || message.getType() == 3) {
                GIOPVersion gIOPVersion = message.getGIOPVersion();
                int n2 = MessageBase.getRequestId(message);
                try {
                    this.sendCancelRequest(gIOPVersion, n2);
                }
                catch (IOException iOException2) {
                    // empty catch block
                }
            }
            throw new COMM_FAILURE(1398079691, CompletionStatus.COMPLETED_NO);
        }
    }

    public IIOPInputStream send(IIOPOutputStream iIOPOutputStream, boolean bl2) {
        iIOPOutputStream.finishSendingMessage();
        return this.getResponse(bl2, MessageBase.getRequestId(iIOPOutputStream.getMessage()));
    }

    public void sendReply(IIOPOutputStream iIOPOutputStream) throws Exception {
        iIOPOutputStream.finishSendingMessage();
    }

    public void sendCancelRequest(GIOPVersion gIOPVersion, int n2) throws IOException {
        CancelRequestMessage cancelRequestMessage = MessageBase.createCancelRequest(gIOPVersion, n2);
        IIOPOutputStream iIOPOutputStream = new IIOPOutputStream(gIOPVersion, this.orb, this);
        iIOPOutputStream.setMessage(cancelRequestMessage);
        cancelRequestMessage.write((org.omg.CORBA.portable.OutputStream)iIOPOutputStream);
        iIOPOutputStream.writeTo(this.outputStream);
        this.outputStream.flush();
    }

    public void sendCloseConnection(GIOPVersion gIOPVersion) throws IOException {
        Message message = MessageBase.createCloseConnection(gIOPVersion);
        IIOPOutputStream iIOPOutputStream = new IIOPOutputStream(gIOPVersion, this.orb, this);
        iIOPOutputStream.setMessage(message);
        message.write((org.omg.CORBA.portable.OutputStream)iIOPOutputStream);
        iIOPOutputStream.writeTo(this.outputStream);
        this.outputStream.flush();
    }

    public void sendMessageError(GIOPVersion gIOPVersion) throws IOException {
        Message message = MessageBase.createMessageError(gIOPVersion);
        IIOPOutputStream iIOPOutputStream = new IIOPOutputStream(gIOPVersion, this.orb, this);
        iIOPOutputStream.setMessage(message);
        message.write((org.omg.CORBA.portable.OutputStream)iIOPOutputStream);
        iIOPOutputStream.writeTo(this.outputStream);
        this.outputStream.flush();
    }

    public boolean isBusy() {
        return this.requestCount > 0 || this.out_calls.size() > 0;
    }

    public synchronized void cleanUp() throws Exception {
        this.writeLock();
        if (this.requestCount > 0 || this.out_calls.size() > 0) {
            this.writeUnlock();
            throw new Exception();
        }
        try {
            Object object;
            if (this.isServer) {
                this.sendCloseConnection(GIOPVersion.V1_0);
                object = this.stateEvent;
                synchronized (object) {
                    this.state = 3;
                    this.stateEvent.notifyAll();
                }
            }
            object = new Exception();
            this.reader.stop((Throwable)object);
            this.purge_calls(1398079697, false, true);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public synchronized void requestBegins() {
        ++this.requestCount;
    }

    public synchronized void requestEnds(IIOPInputStream iIOPInputStream) {
        if (iIOPInputStream.getGIOPVersion().equals(GIOPVersion.V1_2)) {
            this.serverRequestMap.remove(new Integer(MessageBase.getRequestId(iIOPInputStream.getMessage())));
        }
        if (iIOPInputStream.getGIOPVersion().equals(GIOPVersion.V1_1)) {
            this.theOnly1_1ServerRequestImpl = null;
        }
        --this.requestCount;
    }

    void shutdown() {
        ((ReaderThread)this.reader).shutdown();
        super.shutdown();
    }

    public void print() {
        System.out.println("Connection for " + this.endpoint.getHostName() + " @ " + this.endpoint.getPort());
        System.out.println("    Time stamp = " + this.timeStamp);
        boolean bl2 = this.reader.isAlive();
        if (bl2) {
            System.out.println(" Reader is Alive");
        } else {
            System.out.println(" Reader is not Alive");
        }
    }

    public final void setCodeBaseIOR(IOR iOR) {
        this.codeBaseServerIOR = iOR;
    }

    final IOR getCodeBaseIOR() {
        return this.codeBaseServerIOR;
    }

    final CodeBase getCodeBase() {
        return this.cachedCodeBase;
    }

    static final class DeleteConn
    extends Throwable {
        int minorCode;

        DeleteConn(int n2) {
            this.minorCode = n2;
        }
    }

    static final class OutCallDesc {
        Object done = new Object();
        Thread thd;
        SystemException exc;
        IIOPInputStream s;

        OutCallDesc() {
        }
    }
}

