/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sapdb.WebDAVTest.jtests.puttests;

import com.sap.sapdb.WebDAVTest.jtests.WDVTestJ_WebDAVTestHelper;
import com.sap.sapdb.WebDAVTest.protocol.WDVTestJ_WdvException;
import com.sap.sapdb.WebDAVTest.protocol.WDVTestJ_WebDAVCore;
import com.sap.sapdb.testframe.driver.TestDatabaseException;
import com.sap.sapdb.testframe.testcase.TestCaseException;
import java.sql.SQLException;

public class TestPut012
extends WDVTestJ_WebDAVTestHelper {
    static String host = null;
    static String baseUrl = null;
    static String urlStr = null;
    static WDVTestJ_WebDAVCore resource = null;
    static String content = null;
    static String contentType = null;
    static long contentLength = 4711L;
    static String locktoken = null;

    public static void prepare() throws TestCaseException {
        TestPut012.createWebDAVSchema();
        TestPut012.addGlobalMessage((String)("prepare test " + TestPut012.getTestClassId()), (char)'I', (String)"put a resource whose name is longer than 499 chars");
        host = new String(TestPut012.getParameterString((String)"host", (String)"localhost"));
        WDV_PORT = TestPut012.getPort();
        baseUrl = TestPut012.getParameterString((String)"baseUrl", (String)"/webdav");
        start_server = TestPut012.getParameterBoolean((String)"start_server", (boolean)false);
        if (start_server) {
            TestPut012.addGlobalMessage((String)"preparation for test-execution", (char)'I', (String)("starting WebDAV server version '" + WDV_VERSION + "' on port: " + WDV_PORT));
            TestPut012.startWebDAV(WDV_PORT);
            try {
                Thread.sleep(WDV_STARTUP_TIME);
            }
            catch (InterruptedException iex) {
                TestPut012.handleGlobalExceptions((Exception)iex);
            }
        }
        if (!TestPut012.isServerRunning(WDV_PORT)) {
            throw new TestCaseException("Maybe the webdav service is not running properly on WDV_PORT " + WDV_PORT);
        }
        urlStr = new String("/TestPut012");
        while (urlStr.length() < 500) {
            urlStr = urlStr + "TestPut012";
        }
        resource = new WDVTestJ_WebDAVCore().createResource(host, WDV_PORT, baseUrl, urlStr = urlStr + ".txt");
        if (resource == null) {
            TestPut012.addGlobalMessage((String)"1. DELETE the resource /TestPut012.txt at baseUrl", (char)'E', (String)"Preparation failed due to some Java feature.");
        }
        TestPut012.doDelete(resource, locktoken, host + ":" + WDV_PORT + baseUrl + urlStr);
    }

    public void run() {
        content = "Sind des Schaefchens Loeckchen braun,lehnt es am Elektrozaun.Wenn es mit den Augen rollt,will es sagen: Zu viel Volt";
        contentType = "text/plain";
        contentLength = content.length();
        try {
            resource.PUT(content, contentType, locktoken);
            if (TestPut012.getParameterString((String)"use_servlet", (String)"F").equalsIgnoreCase("F")) {
                TestPut012.addGlobalMessage((String)("PUT http://" + host + ":" + WDV_PORT + baseUrl + urlStr), (char)'W', (String)"Expected result: 414 Request URI to long. See http://pts:1080/webpts?wptsdetail=yes&ErrorType=0&ErrorID=1138756");
            } else {
                TestPut012.addGlobalMessage((String)("PUT http://" + host + ":" + WDV_PORT + baseUrl + urlStr), (char)'E', (String)"Expected result: 414 Request URI to long");
            }
        }
        catch (WDVTestJ_WdvException exc) {
            if (TestPut012.getParameterString((String)"use_servlet", (String)"F").equalsIgnoreCase("T")) {
                if (exc.getStatusCode() == 414) {
                    TestPut012.addGlobalMessage((String)("PUT http://" + host + ":" + WDV_PORT + baseUrl + urlStr), (char)'I', (String)"Test was successful!");
                } else {
                    TestPut012.addGlobalMessage((String)("PUT http://" + host + ":" + WDV_PORT + baseUrl + urlStr), (char)'E', (String)("WebDAV exception: " + exc.getStatusCode() + " " + exc.getMessage()));
                    TestPut012.addGlobalMessage((String)"PUT failed due to some WebDAV feature", (char)'I', (String)"Expected result: 414 Request URI to long");
                }
            } else {
                TestPut012.addGlobalMessage((String)("PUT http://" + host + ":" + WDV_PORT + baseUrl + urlStr), (char)'E', (String)("WebDAV exception: " + exc.getStatusCode() + " " + exc.getMessage()));
                TestPut012.addGlobalMessage((String)"PUT failed due to some WebDAV feature", (char)'I', (String)"Expected result: 201 Created");
            }
        }
        catch (Exception exc) {
            TestPut012.addGlobalMessage((String)("PUT http://" + host + ":" + WDV_PORT + baseUrl + urlStr), (char)'E', (String)("  Java exception: " + exc));
            TestPut012.addGlobalMessage((String)"PUT failed due to some Java feature", (char)'I', (String)("Skipping test " + TestPut012.getTestClassId()));
        }
        if (!TestPut012.getParameterString((String)"use_servlet", (String)"F").equalsIgnoreCase("T")) {
            TestPut012.compareContent(resource, content, contentType, contentLength, host + ":" + WDV_PORT + baseUrl + urlStr);
        }
    }

    public static void cleanUp() throws TestCaseException {
        urlStr = new String("/TestPut012.txt");
        resource = new WDVTestJ_WebDAVCore().createResource(host, WDV_PORT, baseUrl, urlStr);
        if (resource == null) {
            TestPut012.addGlobalMessage((String)"4. DELETE the resource /TestPut012.txt at baseUrl", (char)'E', (String)"Preparation failed due to some Java feature.");
        }
        TestPut012.doDelete(resource, locktoken, host + ":" + WDV_PORT + baseUrl + urlStr);
    }
}

