/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sapdb.WebDAVTest.jtests.proppatchtests;

import com.sap.sapdb.WebDAVTest.jtests.WDVTestJ_WebDAVTestHelper;
import com.sap.sapdb.WebDAVTest.protocol.WDVTestJ_WdvException;
import com.sap.sapdb.WebDAVTest.protocol.WDVTestJ_WebDAVCore;
import com.sap.sapdb.testframe.driver.TestDatabaseException;
import com.sap.sapdb.testframe.testcase.TestCaseException;
import java.sql.SQLException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.SAXParseException;

public class TestProppatch017
extends WDVTestJ_WebDAVTestHelper {
    static String host = null;
    static String baseUrl = null;
    static String var_overwrite = null;
    static String urlStr = null;
    static WDVTestJ_WebDAVCore resource = null;
    static String content = null;
    static String contentType = null;
    static long contentLength = 4711L;
    static String locktoken = null;
    static Document xmlDocument = null;
    static Node newproperty_node = null;

    public static void prepare() throws TestCaseException {
        TestProppatch017.createWebDAVSchema();
        TestProppatch017.addGlobalMessage((String)("prepare test " + TestProppatch017.getTestClassId()), (char)'I', (String)"**************************************************************************\n* set a userdefined property with a property-name of more than 300 chars *\n**************************************************************************");
        host = new String(TestProppatch017.getParameterString((String)"host", (String)"localhost"));
        WDV_PORT = TestProppatch017.getPort();
        baseUrl = TestProppatch017.getParameterString((String)"baseUrl", (String)"/webdav");
        var_overwrite = TestProppatch017.getParameterString((String)"var_overwrite", (String)"F");
        start_server = TestProppatch017.getParameterBoolean((String)"start_server", (boolean)false);
        if (start_server) {
            TestProppatch017.addGlobalMessage((String)"preparation for test-execution", (char)'I', (String)("starting WebDAV server version '" + WDV_VERSION + "' on port: " + WDV_PORT));
            TestProppatch017.startWebDAV(WDV_PORT);
            try {
                Thread.sleep(WDV_STARTUP_TIME);
            }
            catch (InterruptedException iex) {
                TestProppatch017.handleGlobalExceptions((Exception)iex);
            }
        }
        if (!TestProppatch017.isServerRunning(WDV_PORT)) {
            throw new TestCaseException("Maybe the webdav service is not running properly on '" + host + ":" + WDV_PORT + "'");
        }
        urlStr = new String("/TestProppatch017.txt");
        resource = new WDVTestJ_WebDAVCore().createResource(host, WDV_PORT, baseUrl, urlStr);
        if (resource == null) {
            TestProppatch017.addGlobalMessage((String)"1. DELETE the resource /TestProppatch017.txt at baseUrl", (char)'E', (String)"Preparation failed due to some Java feature.");
        }
        TestProppatch017.doDelete(resource, locktoken, host + ":" + WDV_PORT + baseUrl + urlStr);
        content = "Sind des Schaefchens Loeckchen braun,lehnt es am Elektrozaun.Wenn es mit den Augen rollt,will es sagen: Zu viel Volt";
        contentType = "text/plain";
        contentLength = content.length();
        if (!TestProppatch017.doPut(resource, content, contentType, locktoken, host + ":" + WDV_PORT + baseUrl + urlStr)) {
            throw new TestCaseException("Maybe the webdav service is not running properly on '" + host + ":" + WDV_PORT + "'");
        }
    }

    public void run() {
        String propName = new String();
        while (propName.length() < 300) {
            propName = propName + "thepropertynameconsistsofmorethan300chars";
        }
        String body = "<?xml version=\"1.0\" encoding=\"utf-8\" ?>";
        body = body + "\n<D:propertyupdate xmlns:D=\"DAV:\"";
        body = body + "\nxmlns:Z=\"http://www.some.place.com\">";
        body = body + "\n<D:set>";
        body = body + "\n <D:prop>";
        body = body + "\n  <Z:" + propName + ">test</Z:" + propName + ">";
        body = body + "\n </D:prop>";
        body = body + "\n</D:set>";
        body = body + "\n</D:propertyupdate>";
        try {
            xmlDocument = resource.PROPPATCH(body, null);
        }
        catch (WDVTestJ_WdvException exc) {
            TestProppatch017.addGlobalMessage((String)("PROPPATCH " + host + ":" + WDV_PORT + baseUrl + urlStr), (char)'E', (String)("status: " + resource.getStatus().getStatusCode() + " " + resource.getStatus().getStatusMessage()));
            TestProppatch017.addGlobalMessage((String)("PROPPATCH " + host + ":" + WDV_PORT + baseUrl + urlStr), (char)'I', (String)"test failed due to some WebDAV feature");
        }
        catch (SAXParseException exc) {
            TestProppatch017.addGlobalMessage((String)("PROPPATCH " + host + ":" + WDV_PORT + baseUrl + urlStr), (char)'E', (String)("parser says: " + exc.getMessage()));
            TestProppatch017.addGlobalMessage((String)("PROPPATCH " + host + ":" + WDV_PORT + baseUrl + urlStr), (char)'I', (String)("request body: " + body));
        }
        catch (Exception exc) {
            TestProppatch017.addGlobalMessage((String)("PROPPATCH " + host + ":" + WDV_PORT + baseUrl + urlStr), (char)'E', (String)("Java exception: " + exc));
            exc.printStackTrace();
            TestProppatch017.addGlobalMessage((String)("PROPPATCH " + host + ":" + WDV_PORT + baseUrl + urlStr), (char)'I', (String)"Test failed due to some Java feature");
        }
        if (resource.getStatus().getStatusCode() == 207) {
            String status = null;
            status = xmlDocument.getElementsByTagName("D:status").item(0).getFirstChild().getNodeValue();
            if (status.startsWith("HTTP/1.1 409")) {
                TestProppatch017.addGlobalMessage((String)"4. check if the property status of the property is \"HTTP/1.1 409 Conflict\"", (char)'I', (String)"Test was successful!");
                String propfind_body = new String("<?xml version=\"1.0\" encoding=\"utf-8\" ?>\n");
                propfind_body = propfind_body + "<D:propfind xmlns:D=\"DAV:\">\n";
                propfind_body = propfind_body + "<D:prop>\n";
                propfind_body = propfind_body + "<D:" + propName + "/>\n";
                propfind_body = propfind_body + "</D:prop>\n";
                propfind_body = propfind_body + "</D:propfind>\n";
                try {
                    xmlDocument = resource.PROPFIND(propfind_body);
                }
                catch (WDVTestJ_WdvException exc) {
                    TestProppatch017.addGlobalMessage((String)("PROPFIND " + host + ":" + WDV_PORT + baseUrl + urlStr), (char)'E', (String)("status: " + resource.getStatus().getStatusCode() + " " + resource.getStatus().getStatusMessage()));
                    TestProppatch017.addGlobalMessage((String)("PROPFIND " + host + ":" + WDV_PORT + baseUrl + urlStr), (char)'I', (String)"test failed due to some WebDAV feature");
                }
                catch (SAXParseException exc) {
                    TestProppatch017.addGlobalMessage((String)("PROPFIND " + host + ":" + WDV_PORT + baseUrl + urlStr), (char)'E', (String)("parser says: " + exc.getMessage()));
                    TestProppatch017.addGlobalMessage((String)("PROPFIND " + host + ":" + WDV_PORT + baseUrl + urlStr), (char)'I', (String)("request body: " + body));
                }
                catch (Exception exc) {
                    TestProppatch017.addGlobalMessage((String)("PROPFIND " + host + ":" + WDV_PORT + baseUrl + urlStr), (char)'E', (String)("Java exception: " + exc));
                    exc.printStackTrace();
                    TestProppatch017.addGlobalMessage((String)("PROPFIND " + host + ":" + WDV_PORT + baseUrl + urlStr), (char)'I', (String)"Test failed due to some Java feature");
                }
                if (resource.getStatus().getStatusCode() == 207) {
                    status = null;
                    status = xmlDocument.getElementsByTagName("D:status").item(0).getFirstChild().getNodeValue();
                    if (status.startsWith("HTTP/1.1 409")) {
                        TestProppatch017.addGlobalMessage((String)"5. check if the property status of the property is \"HTTP/1.1 409 Conflict\"", (char)'I', (String)"Test was successful!");
                    } else {
                        TestProppatch017.addGlobalMessage((String)("5. check if the property status of '" + propName + "' is \"HTTP/1.1 409 Conflict\""), (char)'E', (String)("test failed due to some WebDAV features (status was: " + status + ")"));
                    }
                }
            } else {
                TestProppatch017.addGlobalMessage((String)("4. check if the property status of '" + propName + "' is \"HTTP/1.1 409 Conflict\""), (char)'E', (String)("test failed due to some WebDAV features (status was: " + status + ")"));
            }
        } else {
            TestProppatch017.addGlobalMessage((String)("PROPPATCH " + host + ":" + WDV_PORT + baseUrl + urlStr), (char)'E', (String)("status: " + resource.getStatus().getStatusCode() + " " + resource.getStatus().getStatusMessage()));
            TestProppatch017.addGlobalMessage((String)("PROPPATCH " + host + ":" + WDV_PORT + baseUrl + urlStr), (char)'I', (String)"expected result: 207 Multi-Status");
        }
    }

    public static void cleanUp() throws TestCaseException {
        urlStr = new String("/TestProppatch017.txt");
        resource = new WDVTestJ_WebDAVCore().createResource(host, WDV_PORT, baseUrl, urlStr);
        if (resource == null) {
            TestProppatch017.addGlobalMessage((String)"6. DELETE the resource /TestProppatch017.txt at baseUrl", (char)'E', (String)"Preparation failed due to some Java feature.");
        }
        TestProppatch017.doDelete(resource, locktoken, host + ":" + WDV_PORT + baseUrl + urlStr);
    }
}

