/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sapdb.WebDAVTest.jtests.locktests;

import com.sap.sapdb.WebDAVTest.jtests.WDVTestJ_WebDAVTestHelper;
import com.sap.sapdb.WebDAVTest.protocol.WDVTestJ_WdvException;
import com.sap.sapdb.WebDAVTest.protocol.WDVTestJ_WebDAVCore;
import com.sap.sapdb.testframe.driver.TestDatabaseException;
import com.sap.sapdb.testframe.testcase.TestCaseException;
import java.net.MalformedURLException;
import java.net.URL;
import java.sql.SQLException;

public class TestLock020
extends WDVTestJ_WebDAVTestHelper {
    static String host = null;
    static String baseUrl = null;
    static String var_overwrite = null;
    static String urlStr = null;
    static WDVTestJ_WebDAVCore resource = null;
    static String content = null;
    static String contentType = null;
    static long contentLength = 4711L;
    static String locktoken = null;

    public static void prepare() throws TestCaseException {
        TestLock020.createWebDAVSchema();
        TestLock020.addGlobalMessage((String)("prepare test " + TestLock020.getTestClassId()), (char)'I', (String)"move a null resource without a locktoken");
        host = new String(TestLock020.getParameterString((String)"host", (String)"localhost"));
        WDV_PORT = TestLock020.getPort();
        baseUrl = TestLock020.getParameterString((String)"baseUrl", (String)"/webdav");
        var_overwrite = TestLock020.getParameterString((String)"var_overwrite", (String)"F");
        start_server = TestLock020.getParameterBoolean((String)"start_server", (boolean)false);
        if (start_server) {
            TestLock020.addGlobalMessage((String)"preparation for test-execution", (char)'I', (String)("starting WebDAV server version '" + WDV_VERSION + "' on port: " + WDV_PORT));
            TestLock020.startWebDAV(WDV_PORT);
            try {
                Thread.sleep(WDV_STARTUP_TIME);
            }
            catch (InterruptedException iex) {
                TestLock020.handleGlobalExceptions((Exception)iex);
            }
        }
        if (!TestLock020.isServerRunning(WDV_PORT)) {
            throw new TestCaseException("Maybe the webdav service is not running properly on '" + host + ":" + WDV_PORT + "'");
        }
        urlStr = new String("/TestLock020.txt");
        resource = new WDVTestJ_WebDAVCore().createResource(host, WDV_PORT, baseUrl, urlStr);
        if (resource == null) {
            TestLock020.addGlobalMessage((String)"1. LOCK the file /TestLock020.txt", (char)'E', (String)"Preparations failed due to some Java feature.");
        }
        if (resource.exists() && (locktoken = TestLock020.getLockToken(resource, host + ":" + WDV_PORT + baseUrl + urlStr)) != null) {
            TestLock020.doUnlock(resource, locktoken, host + ":" + WDV_PORT + baseUrl + urlStr);
        }
        if (resource.exists() && !TestLock020.doDelete(resource, locktoken = TestLock020.getLockToken(resource, host + ":" + WDV_PORT + baseUrl + urlStr), host + ":" + WDV_PORT + baseUrl + urlStr)) {
            throw new TestCaseException("Maybe the webdav service is not running properly on '" + host + ":" + WDV_PORT + "'");
        }
        if (!TestLock020.doLock(resource, host + ":" + WDV_PORT + baseUrl + urlStr)) {
            throw new TestCaseException("Maybe the webdav service is not running properly on '" + host + ":" + WDV_PORT + "'");
        }
    }

    public void run() {
        try {
            String dest_Url = new URL("http", host, WDV_PORT, baseUrl + "/TestLock020_move.txt").toString();
            String body = null;
            locktoken = null;
            resource.MOVE(dest_Url, "T", body, locktoken);
            if (resource.getStatus().getStatusCode() != 405) {
                TestLock020.addGlobalMessage((String)"2. MOVE /TestLock020.txt to /TestLock020_move.txt", (char)'E', (String)("status: " + resource.getStatus().getStatusCode() + " " + resource.getStatus().getStatusMessage() + "\n" + "Test failed due to some WebDAV feature. Expected: 405 Method Not Allowed."));
                return;
            }
        }
        catch (WDVTestJ_WdvException exc) {
            if (exc.getStatusCode() == 405) {
                TestLock020.addGlobalMessage((String)"2. MOVE /TestLock020.txt to /TestLock020_move.txt", (char)'I', (String)("WebDAV responses: " + exc.getStatusCode() + " " + exc.getMessage() + "Test was successful!"));
            }
            TestLock020.addGlobalMessage((String)"2. MOVE /TestLock020.txt to /TestLock020_move.txt", (char)'W', (String)("status: " + resource.getStatus().getStatusCode() + " " + resource.getStatus().getStatusMessage() + "\n" + "Test failed due to some WebDAV feature. Expected: 405 Method Not Allowed.\n" + "PTS message: \n" + "http://pts:1080/webpts?wptsdetail=yes&ErrorType=0&ErrorID=1127815"));
            return;
        }
        catch (MalformedURLException exc) {
            TestLock020.addGlobalMessage((String)"2. MOVE /TestLock020.txt to /TestLock020_move.txt", (char)'E', (String)"Test failed due to some Java-URL feature");
            return;
        }
        catch (Exception exc) {
            TestLock020.addGlobalMessage((String)"2. MOVE /TestLock020.txt to /TestLock020_move.txt", (char)'E', (String)("Java exception: " + exc));
            TestLock020.addGlobalMessage((String)"2. MOVE /TestLock020.txt to /TestLock020_move.txt", (char)'I', (String)"Test failed due to some Java feature");
            return;
        }
    }

    public static void cleanUp() throws TestCaseException {
        if (resource.exists() && (locktoken = TestLock020.getLockToken(resource, host + ":" + WDV_PORT + baseUrl + urlStr)) != null) {
            TestLock020.doUnlock(resource, locktoken, host + ":" + WDV_PORT + baseUrl + urlStr);
        }
        if ((resource = new WDVTestJ_WebDAVCore().createResource(host, WDV_PORT, baseUrl, urlStr = new String("/TestLock019.txt"))) == null) {
            TestLock020.addGlobalMessage((String)"3. UNLOCK /TestLock019.txt and /TestLock019_move.txt", (char)'E', (String)"CleanUp failed due to some Java feature.");
        }
        if (resource.exists() && (locktoken = TestLock020.getLockToken(resource, host + ":" + WDV_PORT + baseUrl + urlStr)) != null) {
            TestLock020.doUnlock(resource, locktoken, host + ":" + WDV_PORT + baseUrl + urlStr);
        }
    }
}

