/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sapdb.WebDAVTest.jtests.locktests;

import com.sap.sapdb.WebDAVTest.jtests.WDVTestJ_WebDAVTestHelper;
import com.sap.sapdb.WebDAVTest.protocol.WDVTestJ_WdvException;
import com.sap.sapdb.WebDAVTest.protocol.WDVTestJ_WebDAVCore;
import com.sap.sapdb.testframe.driver.TestDatabaseException;
import com.sap.sapdb.testframe.testcase.TestCaseException;
import java.net.MalformedURLException;
import java.net.URL;
import java.sql.SQLException;

public class TestLock019
extends WDVTestJ_WebDAVTestHelper {
    static String host = null;
    static String baseUrl = null;
    static String var_overwrite = null;
    static String urlStr = null;
    static WDVTestJ_WebDAVCore resource = null;
    static String content = null;
    static String contentType = null;
    static long contentLength = 4711L;
    static String locktoken = null;

    public static void prepare() throws TestCaseException {
        TestLock019.createWebDAVSchema();
        TestLock019.addGlobalMessage((String)("prepare test " + TestLock019.getTestClassId()), (char)'I', (String)"copy a null resource without a locktoken");
        host = new String(TestLock019.getParameterString((String)"host", (String)"localhost"));
        WDV_PORT = TestLock019.getPort();
        baseUrl = TestLock019.getParameterString((String)"baseUrl", (String)"/webdav");
        var_overwrite = TestLock019.getParameterString((String)"var_overwrite", (String)"F");
        start_server = TestLock019.getParameterBoolean((String)"start_server", (boolean)false);
        if (start_server) {
            TestLock019.addGlobalMessage((String)"preparation for test-execution", (char)'I', (String)("starting WebDAV server version '" + WDV_VERSION + "' on port: " + WDV_PORT));
            TestLock019.startWebDAV(WDV_PORT);
            try {
                Thread.sleep(WDV_STARTUP_TIME);
            }
            catch (InterruptedException iex) {
                TestLock019.handleGlobalExceptions((Exception)iex);
            }
        }
        if (!TestLock019.isServerRunning(WDV_PORT)) {
            throw new TestCaseException("Maybe the webdav service is not running properly on '" + host + ":" + WDV_PORT + "'");
        }
        urlStr = new String("/TestLock019.txt");
        resource = new WDVTestJ_WebDAVCore().createResource(host, WDV_PORT, baseUrl, urlStr);
        if (resource == null) {
            TestLock019.addGlobalMessage((String)"1. LOCK the file /TestLock019.txt", (char)'E', (String)"Preparations failed due to some Java feature.");
        }
        if (resource.exists() && (locktoken = TestLock019.getLockToken(resource, host + ":" + WDV_PORT + baseUrl + urlStr)) != null) {
            TestLock019.doUnlock(resource, locktoken, host + ":" + WDV_PORT + baseUrl + urlStr);
        }
        if (resource.exists() && !TestLock019.doDelete(resource, locktoken = TestLock019.getLockToken(resource, host + ":" + WDV_PORT + baseUrl + urlStr), host + ":" + WDV_PORT + baseUrl + urlStr)) {
            throw new TestCaseException("Maybe the webdav service is not running properly on '" + host + ":" + WDV_PORT + "'");
        }
        if (!TestLock019.doLock(resource, host + ":" + WDV_PORT + baseUrl + urlStr)) {
            throw new TestCaseException("Maybe the webdav service is not running properly on '" + host + ":" + WDV_PORT + "'");
        }
    }

    public void run() {
        try {
            String dest_Url = new URL("http", host, WDV_PORT, baseUrl + "/TestLock019_copy.txt").toString();
            String body = null;
            locktoken = null;
            resource.COPY(dest_Url, "T", body, locktoken);
            if (resource.getStatus().getStatusCode() != 405) {
                TestLock019.addGlobalMessage((String)"2. COPY /TestLock019.txt to /TestLock019_copy.txt", (char)'E', (String)("status: " + resource.getStatus().getStatusCode() + " " + resource.getStatus().getStatusMessage() + "\n" + "Test failed due to some WebDAV feature. Expected: 405 Method Not Allowed."));
                return;
            }
        }
        catch (WDVTestJ_WdvException exc) {
            if (exc.getStatusCode() == 405) {
                TestLock019.addGlobalMessage((String)"2. COPY /TestLock019.txt to /TestLock019_copy.txt", (char)'I', (String)("WebDAV responses: " + exc.getStatusCode() + " " + exc.getMessage() + "Test was successful!"));
            }
            TestLock019.addGlobalMessage((String)"2. COPY /TestLock019.txt to /TestLock019_copy.txt", (char)'W', (String)("status: " + resource.getStatus().getStatusCode() + " " + resource.getStatus().getStatusMessage() + "\n" + "Test failed due to some WebDAV feature. Expected: 405 Method Not Allowed.\n" + "PTS messages: \n" + "http://pts:1080/webpts?wptsdetail=yes&ErrorType=0&ErrorID=1127815\n" + "http://pts:1080/webpts?wptsdetail=yes&ErrorType=0&ErrorID=1124287"));
            return;
        }
        catch (MalformedURLException exc) {
            TestLock019.addGlobalMessage((String)"2. COPY /TestLock019.txt to /TestLock019_copy.txt", (char)'E', (String)"Test failed due to some Java-URL feature");
            return;
        }
        catch (Exception exc) {
            TestLock019.addGlobalMessage((String)"2. COPY /TestLock019.txt to /TestLock019_copy.txt", (char)'E', (String)("Java exception: " + exc));
            TestLock019.addGlobalMessage((String)"2. COPY /TestLock019.txt to /TestLock019_copy.txt", (char)'I', (String)"Test failed due to some Java feature");
            return;
        }
    }

    public static void cleanUp() throws TestCaseException {
        if (resource.exists()) {
            locktoken = TestLock019.getLockToken(resource, host + ":" + WDV_PORT + baseUrl + urlStr);
            TestLock019.doUnlock(resource, locktoken, host + ":" + WDV_PORT + baseUrl + urlStr);
        }
        if ((resource = new WDVTestJ_WebDAVCore().createResource(host, WDV_PORT, baseUrl, urlStr = new String("/TestLock019.txt"))) == null) {
            TestLock019.addGlobalMessage((String)"3. UNLOCK /TestLock019.txt and /TestLock019_copy.txt", (char)'E', (String)"CleanUp failed due to some Java feature.");
        }
        if (resource.exists() && (locktoken = TestLock019.getLockToken(resource, host + ":" + WDV_PORT + baseUrl + urlStr)) != null) {
            TestLock019.doUnlock(resource, locktoken, host + ":" + WDV_PORT + baseUrl + urlStr);
        }
    }
}

