/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sapdb.WebDAVTest.jtests.locktests;

import com.sap.sapdb.WebDAVTest.jtests.WDVTestJ_WebDAVTestHelper;
import com.sap.sapdb.WebDAVTest.protocol.WDVTestJ_WdvException;
import com.sap.sapdb.WebDAVTest.protocol.WDVTestJ_WebDAVCore;
import com.sap.sapdb.testframe.driver.TestDatabaseException;
import com.sap.sapdb.testframe.testcase.TestCaseException;
import java.net.MalformedURLException;
import java.net.URL;
import java.sql.SQLException;

public class TestLock018
extends WDVTestJ_WebDAVTestHelper {
    static String host = null;
    static String baseUrl = null;
    static String var_overwrite = null;
    static String urlStr = null;
    static WDVTestJ_WebDAVCore resource = null;
    static String content = null;
    static String contentType = null;
    static long contentLength = 4711L;
    static String locktoken = null;

    public static void prepare() throws TestCaseException {
        TestLock018.createWebDAVSchema();
        TestLock018.addGlobalMessage((String)("prepare test " + TestLock018.getTestClassId()), (char)'I', (String)"check whether the lock properties are duplicated on a copy or not (locktoken of the copy = 'null')");
        host = new String(TestLock018.getParameterString((String)"host", (String)"localhost"));
        WDV_PORT = TestLock018.getPort();
        baseUrl = TestLock018.getParameterString((String)"baseUrl", (String)"/webdav");
        var_overwrite = TestLock018.getParameterString((String)"var_overwrite", (String)"F");
        start_server = TestLock018.getParameterBoolean((String)"start_server", (boolean)false);
        if (start_server) {
            TestLock018.addGlobalMessage((String)"preparation for test-execution", (char)'I', (String)("starting WebDAV server version '" + WDV_VERSION + "' on port: " + WDV_PORT));
            TestLock018.startWebDAV(WDV_PORT);
            try {
                Thread.sleep(WDV_STARTUP_TIME);
            }
            catch (InterruptedException iex) {
                TestLock018.handleGlobalExceptions((Exception)iex);
            }
        }
        if (!TestLock018.isServerRunning(WDV_PORT)) {
            throw new TestCaseException("Maybe the webdav service is not running properly on '" + host + ":" + WDV_PORT + "'");
        }
        urlStr = new String("/TestLock018.txt");
        resource = new WDVTestJ_WebDAVCore().createResource(host, WDV_PORT, baseUrl, urlStr);
        if (resource == null) {
            TestLock018.addGlobalMessage((String)"5. DELETE /TestLock018.txt and /TestLock018_copy.txt", (char)'E', (String)"CleanUp failed due to some Java feature.");
        }
        if (resource.exists() && (locktoken = TestLock018.getLockToken(resource, host + ":" + WDV_PORT + baseUrl + urlStr)) != null) {
            TestLock018.doUnlock(resource, locktoken, host + ":" + WDV_PORT + baseUrl + urlStr);
        }
        if (resource.exists()) {
            locktoken = TestLock018.getLockToken(resource, host + ":" + WDV_PORT + baseUrl + urlStr);
            TestLock018.doDelete(resource, locktoken, host + ":" + WDV_PORT + baseUrl + urlStr);
        }
        if ((resource = new WDVTestJ_WebDAVCore().createResource(host, WDV_PORT, baseUrl, urlStr = new String("/TestLock018.txt"))) == null) {
            TestLock018.addGlobalMessage((String)"1. create the file /TestLock018.txt at baseUrl", (char)'E', (String)"Preparations failed due to some Java feature.");
        }
        if (!TestLock018.doPut(resource, content = "Sind des Schaefchens Loeckchen braun,lehnt es am Elektrozaun.Wenn es mit den Augen rollt,will es sagen: Zu viel Volt", contentType = "text/plain", locktoken, host + ":" + WDV_PORT + baseUrl + urlStr)) {
            throw new TestCaseException("Maybe the webdav service is not running properly on '" + host + ":" + WDV_PORT + "'");
        }
        TestLock018.doLock(resource, host + ":" + WDV_PORT + baseUrl + urlStr);
    }

    public void run() {
        String locktoken_copy;
        try {
            String dest_Url = new URL("http", host, WDV_PORT, baseUrl + "/TestLock018_copy.txt").toString();
            String body = null;
            locktoken = null;
            resource.COPY(dest_Url, "F", body, locktoken);
            if (resource.getStatus().getStatusCode() == 201) {
                TestLock018.addGlobalMessage((String)"3. COPY /TestLock018.txt to /TestLock018_copy.txt", (char)'I', (String)"COPY was successful!");
            }
        }
        catch (WDVTestJ_WdvException exc) {
            TestLock018.addGlobalMessage((String)"3. COPY /TestLock018.txt to /TestLock018_copy.txt", (char)'E', (String)("status: " + resource.getStatus().getStatusCode() + " " + resource.getStatus().getStatusMessage()));
            TestLock018.addGlobalMessage((String)"3. COPY /TestLock018.txt to /TestLock018_copy.txt", (char)'I', (String)"Test failed due to some WebDAV feature.");
        }
        catch (MalformedURLException exc) {
            TestLock018.addGlobalMessage((String)"3. COPY /TestLock018.txt to /TestLock018_copy.txt", (char)'E', (String)"Test failed due to some Java-URL feature");
            return;
        }
        catch (Exception exc) {
            TestLock018.addGlobalMessage((String)"3. COPY /TestLock018.txt to /TestLock018_copy.txt", (char)'E', (String)("Java exception: " + exc));
            TestLock018.addGlobalMessage((String)"3. COPY /TestLock018.txt to /TestLock018_copy.txt", (char)'I', (String)"Test failed due to some Java feature");
            return;
        }
        locktoken = TestLock018.getLockToken(resource, host + ":" + WDV_PORT + baseUrl + urlStr);
        urlStr = new String("/TestLock018_copy.txt");
        resource = new WDVTestJ_WebDAVCore().createResource(host, WDV_PORT, baseUrl, urlStr);
        if (resource == null) {
            TestLock018.addGlobalMessage((String)"4. compare the locktoken of the original and the copy", (char)'E', (String)"Preparations failed due to some Java feature.");
        }
        if ((locktoken_copy = TestLock018.getLockToken(resource, host + ":" + WDV_PORT + baseUrl + urlStr)) == null) {
            TestLock018.addGlobalMessage((String)"4. compare the locktoken of the original and the copy", (char)'I', (String)"Test was successful!");
            TestLock018.addGlobalMessage((String)"4. compare the locktoken of the original and the copy", (char)'I', (String)("original locktoken: " + locktoken + "\ncopied locktoken: " + locktoken_copy));
        } else {
            TestLock018.addGlobalMessage((String)"4. compare the locktoken of the original and the copy", (char)'E', (String)"Test failed due to some Java feature.");
            TestLock018.addGlobalMessage((String)"4. compare the locktoken of the original and the copy", (char)'I', (String)("original locktoken: " + locktoken + "\ncopied locktoken: " + locktoken_copy + "'null' was expected."));
        }
    }

    public static void cleanUp() throws TestCaseException {
        if (resource.exists()) {
            locktoken = TestLock018.getLockToken(resource, host + ":" + WDV_PORT + baseUrl + urlStr);
            TestLock018.doDelete(resource, locktoken, host + ":" + WDV_PORT + baseUrl + urlStr);
        }
        if ((resource = new WDVTestJ_WebDAVCore().createResource(host, WDV_PORT, baseUrl, urlStr = new String("/TestLock018.txt"))) == null) {
            TestLock018.addGlobalMessage((String)"5. DELETE /TestLock018.txt and /TestLock018_copy.txt", (char)'E', (String)"CleanUp failed due to some Java feature.");
        }
        if (resource.exists()) {
            locktoken = TestLock018.getLockToken(resource, host + ":" + WDV_PORT + baseUrl + urlStr);
            TestLock018.doDelete(resource, locktoken, host + ":" + WDV_PORT + baseUrl + urlStr);
        }
    }
}

