/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sapdb.WebDAVTest.jtests.locktests;

import com.sap.sapdb.WebDAVTest.jtests.WDVTestJ_WebDAVTestHelper;
import com.sap.sapdb.WebDAVTest.protocol.WDVTestJ_WdvException;
import com.sap.sapdb.WebDAVTest.protocol.WDVTestJ_WebDAVCore;
import com.sap.sapdb.testframe.driver.TestDatabaseException;
import com.sap.sapdb.testframe.testcase.TestCaseException;
import java.sql.SQLException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class TestLock007
extends WDVTestJ_WebDAVTestHelper {
    static String host = null;
    static String baseUrl = null;
    static String var_overwrite = null;
    static String urlStr = null;
    static WDVTestJ_WebDAVCore resource = null;
    static String content = null;
    static String contentType = null;
    static long contentLength = 4711L;
    static String locktoken = null;
    static Document xmlDocument = null;

    public static void prepare() throws TestCaseException {
        TestLock007.createWebDAVSchema();
        TestLock007.addGlobalMessage((String)("prepare test " + TestLock007.getTestClassId()), (char)'I', (String)"lock a resource using a xmlBody that exceeds the 8000 chars of the WebDAV-XMLBuffer, the owner value has less than 450 characters and overwrites the Buffer space.");
        host = new String(TestLock007.getParameterString((String)"host", (String)"localhost"));
        WDV_PORT = TestLock007.getPort();
        baseUrl = TestLock007.getParameterString((String)"baseUrl", (String)"/webdav");
        var_overwrite = TestLock007.getParameterString((String)"var_overwrite", (String)"F");
        start_server = TestLock007.getParameterBoolean((String)"start_server", (boolean)false);
        if (start_server) {
            TestLock007.addGlobalMessage((String)"preparation for test-execution", (char)'I', (String)("starting WebDAV server version '" + WDV_VERSION + "' on port: " + WDV_PORT));
            TestLock007.startWebDAV(WDV_PORT);
            try {
                Thread.sleep(WDV_STARTUP_TIME);
            }
            catch (InterruptedException iex) {
                TestLock007.handleGlobalExceptions((Exception)iex);
            }
        }
        if (!TestLock007.isServerRunning(WDV_PORT)) {
            throw new TestCaseException("Maybe the webdav service is not running properly on '" + host + ":" + WDV_PORT + "'");
        }
        urlStr = new String("/TestLock007.txt");
        resource = new WDVTestJ_WebDAVCore().createResource(host, WDV_PORT, baseUrl, urlStr);
        if (resource == null) {
            TestLock007.addGlobalMessage((String)"1. DELETE resource /TestLock007.txt at baseUrl", (char)'E', (String)"Preparations failed due to some Java feature.");
            return;
        }
        if (resource.exists()) {
            locktoken = TestLock007.getLockToken(resource, host + ":" + WDV_PORT + baseUrl + urlStr);
            TestLock007.doDelete(resource, locktoken, host + ":" + WDV_PORT + baseUrl + urlStr);
        }
        content = "Sind des Schaefchens Loeckchen braun,lehnt es am Elektrozaun.Wenn es mit den Augen rollt,will es sagen: Zu viel Volt";
        contentType = "text/plain";
        contentLength = content.length();
        if (!TestLock007.doPut(resource, content, contentType, locktoken, host + ":" + WDV_PORT + baseUrl + urlStr)) {
            throw new TestCaseException("Maybe the webdav service is not running properly on '" + host + ":" + WDV_PORT + "'");
        }
    }

    public void run() {
        String lockOwner = "D041249";
        while (lockOwner.length() < 420) {
            lockOwner = lockOwner + "D041249";
        }
        String gapFiller = "          ";
        while (gapFiller.length() <= 7000) {
            gapFiller = gapFiller + "          ";
        }
        String lockOwnerR = null;
        String body = "<?xml version=\"1.0\" encoding=\"utf-8\" ?>\n";
        body = body + "<D:lockinfo xmlns:D=\"DAV:\">\n";
        body = body + "<D:locktype>\n";
        body = body + gapFiller;
        body = body + "<D:write/>\n";
        body = body + "</D:locktype>\n";
        body = body + "<D:lockscope>\n";
        body = body + "<D:exclusive/>\n";
        body = body + "</D:lockscope>\n";
        body = body + "<D:owner>" + lockOwner + "</D:owner>\n";
        body = body + "</D:lockinfo>\n";
        try {
            resource.LOCK(body, null);
        }
        catch (WDVTestJ_WdvException exc) {
            TestLock007.addGlobalMessage((String)"3. LOCK the resource /TestLock007.txt", (char)'E', (String)("WebDAV exception: " + exc.getStatusCode() + " " + exc.getMessage()));
            TestLock007.addGlobalMessage((String)"3. LOCK the resource /TestLock007.txt", (char)'I', (String)"Test failed due to some WebDAV feature.");
            return;
        }
        catch (Exception exc) {
            TestLock007.addGlobalMessage((String)"3. LOCK the resource /TestLock007.txt", (char)'E', (String)("Java exception: " + exc.getLocalizedMessage()));
            TestLock007.addGlobalMessage((String)"3. LOCK the resource /TestLock007.txt", (char)'I', (String)"Test failed due to some Java feature.");
            return;
        }
        String propfindBody = "<?xml version=\"1.0\" encoding=\"utf-8\" ?>\n";
        propfindBody = propfindBody + "<D:propfind xmlns:D=\"DAV:\">\n";
        propfindBody = propfindBody + "<D:prop>\n";
        propfindBody = propfindBody + "<D:lockdiscovery/>\n";
        propfindBody = propfindBody + "</D:prop>\n";
        propfindBody = propfindBody + "</D:propfind>\n";
        xmlDocument = TestLock007.doPropfind(resource, propfindBody, host + ":" + WDV_PORT + baseUrl + urlStr);
        Node owner_node = null;
        try {
            NodeList nl = xmlDocument.getElementsByTagName("D:owner");
            if (nl.getLength() == 0) {
                nl = xmlDocument.getElementsByTagName("owner");
            }
            owner_node = nl.item(0);
        }
        catch (NullPointerException exc) {
            TestLock007.addGlobalMessage((String)"retrieving the 'D:owner'-element", (char)'E', (String)"the 'owner'-element for the resource could not be retrieved");
        }
        try {
            String element_val;
            lockOwnerR = element_val = owner_node.getFirstChild().getNodeValue().toString();
        }
        catch (NullPointerException npexc) {
            TestLock007.addGlobalMessage((String)"receiving the value of the 'owner'-node for the resource", (char)'E', (String)"value of 'owner'-node is not existing");
        }
        if (lockOwner.equalsIgnoreCase(lockOwnerR)) {
            TestLock007.addGlobalMessage((String)"4. get the LOCK-owner using PROPFIND", (char)'I', (String)"The correct LOCK-owner was supplied. Test was successful!");
        } else {
            TestLock007.addGlobalMessage((String)"4. get the LOCK-owner using PROPFIND", (char)'E', (String)"The posted and the received LOCK-Owner values are not equal.");
            TestLock007.addGlobalMessage((String)"4. get the LOCK-owner using PROPFIND", (char)'I', (String)("Posted: " + lockOwner + "\nReceived: " + lockOwnerR));
        }
    }

    public static void cleanUp() throws TestCaseException {
        if (resource.exists()) {
            locktoken = TestLock007.getLockToken(resource, host + ":" + WDV_PORT + baseUrl + urlStr);
            TestLock007.doDelete(resource, locktoken, host + ":" + WDV_PORT + baseUrl + urlStr);
        }
    }
}

