/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sapdb.WebDAVTest.jtests.gettests;

import com.sap.sapdb.WebDAVTest.jtests.WDVTestJ_WebDAVTestHelper;
import com.sap.sapdb.WebDAVTest.protocol.WDVTestJ_WdvException;
import com.sap.sapdb.WebDAVTest.protocol.WDVTestJ_WebDAVCore;
import com.sap.sapdb.testframe.driver.TestDatabaseException;
import com.sap.sapdb.testframe.testcase.TestCaseException;
import java.sql.SQLException;

public class TestGet012
extends WDVTestJ_WebDAVTestHelper {
    static String host = null;
    static String baseUrl = null;
    static String var_overwrite = null;
    static String urlStr = null;
    static WDVTestJ_WebDAVCore resource = null;
    static String content = "";
    static String contentType = null;
    static int contentLength = 0;
    static String expectedContent = "";
    static String locktoken = null;
    static String contentRange = null;
    static Byte firstByte = null;
    static Byte lastByte = null;

    public static void prepare() throws TestCaseException {
        TestGet012.createWebDAVSchema();
        TestGet012.addGlobalMessage((String)("prepare test " + TestGet012.getTestClassId()), (char)'I', (String)"*************************************************************\n* get on an existing file and try to receive a byte range   *\n* whose start byte is higher than the end byte (Status 416) *\n*************************************************************");
        host = new String(TestGet012.getParameterString((String)"host", (String)"localhost"));
        WDV_PORT = TestGet012.getPort();
        baseUrl = TestGet012.getParameterString((String)"baseUrl", (String)"/webdav");
        var_overwrite = TestGet012.getParameterString((String)"var_overwrite", (String)"F");
        start_server = TestGet012.getParameterBoolean((String)"start_server", (boolean)false);
        if (start_server) {
            TestGet012.addGlobalMessage((String)"preparation for test-execution", (char)'I', (String)("starting WebDAV server version '" + WDV_VERSION + "' on port: " + WDV_PORT));
            TestGet012.startWebDAV(WDV_PORT);
            try {
                Thread.sleep(WDV_STARTUP_TIME);
            }
            catch (InterruptedException iex) {
                TestGet012.handleGlobalExceptions((Exception)iex);
            }
        }
        if (!TestGet012.isServerRunning(WDV_PORT)) {
            throw new TestCaseException("Maybe the webdav service is not running properly on '" + host + ":" + WDV_PORT + "'");
        }
        urlStr = "/TestGet012.txt";
        resource = new WDVTestJ_WebDAVCore().createResource(host, WDV_PORT, baseUrl, urlStr);
        if (resource == null) {
            TestGet012.addGlobalMessage((String)"1. DELETE /TestGet012.txt at baseUrl", (char)'E', (String)"Preparations failed due to some Java feature.");
        }
        if (!TestGet012.doDelete(resource, locktoken, host + ":" + WDV_PORT + baseUrl + urlStr)) {
            throw new TestCaseException("Maybe the webdav service is not running properly on '" + host + ":" + WDV_PORT + "'");
        }
        expectedContent = content = "Sind des Schaefchens Loeckchen braun,lehnt es am Elektrozaun.Wenn es mit den Augen rollt,will es sagen: Zu viel Volt! ";
        contentLength = content.length();
        contentType = "text/plain";
        if (!TestGet012.doPut(resource, content, contentType, locktoken, host + ":" + WDV_PORT + baseUrl + urlStr)) {
            throw new TestCaseException("Maybe the webdav service is not running properly on '" + host + ":" + WDV_PORT + "'");
        }
    }

    public void run() {
        contentRange = "bytes=20-10";
        try {
            resource.GET(contentRange);
            if (resource.getStatus().getStatusCode() != 416) {
                TestGet012.addGlobalMessage((String)"3. Call the GET method for the resource", (char)'E', (String)("Status Code is '" + resource.getStatus().getStatusCode() + " " + resource.getStatus().getStatusMessage() + "'" + "and DOES NOT equal the expected status ('416 Requested range not satisfiable')."));
            }
        }
        catch (WDVTestJ_WdvException exc) {
            if (exc.getStatusCode() == 416) {
                TestGet012.addGlobalMessage((String)"3. Call the GET method for the resource", (char)'I', (String)("Status Code is '" + resource.getStatus().getStatusCode() + " " + resource.getStatus().getStatusMessage() + "'" + "and equals the expected status."));
            } else {
                TestGet012.addGlobalMessage((String)"3. Call the GET method for the resource", (char)'E', (String)("WebDAV exception: " + exc.getStatusCode() + " " + exc.getMessage()));
                TestGet012.addGlobalMessage((String)"3. Call the GET method for the resource", (char)'I', (String)"Test failed due to some WebDAV feature.");
            }
        }
        catch (Exception exc) {
            TestGet012.addGlobalMessage((String)"3. Call the GET method for the resource", (char)'E', (String)("Java exception: " + exc.getMessage()));
            TestGet012.addGlobalMessage((String)"3. Call the GET method for the resource", (char)'I', (String)"Test failed due to some Java feature.");
        }
    }

    public static void cleanUp() throws TestCaseException {
        TestGet012.doDelete(resource, locktoken, host + ":" + WDV_PORT + baseUrl + urlStr);
    }
}

