/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sapdb.WebDAVTest.jtests.gettests;

import com.sap.sapdb.WebDAVTest.jtests.WDVTestJ_WebDAVTestHelper;
import com.sap.sapdb.WebDAVTest.protocol.WDVTestJ_WdvException;
import com.sap.sapdb.WebDAVTest.protocol.WDVTestJ_WebDAVCore;
import com.sap.sapdb.testframe.driver.TestDatabaseException;
import com.sap.sapdb.testframe.testcase.TestCaseException;
import java.sql.SQLException;

public class TestGet004
extends WDVTestJ_WebDAVTestHelper {
    static String host = null;
    static String baseUrl = null;
    static String var_overwrite = null;
    static String urlStr = null;
    static WDVTestJ_WebDAVCore resource = null;
    static String content = null;
    static String contentType = null;
    static long contentLength = 4711L;
    static String locktoken = null;

    public static void prepare() throws TestCaseException {
        TestGet004.createWebDAVSchema();
        TestGet004.addGlobalMessage((String)("prepare test " + TestGet004.getTestClassId()), (char)'I', (String)"get on a not existing folder");
        host = new String(TestGet004.getParameterString((String)"host", (String)"localhost"));
        WDV_PORT = TestGet004.getPort();
        baseUrl = TestGet004.getParameterString((String)"baseUrl", (String)"/webdav");
        var_overwrite = TestGet004.getParameterString((String)"var_overwrite", (String)"F");
        start_server = TestGet004.getParameterBoolean((String)"start_server", (boolean)false);
        if (start_server) {
            TestGet004.addGlobalMessage((String)"preparation for test-execution", (char)'I', (String)("starting WebDAV server version '" + WDV_VERSION + "' on port: " + WDV_PORT));
            TestGet004.startWebDAV(WDV_PORT);
            try {
                Thread.sleep(WDV_STARTUP_TIME);
            }
            catch (InterruptedException iex) {
                TestGet004.handleGlobalExceptions((Exception)iex);
            }
        }
        if (!TestGet004.isServerRunning(WDV_PORT)) {
            throw new TestCaseException("Maybe the webdav service is not running properly on '" + host + ":" + WDV_PORT + "'");
        }
        urlStr = "/TestGet004";
        resource = new WDVTestJ_WebDAVCore().createResource(host, WDV_PORT, baseUrl, urlStr);
        if (resource == null) {
            TestGet004.addGlobalMessage((String)"1. DELETE /TestGet004 at baseUrl", (char)'E', (String)"Preparations failed due to some Java feature.");
        }
        if (!TestGet004.doDelete(resource, locktoken, host + ":" + WDV_PORT + baseUrl + urlStr)) {
            throw new TestCaseException("Maybe the webdav service is not running properly on '" + host + ":" + WDV_PORT + "'");
        }
    }

    public void run() {
        try {
            String contentR = new String(resource.GET());
            if (contentR != null) {
                TestGet004.addGlobalMessage((String)("GET http://" + host + ":" + WDV_PORT + baseUrl + urlStr), (char)'E', (String)"Content was recieved!!!");
            }
        }
        catch (WDVTestJ_WdvException exc) {
            if (exc.getStatusCode() == 404) {
                TestGet004.addGlobalMessage((String)("GET http://" + host + ":" + WDV_PORT + baseUrl + urlStr), (char)'I', (String)"Test was succesful. No content retrieved.");
            } else {
                TestGet004.addGlobalMessage((String)("GET http://" + host + ":" + WDV_PORT + baseUrl + urlStr), (char)'E', (String)("WebDAV exception: " + exc.getStatusCode() + " " + exc.getMessage() + "Expected result: 404 Not found"));
            }
        }
        catch (Exception exc) {
            TestGet004.addGlobalMessage((String)("GET http://" + host + ":" + WDV_PORT + baseUrl + urlStr), (char)'E', (String)("Java exception: " + exc));
        }
    }

    public static void cleanUp() throws TestCaseException {
    }
}

