/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sapdb.WebDAVTest.jtests.destructivetests;

import com.sap.sapdb.WebDAVTest.jtests.WDVTestJ_WebDAVTestHelper;
import com.sap.sapdb.WebDAVTest.protocol.WDVTestJ_WebDAVCore;
import com.sap.sapdb.testframe.driver.TestDatabaseException;
import com.sap.sapdb.testframe.testcase.TestCaseException;
import java.sql.SQLException;

public class TestDestructive001
extends WDVTestJ_WebDAVTestHelper {
    static String host = null;
    static String baseUrl = null;
    static String urlStr = null;
    static WDVTestJ_WebDAVCore resource = null;
    static String content = null;
    static String contentType = null;
    static long contentLength = 4711L;
    static String locktoken = null;
    int iterations = 10000;

    public static void prepare() throws TestCaseException {
        TestDestructive001.createWebDAVSchema();
        TestDestructive001.addGlobalMessage((String)("prepare test " + TestDestructive001.getTestClassId()), (char)'I', (String)"test the servers stability by putting hundreds of resources");
        host = new String(TestDestructive001.getParameterString((String)"host", (String)"localhost"));
        WDV_PORT = TestDestructive001.getPort();
        baseUrl = TestDestructive001.getParameterString((String)"baseUrl", (String)"/webdav");
        start_server = TestDestructive001.getParameterBoolean((String)"start_server", (boolean)false);
        if (start_server) {
            TestDestructive001.addGlobalMessage((String)"preparation for test-execution", (char)'I', (String)("starting WebDAV server version '" + WDV_VERSION + "' on port: " + WDV_PORT));
            TestDestructive001.startWebDAV(WDV_PORT);
            try {
                Thread.sleep(WDV_STARTUP_TIME);
            }
            catch (InterruptedException iex) {
                TestDestructive001.handleGlobalExceptions((Exception)iex);
            }
        }
        if (!TestDestructive001.isServerRunning(WDV_PORT)) {
            throw new TestCaseException("Maybe the webdav service is not running properly on '" + host + ":" + WDV_PORT + "'");
        }
        urlStr = "/TestDestructive001";
        resource = new WDVTestJ_WebDAVCore().createResource(host, WDV_PORT, baseUrl, urlStr);
        if (resource == null) {
            TestDestructive001.addGlobalMessage((String)"1. DELETE folder /TestDestructive001 at baseUrl", (char)'E', (String)"Preparations failed due to some Java feature.");
        }
        if (!TestDestructive001.doDelete(resource, locktoken, host + ":" + WDV_PORT + baseUrl + urlStr)) {
            throw new TestCaseException("Maybe the webdav service is not running properly on '" + host + ":" + WDV_PORT + "'");
        }
        if (!TestDestructive001.doMkCol(resource, locktoken, host + ":" + WDV_PORT + baseUrl + urlStr)) {
            throw new TestCaseException("Maybe the webdav service is not running properly on '" + host + ":" + WDV_PORT + "'");
        }
    }

    public void run() {
        for (int test_iterations = 0; test_iterations <= this.iterations; ++test_iterations) {
            urlStr = "/TestDestructive001/TestDestructive001_" + test_iterations + ".txt";
            resource = new WDVTestJ_WebDAVCore().createResource(host, WDV_PORT, baseUrl, urlStr);
            if (resource == null) {
                TestDestructive001.addGlobalMessage((String)("3. PUT /TestDestructive001/TestDestructive001_" + test_iterations + ".txt"), (char)'E', (String)"Preparations failed due to some Java feature.");
            }
            content = "Sind des Schaefchens Loeckchen braun,lehnt es am Elektrozaun.Wenn es mit den Augen rollt,will es sagen: Zu viel Volt";
            contentType = "text/plain";
            contentLength = content.length();
            TestDestructive001.doPut(resource, content, contentType, locktoken, host + ":" + WDV_PORT + baseUrl + urlStr);
        }
        for (int check_iterations = 0; check_iterations <= this.iterations; ++check_iterations) {
            urlStr = "/TestDestructive001/TestDestructive001_" + check_iterations + ".txt";
            resource = new WDVTestJ_WebDAVCore().createResource(host, WDV_PORT, baseUrl, urlStr);
            if (resource == null) {
                TestDestructive001.addGlobalMessage((String)"4. perform checks in /TestDestructive001", (char)'E', (String)"Check failed due to some Java feature.");
            }
            TestDestructive001.compareContent(resource, content, contentType, contentLength, host + ":" + WDV_PORT + baseUrl + urlStr);
        }
    }

    public static void cleanUp() throws TestCaseException {
        urlStr = "/TestDestructive001";
        resource = new WDVTestJ_WebDAVCore().createResource(host, WDV_PORT, baseUrl, urlStr);
        if (resource == null) {
            TestDestructive001.addGlobalMessage((String)"5. clean up and DELETE folder /TestDestructive001 at baseUrl", (char)'E', (String)"Preparations failed due to some Java feature.");
        }
        TestDestructive001.doDelete(resource, locktoken, host + ":" + WDV_PORT + baseUrl + urlStr);
    }
}

