/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sapdb.WebDAVTest.jtests.deletetests;

import com.sap.sapdb.WebDAVTest.jtests.WDVTestJ_WebDAVTestHelper;
import com.sap.sapdb.WebDAVTest.protocol.WDVTestJ_WdvException;
import com.sap.sapdb.WebDAVTest.protocol.WDVTestJ_WebDAVCore;
import com.sap.sapdb.testframe.driver.TestDatabaseException;
import com.sap.sapdb.testframe.testcase.TestCaseException;
import java.sql.SQLException;

public class TestDelete003
extends WDVTestJ_WebDAVTestHelper {
    static String host = null;
    static String baseUrl = null;
    static String urlStr = null;
    static WDVTestJ_WebDAVCore resource = null;
    static String content = null;
    static String contentType = null;
    static long contentLength = 4711L;
    static String locktoken = null;

    public static void prepare() throws TestCaseException {
        TestDelete003.createWebDAVSchema();
        TestDelete003.addGlobalMessage((String)("prepare test " + TestDelete003.getTestClassId()), (char)'I', (String)"delete a not existing resource");
        host = new String(TestDelete003.getParameterString((String)"host", (String)"localhost"));
        WDV_PORT = TestDelete003.getPort();
        baseUrl = TestDelete003.getParameterString((String)"baseUrl", (String)"/webdav");
        start_server = TestDelete003.getParameterBoolean((String)"start_server", (boolean)false);
        if (start_server) {
            TestDelete003.addGlobalMessage((String)"preparation for test-execution", (char)'I', (String)("starting WebDAV server version '" + WDV_VERSION + "' on port: " + WDV_PORT));
            TestDelete003.startWebDAV(WDV_PORT);
            try {
                Thread.sleep(WDV_STARTUP_TIME);
            }
            catch (InterruptedException iex) {
                TestDelete003.handleGlobalExceptions((Exception)iex);
            }
        }
        if (!TestDelete003.isServerRunning(WDV_PORT)) {
            throw new TestCaseException("Maybe the webdav service is not running properly on '" + host + ":" + WDV_PORT + "'");
        }
        urlStr = "/TestDelete003";
        resource = new WDVTestJ_WebDAVCore().createResource(host, WDV_PORT, baseUrl, urlStr);
        if (resource == null) {
            TestDelete003.addGlobalMessage((String)"1. DELETE folder /TestDelete003 at baseUrl", (char)'E', (String)"Preparations failed due to some Java feature.");
        }
        if (!TestDelete003.doDelete(resource, locktoken, host + ":" + WDV_PORT + baseUrl + urlStr)) {
            throw new TestCaseException("Maybe the webdav service is not running properly on '" + host + ":" + WDV_PORT + "'");
        }
    }

    public void run() {
        try {
            resource.DELETE(locktoken);
            if (resource.getStatus().getStatusCode() == 404) {
                TestDelete003.addGlobalMessage((String)("DELETE http://" + host + ":" + WDV_PORT + baseUrl + urlStr), (char)'I', (String)"Test was succesful.");
            } else {
                TestDelete003.addGlobalMessage((String)("DELETE http://" + host + ":" + WDV_PORT + baseUrl + urlStr), (char)'E', (String)("WebDAV exception: " + resource.getStatus().getStatusCode() + " " + resource.getStatus().getStatusMessage() + " Expected result: 404 Not Found"));
                TestDelete003.addGlobalMessage((String)("DELETE http://" + host + ":" + WDV_PORT + baseUrl + urlStr), (char)'I', (String)"Test failed due to some WebDAV feature.");
            }
        }
        catch (WDVTestJ_WdvException exc) {
            if (exc.getStatusCode() != 404) {
                TestDelete003.addGlobalMessage((String)("DELETE http://" + host + ":" + WDV_PORT + baseUrl + urlStr), (char)'E', (String)("WebDAV exception: " + exc.getStatusCode() + " " + exc.getMessage() + " Expected result: 404 Not Found"));
                TestDelete003.addGlobalMessage((String)("DELETE http://" + host + ":" + WDV_PORT + baseUrl + urlStr), (char)'I', (String)"Test failed due to some WebDAV feature");
            }
        }
        catch (Exception exc) {
            TestDelete003.addGlobalMessage((String)("DELETE http://" + host + ":" + WDV_PORT + baseUrl + urlStr), (char)'E', (String)("Java exception: " + exc));
            TestDelete003.addGlobalMessage((String)("DELETE http://" + host + ":" + WDV_PORT + baseUrl + urlStr), (char)'I', (String)"Test failed due to some Java feature");
        }
    }

    public static void cleanUp() throws TestCaseException {
        TestDelete003.doDelete(resource, locktoken, host + ":" + WDV_PORT + baseUrl + urlStr);
    }
}

