/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sapdb.WebDAVTest.jtests.copytests;

import com.sap.sapdb.WebDAVTest.jtests.WDVTestJ_WebDAVTestHelper;
import com.sap.sapdb.WebDAVTest.protocol.WDVTestJ_WdvException;
import com.sap.sapdb.WebDAVTest.protocol.WDVTestJ_WebDAVCore;
import com.sap.sapdb.testframe.driver.TestDatabaseException;
import com.sap.sapdb.testframe.testcase.TestCaseException;
import java.net.MalformedURLException;
import java.net.URL;
import java.sql.SQLException;

public class TestCopy009
extends WDVTestJ_WebDAVTestHelper {
    static String host = null;
    static String baseUrl = null;
    static String var_overwrite = null;
    static String urlStr = null;
    static WDVTestJ_WebDAVCore resource = null;
    static String content = null;
    static String contentType = null;
    static long contentLength = 4711L;
    static String locktoken = null;

    public static void prepare() throws TestCaseException {
        TestCopy009.createWebDAVSchema();
        TestCopy009.addGlobalMessage((String)("prepare test " + TestCopy009.getTestClassId()), (char)'I', (String)"****************************************************************\n* try to copy a resource from one WebDAV server to another one *\n****************************************************************\n");
        host = new String(TestCopy009.getParameterString((String)"host", (String)"localhost"));
        WDV_PORT = TestCopy009.getPort();
        baseUrl = TestCopy009.getParameterString((String)"baseUrl", (String)"/webdav");
        var_overwrite = TestCopy009.getParameterString((String)"var_overwrite", (String)"F");
        start_server = TestCopy009.getParameterBoolean((String)"start_server", (boolean)false);
        if (start_server) {
            TestCopy009.addGlobalMessage((String)"preparation for test-execution", (char)'I', (String)("starting WebDAV server version '" + WDV_VERSION + "' on port: " + WDV_PORT));
            TestCopy009.startWebDAV(WDV_PORT);
            try {
                Thread.sleep(WDV_STARTUP_TIME);
            }
            catch (InterruptedException iex) {
                TestCopy009.handleGlobalExceptions((Exception)iex);
            }
        }
        if (!TestCopy009.isServerRunning(WDV_PORT)) {
            throw new TestCaseException("Maybe the webdav service is not running properly on '" + host + ":" + WDV_PORT + "'");
        }
        urlStr = new String("/TestCopy009.txt");
        resource = new WDVTestJ_WebDAVCore().createResource(host, WDV_PORT, baseUrl, urlStr);
        if (resource == null) {
            TestCopy009.addGlobalMessage((String)"1. DELETE /TestCopy009.txt at baseUrl", (char)'E', (String)"Preparations failed due to some Java feature.");
        }
        if (!TestCopy009.doDelete(resource, locktoken, host + ":" + WDV_PORT + baseUrl + urlStr)) {
            throw new TestCaseException("Maybe the webdav service is not running properly on '" + host + ":" + WDV_PORT + "'");
        }
        urlStr = new String("/TestCopy009.txt");
        resource = new WDVTestJ_WebDAVCore().createResource(host, WDV_PORT, baseUrl, urlStr);
        if (resource == null) {
            TestCopy009.addGlobalMessage((String)"2. create resource /TestCopy009.txt at baseUrl", (char)'E', (String)"Preparations failed due to some Java feature.");
        }
        if (!TestCopy009.doPut(resource, content = "Sind des Schaefchens Loeckchen braun,lehnt es am Elektrozaun.Wenn es mit den Augen rollt,will es sagen: Zu viel Volt", contentType = "text/plain", locktoken, host + ":" + WDV_PORT + baseUrl + urlStr)) {
            throw new TestCaseException("Maybe the webdav service is not running properly on '" + host + ":" + WDV_PORT + "'");
        }
    }

    public void run() {
        urlStr = new String("/TestCopy009.txt");
        resource = new WDVTestJ_WebDAVCore().createResource(host, WDV_PORT, baseUrl, urlStr);
        if (resource == null) {
            TestCopy009.addGlobalMessage((String)"3. COPY /TestCopy009.txt to http://pts:1080/webdav/tests/WebDAVTests", (char)'E', (String)"Preparations failed due to some Java feature.");
        }
        String dest_Url = null;
        String body = null;
        locktoken = null;
        try {
            dest_Url = new URL("http", "pts", 1080, "/webdav/tests/WebDAVTests/TestCopy009.txt").toString();
        }
        catch (MalformedURLException exc) {
            TestCopy009.addGlobalMessage((String)"3. COPY /TestCopy009.txt to http://pts:1080/webdav/tests/WebDAVTests", (char)'E', (String)"Test failed due to some Java-URL feature");
        }
        try {
            resource.COPY(dest_Url, "F", body, locktoken);
            if (resource.getStatus().getStatusCode() != 501) {
                TestCopy009.addGlobalMessage((String)"3. COPY /TestCopy009.txt to http://pts:1080/webdav/tests/WebDAVTests", (char)'E', (String)("unexpected status: " + resource.getStatus().getStatusCode() + " " + resource.getStatus().getStatusMessage()));
                TestCopy009.addGlobalMessage((String)"3. COPY /TestCopy009.txt to http://pts:1080/webdav/tests/WebDAVTests", (char)'I', (String)"expected: '501 Not Implemented'");
                return;
            }
        }
        catch (WDVTestJ_WdvException exc) {
            if (exc.getStatusCode() == 501) {
                TestCopy009.addGlobalMessage((String)"3. COPY /TestCopy009.txt to http://pts:1080/webdav/tests/WebDAVTests", (char)'I', (String)("server returned the correct status: " + resource.getStatus().getStatusCode() + " " + resource.getStatus().getStatusMessage() + "\nTest was successful!"));
                return;
            }
            TestCopy009.addGlobalMessage((String)"3. COPY /TestCopy009.txt to http://pts:1080/webdav/tests/WebDAVTests", (char)'E', (String)("unexpected status: " + resource.getStatus().getStatusCode() + " " + resource.getStatus().getStatusMessage()));
            TestCopy009.addGlobalMessage((String)"3. COPY /TestCopy009.txt to http://pts:1080/webdav/tests/WebDAVTests", (char)'I', (String)"expected: '201 Created' or '501 Not Implemented'");
        }
        catch (Exception exc) {
            TestCopy009.addGlobalMessage((String)("COPY TO http://" + dest_Url), (char)'E', (String)("Java exception: " + exc));
            TestCopy009.addGlobalMessage((String)"COPY failed due to some Java feature", (char)'I', (String)("Skipping test " + TestCopy009.getTestClassId()));
            return;
        }
    }

    public static void cleanUp() throws TestCaseException {
        urlStr = new String("/TestCopy009.txt");
        resource = new WDVTestJ_WebDAVCore().createResource(host, WDV_PORT, baseUrl, urlStr);
        if (resource == null) {
            TestCopy009.addGlobalMessage((String)"4. clean up and DELETE /TestCopy009.txt", (char)'E', (String)"CleanUp failed due to some Java feature.");
        }
        TestCopy009.doDelete(resource, locktoken, host + ":" + WDV_PORT + baseUrl + urlStr);
    }
}

