/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sapdb.WebDAVTest.jtests.copytests;

import com.sap.sapdb.WebDAVTest.jtests.WDVTestJ_WebDAVTestHelper;
import com.sap.sapdb.WebDAVTest.protocol.WDVTestJ_WdvException;
import com.sap.sapdb.WebDAVTest.protocol.WDVTestJ_WebDAVCore;
import com.sap.sapdb.testframe.driver.TestDatabaseException;
import com.sap.sapdb.testframe.testcase.TestCaseException;
import java.net.MalformedURLException;
import java.net.URL;
import java.sql.SQLException;

public class TestCopy003
extends WDVTestJ_WebDAVTestHelper {
    static String host = null;
    static String baseUrl = null;
    static String var_overwrite = null;
    static String urlStr = null;
    static WDVTestJ_WebDAVCore resource = null;
    static String content = null;
    static String contentType = null;
    static long contentLength = 4711L;
    static String locktoken = null;
    static long sleep_time = 5000L;

    public static void prepare() throws TestCaseException {
        TestCopy003.createWebDAVSchema();
        TestCopy003.addGlobalMessage((String)("Prepare test " + TestCopy003.getTestClassId()), (char)'I', (String)"********************************************************\n* Copy a collection on a resource (with overwrite ='T' *\n********************************************************");
        host = new String(TestCopy003.getParameterString((String)"host", (String)"localhost"));
        WDV_PORT = TestCopy003.getPort();
        baseUrl = TestCopy003.getParameterString((String)"baseUrl", (String)"/webdav");
        var_overwrite = TestCopy003.getParameterString((String)"var_overwrite", (String)"T");
        start_server = TestCopy003.getParameterBoolean((String)"start_server", (boolean)false);
        if (start_server) {
            TestCopy003.addGlobalMessage((String)"preparation for test-execution", (char)'I', (String)("starting WebDAV server version '" + WDV_VERSION + "' on port: " + WDV_PORT));
            TestCopy003.startWebDAV(WDV_PORT);
            try {
                Thread.sleep(WDV_STARTUP_TIME);
            }
            catch (InterruptedException iex) {
                TestCopy003.handleGlobalExceptions((Exception)iex);
            }
        }
        if (!TestCopy003.isServerRunning(WDV_PORT)) {
            throw new TestCaseException("Maybe the webdav service is not running properly on '" + host + ":" + WDV_PORT + "'");
        }
        urlStr = new String("/TestCopy003.txt");
        resource = new WDVTestJ_WebDAVCore().createResource(host, WDV_PORT, baseUrl, urlStr);
        if (resource == null) {
            TestCopy003.addGlobalMessage((String)"1. DELETE resource /TestCopy003.txt at baseUrl", (char)'E', (String)"Preparations failed due to some Java feature.");
        }
        if (!TestCopy003.doDelete(resource, locktoken, host + ":" + WDV_PORT + baseUrl + urlStr)) {
            throw new TestCaseException("Maybe the webdav service is not running properly on '" + host + ":" + WDV_PORT + "'");
        }
        urlStr = new String("/TestCopy003");
        resource = new WDVTestJ_WebDAVCore().createResource(host, WDV_PORT, baseUrl, urlStr);
        if (resource == null) {
            TestCopy003.addGlobalMessage((String)"1. DELETE folder /TestCopy003 at baseUrl", (char)'E', (String)"Preparations failed due to some Java feature.");
        }
        TestCopy003.doDelete(resource, locktoken, host + ":" + WDV_PORT + baseUrl + urlStr);
        urlStr = new String("/TestCopy003");
        resource = new WDVTestJ_WebDAVCore().createResource(host, WDV_PORT, baseUrl, urlStr);
        if (resource == null) {
            TestCopy003.addGlobalMessage((String)"2. create the folder /TestCopy003 at baseUrl", (char)'E', (String)"Preparations failed due to some Java feature.");
        }
        TestCopy003.doMkCol(resource, locktoken, host + ":" + WDV_PORT + baseUrl + urlStr);
        urlStr = new String("/TestCopy003.txt");
        resource = new WDVTestJ_WebDAVCore().createResource(host, WDV_PORT, baseUrl, urlStr);
        if (resource == null) {
            TestCopy003.addGlobalMessage((String)"2. create the resource /TestCopy003.txt at baseUrl", (char)'E', (String)"Preparations failed due to some Java feature.");
        }
        content = "Sind des Schaefchens Loeckchen braun,lehnt es am Elektrozaun.Wenn es mit den Augen rollt,will es sagen: Zu viel Volt";
        contentType = "text/plain";
        contentLength = content.length();
        if (!TestCopy003.doPut(resource, content, contentType, locktoken, host + ":" + WDV_PORT + baseUrl + urlStr)) {
            throw new TestCaseException("Maybe the webdav service is not running properly on '" + host + ":" + WDV_PORT + "'");
        }
        urlStr = new String("/TestCopy003/TestCopy003.txt");
        resource = new WDVTestJ_WebDAVCore().createResource(host, WDV_PORT, baseUrl, urlStr);
        if (resource == null) {
            TestCopy003.addGlobalMessage((String)"2. create the resource /TestCopy003.txt at baseUrl", (char)'E', (String)"Preparations failed due to some Java feature.");
        }
        content = "Sind des Schaefchens Loeckchen braun,lehnt es am Elektrozaun.Wenn es mit den Augen rollt,will es sagen: Zu viel Volt";
        contentType = "text/plain";
        contentLength = content.length();
        TestCopy003.doPut(resource, content, contentType, locktoken, host + ":" + WDV_PORT + baseUrl + urlStr);
    }

    public void run() {
        String dir_contentType;
        urlStr = new String("/TestCopy003");
        resource = new WDVTestJ_WebDAVCore().createResource(host, WDV_PORT, baseUrl, urlStr);
        if (resource == null) {
            TestCopy003.addGlobalMessage((String)"3. COPY the collection /TestCopy003 to /TestCopy003.txt", (char)'E', (String)"Preparations failed due to some Java feature.");
        }
        String dest_Url = null;
        Object body = null;
        try {
            dest_Url = new URL("http", host, WDV_PORT, baseUrl + "/TestCopy003.txt").toString();
            body = null;
            locktoken = null;
        }
        catch (MalformedURLException exc) {
            TestCopy003.addGlobalMessage((String)"3. COPY the collection /TestCopy003 to /TestCopy003.txt", (char)'E', (String)"Test failed due to some Java-URL feature");
        }
        try {
            resource.COPY(dest_Url, "T", body, locktoken);
            if (resource.getStatus().getStatusCode() == 204) {
                TestCopy003.addGlobalMessage((String)"3. COPY the collection /TestCopy003 to /TestCopy003.txt", (char)'I', (String)("server returned the correct status: " + resource.getStatus().getStatusCode() + " " + resource.getStatus().getStatusMessage() + "\nTest was successful!"));
            } else {
                TestCopy003.addGlobalMessage((String)"3. COPY the collection /TestCopy003 to /TestCopy003.txt", (char)'E', (String)("unexpected status: " + resource.getStatus().getStatusCode() + " " + resource.getStatus().getStatusMessage()));
                TestCopy003.addGlobalMessage((String)"3. COPY the collection /TestCopy003 to /TestCopy003.txt", (char)'I', (String)"expected: 204 No Content");
            }
        }
        catch (WDVTestJ_WdvException exc) {
            TestCopy003.addGlobalMessage((String)("COPY TO http://" + dest_Url), (char)'E', (String)("WebDAV exception: " + exc.getStatusCode() + " " + exc.getMessage()));
            TestCopy003.addGlobalMessage((String)"COPY failed due to some WebDAV feature", (char)'I', (String)"Expected result: 204 No Content");
        }
        catch (Exception exc) {
            TestCopy003.addGlobalMessage((String)("COPY TO http://" + dest_Url), (char)'E', (String)("Java exception: " + exc));
            exc.printStackTrace();
            TestCopy003.addGlobalMessage((String)"COPY failed due to some Java feature", (char)'I', (String)("Skipping test " + TestCopy003.getTestClassId()));
        }
        urlStr = new String("/TestCopy003");
        resource = new WDVTestJ_WebDAVCore().createResource(host, WDV_PORT, baseUrl, urlStr);
        if (resource == null) {
            TestCopy003.addGlobalMessage((String)"3. compare the source and the destination", (char)'E', (String)"Preparations failed due to some Java feature.");
        }
        if ((dir_contentType = TestCopy003.doPropfindByTagName(resource, "getcontenttype", host + ":" + WDV_PORT + baseUrl + urlStr)).equalsIgnoreCase("sapdbwww/directory")) {
            TestCopy003.addGlobalMessage((String)("CHECK: GET http://" + host + ":" + WDV_PORT + baseUrl + urlStr), (char)'I', (String)"Recieved content type equals posted content type\nTest was successful.");
        } else {
            TestCopy003.addGlobalMessage((String)("CHECK: GET http://" + host + ":" + WDV_PORT + baseUrl + urlStr), (char)'E', (String)("Recieved content type (" + dir_contentType + ") not equal to posted content type (\"sapdbwww/directory\")"));
        }
    }

    public static void cleanUp() throws TestCaseException {
        urlStr = new String("/TestCopy003");
        resource = new WDVTestJ_WebDAVCore().createResource(host, WDV_PORT, baseUrl, urlStr);
        if (resource == null) {
            TestCopy003.addGlobalMessage((String)"4. clean up and DELETE /TestCopy003 as well as /TestCopy003.txt", (char)'E', (String)"CleanUp failed due to some Java feature.");
        }
        TestCopy003.doDelete(resource, locktoken, host + ":" + WDV_PORT + baseUrl + urlStr);
        urlStr = new String("/TestCopy003.txt");
        resource = new WDVTestJ_WebDAVCore().createResource(host, WDV_PORT, baseUrl, urlStr);
        if (resource == null) {
            TestCopy003.addGlobalMessage((String)"4. clean up and DELETE /TestCopy003 as well as /TestCopy003.txt", (char)'E', (String)"CleanUp failed due to some Java feature.");
        }
        TestCopy003.doDelete(resource, locktoken, host + ":" + WDV_PORT + baseUrl + urlStr);
    }
}

