/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sapdb.WebDAVTest.jtests.copytests;

import com.sap.sapdb.WebDAVTest.jtests.WDVTestJ_WebDAVTestHelper;
import com.sap.sapdb.WebDAVTest.protocol.WDVTestJ_WebDAVCore;
import com.sap.sapdb.testframe.driver.TestDatabaseException;
import com.sap.sapdb.testframe.testcase.TestCaseException;
import java.net.MalformedURLException;
import java.net.URL;
import java.sql.SQLException;

public class TestCopy001
extends WDVTestJ_WebDAVTestHelper {
    static String host = null;
    static String baseUrl = null;
    static String var_overwrite = null;
    static String urlStr = null;
    static WDVTestJ_WebDAVCore resource = null;
    static String content = null;
    static String contentType = null;
    static long contentLength = 4711L;
    static String locktoken = null;

    public static void prepare() throws TestCaseException {
        TestCopy001.createWebDAVSchema();
        TestCopy001.addGlobalMessage((String)("prepare test " + TestCopy001.getTestClassId()), (char)'I', (String)"*********************************************************\n* copy an existing resource to a sub-folder (Status 201)*\n*********************************************************");
        host = new String(TestCopy001.getParameterString((String)"host", (String)"localhost"));
        WDV_PORT = TestCopy001.getPort();
        baseUrl = TestCopy001.getParameterString((String)"baseUrl", (String)"/webdav");
        var_overwrite = TestCopy001.getParameterString((String)"var_overwrite", (String)"F");
        start_server = TestCopy001.getParameterBoolean((String)"start_server", (boolean)false);
        if (start_server) {
            TestCopy001.addGlobalMessage((String)"preparation for test-execution", (char)'I', (String)("starting WebDAV server version '" + WDV_VERSION + "' on port: " + WDV_PORT));
            TestCopy001.startWebDAV(WDV_PORT);
            TestCopy001.addGlobalMessage((String)"Start WebDAV Server after return from method", (char)'I', (String)"");
            try {
                Thread.sleep(WDV_STARTUP_TIME);
            }
            catch (InterruptedException iex) {
                TestCopy001.handleGlobalExceptions((Exception)iex);
            }
        }
        if (!TestCopy001.isServerRunning(WDV_PORT)) {
            throw new TestCaseException("Maybe the webdav service is not running properly on '" + host + ":" + WDV_PORT + "'");
        }
        urlStr = new String("/TestCopy001.txt");
        resource = new WDVTestJ_WebDAVCore().createResource(host, WDV_PORT, baseUrl, urlStr);
        if (resource == null) {
            TestCopy001.addGlobalMessage((String)"1. DELETE resource /TestCopy001.txt at baseUrl", (char)'E', (String)"Preparations failed due to some Java feature.");
        }
        if (!TestCopy001.doDelete(resource, locktoken, host + ":" + WDV_PORT + baseUrl + urlStr)) {
            throw new TestCaseException("Maybe the webdav service is not running properly on '" + host + ":" + WDV_PORT + "'");
        }
        urlStr = new String("/TestCopy001");
        resource = new WDVTestJ_WebDAVCore().createResource(host, WDV_PORT, baseUrl, urlStr);
        if (resource == null) {
            TestCopy001.addGlobalMessage((String)"1. DELETE folder /TestCopy001 at baseUrl", (char)'E', (String)"Preparations failed due to some Java feature.");
        }
        TestCopy001.doDelete(resource, locktoken, host + ":" + WDV_PORT + baseUrl + urlStr);
        urlStr = new String("/TestCopy001.txt");
        resource = new WDVTestJ_WebDAVCore().createResource(host, WDV_PORT, baseUrl, urlStr);
        if (resource == null) {
            TestCopy001.addGlobalMessage((String)"2. create the resource TestCopy001.txt at baseUrl", (char)'E', (String)"Preparations failed due to some Java feature.");
        }
        content = "Sind des Schaefchens Loeckchen braun,lehnt es am Elektrozaun.Wenn es mit den Augen rollt,will es sagen: Zu viel Volt";
        contentType = "text/plain";
        contentLength = content.length();
        if (!TestCopy001.doPut(resource, content, contentType, locktoken, host + ":" + WDV_PORT + baseUrl + urlStr)) {
            throw new TestCaseException("Maybe the webdav service is not running properly on '" + host + ":" + WDV_PORT + "'");
        }
        urlStr = new String("/TestCopy001");
        resource = new WDVTestJ_WebDAVCore().createResource(host, WDV_PORT, baseUrl, urlStr);
        if (resource == null) {
            TestCopy001.addGlobalMessage((String)"2. create the collection /TestCopy001 at baseUrl", (char)'E', (String)"Preparations failed due to some Java feature.");
        }
        TestCopy001.doMkCol(resource, locktoken, host + ":" + WDV_PORT + baseUrl + urlStr);
    }

    public void run() {
        urlStr = "/TestCopy001.txt";
        resource = new WDVTestJ_WebDAVCore().createResource(host, WDV_PORT, baseUrl, urlStr);
        if (resource == null) {
            TestCopy001.addGlobalMessage((String)"3. COPY TestCopy001.txt to /TestCopy001", (char)'E', (String)"Test failed due to some Java feature");
        }
        try {
            String dest_Url = new URL("http", host, WDV_PORT, baseUrl + "/TestCopy001/TestCopy001.txt").toString();
            String overwrite = var_overwrite;
            String body = null;
            locktoken = null;
            TestCopy001.doCopy(resource, dest_Url, overwrite, body, locktoken, null);
        }
        catch (MalformedURLException exc) {
            TestCopy001.addGlobalMessage((String)"3. COPY TestCopy001.txt to /TestCopy001", (char)'E', (String)"Test failed due to some Java-URL feature");
            return;
        }
        urlStr = new String("/TestCopy001/TestCopy001.txt");
        resource = new WDVTestJ_WebDAVCore().createResource(host, WDV_PORT, baseUrl, urlStr);
        if (resource == null) {
            TestCopy001.addGlobalMessage((String)"4. compare the source and the destination after COPY", (char)'E', (String)"Test failed due to some Java feature.");
        }
        TestCopy001.compareContent(resource, content, contentType, contentLength, host + ":" + WDV_PORT + baseUrl + urlStr);
    }

    public static void cleanUp() throws TestCaseException {
        urlStr = new String("/TestCopy001.txt");
        resource = new WDVTestJ_WebDAVCore().createResource(host, WDV_PORT, baseUrl, urlStr);
        if (resource == null) {
            TestCopy001.addGlobalMessage((String)"5. clean up and DELETE resource /TestCopy001.txt at baseUrl", (char)'E', (String)"CleanUp failed due to some Java feature.");
        }
        TestCopy001.doDelete(resource, locktoken, host + ":" + WDV_PORT + baseUrl + urlStr);
        urlStr = new String("/TestCopy001");
        resource = new WDVTestJ_WebDAVCore().createResource(host, WDV_PORT, baseUrl, urlStr);
        if (resource == null) {
            TestCopy001.addGlobalMessage((String)"4. clean up and DELETE folder /TestCopy001 at baseUrl", (char)'E', (String)"CleanUp failed due to some Java feature.");
        }
        TestCopy001.doDelete(resource, locktoken, host + ":" + WDV_PORT + baseUrl + urlStr);
    }
}

