/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sapdb.packettest.jdbc;

import com.sap.dbtech.jdbc.exceptions.JDBCDriverException;
import com.sap.dbtech.jdbc.exceptions.TimeoutException;
import com.sap.dbtech.rte.comm.JdbcCommFactory;
import com.sap.dbtech.rte.comm.JdbcCommunication;
import com.sap.dbtech.rte.comm.NativeComm;
import com.sap.dbtech.rte.comm.RTEException;
import com.sap.dbtech.rte.comm.SecureCommunication;
import com.sap.dbtech.rte.comm.SocketComm;
import com.sap.dbtech.util.MessageTranslator;
import com.sap.dbtech.util.StringUtil;
import com.sap.dbtech.util.Tracer;
import com.sap.dbtech.util.VersionInfo;
import java.io.IOException;
import java.security.AccessControlException;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Properties;

public class DriverSapDB
implements Driver {
    public static DriverSapDB driver = new DriverSapDB();
    public static JdbcCommFactory commFactory;
    public static boolean isJDBC20;
    public static VersionInfo jdbcDriverVersion;
    public static final String protocolName_C = "jdbc:sapdb:";
    public static final String dllName_C = "sapdbcbin";
    public static final String loadbinProperty_C = "com.sap.dbtech.jdbc.loadbin";
    public static final String osNameProperty_C = "os.name";
    public static final String osLinuxString_C = "Linux";
    public static final String driverName_C = "SAP DB";
    public static final String sapdbEncodingC = "ISO8859_1";
    public static final int JAVA_1_1 = 1001999;
    public static final int JAVA_1_2 = 1002999;
    public static final int JAVA_1_3 = 1003999;
    public static final int currentVMVersion;
    public static final String userName_C = "user";
    public static final String passwordName_C = "password";
    public static final String urlName_C = "url";
    public static final String sqlmodeName_C = "sqlmode";
    public static final String cachelimitName_C = "cachelimit";
    public static final String timeoutName_C = "timeout";
    public static final String isolationName_C = "isolation";
    public static final String autocommitName_C = "autocommit";
    public static final String traceName_C = "trace";
    public static final String traceSize_C = "tracesize";
    public static final String transportName_C = "transport";
    public static final String cacheName_C = "cache";
    public static final String cacheSizeName_C = "cachesize";
    public static final String unicodeName_C = "unicode";
    public static final String reconnect_C = "reconnect";
    public static final String spaceoption_C = "spaceoption";
    public static final String application_C = "application";
    public static final String appversion_C = "appversion";
    public static final String communicationtimeout_C = "communicationtimeout";
    public static final String paketSpyClass_C = "packetspyclass";
    public static final String dburlName_C = "dburl";
    public static final String dbName_C = "dbname";
    public static final String sqlmodeOracle_C = "oracle";
    public static final boolean catchAllNotImplemented_C = false;
    private static final String[] trueStrings;

    static {
        isJDBC20 = DriverSapDB.detectJDBC20();
        DriverSapDB.loadDriver();
        currentVMVersion = DriverSapDB.getVMVersion();
        trueStrings = new String[]{"true", "yes", "on"};
    }

    public static int getVMVersion() {
        try {
            String vers = System.getProperty("java.version");
            int startpos = vers.indexOf(49);
            int verslen = vers.length();
            if (startpos == -1) {
                return 1003999;
            }
            int endpos = vers.indexOf(46, startpos);
            if (endpos == -1) {
                return 1003999;
            }
            int major = Integer.parseInt(vers.substring(startpos, endpos));
            startpos = endpos + 1;
            if ((endpos = vers.indexOf(46, startpos)) == -1) {
                return 1003999;
            }
            int minor = Integer.parseInt(vers.substring(startpos, endpos));
            return major * 1000000 + minor * 1000;
        }
        catch (NumberFormatException numberFormatEx) {
            return 1003999;
        }
        catch (AccessControlException ex) {
            return 1002999;
        }
    }

    public boolean acceptsURL(String url) throws SQLException {
        boolean result = url.startsWith(protocolName_C);
        return result;
    }

    public static final String buildURL(String host, String dbname) {
        return "jdbc:sapdb://" + host + "/" + dbname;
    }

    public static final Connection connect(String user, String pwd, String host, String dbname, String properties) throws SQLException {
        String url = DriverSapDB.buildURL(host, dbname);
        if (properties != null && properties.length() > 0) {
            url = String.valueOf(url) + "?" + properties;
        }
        Properties info = new Properties();
        info.put(userName_C, user);
        info.put(passwordName_C, pwd);
        return DriverSapDB.singleton().connect(url, info);
    }

    public Connection connect(String url, Properties info) throws SQLException {
        return null;
    }

    private final boolean openTrace(String url, Properties info) {
        long maxTraceSize;
        boolean result = false;
        String trace = info.getProperty(traceName_C);
        if (trace == null) {
            try {
                trace = System.getProperty("sapdbctrace");
            }
            catch (AccessControlException accessControlException) {
                // empty catch block
            }
        }
        try {
            maxTraceSize = Long.parseLong(info.getProperty(traceSize_C));
        }
        catch (NumberFormatException ex) {
            maxTraceSize = Long.MAX_VALUE;
        }
        if (trace != null) {
            result = true;
            try {
                Tracer.forceNewLog((String)trace, (boolean)true, (long)maxTraceSize);
            }
            catch (IOException ex) {
                // empty catch block
            }
            Tracer.println((String)"==================================");
            String java_version = "<unknown>";
            try {
                java_version = System.getProperty("java.version", "<unknown>");
            }
            catch (AccessControlException accessControlException) {
                // empty catch block
            }
            Tracer.println((String)(String.valueOf(this.getVersionString()) + " on Java " + java_version));
            Tracer.print((String)("new Connection '" + url + "'"), (Properties)info);
        }
        if ((trace = info.getProperty("extendedTrace")) != null) {
            TimeoutException.addExtendedTrace((String)trace);
        }
        return result;
    }

    public static final boolean getBooleanProperty(Properties properties, String name, boolean defaultValue) {
        boolean result = defaultValue;
        String value = properties.getProperty(name);
        if (value != null) {
            result = false;
            int i = 0;
            while (i < trueStrings.length) {
                if (value.equalsIgnoreCase(trueStrings[i])) {
                    result = true;
                    break;
                }
                ++i;
            }
        }
        return result;
    }

    public static final int getIntProperty(Properties properties, String name, int defaultValue) {
        int result = defaultValue;
        String value = properties.getProperty(name);
        if (value != null) {
            try {
                result = Integer.parseInt(value);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return result;
    }

    public final int getMajorVersion() {
        return jdbcDriverVersion.getMajorVersion();
    }

    public final int getMinorVersion() {
        return jdbcDriverVersion.getMinorVersion();
    }

    final String getName() {
        return driverName_C;
    }

    public final DriverPropertyInfo[] getPropertyInfo(String url, Properties info) throws SQLException {
        DriverPropertyInfo userItem = null;
        DriverPropertyInfo passwordItem = null;
        int count = 0;
        int i = 0;
        if (info.getProperty(userName_C) == null) {
            userItem = new DriverPropertyInfo(userName_C, null);
            userItem.required = true;
            ++count;
        }
        if (info.getProperty(passwordName_C) == null) {
            passwordItem = new DriverPropertyInfo(passwordName_C, null);
            passwordItem.required = true;
            ++count;
        }
        DriverPropertyInfo[] result = new DriverPropertyInfo[count];
        if (userItem != null) {
            result[i] = userItem;
            ++i;
        }
        if (passwordItem != null) {
            result[i] = passwordItem;
            ++i;
        }
        return result;
    }

    public static final String getProtocol() {
        return protocolName_C;
    }

    final String getVersionString() {
        return DriverSapDB.getStaticVersion();
    }

    public static String getStaticVersion() {
        return jdbcDriverVersion.toString();
    }

    public final boolean jdbcCompliant() {
        return true;
    }

    public static void load() {
    }

    public static void main(String[] args) {
        if (args.length > 0) {
            if (args[0].equals("-V") || args[0].equals("--version")) {
                System.out.println(DriverSapDB.getStaticVersion());
            } else {
                Properties info = new Properties();
                boolean hasUser = false;
                boolean hasDb = false;
                info.put("host", "");
                info.put("options", "");
                info.put("cmd", "Select 'successfully connected' as \"connect test\" from dual");
                int i = 0;
                while (i < args.length) {
                    String currentArg = args[i];
                    if (currentArg.charAt(0) != '-') break;
                    char currentOpt = currentArg.charAt(1);
                    switch (currentOpt) {
                        case 'u': {
                            currentArg = args[++i];
                            int pos = currentArg.indexOf(44);
                            info.put(userName_C, currentArg.substring(0, pos));
                            info.put(passwordName_C, currentArg.substring(pos + 1));
                            hasUser = true;
                            break;
                        }
                        case 'd': {
                            info.put(dbName_C, args[++i]);
                            hasDb = true;
                            break;
                        }
                        case 'n': {
                            info.put("host", args[++i]);
                            break;
                        }
                        case 'o': {
                            info.put("options", "?" + args[++i]);
                            break;
                        }
                        case 'c': {
                            info.put("cmd", args[++i]);
                            break;
                        }
                        default: {
                            System.err.println("invalid option " + currentOpt);
                        }
                    }
                    ++i;
                }
                if (hasDb && hasUser) {
                    try {
                        Connection connection = new DriverSapDB().connect(String.valueOf(DriverSapDB.buildURL((String)info.get("host"), (String)info.get(dbName_C))) + info.get("options"), info);
                        Statement stmt = connection.createStatement();
                        if (stmt.execute((String)info.get("cmd"))) {
                            ResultSet rs = stmt.getResultSet();
                            if (!rs.next()) {
                                System.out.println("row not found");
                            } else {
                                int j;
                                int len;
                                String val;
                                ResultSetMetaData rsmd = rs.getMetaData();
                                StringBuffer res = new StringBuffer(50);
                                res.append("| ");
                                int i2 = 1;
                                while (i2 <= rsmd.getColumnCount()) {
                                    val = rsmd.getColumnName(i2);
                                    len = rsmd.getPrecision(i2);
                                    if (val.length() > len) {
                                        res.append(val.substring(0, len));
                                    } else {
                                        res.append(val);
                                        j = 0;
                                        while (j < len - val.length()) {
                                            res.append(" ");
                                            ++j;
                                        }
                                    }
                                    res.append(" | ");
                                    ++i2;
                                }
                                System.out.println(res.toString());
                                int j2 = 1;
                                while (j2 < res.length()) {
                                    System.out.print("-");
                                    ++j2;
                                }
                                System.out.println("");
                                do {
                                    res = new StringBuffer(res.capacity());
                                    res.append("| ");
                                    i2 = 1;
                                    while (i2 <= rsmd.getColumnCount()) {
                                        val = rs.getString(i2);
                                        len = rsmd.getPrecision(i2);
                                        if (val.length() > len) {
                                            res.append(val.substring(0, len));
                                        } else {
                                            res.append(val);
                                            j = 0;
                                            while (j < len - val.length()) {
                                                res.append(" ");
                                                ++j;
                                            }
                                        }
                                        res.append(" | ");
                                        ++i2;
                                    }
                                    System.out.println(res.toString());
                                } while (rs.next());
                            }
                        } else {
                            System.out.println(String.valueOf(stmt.getUpdateCount()) + " row(s) affected");
                        }
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
            }
        }
    }

    public static String mapIsolation(String isolationProperty) throws JDBCDriverException {
        String result;
        int isolevel;
        block14: {
            isolevel = -1;
            try {
                isolevel = Integer.parseInt(isolationProperty);
            }
            catch (NumberFormatException exc1) {
                String sapdbtechPrefix = "ADABAS";
                String jdbcPrefix = "TRANSACTION_";
                if (isolationProperty.startsWith("ADABAS")) {
                    try {
                        isolevel = Integer.parseInt(isolationProperty.substring("ADABAS".length()));
                    }
                    catch (NumberFormatException exc2) {}
                }
                if (!isolationProperty.startsWith("TRANSACTION_")) break block14;
                String rest = isolationProperty.substring("TRANSACTION_".length());
                if (rest.equals("READ_UNCOMMITTED")) {
                    isolevel = 1;
                }
                if (rest.equals("READ_COMMITTED")) {
                    isolevel = 2;
                }
                if (rest.equals("REPEATABLE_READ")) {
                    isolevel = 4;
                }
                if (!rest.equals("SERIALIZABLE")) break block14;
                isolevel = 8;
            }
        }
        switch (isolevel) {
            case 1: {
                result = "0";
                break;
            }
            case 2: {
                result = "1";
                break;
            }
            case 4: {
                result = "2";
                break;
            }
            case 8: {
                result = "3";
                break;
            }
            default: {
                throw new JDBCDriverException(MessageTranslator.translate((String)"error.invalid.transactionisolation", (Object)isolationProperty));
            }
        }
        return result;
    }

    public static int isolevelString2Jdbc(String isolationProperty) {
        int isolevel;
        block8: {
            isolevel = -1;
            try {
                isolevel = Integer.parseInt(isolationProperty);
            }
            catch (NumberFormatException exc1) {
                String sapdbtechPrefix = "ADABAS";
                String jdbcPrefix = "TRANSACTION_";
                if (isolationProperty.startsWith("ADABAS")) {
                    try {
                        isolevel = Integer.parseInt(isolationProperty.substring("ADABAS".length()));
                    }
                    catch (NumberFormatException exc2) {}
                }
                if (!isolationProperty.startsWith("TRANSACTION_")) break block8;
                String rest = isolationProperty.substring("TRANSACTION_".length());
                if (rest.equals("READ_UNCOMMITTED")) {
                    isolevel = 1;
                }
                if (rest.equals("READ_COMMITTED")) {
                    isolevel = 2;
                }
                if (rest.equals("REPEATABLE_READ")) {
                    isolevel = 4;
                }
                if (!rest.equals("SERIALIZABLE")) break block8;
                isolevel = 8;
            }
        }
        return isolevel;
    }

    public static String isolevelJdbc2native(int isolevel) throws SQLException {
        String result;
        switch (isolevel) {
            case 0: 
            case 1: {
                result = "0";
                break;
            }
            case 2: {
                result = "1";
                break;
            }
            case 4: {
                result = "2";
                break;
            }
            case 8: {
                result = "3";
                break;
            }
            default: {
                throw new JDBCDriverException(MessageTranslator.translate((String)"error.invalid.transactionisolation", (Object)Integer.toString(isolevel)));
            }
        }
        return result;
    }

    private final JdbcCommunication openByURL(String url, Properties info) throws RTEException, SQLException {
        String dbname;
        String host;
        int slashPos;
        int urlLength = url.length();
        if (urlLength >= (slashPos = protocolName_C.length()) + 3 && url.substring(slashPos, slashPos + 2).equals("//")) {
            int closingSlashPos = url.indexOf(47, slashPos + 2);
            host = url.substring(slashPos + 2, closingSlashPos);
            dbname = url.substring(closingSlashPos + 1, urlLength);
        } else {
            host = "";
            dbname = url.substring(slashPos, urlLength).trim();
        }
        dbname = dbname.toUpperCase();
        String dburl = DriverSapDB.buildURL(host, dbname);
        info.put(dburlName_C, dburl);
        info.put(dbName_C, dbname);
        return this.openConnection(host, dbname, info);
    }

    private final String parseURLProperties(String url, Properties info) {
        int questionPos = url.indexOf(63);
        if (questionPos >= 0) {
            this.parsePropertiesString(url.substring(questionPos + 1), info);
            url = url.substring(0, questionPos);
        }
        return url;
    }

    public final JdbcCommunication openConnection(String host, String dbname, Properties info) throws RTEException {
        JdbcCommunication result;
        JdbcCommFactory factory;
        String transport = info.getProperty(transportName_C, null);
        if (transport == null) {
            factory = commFactory;
        } else if (transport.equals("socket")) {
            factory = SocketComm.factory;
        } else if (transport.equals("native")) {
            factory = NativeComm.factory;
        } else if (transport.equals("secure")) {
            factory = SecureCommunication.factory;
        } else {
            throw new RTEException(MessageTranslator.translate((String)"error.invalid.transport", (Object)transport), -10899);
        }
        try {
            result = factory.open(host, dbname, info);
        }
        catch (UnsatisfiedLinkError linkErr) {
            throw new RTEException(MessageTranslator.translate((String)"error.library.notloaded", (Object)dllName_C), -10899);
        }
        return result;
    }

    public static boolean parseBooleanProperty(String property) {
        boolean result = false;
        if (property.equalsIgnoreCase("true")) {
            result = true;
        }
        return result;
    }

    private void parsePropertiesString(String urlArgs, Properties info) {
        String[] args = StringUtil.split((String)urlArgs, (String)"&");
        int i = 0;
        while (i < args.length) {
            String arg = args[i];
            int assignPos = arg.indexOf(61);
            if (assignPos > 0) {
                info.put(arg.substring(0, assignPos), arg.substring(assignPos + 1));
            }
            ++i;
        }
    }

    public static DriverSapDB singleton() {
        return driver;
    }

    private static void switchTraces(String verbosity, String filename) {
        if (verbosity != null) {
            try {
                Tracer.setVerbosity((int)Integer.parseInt(verbosity));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (filename != null) {
            try {
                Tracer.openLog((String)filename);
            }
            catch (IOException exc) {
                System.err.println("SAP DBTech JDBC: Cannot open log " + filename);
            }
        }
    }

    private static void switchTracesByProperties(Properties info) {
        DriverSapDB.switchTraces(info.getProperty("traceVerbosity"), info.getProperty("traceFile"));
    }

    private static void loadDriver() {
        jdbcDriverVersion = new VersionInfo("com.sap.dbtech.jdbc", "package com.sap.dbtech.jdbc, SAP DB JDBC Driver, SAP AG, ");
        commFactory = SocketComm.factory;
        try {
            String osName = null;
            String loadbin = null;
            try {
                osName = System.getProperty(osNameProperty_C);
                loadbin = System.getProperty(loadbinProperty_C);
            }
            catch (AccessControlException accessControlException) {
                // empty catch block
            }
            if (osName != null && osName.equalsIgnoreCase(osLinuxString_C)) {
                commFactory = SocketComm.factory;
            }
            if (loadbin != null && loadbin.equals("no")) {
                commFactory = SocketComm.factory;
            } else {
                try {
                    System.loadLibrary(dllName_C);
                    commFactory = NativeComm.factory;
                }
                catch (Error e) {}
            }
        }
        catch (AccessControlException accessControlException) {
            // empty catch block
        }
        try {
            DriverManager.registerDriver(driver);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    private static boolean detectJDBC20() {
        boolean result;
        try {
            Class.forName("java.sql.Clob");
            result = true;
        }
        catch (ClassNotFoundException exc) {
            result = false;
        }
        return result;
    }
}

