/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sapdb.packettest.core;

import com.sap.dbtech.jdbc.DbsCache;
import com.sap.dbtech.jdbc.ParseinfoCache;
import com.sap.dbtech.jdbc.exceptions.SQLExceptionSapDB;
import com.sap.dbtech.jdbc.packet.RequestPacket;
import com.sap.dbtech.jdbc.packet.RequestPacketUnicode;
import com.sap.dbtech.rte.comm.JdbcCommunication;
import com.sap.dbtech.util.GarbageCursor;
import com.sap.dbtech.util.GarbageParseid;
import com.sap.dbtech.util.MessageTranslator;
import com.sap.dbtech.util.StructuredBytes;
import com.sap.dbtech.util.StructuredMem;
import com.sap.dbtech.util.Traceable;
import com.sap.dbtech.util.Tracer;
import com.sap.dbtech.util.UniqueID;
import com.sap.sapdb.packettest.PacketTest;
import com.sap.sapdb.packettest.jdbc.DriverSapDB;
import com.sap.sapdb.packettest.jdbc.NameHandling;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.util.ArrayList;
import java.util.Map;
import java.util.Properties;
import java.util.Stack;

public class DBConnectPacket {
    public static final int GC_ALLOWED = 1;
    public static final int GC_DELAYED = 2;
    public static final int GC_NONE = 3;
    JdbcCommunication session;
    boolean autocommit = true;
    private boolean inTransaction = false;
    Stack packetPool = new Stack();
    private boolean isUnicode = false;
    private SQLWarning warningList;
    private Properties connectProperties;
    private UniqueID UniqueID = new UniqueID();
    private Map typeMap;
    private Object executingObject = null;
    private boolean inReconnect = false;
    private GarbageParseid garbageParseids = null;
    private GarbageCursor garbageCursors = null;
    ArrayList statementContainer = null;
    private boolean keepGarbage = false;
    private int isolationLevel = 2;
    ParseinfoCache parseCache = null;
    DbsCache dbsCache = null;
    int sessionID = -1;
    boolean isSQLModeOracle = false;
    boolean isSpaceoptionSet = false;
    private DatabaseMetaData DatabaseMetaData = null;
    private String cursorPrefix = "JDBC_CURSOR_";
    private static final String syncObj = "";
    private int nonRecyclingExecutions = 0;
    private String applID = null;
    private int kernelversion;
    private static byte[] defaultFeatureSet;
    private byte[] kernelFeatures = new byte[defaultFeatureSet.length];
    private PacketTest packetTest;

    static {
        byte[] byArray = new byte[10];
        byArray[0] = 1;
        byArray[2] = 2;
        byArray[4] = 3;
        byArray[6] = 4;
        byArray[8] = 5;
        defaultFeatureSet = byArray;
    }

    public DBConnectPacket(PacketTest packetTest) {
        this.packetTest = packetTest;
    }

    public StructuredMem createDBConnect(Properties info) throws SQLException {
        byte[] crypted;
        String passwd;
        this.connectProperties = info;
        String user = info.getProperty("user");
        if (user == null) {
            throw new SQLExceptionSapDB(MessageTranslator.translate((String)"error.nouser"));
        }
        char firstChar = user.charAt(0);
        char lastChar = user.charAt(user.length() - 1);
        if (firstChar != '\"' || lastChar != '\"') {
            user = user.toUpperCase();
            info.put("user", user);
        }
        if ((passwd = info.getProperty("password")) == null) {
            throw new SQLExceptionSapDB(MessageTranslator.translate((String)"error.nopassword"));
        }
        String sqlMode = info.getProperty("sqlmode", "INTERNAL");
        String cacheLimit = info.getProperty("cachelimit");
        String timeout = info.getProperty("timeout");
        String isolationLevel = info.getProperty("isolation");
        String termid = "              java";
        RequestPacket requestPacket = this.connectionSapDBgetRequestPacket();
        String connectCmd = "Connect " + user + " identified by :PW " + "SQLMODE " + sqlMode;
        if (timeout != null) {
            connectCmd = String.valueOf(connectCmd) + " TIMEOUT " + timeout;
        }
        if (isolationLevel != null) {
            this.isolationLevel = DriverSapDB.isolevelString2Jdbc(isolationLevel);
            connectCmd = String.valueOf(connectCmd) + " ISOLATION LEVEL " + DriverSapDB.isolevelJdbc2native(this.isolationLevel);
        }
        if (cacheLimit != null) {
            connectCmd = String.valueOf(connectCmd) + " CACHELIMIT " + cacheLimit;
        }
        if (this.isSpaceoptionSet) {
            connectCmd = String.valueOf(connectCmd) + " SPACE OPTION ";
            this.setKernelFeatureRequest(2);
        }
        requestPacket.initDbsCommand(false, connectCmd, 1003);
        requestPacket.newPart(5);
        try {
            crypted = NameHandling.mangle(passwd, this.isUnicode);
        }
        catch (ArrayIndexOutOfBoundsException exc) {
            throw new SQLExceptionSapDB(MessageTranslator.translate((String)"error.invalidpassword"));
        }
        requestPacket.addDataBytes(crypted);
        requestPacket.addDataString(termid);
        requestPacket.incrPartArguments();
        System.arraycopy(defaultFeatureSet, 0, this.kernelFeatures, 0, defaultFeatureSet.length);
        this.setKernelFeatureRequest(1);
        requestPacket.addFeatureRequestPart(this.kernelFeatures);
        RequestPacket requestPacket2 = this.execute(requestPacket, this, 2);
        StructuredBytes sb = new StructuredBytes(requestPacket2.length());
        sb.putBytes(requestPacket2.getBytes(0, requestPacket2.length()), 0, requestPacket2.length());
        return sb;
    }

    public RequestPacket execute(RequestPacket requestPacket, Object executingObject, int gcFlags) throws SQLException {
        return this.execute(requestPacket, false, false, executingObject, gcFlags);
    }

    public synchronized RequestPacket execute(RequestPacket requestPacket, boolean ignoreErrors, boolean isParse, Object executingObject, int gcFlags) throws SQLException {
        Object replyPacket = null;
        boolean localWeakReturnCode = false;
        if (gcFlags == 1) {
            boolean spaceleft = true;
            if (this.garbageCursors != null && this.garbageCursors.isPending()) {
                spaceleft = this.garbageCursors.emptyCan(requestPacket);
            }
            if (spaceleft && this.garbageParseids != null && this.garbageParseids.isPending()) {
                this.garbageParseids.emptyCan(requestPacket);
            }
        } else if (this.garbageParseids != null && this.garbageParseids.isPending()) {
            ++this.nonRecyclingExecutions;
        }
        requestPacket.closePacket();
        int requestLen = requestPacket.length();
        if (Tracer.isOn((int)5)) {
            Tracer.traceObject(null, (Traceable)requestPacket, (int)6);
        }
        return requestPacket;
    }

    public final synchronized RequestPacket connectionSapDBgetRequestPacket() throws SQLException {
        String applID = this.connectProperties.getProperty("application", null);
        String applVers = this.connectProperties.getProperty("appversion", null);
        Object result = this.isUnicode ? new RequestPacketUnicode(this.packetTest.getRequestPacket(), applID, applVers) : new RequestPacket(this.packetTest.getRequestPacket(), 0, applID, applVers);
        result.setAvailability(true);
        return result;
    }

    private void setKernelFeatureRequest(int feature) {
        this.kernelFeatures[2 * (feature - 1) + 1] = 1;
    }

    public void freeRequestPacket(RequestPacket requestPacket) {
        requestPacket.setAvailability(false);
        this.packetPool.push(requestPacket);
    }
}

