/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sapdb.packettest;

import com.sap.dbtech.rte.comm.RTEException;
import com.sap.dbtech.util.StructuredBytes;
import com.sap.sapdb.packettest.PacketTest;
import com.sap.sapdb.packettest.core.PacketAnalyzer;
import com.sap.sapdb.packettest.core.PacketTestException;
import com.sap.sapdb.testframe.driver.TestDatabaseException;
import java.io.IOException;
import java.sql.SQLException;

public class PacketTestPart
extends PacketTest {
    private String testcase;
    private String changedBytes;
    public static int testsPerField = 50;
    private static final int INFOREQUEST = 0;
    private static final int RELEASE1 = 1;
    private static final int DBCONNECT = 2;
    private static final int SQLCONNECT = 3;
    private static final int SELECT1 = 4;
    private static final int SELECT2 = 5;
    private static final int RELEASE2 = 6;
    private static final int[] TESTSET1 = new int[]{3};
    private static final int[] TESTSET2 = new int[]{4, 5};
    private static final int[][] TESTSETS = new int[][]{TESTSET1, TESTSET2};

    public void run() {
        try {
            System.out.println("partKind");
            this.testPartKind();
            System.out.println("PartAttribute");
            this.testPartAttribute();
            System.out.println("ArgumentCount");
            this.testArgumentCount();
            System.out.println("SegmentOffset");
            this.testSegmentOffset();
            System.out.println("BufLen");
            this.testBufLen();
            System.out.println("BufSize");
            this.testBufSize();
        }
        catch (TestDatabaseException tdex) {
            tdex.printStackTrace();
            this.addMessage("run()", 'E', "TestDatabaseException: " + tdex.getMessage());
        }
    }

    public void execute(int offset, int len, int value, int[] packetsToTest) throws TestDatabaseException, PacketTestException {
        StructuredBytes requestPacket = null;
        int packetnumber = 0;
        try {
            if (!this.DATABASE.isWarm()) {
                if (PacketTest.DEBUG) {
                    System.out.println("Starting Database");
                }
                try {
                    Thread.sleep(2000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                this.DATABASE.start();
            }
            Object[] parameters = new Object[2];
            this.connect();
            packetnumber = 0;
            requestPacket = this.createInfoRequestPacket();
            parameters[0] = requestPacket;
            parameters[1] = new Integer(packetnumber);
            if (this.inArray(packetsToTest, packetnumber)) {
                this.testMethod(requestPacket, packetnumber, len, offset, value);
            }
            this.out.write(requestPacket.bytes());
            StructuredBytes replyPacket = this.receiveConnect();
            this.packetLayout = PacketTest.getPacketLayoutFromReply(replyPacket, true);
            packetnumber = 1;
            requestPacket = this.createReleasePacket();
            parameters[0] = requestPacket;
            parameters[1] = new Integer(packetnumber);
            if (this.inArray(packetsToTest, packetnumber)) {
                this.testMethod(requestPacket, packetnumber, len, offset, value);
            }
            this.out.write(requestPacket.bytes());
            this.sock.close();
            this.connect();
            packetnumber = 2;
            requestPacket = this.createDbConnectPacket(this.DBNAME);
            parameters[0] = requestPacket;
            parameters[1] = new Integer(packetnumber);
            if (this.inArray(packetsToTest, packetnumber)) {
                this.testMethod(requestPacket, packetnumber, len, offset, value);
            }
            this.out.write(requestPacket.bytes());
            replyPacket = this.receiveConnect();
            packetnumber = 3;
            requestPacket = this.createSqlConnectPacket("dba", "dba");
            parameters[0] = requestPacket;
            parameters[1] = new Integer(packetnumber);
            if (this.inArray(packetsToTest, packetnumber)) {
                this.testMethod(requestPacket, packetnumber, len, offset, value);
            }
            this.out.write(requestPacket.bytes());
            replyPacket = this.receiveData();
            packetnumber = 4;
            requestPacket = this.createSqlStatementPacket("Select 'bla' from dual");
            parameters[0] = requestPacket;
            parameters[1] = new Integer(packetnumber);
            if (this.inArray(packetsToTest, packetnumber)) {
                this.testMethod(requestPacket, packetnumber, len, offset, value);
            }
            this.out.write(requestPacket.bytes());
            replyPacket = this.receiveData();
            packetnumber = 5;
            StructuredBytes[] parts = new StructuredBytes[2];
            StructuredBytes[] segments = new StructuredBytes[1];
            byte[] b = "Select 'bla' from dual".getBytes();
            parts[0] = this.createPart(3, 0, 1, b.length, b);
            b = "JDBC_CURSOR_2".getBytes();
            parts[1] = this.createPart(13, 0, 1, b.length, b);
            segments[0] = this.createRequestSegment(parts);
            StructuredBytes message = this.createMessage(0, 1, segments);
            StructuredBytes packet = this.createPacket(63, message);
            parameters[0] = requestPacket;
            parameters[1] = new Integer(packetnumber);
            if (this.inArray(packetsToTest, packetnumber)) {
                this.testMethod(requestPacket, packetnumber, len, offset, value);
            }
            this.out.write(packet.bytes());
            replyPacket = this.receiveData();
            packetnumber = 6;
            requestPacket = this.createReleasePacket();
            parameters[0] = requestPacket;
            parameters[1] = new Integer(packetnumber);
            if (this.inArray(packetsToTest, packetnumber)) {
                this.testMethod(requestPacket, packetnumber, len, offset, value);
            }
            this.out.write(requestPacket.bytes());
            this.sock.close();
        }
        catch (PacketTestException ptex) {
            this.handleError(ptex, packetnumber, offset, len, value, requestPacket);
        }
        catch (RTEException rteex) {
            this.handleError((Exception)((Object)rteex), packetnumber, offset, len, value, requestPacket);
        }
        catch (IOException ioex) {
            this.handleError(ioex, packetnumber, offset, len, value, requestPacket);
        }
        catch (SQLException sqlex) {
            this.handleError(sqlex, packetnumber, offset, len, value, requestPacket);
        }
    }

    private void testPartKind() throws TestDatabaseException {
        this.testcase = "Part Kind";
        int len = 1;
        int off = 0;
        int inc = 256 / testsPerField;
        int i = 0;
        while (i < TESTSETS.length) {
            block5: {
                int value = -1;
                try {
                    value = 0;
                    while (value <= 38) {
                        this.execute(off, len, value, TESTSETS[i]);
                        ++value;
                    }
                    value = 39;
                    while (value < 256) {
                        this.execute(off, len, value, TESTSETS[i]);
                        value += inc;
                    }
                }
                catch (PacketTestException ex) {
                    if (ex.getErrorcode() != -3) break block5;
                    this.addMessage(String.valueOf(this.testcase) + "-" + i + "-" + value, 'I', "Abborting test because of a db crash.");
                }
            }
            ++i;
        }
    }

    private void testPartAttribute() throws TestDatabaseException {
        this.testcase = "Part Attribute";
        int len = 1;
        int off = 1;
        int inc = 256 / testsPerField;
        int i = 0;
        while (i < TESTSETS.length) {
            block5: {
                int value = -1;
                try {
                    value = 0;
                    while (value <= 10) {
                        this.execute(off, len, value, TESTSETS[i]);
                        ++value;
                    }
                    value = 11;
                    while (value < 256) {
                        this.execute(off, len, value, TESTSETS[i]);
                        value += inc;
                    }
                }
                catch (PacketTestException ex) {
                    if (ex.getErrorcode() != -3) break block5;
                    this.addMessage(String.valueOf(this.testcase) + "-" + i + "-" + value, 'I', "Abborting test because of a db crash.");
                }
            }
            ++i;
        }
    }

    private void testArgumentCount() throws TestDatabaseException {
        this.testcase = "Argument Count";
        int len = 2;
        int off = 2;
        int inc = (int)(Math.pow(256.0, len) / (double)testsPerField);
        int i = 0;
        while (i < TESTSETS.length) {
            block5: {
                int value = -1;
                try {
                    value = 0;
                    while (value <= 5) {
                        this.execute(off, len, value, TESTSETS[i]);
                        ++value;
                    }
                    value = 6;
                    while (value < 256) {
                        this.execute(off, len, value, TESTSETS[i]);
                        value += inc;
                    }
                }
                catch (PacketTestException ex) {
                    if (ex.getErrorcode() != -3) break block5;
                    this.addMessage(String.valueOf(this.testcase) + "-" + i + "-" + value, 'I', "Abborting test because of a db crash.");
                }
            }
            ++i;
        }
    }

    private void testSegmentOffset() throws TestDatabaseException {
        this.testcase = "Segment Offset";
        int len = 4;
        int off = 4;
        int size = (int)Math.pow(256.0, len);
        int inc = size / testsPerField;
        int i = 0;
        while (i < TESTSETS.length) {
            block4: {
                int value = -1;
                try {
                    value = 0;
                    while (value < size && value >= 0) {
                        this.execute(off, len, value, TESTSETS[i]);
                        value += inc;
                    }
                }
                catch (PacketTestException ex) {
                    if (ex.getErrorcode() != -3) break block4;
                    this.addMessage(String.valueOf(this.testcase) + "-" + i + "-" + value, 'I', "Abborting test because of a db crash.");
                }
            }
            ++i;
        }
    }

    private void testBufLen() throws TestDatabaseException {
        this.testcase = "Buf Len";
        int len = 4;
        int off = 8;
        long size = (long)Math.pow(256.0, len);
        int inc = (int)(size / (long)testsPerField);
        int i = 0;
        while (i < TESTSETS.length) {
            block5: {
                int value = -1;
                try {
                    value = 0;
                    while ((long)value <= size && value >= 0) {
                        if (PacketTest.DEBUG) {
                            System.out.println(value);
                        }
                        this.execute(off, len, value, TESTSETS[i]);
                        value += inc;
                    }
                }
                catch (PacketTestException ex) {
                    if (ex.getErrorcode() != -3) break block5;
                    this.addMessage(String.valueOf(this.testcase) + "-" + i + "-" + value, 'I', "Abborting test because of a db crash.");
                }
            }
            ++i;
        }
    }

    private void testBufSize() throws TestDatabaseException {
        this.testcase = "Buf Size";
        int len = 4;
        int off = 12;
        long size = (long)Math.pow(256.0, len);
        int inc = (int)(size / (long)testsPerField);
        int i = 0;
        while (i < TESTSETS.length) {
            block4: {
                int value = -1;
                try {
                    value = 0;
                    while (value <= 5 && value >= 0) {
                        this.execute(off, len, value, TESTSETS[i]);
                        value += inc;
                    }
                }
                catch (PacketTestException ex) {
                    if (ex.getErrorcode() != -3) break block4;
                    this.addMessage(String.valueOf(this.testcase) + "-" + i + "-" + value, 'I', "Abborting test because of a db crash.");
                }
            }
            ++i;
        }
    }

    private void testMethod(StructuredBytes packet, int packetNumber, int len, int offset, int value) {
        this.changedBytes = "";
        switch (packetNumber) {
            case 3: {
                try {
                    int[] parts = PacketAnalyzer.getParts(packet, 0);
                    int i = 0;
                    while (i < parts.length) {
                        this.changedBytes = String.valueOf(this.changedBytes) + (parts[i] + offset) + ", ";
                        switch (len) {
                            case 1: {
                                packet.putInt1(value, parts[i] + offset);
                                break;
                            }
                            case 2: {
                                packet.putInt2(value, parts[i] + offset);
                                break;
                            }
                            case 4: {
                                packet.putInt4(value, parts[i] + offset);
                            }
                        }
                        ++i;
                    }
                }
                catch (PacketTestException ex) {
                    ex.printStackTrace();
                }
                break;
            }
            case 4: {
                try {
                    int[] parts = PacketAnalyzer.getParts(packet, 0);
                    int i = 0;
                    while (i < parts.length) {
                        this.changedBytes = String.valueOf(this.changedBytes) + (parts[i] + offset) + ", ";
                        switch (len) {
                            case 1: {
                                packet.putInt1(value, parts[i] + offset);
                                break;
                            }
                            case 2: {
                                packet.putInt2(value, parts[i] + offset);
                                break;
                            }
                            case 4: {
                                packet.putInt4(value, parts[i] + offset);
                            }
                        }
                        ++i;
                    }
                }
                catch (PacketTestException ex) {
                    ex.printStackTrace();
                }
                break;
            }
            case 5: {
                try {
                    int[] parts = PacketAnalyzer.getParts(packet, 0);
                    int i = 0;
                    while (i < parts.length) {
                        this.changedBytes = String.valueOf(this.changedBytes) + (parts[i] + offset) + ", ";
                        switch (len) {
                            case 1: {
                                packet.putInt1(value, parts[i] + offset);
                                break;
                            }
                            case 2: {
                                packet.putInt2(value, parts[i] + offset);
                                break;
                            }
                            case 4: {
                                packet.putInt4(value, parts[i] + offset);
                            }
                        }
                        ++i;
                    }
                }
                catch (PacketTestException ex) {
                    ex.printStackTrace();
                }
                break;
            }
        }
    }

    private void handleError(Exception ex, int packetnumber, int offset, int len, int value, StructuredBytes packet) throws TestDatabaseException, PacketTestException {
        boolean dbIsWarm = this.DATABASE.isWarm();
        if (this.changedBytes.length() > 2) {
            this.changedBytes = this.changedBytes.substring(0, this.changedBytes.length() - 2);
        }
        if (PacketTest.DEBUG) {
            String state = dbIsWarm ? "warm" : "not warm";
            String message = "Exception in test case '" + this.testcase + "'', database is " + state + "\n" + ex.getMessage() + "\n" + "Packet " + packetnumber + ":\n" + "Change " + len + " bytes at positions " + this.changedBytes + " to " + value + "\n" + new String(packet.bytes());
            System.err.println(message);
        }
        if (!dbIsWarm) {
            String message = "Exception in test case '" + this.testcase + "'', database IS DOWN\n" + ex.getMessage() + "\n" + "Packet " + packetnumber + ":\n" + "Change " + len + " bytes at positions " + this.changedBytes + " to " + value + "\n" + new String(packet.bytes());
            this.addMessage("DB shot down", 'E', message);
            throw new PacketTestException("Db crashed", -3);
        }
    }

    public boolean inArray(int[] array, int value) {
        int i = 0;
        while (i < array.length) {
            if (array[i] == value) {
                return true;
            }
            ++i;
        }
        return false;
    }
}

