/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sapdb.lctest;

import com.sap.sapdb.lctest.DataConsistencyException;
import com.sap.sapdb.lctest.LiveCacheMaster;
import com.sap.sapdb.lctest.SQLActor;
import com.sap.sapdb.lctest.SQLTableDescriptor;
import com.sap.sapdb.testframe.driver.TestDatabaseException;
import com.sap.sapdb.testframe.testcase.TestCase;
import com.sap.sapdb.testframe.testcase.TestStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

public class SQLWriter
extends SQLActor {
    private int mNumberOfTables = 0;
    private int mMaxTableEntries = 0;
    private int mSubtransactionPercentage = 0;
    private int mSubtransCommitPercentage = 0;
    private int mInsertPercentage = 0;
    private int mUpdatePercentage = 0;
    private int mDeletePercentage = 0;
    private boolean mTwoPhaseCommit = false;

    public SQLWriter() {
        this.mTitle = "Writer";
    }

    public void check() throws DataConsistencyException {
        int TableIndex = 0;
        Integer helpIndex = new Integer(this.mTitle.substring(9, 10));
        try {
            TableIndex = helpIndex;
            SQLTableDescriptor Table = this.mMaster.getTable(TableIndex);
            SQLTableDescriptor fallbackTable = this.mMaster.getFallbackTable(TableIndex);
            this.checkTable(TableIndex, Table, fallbackTable);
            LiveCacheMaster.printInfo(this.mTitle, " check of table " + TableIndex + " ok.");
        }
        catch (SQLException e) {
            throw new DataConsistencyException("Table not accessible: " + e.getMessage());
        }
    }

    boolean checkTable(int TableIndex, SQLTableDescriptor pTable, SQLTableDescriptor pFallbackTable) throws DataConsistencyException, SQLException {
        Object stm = null;
        int Checksum = 0;
        int NumberOfEntries = 0;
        if (pTable == null && pFallbackTable == null) {
            LiveCacheMaster.printTrace(this.mTitle + "NO consistency check performed, because either Table = NULL and FallbackTable = NULL or tableName = null");
            return true;
        }
        try {
            this.mConnection = TestCase.getDatabase().connect(TestCase.getUser(), TestCase.getPassword());
            this.mStatement = new TestStatement(null, this.mConnection);
        }
        catch (TestDatabaseException e) {
            System.out.println(e.getMessage());
        }
        if (pTable == null && pFallbackTable != null && !this.mTwoPhaseCommit) {
            LiveCacheMaster.printTrace(this.mTitle + ": Reading fallbacktable <" + TableIndex + ">, expecting checksum: " + pFallbackTable.getChecksum());
            try {
                ResultSet rs = this.mStatement.executeQuery("select * from " + pFallbackTable.getTableName());
                while (rs.next()) {
                    String s = rs.getString("k1");
                    int number = rs.getInt("k0");
                    String t = rs.getString("f0");
                    Checksum += number;
                    ++NumberOfEntries;
                }
                this.mMaster.addMessage(this.mTitle, 'W', "Using fallback table for data check.");
                LiveCacheMaster.printInfo(this.mTitle, ": " + pFallbackTable.getTableName() + ": Expected checkSum = " + pFallbackTable.getChecksum() + ", Expected # Records = " + pFallbackTable.getNumberOfEntries());
                LiveCacheMaster.printInfo(this.mTitle, ": " + pFallbackTable.getTableName() + ": Selected checksum = " + Checksum + ", selected # Records = " + NumberOfEntries);
            }
            catch (Exception ex) {
                LiveCacheMaster.printInfo(this.mTitle, "ERROR in Check during SELECT, table was probably dropped: " + ex.getMessage() + "\n If table is dropped, it is ok!");
                return true;
            }
            if (pFallbackTable.getChecksum() != Checksum || pFallbackTable.getNumberOfEntries() != NumberOfEntries) {
                LiveCacheMaster.printTrace(this.mTitle + ": ** ERROR ** Consistency error: Expecting from fallback table checksum: " + pFallbackTable.getChecksum() + ", # of entries: " + pTable.getNumberOfEntries() + ", but found checksum: " + Checksum + ", # of entries = " + NumberOfEntries);
                throw new DataConsistencyException("Expecting <" + pFallbackTable.getChecksum() + "," + pFallbackTable.getNumberOfEntries() + ">, but found <" + Checksum + "," + NumberOfEntries + ">");
            }
            this.mStatement.close();
            return true;
        }
        if (pTable != null && pFallbackTable != null && !this.mTwoPhaseCommit) {
            LiveCacheMaster.printTrace(this.mTitle + ": Reading table <" + TableIndex + ">, expecting checksum: " + pTable.getChecksum() + " or " + pFallbackTable.getChecksum());
            try {
                ResultSet rs = this.mStatement.executeQuery("select * from " + pTable.getTableName());
                while (rs.next()) {
                    String s = rs.getString("k1");
                    int number = rs.getInt("k0");
                    String t = rs.getString("f0");
                    Checksum += number;
                    ++NumberOfEntries;
                }
                LiveCacheMaster.printInfo(this.mTitle, ": " + pTable.getTableName() + ": Expected checkSum = " + pTable.getChecksum() + ", Expected # Records = " + pTable.getNumberOfEntries());
                LiveCacheMaster.printInfo(this.mTitle, ": " + pFallbackTable.getTableName() + "(Fallback): Expected checkSum = " + pFallbackTable.getChecksum() + ", Expected # Records = " + pFallbackTable.getNumberOfEntries());
                LiveCacheMaster.printInfo(this.mTitle, ": " + pTable.getTableName() + ": Selected checksum = " + Checksum + ", selected # Records = " + NumberOfEntries);
            }
            catch (Exception ex) {
                LiveCacheMaster.printInfo(this.mTitle, "ERROR in Check during SELECT, table was probably dropped: " + ex.getMessage());
            }
            if (!(pTable.getChecksum() == Checksum && pTable.getNumberOfEntries() == NumberOfEntries || pFallbackTable.getChecksum() == Checksum && pFallbackTable.getNumberOfEntries() == NumberOfEntries)) {
                LiveCacheMaster.printTrace(this.mTitle + ": ** ERROR ** Consistency error: \n Expecting checksum: " + pTable.getChecksum() + ", # of entries: " + pTable.getNumberOfEntries() + " or\n Expecting checksum (fallback): " + pFallbackTable.getChecksum() + ", # of entries: " + pFallbackTable.getNumberOfEntries() + " ,\n but found checksum: " + Checksum + ", # of entries = " + NumberOfEntries);
                throw new DataConsistencyException("Expecting <" + pTable.getChecksum() + "," + pTable.getNumberOfEntries() + "> or <" + pFallbackTable.getChecksum() + "," + pFallbackTable.getNumberOfEntries() + ">, but found <" + Checksum + "," + NumberOfEntries + ">");
            }
            if (pFallbackTable.getChecksum() != Checksum || pFallbackTable.getNumberOfEntries() != NumberOfEntries) {
                this.mMaster.addMessage(this.mTitle, 'W', "Using fallback table for data check.");
            }
            this.mStatement.close();
            return true;
        }
        if (pTable == null && this.mTwoPhaseCommit) {
            LiveCacheMaster.printTrace(this.mTitle + ": Reading table <" + TableIndex + ">; expecting nothing, because table should be dropped.");
            try {
                ResultSet rs = this.mStatement.executeQuery("select * from SQLTab " + TableIndex);
            }
            catch (Exception ex) {
                LiveCacheMaster.printInfo(this.mTitle, "Error in Check during SELECT; table was probably dropped: ok! No error!");
                this.mStatement.close();
                return true;
            }
            this.mStatement.close();
            throw new DataConsistencyException("Expecting no table for tableindex " + TableIndex + ", but found an table!");
        }
        if (pTable != null && this.mTwoPhaseCommit) {
            LiveCacheMaster.printTrace(this.mTitle + ": Reading table <" + TableIndex + ">, expecting checksum:" + pTable.getChecksum());
            try {
                ResultSet rs = this.mStatement.executeQuery("select * from " + pTable.getTableName());
                while (rs.next()) {
                    String s = rs.getString("k1");
                    int number = rs.getInt("k0");
                    String t = rs.getString("f0");
                    Checksum += number;
                    ++NumberOfEntries;
                }
                LiveCacheMaster.printInfo(this.mTitle, ": " + pTable.getTableName() + ": Expected checkSum = " + pTable.getChecksum() + ", Expected # Records = " + pTable.getNumberOfEntries());
                LiveCacheMaster.printInfo(this.mTitle, ": " + pTable.getTableName() + ": Selected checksum = " + Checksum + ", selected # Records = " + NumberOfEntries);
            }
            catch (Exception ex) {
                LiveCacheMaster.printInfo(this.mTitle, "ERROR in Check during SELECT, table was probably dropped: " + ex.getMessage());
            }
            if (pTable.getChecksum() != Checksum || pTable.getNumberOfEntries() != NumberOfEntries) {
                LiveCacheMaster.printTrace(this.mTitle + ": ** ERROR ** Consistency error: Expecting checksum: " + pTable.getChecksum() + ", # of entries: " + pTable.getNumberOfEntries() + ", but found checksum: " + Checksum + ", # of entries = " + NumberOfEntries);
                throw new DataConsistencyException("Expecting <" + pTable.getChecksum() + "," + pTable.getNumberOfEntries() + ">, but found <" + Checksum + "," + NumberOfEntries + ">");
            }
            this.mStatement.close();
            return true;
        }
        return true;
    }

    public int getActorType() {
        return 1;
    }

    protected int nextAction() {
        switch (this.mAction) {
            case 0: 
            case 2: 
            case 3: {
                if (SQLWriter.randomInteger(0, 100) <= this.mInsertPercentage) {
                    this.mAction = 4;
                    break;
                }
                this.mAction = 1;
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                this.mAction = 2;
                break;
            }
            case 1: {
                this.mAction = SQLWriter.randomInteger(0, this.mUpdatePercentage + this.mDeletePercentage) <= this.mUpdatePercentage ? 6 : 5;
            }
        }
        if (this.mAction == 2 && Math.random() > 0.5) {
            this.mAction = 3;
        }
        return this.mAction;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void run() {
        block44: {
            int CurrentCycle = 0;
            int TableIndex = -1;
            int CurrentLoop = 0;
            int checksum = 0;
            boolean KeepRunning = true;
            boolean ExpectingOutOfDate = false;
            boolean inException = false;
            SQLTableDescriptor mTable = null;
            SQLTableDescriptor OldTable = null;
            this.mRunning = true;
            Boolean TabSyncObject = new Boolean(true);
            Integer helpIndex = new Integer(this.mTitle.substring(9, 10));
            try {
                while (KeepRunning) {
                    TableIndex = helpIndex;
                    this.mAction = this.nextAction();
                    if (CurrentLoop % 1000 == 0) {
                        LiveCacheMaster.printInfo(this.mTitle, "Starting cycle " + CurrentLoop);
                    }
                    ++CurrentLoop;
                    switch (this.mAction) {
                        case 1: {
                            LiveCacheMaster.printTrace(this.mTitle + ": Current action is W_LOCK!");
                            mTable = this.mMaster.getTable(TableIndex);
                            if (mTable == null) {
                                LiveCacheMaster.printTrace(this.mTitle + ": Table <" + TableIndex + "> not existent yet");
                                this.mAction = 2;
                                break;
                            }
                            OldTable = (SQLTableDescriptor)mTable.clone();
                            TabSyncObject = this.mMaster.getTabSyncObject(TableIndex);
                            try {
                                LiveCacheMaster.printTrace(this.mTitle + ": Trying to lock table descriptor no <" + TableIndex + ">");
                                Boolean bl = TabSyncObject;
                                synchronized (bl) {
                                    if (this.mMaster.isTabLocked(TableIndex)) {
                                        LiveCacheMaster.printTrace(this.mTitle + ": ** ERROR ** Table <" + TableIndex + "> should be locked, but is accessible");
                                        this.setStatus(-1, "Table <" + TableIndex + "> should be locked, but is accessible");
                                        KeepRunning = false;
                                    } else {
                                        this.mMaster.setTabLocked(TableIndex, true);
                                    }
                                }
                                LiveCacheMaster.printTrace(this.mTitle + ": Lock end");
                            }
                            catch (Exception e) {
                                LiveCacheMaster.printTrace(this.mTitle + ": Table <" + TableIndex + "> cannot be locked - committing");
                                this.mConnection.commit();
                                LiveCacheMaster.printTrace(this.mTitle + ": ** ERROR **  General exception: " + e.getMessage());
                                this.setStatus(-3, "Exception: " + e.getMessage());
                                this.mAction = 2;
                            }
                            break;
                        }
                        case 4: {
                            LiveCacheMaster.printTrace(this.mTitle + ": Current action is W_CREATE!");
                            mTable = this.mMaster.createTable(TableIndex);
                            if (mTable == null) {
                                LiveCacheMaster.printTrace(this.mTitle + ": Table with ID <" + TableIndex + "> still exists and could not be created");
                                this.mAction = 2;
                                break;
                            }
                            OldTable = (SQLTableDescriptor)mTable.clone();
                            int howMany = SQLWriter.randomInteger(0, this.mMaxTableEntries - 1);
                            LiveCacheMaster.printTrace(this.mTitle + ": Creating new table <" + mTable.getTableName() + "> with <" + howMany + "> entries.");
                            checksum = this.createInitialTable(mTable.getTableName(), howMany);
                            mTable.setChecksum(checksum);
                            mTable.setNumberOfEntries(howMany);
                            mTable.setValid(true);
                            LiveCacheMaster.printTrace(this.mTitle + ": New Table <" + mTable.getTableName() + ">");
                            break;
                        }
                        case 5: {
                            LiveCacheMaster.printTrace(this.mTitle + ": Current action is W_DROP!");
                            if (this.mTraceOn) {
                                LiveCacheMaster.printTrace(this.mTitle + ": Dropping table <" + mTable.getTableName() + ">");
                            }
                            if (!mTable.isValid()) break;
                            this.dropTable(mTable.getTableName());
                            mTable.setTableName(null);
                            mTable.setValid(false);
                            break;
                        }
                        case 6: {
                            int NextChangeAction = SQLWriter.randomInteger(0, 100);
                            String whichAction = "";
                            int NoOfRecords = 0;
                            int currentEntries = 0;
                            int currentChecksum = 0;
                            currentEntries = mTable.getNumberOfEntries();
                            currentChecksum = mTable.getChecksum();
                            if (mTable.isValid()) {
                                LiveCacheMaster.printTrace(this.mTitle + ": Current action is W_CHANGE!");
                                if (NextChangeAction < 33) {
                                    whichAction = "INSERT";
                                    if (this.mMaxTableEntries > currentEntries) {
                                        NoOfRecords = SQLWriter.randomInteger(0, this.mMaxTableEntries - mTable.getNumberOfEntries() - 1);
                                        checksum = this.insertIntoTable(mTable.getTableName(), mTable.getChecksum(), mTable.getNumberOfEntries(), NoOfRecords);
                                        NoOfRecords += mTable.getNumberOfEntries();
                                    } else {
                                        LiveCacheMaster.printTrace(this.mTitle + ": No records inserted into " + mTable.getTableName() + " because max. allowed entries exist");
                                    }
                                } else if (NextChangeAction < 67) {
                                    whichAction = "UPDATE";
                                    NoOfRecords = SQLWriter.randomInteger(0, mTable.getNumberOfEntries() - 1);
                                    checksum = this.updateTable(mTable.getTableName(), mTable.getChecksum(), mTable.getNumberOfEntries(), NoOfRecords);
                                    NoOfRecords = mTable.getNumberOfEntries();
                                } else {
                                    whichAction = "DELETE";
                                    NoOfRecords = SQLWriter.randomInteger(0, mTable.getNumberOfEntries() - 1);
                                    checksum = this.deleteFromTable(mTable.getTableName(), mTable.getChecksum(), mTable.getNumberOfEntries(), NoOfRecords);
                                    NoOfRecords = mTable.getNumberOfEntries() - NoOfRecords;
                                }
                            }
                            mTable.setNumberOfEntries(NoOfRecords);
                            mTable.setChecksum(checksum);
                            break;
                        }
                        case 2: {
                            LiveCacheMaster.printTrace(this.mTitle + ": Current action is W_COMMIT!");
                            LiveCacheMaster.printTrace(this.mTitle + ": Committing table <" + mTable.getTableName() + ">");
                            Boolean bl = TabSyncObject;
                            synchronized (bl) {
                                LiveCacheMaster.printTrace(this.mTitle + ": REALLY PERFORMING COMMIT " + mTable.getTableName());
                                this.mConnection.commit();
                                this.mMaster.setTable(TableIndex, mTable);
                                this.mMaster.setTabInProgress(TableIndex, false);
                                mTable.setLocked(false);
                            }
                            LiveCacheMaster.printTrace(this.mTitle + ": Committing finished");
                            ++CurrentCycle;
                            break;
                        }
                        case 3: {
                            LiveCacheMaster.printTrace(this.mTitle + ": Current action is W_ROLLBACK!");
                            LiveCacheMaster.printTrace(this.mTitle + ": Rolling back table <" + TableIndex + ">");
                            Boolean bl = TabSyncObject;
                            synchronized (bl) {
                                this.mConnection.rollback();
                                this.mMaster.setTabLocked(TableIndex, false);
                                this.mMaster.setTabInProgress(TableIndex, false);
                            }
                            LiveCacheMaster.printTrace(this.mTitle + ": Rollback finished");
                            ++CurrentCycle;
                        }
                    }
                    SQLWriter.sleep(25L);
                    if (mCycleNumber != -1 && CurrentCycle > mCycleNumber) {
                        LiveCacheMaster.printTrace(this.mTitle + ": Finished <" + (CurrentCycle - 1) + "> cycles");
                        KeepRunning = false;
                        this.setStatus(1);
                    }
                    if (!this.mShouldStop) continue;
                    LiveCacheMaster.printTrace(this.mTitle + ": Soft interrupted");
                    KeepRunning = false;
                    this.setStatus(2);
                }
                Object var23_27 = null;
                super.cleanup();
                if (!inException || this.mTwoPhaseCommit || this.mAction != 2 || mTable == null || !mTable.isLocked() || TableIndex == -1) break block44;
                this.mMaster.mTables_Fallback[TableIndex] = mTable;
                this.mMaster.mTables_Fallback[TableIndex].setValid(true);
            }
            catch (Throwable throwable) {
                Object var23_31 = null;
                super.cleanup();
                if (inException && !this.mTwoPhaseCommit && this.mAction == 2 && mTable != null && mTable.isLocked() && TableIndex != -1) {
                    this.mMaster.mTables_Fallback[TableIndex] = mTable;
                    this.mMaster.mTables_Fallback[TableIndex].setValid(true);
                    LiveCacheMaster.printTrace(this.mTitle + ": Use fallback-table for table <" + TableIndex + "> with : " + mTable.getNumberOfEntries() + " entries and a checksum of:" + mTable.getChecksum());
                }
                throw throwable;
            }
            LiveCacheMaster.printTrace(this.mTitle + ": Use fallback-table for table <" + TableIndex + "> with : " + mTable.getNumberOfEntries() + " entries and a checksum of:" + mTable.getChecksum());
            {
                break block44;
                catch (SQLException e) {
                    LiveCacheMaster.printTrace(this.mTitle + ": ** ERROR ** Raising exception " + e.getMessage());
                    this.setStatus(-2, "SQLException: " + e.getMessage());
                    inException = true;
                    Object var23_28 = null;
                    super.cleanup();
                    if (inException && !this.mTwoPhaseCommit && this.mAction == 2 && mTable != null && mTable.isLocked() && TableIndex != -1) {
                        this.mMaster.mTables_Fallback[TableIndex] = mTable;
                        this.mMaster.mTables_Fallback[TableIndex].setValid(true);
                        LiveCacheMaster.printTrace(this.mTitle + ": Use fallback-table for table <" + TableIndex + "> with : " + mTable.getNumberOfEntries() + " entries and a checksum of:" + mTable.getChecksum());
                    }
                    break block44;
                }
                catch (InterruptedException e) {
                    LiveCacheMaster.printTrace(this.mTitle + ": Hard interrupted");
                    this.setStatus(2);
                    inException = true;
                    Object var23_29 = null;
                    super.cleanup();
                    if (inException && !this.mTwoPhaseCommit && this.mAction == 2 && mTable != null && mTable.isLocked() && TableIndex != -1) {
                        this.mMaster.mTables_Fallback[TableIndex] = mTable;
                        this.mMaster.mTables_Fallback[TableIndex].setValid(true);
                        LiveCacheMaster.printTrace(this.mTitle + ": Use fallback-table for table <" + TableIndex + "> with : " + mTable.getNumberOfEntries() + " entries and a checksum of:" + mTable.getChecksum());
                    }
                    break block44;
                }
                catch (Exception e) {
                    LiveCacheMaster.printTrace(this.mTitle + ": ** ERROR **  General exception: " + e.getMessage());
                    this.setStatus(-3, "Exception: " + e.getMessage());
                    inException = true;
                    Object var23_30 = null;
                    super.cleanup();
                    if (inException && !this.mTwoPhaseCommit && this.mAction == 2 && mTable != null && mTable.isLocked() && TableIndex != -1) {
                        this.mMaster.mTables_Fallback[TableIndex] = mTable;
                        this.mMaster.mTables_Fallback[TableIndex].setValid(true);
                        LiveCacheMaster.printTrace(this.mTitle + ": Use fallback-table for table <" + TableIndex + "> with : " + mTable.getNumberOfEntries() + " entries and a checksum of:" + mTable.getChecksum());
                    }
                }
            }
        }
        this.mRunning = false;
        LiveCacheMaster.printTrace(this.mTitle + ": Terminating");
    }

    public void setMaster(LiveCacheMaster newMaster) throws TestDatabaseException, SQLException {
        super.setMaster(newMaster);
        this.mNumberOfTables = TestCase.getParameterInt((String)"NumberOfSQLActors", (int)1);
        this.mMaxTableEntries = TestCase.getParameterInt((String)"MaxTableEntries", (int)33);
        this.mInsertPercentage = TestCase.getParameterInt((String)"InsertPercentage", (int)33);
        this.mDeletePercentage = TestCase.getParameterInt((String)"DeletePercentage", (int)33);
        this.mUpdatePercentage = TestCase.getParameterInt((String)"UpdatePercentage", (int)33);
        this.mSubtransactionPercentage = TestCase.getParameterInt((String)"SubtransactionPercentage", (int)50);
        this.mSubtransCommitPercentage = TestCase.getParameterInt((String)"SubtransCommitPercentage", (int)75);
        this.mTwoPhaseCommit = TestCase.getParameterBoolean((String)"TwoPhaseCommit", (boolean)false);
    }
}

