/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sapdb.lctest;

import com.sap.sapdb.lctest.SQLRecoverTest;
import com.sap.sapdb.testframe.driver.TestDatabaseException;
import com.sap.sapdb.testframe.driver.TestDatabaseSap;
import com.sap.sapdb.testframe.driver.TestDriver;
import com.sap.sapdb.testframe.testcase.TestCaseException;
import com.sap.sapdb.testframe.testcase.TestPreparedStatement;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.sql.ResultSet;
import java.sql.SQLException;

public class SQLRecoverTest6
extends SQLRecoverTest {
    static boolean dbHasLOBType;

    public static void cleanUp() throws TestCaseException {
        SQLRecoverTest.cleanUp();
    }

    public static void prepare() throws TestCaseException {
        try {
            dbHasLOBType = TestDriver.compareRelease((String)(((TestDatabaseSap)SQLRecoverTest6.getDatabase()).getKernelVersion() + "." + ((TestDatabaseSap)SQLRecoverTest6.getDatabase()).getKernelBuild().substring(0, 3)), (String)">=", (String)"7.7.0.0");
        }
        catch (TestDatabaseException e) {
            e.printStackTrace(System.err);
        }
        SQLRecoverTest.prepare();
    }

    public void insertLOB(int pUser, int key, int size) throws TestCaseException, SQLException {
        TestPreparedStatement prepS = new TestPreparedStatement(null, this.getConnection(pUser), "INSERT SQLRecoverTest6 values (?,?,?)");
        byte[] buffer = new byte[size];
        prepS.setString(1, "" + key);
        prepS.setString(2, "col1");
        prepS.setAsciiStream(3, (InputStream)new ByteArrayInputStream(buffer), size);
        prepS.execute();
    }

    public void updateLOB(int pUser, int key, int size, int updateSize) throws TestCaseException, SQLException {
        TestPreparedStatement prepS = new TestPreparedStatement(null, this.getConnection(pUser), "INSERT SQLRecoverTest6 values (?,?,?)");
        TestPreparedStatement prepUpdateS = new TestPreparedStatement(null, this.getConnection(pUser), "UPDATE SQLRecoverTest6 set LOBCOL = (?) where KEY1 = (?) ");
        byte[] buffer = new byte[size];
        byte[] updbuffer = new byte[updateSize];
        prepS.setString(1, "" + key);
        prepS.setString(2, "col1");
        prepS.setAsciiStream(3, (InputStream)new ByteArrayInputStream(buffer), size);
        prepS.execute();
        prepUpdateS.setAsciiStream(1, (InputStream)new ByteArrayInputStream(updbuffer), updateSize);
        prepUpdateS.setString(2, "" + key);
        prepUpdateS.execute();
    }

    int compareLOBCounter(int pUser, String testName) throws TestCaseException, SQLException {
        ResultSet result = this.getStatement(1).executeQuery("select FILES.LOBSIZE from FILES,ROOTS where roots.tablename = 'SQLRECOVERTEST6' and roots.tableid = files.fileid and files.type = 'TABLE'");
        result.next();
        int fdirCounter = result.getInt(1);
        result = dbHasLOBType ? this.getStatement(1).executeQuery("select numeric_value from TABLESTATISTICS where tablename = 'SQLRECOVERTEST6' and description = 'LOB column pages'") : this.getStatement(1).executeQuery("select numeric_value from TABLESTATISTICS where tablename = 'SQLRECOVERTEST6' and description = 'LONG column pages'");
        result.next();
        int tabStatsCounter = result.getInt(1) * 8;
        if (tabStatsCounter != fdirCounter) {
            this.addMessage(this.nextStep(testName), 'E', "FDIR LOB counter: " + fdirCounter + "kb\n" + "TABLESTATISTICS counter: " + tabStatsCounter + "kb");
        }
        return fdirCounter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        TestDatabaseSap sapdb = (TestDatabaseSap)SQLRecoverTest6.getDatabase();
        try {
            this.printTestHeader(this);
            this.executeSQL(1, "drop table SQLRecoverTest6");
            this.executeSQL(1, "commit");
            this.executeDBMCmd("util_connect");
            this.executeDBMCmd("medium_put srt6 srt6 FILE DATA 0 8 YES NO");
            this.executeDBMCmd("util_release");
            SQLRecoverTest6.addGlobalMessage((String)"SQLRecoverTest6", (char)'I', (String)"--> Just created backup media (FILE c:/Temp/srt6)!");
            this.executeDBMCmd("util_connect");
            this.executeDBMCmd("backup_save srt6");
            this.executeDBMCmd("util_release");
            SQLRecoverTest6.addGlobalMessage((String)"SQLRecoverTest6", (char)'I', (String)"--> Just performed backup srt6!");
            if (dbHasLOBType) {
                this.executeSQL(1, "CREATE TABLE SQLRecoverTest6 (KEY1 CHAR(15), COL1 CHAR(15), PRIMARY KEY (KEY1), LOBCOL CLOB)");
            } else {
                this.executeSQL(1, "CREATE TABLE SQLRecoverTest6 (KEY1 CHAR(15), COL1 CHAR(15), PRIMARY KEY (KEY1), LOBCOL LONG)");
            }
            this.executeSQL(1, "commit");
            int key = 1;
            this.insertLOB(1, key++, 200);
            this.insertLOB(1, key++, 9000);
            this.insertLOB(1, key++, 0x100000);
            this.updateLOB(1, key++, 200, 27000);
            this.updateLOB(1, key++, 27000, 200);
            this.executeSQL(1, "commit");
            this.compareLOBCounter(1, "SQLRecoverTest6");
            this.insertLOB(1, key++, 200);
            this.insertLOB(1, key++, 9000);
            this.insertLOB(1, key++, 0x100000);
            this.updateLOB(1, key++, 200, 27000);
            this.updateLOB(1, key++, 27000, 200);
            this.executeSQL(1, "commit");
            int beforeOffline = this.compareLOBCounter(1, "SQLRecoverTest6");
            this.insertLOB(1, key++, 200);
            this.insertLOB(1, key++, 9000);
            this.insertLOB(1, key++, 0x100000);
            this.updateLOB(1, key++, 200, 27000);
            this.updateLOB(1, key++, 27000, 200);
            this.executeSQL(1, "rollback");
            this.compareLOBCounter(1, "SQLRecoverTest6");
            this.executeDBMCmd("db_offline");
            SQLRecoverTest6.addGlobalMessage((String)"SQLRecoverTest6", (char)'I', (String)"--> Just performed db_offline!");
            SQLRecoverTest6.addGlobalMessage((String)"SQLRecoverTest6", (char)'I', (String)("--> db kernel mode is: " + sapdb.getKernelMode()));
            this.executeDBMCmd("db_cold -" + sapdb.getKernelMode());
            SQLRecoverTest6.addGlobalMessage((String)"SQLRecoverTest6", (char)'I', (String)("--> Just performed db_cold -" + sapdb.getKernelMode() + "!"));
            this.executeDBMCmd("util_connect");
            this.executeDBMCmd("recover_start srt6 data");
            SQLRecoverTest6.addGlobalMessage((String)"SQLRecoverTest6", (char)'I', (String)"--> Just performed recovery!");
            this.executeDBMCmd("db_warm -" + sapdb.getKernelMode());
            SQLRecoverTest6.addGlobalMessage((String)"SQLRecoverTest6", (char)'I', (String)("--> Just performed db_warm -" + sapdb.getKernelMode() + "!"));
            SQLRecoverTest6.createConnections();
            int afterRestore = this.compareLOBCounter(1, "SQLRecoverTest6");
            if (afterRestore != beforeOffline) {
                this.addMessage(this.nextStep("SQLRecoverTest6"), 'E', "FDIR LOB counter before offline: " + beforeOffline + "kb\n" + "FDIR LOB counter after restore: " + afterRestore + "kb\n");
            }
            this.executeDBMCmd("util_release");
            this.compareLOBCounter(1, "SQLRecoverTest6");
        }
        catch (Exception e) {
            this.printTestError(this);
            SQLRecoverTest6.addGlobalMessage((String)"SQLRecoverTest6", (char)'E', (String)e.getMessage());
            e.printStackTrace(System.err);
        }
        finally {
            try {
                this.executeDBMCmd("util_release");
                this.executeDBMCmd("sql_release");
            }
            catch (Exception exception) {}
        }
        this.printTestTrailer(this);
    }
}

