/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sapdb.lctest;

import com.sap.dbtech.powertoys.DBM;
import com.sap.sapdb.lctest.LiveCacheConstants;
import com.sap.sapdb.testframe.driver.TestDatabaseException;
import com.sap.sapdb.testframe.driver.TestDatabaseSap;
import com.sap.sapdb.testframe.driver.TestDriver;
import com.sap.sapdb.testframe.testcase.TestCase;
import com.sap.sapdb.testframe.testcase.TestCaseException;
import com.sap.sapdb.testframe.testcase.TestStatement;
import java.io.File;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.StringTokenizer;

public class RedoOfRedoTest01
extends TestCase
implements LiveCacheConstants {
    private static final String sVersion = "1.3";
    private Connection mConnection = null;
    private TestStatement stmt = null;
    private static int mTraceLevel;
    private DBM mDBMan = null;
    private String sString = null;
    private String[] LogSaves;
    private String checkValues = null;
    private String mKernelMode = "FAST";
    private String mOldRestartTime = null;
    private static int mWorkOnDatabase;

    public static String getTestClassId() {
        return "RedoOfRedoTest01";
    }

    public static String getMinimumRelease() {
        return "7.4.1.*";
    }

    public static void prepare() throws TestCaseException {
        RedoOfRedoTest01.readAndPrintParameters();
    }

    private static void printInfo(int Level2, String pComponent, String pInfoText) {
        if (Level2 <= mTraceLevel) {
            System.out.println(pComponent + " --> " + pInfoText);
        }
        if (Level2 < 7) {
            RedoOfRedoTest01.addGlobalMessage((String)pComponent, (char)'I', (String)pInfoText);
        } else if (mTraceLevel >= 9) {
            RedoOfRedoTest01.addGlobalMessage((String)pComponent, (char)'I', (String)pInfoText);
        }
    }

    protected static void readAndPrintParameters() throws TestCaseException {
        int defaultValue = 10;
        mTraceLevel = RedoOfRedoTest01.getParameterInt((String)"TraceLevel", (int)2);
        mWorkOnDatabase = RedoOfRedoTest01.getParameterInt((String)"WorkOnDatabase", (int)5);
        RedoOfRedoTest01.printInfo(1, "\n" + RedoOfRedoTest01.getTestClassId(), "Starting " + RedoOfRedoTest01.getTestClassId() + " Test - Version: " + sVersion + "\n");
        RedoOfRedoTest01.printInfo(2, RedoOfRedoTest01.getTestClassId(), "Parameter: TraceLevel     = " + mTraceLevel);
        RedoOfRedoTest01.printInfo(2, RedoOfRedoTest01.getTestClassId(), "Parameter: WorkOnDatabase = " + mWorkOnDatabase);
    }

    public String executeDBMCmd(String pCmd) throws TestDatabaseException {
        String logon = "";
        String mHost = "";
        String mName = "";
        RedoOfRedoTest01.printInfo(5, RedoOfRedoTest01.getTestClassId(), "executeDBMCmd: " + pCmd);
        try {
            mHost = RedoOfRedoTest01.getDatabase().getHost();
            mName = RedoOfRedoTest01.getDatabase().getName();
            int mPort = RedoOfRedoTest01.getDatabase().getPort();
            if (this.mDBMan == null) {
                this.mDBMan = DBM.dbDBM((String)(mHost + ":" + mPort), (String)mName);
                logon = "USER_LOGON DBM,DBM";
                this.mDBMan.cmd(logon);
            }
            return this.mDBMan.cmd(pCmd);
        }
        catch (Exception e) {
            throw new TestDatabaseException(e, " DBM command: " + pCmd + ", logon String: " + logon);
        }
    }

    private void recoverData() throws TestCaseException, SQLException, TestDatabaseException {
        RedoOfRedoTest01.printInfo(2, RedoOfRedoTest01.getTestClassId(), "Recover from data backup");
        this.executeDBMCmd("util_connect");
        this.executeDBMCmd("recover_start lcredo01dat DATA");
        this.executeDBMCmd("util_release");
    }

    private void recoverLog() throws TestCaseException, SQLException, TestDatabaseException {
        this.executeDBMCmd("util_connect");
        RedoOfRedoTest01.printInfo(2, RedoOfRedoTest01.getTestClassId(), "Recover from log...");
        boolean recoverFirst = false;
        String resultString = "";
        for (int lo = 0; lo < this.LogSaves.length && this.LogSaves[lo] != null; ++lo) {
            String firstLogSaveNumber = this.LogSaves[lo].substring(this.LogSaves[lo].indexOf(".") + 1, this.LogSaves[lo].length());
            if (!recoverFirst) {
                resultString = this.executeDBMCmd("recover_start lcredo01log LOG " + firstLogSaveNumber);
                RedoOfRedoTest01.printInfo(5, RedoOfRedoTest01.getTestClassId(), resultString);
                if (resultString.indexOf("-7075") > 0) continue;
                recoverFirst = true;
                continue;
            }
            if (resultString.indexOf("-8020") <= 0 || this.LogSaves[lo] == null) break;
            resultString = this.executeDBMCmd("recover_replace lcredo01log " + this.LogSaves[lo]);
            RedoOfRedoTest01.printInfo(5, RedoOfRedoTest01.getTestClassId(), resultString);
        }
        try {
            Thread.sleep(10000L);
        }
        catch (InterruptedException inExc) {
            System.out.println("Sleep-Exception: " + inExc.getMessage());
        }
        this.executeDBMCmd("recover_ignore");
        this.executeDBMCmd("util_release");
    }

    private void recoverLogCrashDatabase() throws TestCaseException, SQLException, TestDatabaseException {
        this.executeDBMCmd("util_connect");
        String firstLogSaveNumber = this.LogSaves[0].substring(this.LogSaves[0].indexOf(".") + 1, this.LogSaves[0].length());
        String resultString = "";
        RedoOfRedoTest01.printInfo(2, RedoOfRedoTest01.getTestClassId(), "Recover from log and crash database ...");
        resultString = this.executeDBMCmd("recover_start lcredo01log LOG " + firstLogSaveNumber);
        RedoOfRedoTest01.printInfo(5, RedoOfRedoTest01.getTestClassId(), resultString);
        for (int lo = 1; lo < this.LogSaves.length && this.LogSaves[lo] != null; ++lo) {
            resultString = this.executeDBMCmd("recover_replace lcredo01log " + this.LogSaves[lo]);
            RedoOfRedoTest01.printInfo(5, RedoOfRedoTest01.getTestClassId(), resultString);
            if (lo != 2) continue;
            try {
                this.executeDBMCmd("db_stop");
            }
            catch (TestDatabaseException tde) {
                System.out.println(this.executeDBMCmd("db_state"));
                if (tde.getMessage().indexOf("Kernel stop failed") == -1) break;
                try {
                    Thread.sleep(10000L);
                }
                catch (InterruptedException inExc) {
                    System.out.println("sleepy... " + inExc.getMessage());
                }
            }
            break;
        }
    }

    private void restartDatabaseCold() throws TestCaseException, SQLException, TestDatabaseException {
        this.executeDBMCmd("util_release");
        RedoOfRedoTest01.printInfo(2, RedoOfRedoTest01.getTestClassId(), "Restart database ");
        this.executeDBMCmd("db_cold -" + this.mKernelMode);
        try {
            Thread.sleep(8000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        RedoOfRedoTest01.printInfo(5, RedoOfRedoTest01.getTestClassId(), "db_state -> " + this.executeDBMCmd("db_state"));
        if (TestDriver.compareRelease((String)((TestDatabaseSap)RedoOfRedoTest01.getDatabase()).getKernelVersion(), (String)">=", (String)"7.6.0")) {
            this.executeDBMCmd("util_execute SET PARAMETER TRACE_LOGTRANS=5");
        } else {
            this.executeDBMCmd("util_execute diagnose vtrace topic 'log 5' on");
        }
        this.executeDBMCmd("util_connect");
        RedoOfRedoTest01.printInfo(5, RedoOfRedoTest01.getTestClassId(), this.executeDBMCmd("db_restartinfo"));
        this.executeDBMCmd("util_release");
    }

    private void startUp() throws TestCaseException, SQLException, TestDatabaseException {
        this.mConnection = RedoOfRedoTest01.getDatabase().connect(RedoOfRedoTest01.getUser(), RedoOfRedoTest01.getPassword());
        this.mConnection.setAutoCommit(true);
        this.stmt = new TestStatement((TestCase)this, this.mConnection);
        TestDatabaseSap sapdb = (TestDatabaseSap)RedoOfRedoTest01.getDatabase();
        this.mKernelMode = sapdb.getKernelMode();
        this.executeDBMCmd("autosave_off");
        this.mOldRestartTime = this.readDatabaseParameter("_RESTART_TIME");
    }

    private void testCleanUp() throws TestCaseException, SQLException, TestDatabaseException {
        this.changeDatabaseParameter("_RESTART_TIME", this.mOldRestartTime);
        String wrkDir = this.readDatabaseParameter("RUNDIRECTORY");
        File FileDir = new File(wrkDir);
        String[] FileList = FileDir.list();
        for (int i = 0; i < FileList.length; ++i) {
            File file = new File(FileDir, FileList[i]);
            if (!file.getName().startsWith("lcredo01")) continue;
            RedoOfRedoTest01.printInfo(4, RedoOfRedoTest01.getTestClassId(), "Delete unusable backup file: " + file.getName());
            file.delete();
        }
        this.mConnection.close();
    }

    private void changeDatabaseParameter(String paramName, String paramValue) throws TestDatabaseException {
        RedoOfRedoTest01.printInfo(5, RedoOfRedoTest01.getTestClassId(), "Change " + paramName + " to " + paramValue);
        this.executeDBMCmd("param_directput " + paramName + " " + paramValue);
    }

    private String readDatabaseParameter(String paramName) throws TestDatabaseException {
        StringTokenizer resultParam = new StringTokenizer(this.executeDBMCmd("param_directget " + paramName));
        if (resultParam != null && resultParam.nextToken().equalsIgnoreCase(paramName)) {
            return resultParam.nextToken();
        }
        return null;
    }

    private void checkBackUpState() throws SQLException, TestDatabaseException {
        String[] szLines = new String[200];
        int nCurrent = 0;
        String[] tempArray = new String[100];
        int tempArrayInt = 0;
        String szBuffer = this.executeDBMCmd("backup_history_list -c KEY -m -r LAST");
        String dummy = "";
        StringTokenizer stBuffer = new StringTokenizer(szBuffer);
        RedoOfRedoTest01.printInfo(4, RedoOfRedoTest01.getTestClassId(), "DBM command: 'backup_history_list -c KEY -m -r LAST' returns:\n" + szBuffer);
        while (stBuffer.hasMoreTokens()) {
            dummy = stBuffer.nextToken("\n");
            if (!dummy.startsWith("M:") || dummy.indexOf("YES") == -1) continue;
            StringTokenizer singleLine = new StringTokenizer(dummy);
            int lastElementOfSingleLine = singleLine.countTokens();
            while (singleLine.hasMoreTokens()) {
                tempArray[tempArrayInt++] = singleLine.nextToken("|");
            }
            szLines[nCurrent++] = tempArray[lastElementOfSingleLine].trim();
            tempArray = new String[100];
            tempArrayInt = 0;
        }
        this.LogSaves = szLines;
        for (int z = 0; z < 200; ++z) {
            if (this.LogSaves[z] == null) continue;
            RedoOfRedoTest01.printInfo(4, RedoOfRedoTest01.getTestClassId(), "LogSaves[" + z + "] = " + this.LogSaves[z]);
        }
        if (this.LogSaves[0] == null) {
            this.addMessage(RedoOfRedoTest01.getTestClassId(), 'E', "Can not read the last log saves by using the statement \"backup_history_list -c KEY -m -r LAST\"");
            this.addMessage(RedoOfRedoTest01.getTestClassId(), 'I', "get:\n" + szBuffer);
            throw new TestDatabaseException("Can not read the last log saves.");
        }
    }

    private void checkState() throws SQLException, TestDatabaseException {
        this.checkState(-1);
    }

    private void checkState(int curCounter) throws SQLException, TestDatabaseException {
        ResultSet rs = null;
        Connection mCheckStateConnection = RedoOfRedoTest01.getDatabase().connect(RedoOfRedoTest01.getUser(), RedoOfRedoTest01.getPassword());
        this.stmt = new TestStatement((TestCase)this, mCheckStateConnection);
        String checkTempValues = "";
        if (curCounter == -1 && this.checkValues == null) {
            this.sString = "Select count(*) from TT_REDO";
            rs = this.stmt.executeQuery(this.sString);
            rs.next();
            this.checkValues = "";
            this.checkValues = this.checkValues + "Result of \"" + this.sString + "\" -> ";
            this.checkValues = this.checkValues + rs.getInt(1) + "\n";
            this.sString = "Select * from TT_REDO WHERE PRIMKEY > " + (rs.getInt(1) - 10);
            rs = this.stmt.executeQuery(this.sString);
            this.checkValues = this.checkValues + "Result of \"" + this.sString + "\"\n";
            this.checkValues = this.checkValues + "PrimKey \t Value_A \t Value_B\n";
            while (rs.next()) {
                this.checkValues = this.checkValues + " " + rs.getInt(1) + " ";
                this.checkValues = this.checkValues + "\t  " + rs.getInt(2) + " ";
                this.checkValues = this.checkValues + "\t  " + rs.getString(3) + "\n";
            }
            this.stmt.close();
            mCheckStateConnection.close();
            return;
        }
        if (curCounter == -1 && this.checkValues != null) {
            this.sString = "Select count(*) from TT_REDO";
            rs = this.stmt.executeQuery(this.sString);
            rs.next();
            checkTempValues = "";
            checkTempValues = checkTempValues + "Result of \"" + this.sString + "\" -> ";
            checkTempValues = checkTempValues + rs.getInt(1) + "\n";
            this.sString = "Select * from TT_REDO WHERE PRIMKEY > " + (rs.getInt(1) - 10);
            rs = this.stmt.executeQuery(this.sString);
            checkTempValues = checkTempValues + "Result of \"" + this.sString + "\"\n";
            checkTempValues = checkTempValues + "PrimKey \t Value_A \t Value_B\n";
            while (rs.next()) {
                checkTempValues = checkTempValues + " " + rs.getInt(1) + " ";
                checkTempValues = checkTempValues + "\t  " + rs.getInt(2) + " ";
                checkTempValues = checkTempValues + "\t  " + rs.getString(3) + "\n";
            }
            this.stmt.close();
            mCheckStateConnection.close();
            if (this.checkValues.compareTo(checkTempValues) != 0) {
                RedoOfRedoTest01.addGlobalMessage((String)RedoOfRedoTest01.getTestClassId(), (char)'E', (String)("***** ERROR ****** \nwrong table content --> expecting:\n" + this.checkValues + "\ngetting:\n" + checkTempValues));
            }
            return;
        }
        checkTempValues = "" + curCounter + " ";
        this.sString = "Select count(*) from TT_REDO";
        rs = this.stmt.executeQuery(this.sString);
        rs.next();
        checkTempValues = checkTempValues + "Result of \"" + this.sString + "\" -> ";
        checkTempValues = checkTempValues + rs.getInt(1) + "\n";
        this.sString = "Select * from TT_REDO WHERE PRIMKEY > " + (rs.getInt(1) - 10);
        rs = this.stmt.executeQuery(this.sString);
        checkTempValues = checkTempValues + "Result of \"" + this.sString + "\"\n";
        checkTempValues = checkTempValues + "PrimKey \t Value_A \t Value_B\n";
        while (rs.next()) {
            checkTempValues = checkTempValues + " " + rs.getInt(1) + " ";
            checkTempValues = checkTempValues + "\t  " + rs.getInt(2) + " ";
            checkTempValues = checkTempValues + "\t  " + rs.getString(3) + "\n";
        }
        RedoOfRedoTest01.printInfo(7, RedoOfRedoTest01.getTestClassId() + " - checkState", "Endresult:\n" + checkTempValues);
        this.stmt.close();
        mCheckStateConnection.close();
    }

    private void createTable() throws TestCaseException, SQLException {
        this.sString = "DROP TABLE TT_REDO";
        RedoOfRedoTest01.printInfo(5, RedoOfRedoTest01.getTestClassId(), this.sString);
        this.stmt.executeUpdateIgnoreErrors(this.sString);
        this.sString = "DROP DBPROC FILL_REDO_TAB";
        RedoOfRedoTest01.printInfo(5, RedoOfRedoTest01.getTestClassId(), this.sString);
        this.stmt.executeUpdateIgnoreErrors(this.sString);
        this.sString = "CREATE TABLE TT_REDO(PRIMKEY INTEGER PRIMARY KEY, VALUE_A INTEGER, VALUE_B CHAR(24) )";
        RedoOfRedoTest01.printInfo(5, RedoOfRedoTest01.getTestClassId(), this.sString);
        this.stmt.executeUpdate(this.sString);
        this.sString = "CREATE DBPROC FILL_REDO_TAB(IN COUNTER INTEGER) AS  VAR x INT;  SET x = (COUNTER - 1) * 10000;  WHILE x < (10000 * COUNTER) DO BEGIN   INSERT INTO " + RedoOfRedoTest01.getDatabase().getDBAUser() + ".TT_REDO VALUES (:x, 10000 * :COUNTER + :x, 'RedoValue');      " + "  IF $RC <> 0 THEN \t" + "   STOP ($RC, $ERRMSG); " + "  UPDATE " + RedoOfRedoTest01.getDatabase().getDBAUser() + ".TT_REDO SET VALUE_B = 'a little string' WHERE PRIMKEY = :x; " + "  IF $RC <> 0 THEN \t" + "   STOP ($RC, $ERRMSG); " + "  x = x + 1; " + " END; ";
        RedoOfRedoTest01.printInfo(5, RedoOfRedoTest01.getTestClassId(), this.sString);
        this.stmt.executeUpdate(this.sString);
        this.mConnection.commit();
    }

    private void createBackUpMedium() throws TestCaseException, SQLException, TestDatabaseException {
        this.executeDBMCmd("util_connect");
        this.executeDBMCmd("backup_media_put lcredo01log lcredo01log FILE LOG");
        this.executeDBMCmd("backup_media_put lcredo01dat lcredo01dat FILE DATA 0 8 YES NO ");
        this.executeDBMCmd("util_release");
    }

    private void backUpData() throws TestCaseException, SQLException, TestDatabaseException {
        this.setStatus("createBackup");
        RedoOfRedoTest01.printInfo(2, RedoOfRedoTest01.getTestClassId(), "Backup data");
        this.executeDBMCmd("util_connect");
        this.executeDBMCmd("backup_save lcredo01dat DATA");
        this.executeDBMCmd("util_release");
    }

    private void backUpLogWarm() throws TestCaseException, SQLException, TestDatabaseException {
        this.setStatus("createBackup");
        RedoOfRedoTest01.printInfo(2, RedoOfRedoTest01.getTestClassId(), "Backup log");
        this.executeDBMCmd("util_connect");
        this.executeDBMCmd("backup_save lcredo01log LOG");
        this.executeDBMCmd("util_release");
    }

    private void backUpLogCold() throws TestCaseException, SQLException, TestDatabaseException {
        this.executeDBMCmd("db_cold -" + this.mKernelMode);
        this.setStatus("createBackup");
        RedoOfRedoTest01.printInfo(2, RedoOfRedoTest01.getTestClassId(), "Backup log");
        this.executeDBMCmd("util_connect");
        this.executeDBMCmd("backup_save lcredo01log LOG");
        this.executeDBMCmd("util_release");
    }

    private void workOnTheDatabase(int loopCounter) throws TestCaseException, SQLException, TestDatabaseException {
        Connection mWorkConnection = RedoOfRedoTest01.getDatabase().connect(RedoOfRedoTest01.getUser(), RedoOfRedoTest01.getPassword());
        mWorkConnection.setAutoCommit(false);
        TestStatement workstmt = new TestStatement((TestCase)this, mWorkConnection);
        if (loopCounter != -1) {
            RedoOfRedoTest01.printInfo(2, RedoOfRedoTest01.getTestClassId(), "Working with data in the database ( " + loopCounter + " ) ...");
        }
        this.sString = "CALL FILL_REDO_TAB (" + loopCounter + ")";
        RedoOfRedoTest01.printInfo(5, RedoOfRedoTest01.getTestClassId(), "execute: " + this.sString);
        workstmt.execute(this.sString);
        mWorkConnection.commit();
        mWorkConnection.close();
    }

    public void run() {
        try {
            this.setStatus("startUp");
            this.startUp();
            this.setStatus("createBackUpMedium");
            this.createBackUpMedium();
            this.setStatus("createTable");
            this.createTable();
            this.setStatus("BackUp DATA");
            this.backUpData();
            this.setStatus("Work on Database");
            int counter = 1;
            do {
                this.workOnTheDatabase(counter);
                Thread.sleep(120L);
                this.checkState(counter);
            } while (++counter <= mWorkOnDatabase);
            this.setStatus("BackUp LOG cold");
            this.backUpLogCold();
            this.executeDBMCmd("db_warm -" + this.mKernelMode);
            this.setStatus("Work on Database");
            do {
                this.workOnTheDatabase(counter);
                Thread.sleep(120L);
                this.checkState(counter);
            } while (++counter <= mWorkOnDatabase * 2);
            this.setStatus("BackUp LOG cold");
            this.backUpLogCold();
            this.executeDBMCmd("db_warm -" + this.mKernelMode);
            this.setStatus("Work on Database");
            do {
                this.workOnTheDatabase(counter);
                Thread.sleep(120L);
                this.checkState(counter);
            } while (++counter <= mWorkOnDatabase * 3);
            this.setStatus("BackUp LOG cold");
            this.backUpLogCold();
            this.executeDBMCmd("db_warm -" + this.mKernelMode);
            this.setStatus("Work on Database");
            do {
                this.workOnTheDatabase(counter);
                Thread.sleep(120L);
                this.checkState(counter);
            } while (++counter <= mWorkOnDatabase * 4);
            this.setStatus("BackUp LOG cold");
            this.backUpLogCold();
            this.executeDBMCmd("db_warm -" + this.mKernelMode);
            this.setStatus("Work on Database");
            do {
                this.workOnTheDatabase(counter);
                Thread.sleep(120L);
                this.checkState(counter);
            } while (++counter <= mWorkOnDatabase * 5);
            this.setStatus("Check State");
            this.checkState();
            this.setStatus("BackUp LOG cold");
            this.backUpLogCold();
            this.changeDatabaseParameter("_RESTART_TIME", "2");
            this.restartDatabaseCold();
            this.executeDBMCmd("util_execute clear log");
            this.checkBackUpState();
            this.setStatus("Recover Data");
            this.recoverData();
            this.setStatus("Recover LOG");
            this.recoverLogCrashDatabase();
            this.restartDatabaseCold();
            this.checkBackUpState();
            this.recoverLog();
            this.setStatus("Check State");
            this.checkState();
            this.executeDBMCmd("db_cold -" + this.mKernelMode);
            this.executeDBMCmd("util_connect");
            this.executeDBMCmd("util_execute verify");
            this.executeDBMCmd("util_release");
            this.testCleanUp();
        }
        catch (Exception e) {
            System.out.println("Exception: " + e.getMessage() + " " + e.getClass() + " " + e.getLocalizedMessage());
            e.printStackTrace();
            RedoOfRedoTest01.addGlobalMessage((String)RedoOfRedoTest01.getTestClassId(), (char)'E', (String)("Exception: " + e.getClass() + " " + e.getMessage()));
            StringWriter sw = new StringWriter();
            e.printStackTrace(new PrintWriter(sw));
            RedoOfRedoTest01.addGlobalMessage((String)RedoOfRedoTest01.getTestClassId(), (char)'T', (String)("Trace: " + sw.toString()));
        }
    }

    public static void cleanUp() throws TestCaseException {
    }
}

