/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sapdb.lctest;

import com.sap.dbtech.powertoys.DBM;
import com.sap.sapdb.lctest.PrimaryTest;
import com.sap.sapdb.lctest.TestActor;
import com.sap.sapdb.testframe.driver.TestDatabaseException;
import com.sap.sapdb.testframe.testcase.TestCaseException;
import com.sap.sapdb.testframe.testcase.TestPreparedStatement;
import com.sap.sapdb.testframe.testcase.TestStatement;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Random;

public class MultiUserTemplateLc
extends PrimaryTest {
    private static final String sVersion = "1.0";
    private String mKernelMode = "FAST";
    private static Connection mMainConnection = null;
    private static TestStatement mMainStatement = null;
    private static TestPreparedStatement mMainPrepStatement = null;
    private static Connection[] mConnections;
    private static TestStatement[] mStatements;
    private static TestPreparedStatement[] mPrepStatement;
    protected static int mNumberOfConcurrentUsers;
    protected static int mNumberOfReaders;
    protected static int mNumberOfWriters;
    protected static int mNoOfCycles;
    protected static int mStartDistance;
    protected static int mWaitTimeAfterStart;
    private static Random mRandomGenerator;
    private static int mTraceLevel;
    private DBM mDBMan = null;

    public static String getMinimumRelease() {
        return "7.4.1.*";
    }

    public static void prepare() throws TestCaseException {
        PrimaryTest.prepare();
        MultiUserTemplateLc.readAndPrintParameters();
    }

    protected static void readAndPrintParameters() throws TestCaseException {
        mTraceLevel = MultiUserTemplateLc.getParameterInt((String)"TraceLevel", (int)2);
        mNumberOfReaders = MultiUserTemplateLc.getParameterInt((String)"NumberOfReaders", (int)1);
        mNumberOfWriters = MultiUserTemplateLc.getParameterInt((String)"NumberOfWriters", (int)2);
        mNumberOfConcurrentUsers = mNumberOfReaders + mNumberOfWriters;
        mNoOfCycles = MultiUserTemplateLc.getParameterInt((String)"NoOfCycles", (int)100);
        mStartDistance = MultiUserTemplateLc.getParameterInt((String)"StartDistance", (int)1);
        mWaitTimeAfterStart = MultiUserTemplateLc.getParameterInt((String)"WaitTimeAfterStart", (int)1);
        MultiUserTemplateLc.printInfo(1, "\n" + MultiUserTemplateLc.getTestClassId(), "Starting " + MultiUserTemplateLc.getTestClassId() + " Test - Version: " + sVersion + "\n");
        MultiUserTemplateLc.printInfo(2, MultiUserTemplateLc.getTestClassId(), "Parameter: NumberOfReaders    = " + mNumberOfReaders);
        MultiUserTemplateLc.printInfo(2, MultiUserTemplateLc.getTestClassId(), "Parameter: NumberOfWriters    = " + mNumberOfWriters);
        MultiUserTemplateLc.printInfo(2, MultiUserTemplateLc.getTestClassId(), "Parameter: StartDistance      = " + mStartDistance);
        MultiUserTemplateLc.printInfo(2, MultiUserTemplateLc.getTestClassId(), "Parameter: WaitTimeAfterStart = " + mWaitTimeAfterStart);
        MultiUserTemplateLc.printInfo(2, MultiUserTemplateLc.getTestClassId(), "Parameter: TraceLevel         = " + mTraceLevel);
        MultiUserTemplateLc.printInfo(2, MultiUserTemplateLc.getTestClassId(), "Parameter: NoOfCycles         = " + mNoOfCycles);
    }

    public static int randomInteger(int MinValue, int MaxValue) {
        return (int)((double)mRandomGenerator.nextFloat() * (double)(MaxValue - MinValue + 1)) + MinValue;
    }

    public static void cleanUp() throws TestCaseException {
        PrimaryTest.cleanUp();
        System.out.println("End of " + MultiUserTemplateLc.getTestClassId());
    }

    private static void printInfo(int Level2, String pComponent, String pInfoText) {
        if (Level2 <= mTraceLevel) {
            System.out.println(pComponent + " --> " + pInfoText);
        }
        if (Level2 < 7) {
            MultiUserTemplateLc.addGlobalMessage((String)pComponent, (char)'I', (String)pInfoText);
        } else if (mTraceLevel >= 9) {
            MultiUserTemplateLc.addGlobalMessage((String)pComponent, (char)'I', (String)pInfoText);
        }
    }

    private static boolean createConnections() {
        try {
            mMainConnection = MultiUserTemplateLc.getDatabase().connect(MultiUserTemplateLc.getUser(), MultiUserTemplateLc.getPassword());
            mMainConnection.setAutoCommit(true);
            mMainStatement = new TestStatement(null, mMainConnection);
            mConnections = new Connection[mNumberOfConcurrentUsers];
            mStatements = new TestStatement[mNumberOfConcurrentUsers];
            mPrepStatement = new TestPreparedStatement[mNumberOfConcurrentUsers];
            System.out.println("Creating " + mNumberOfConcurrentUsers + " connections!");
            for (int i = 0; i < mNumberOfConcurrentUsers; ++i) {
                MultiUserTemplateLc.mConnections[i] = MultiUserTemplateLc.getDatabase().connect("UPRIMARY", "UPRIMARY");
                mConnections[i].setAutoCommit(false);
                MultiUserTemplateLc.mStatements[i] = new TestStatement(null, mConnections[i]);
                mStatements[i].execute("CALL SET_CURRENT_SCHEMA('testteam')");
                mConnections[i].commit();
            }
        }
        catch (Exception e) {
            MultiUserTemplateLc.addGlobalMessage((String)"createConnections", (char)'E', (String)("Error during connection creation: " + e.getMessage()));
            return false;
        }
        return true;
    }

    public static String getTestClassId() {
        return "MultiUserTemplateLc";
    }

    private void handleException(Exception e) {
        this.handleExceptions(e);
    }

    public void startingMultipleThreads(int StartDistance, int WaitTimeAfterStart) throws TestCaseException {
        try {
            boolean areRAlive;
            boolean areWAlive;
            int j;
            int i;
            long SleepTime = 1000 * StartDistance;
            LCReader[] ReaderSet = new LCReader[mNumberOfReaders + 1];
            LCWriter[] WriterSet = new LCWriter[mNumberOfWriters + 1];
            this.prCreateContainer(1, 1, "testteam", 1, 0);
            this.prCommit(1);
            for (i = 0; i < mNumberOfWriters; ++i) {
                MultiUserTemplateLc.printInfo(2, MultiUserTemplateLc.getTestClassId(), "Start LCWriter" + Integer.toString(i));
                WriterSet[i] = new LCWriter(i, i);
                Thread.sleep(SleepTime);
            }
            for (j = 0; j < mNumberOfReaders; ++j) {
                MultiUserTemplateLc.printInfo(2, MultiUserTemplateLc.getTestClassId(), "Start LCReader" + Integer.toString(j));
                ReaderSet[j] = new LCReader(j, i + j);
                Thread.sleep(SleepTime);
            }
            SleepTime = 60000 * mWaitTimeAfterStart;
            Thread.sleep(SleepTime);
            MultiUserTemplateLc.printInfo(2, MultiUserTemplateLc.getTestClassId(), "Stop all threads");
            for (i = 0; i < mNumberOfWriters; ++i) {
                if (WriterSet[i] != null) {
                    WriterSet[i].pleaseStop();
                }
                System.out.println("asked to stop writers: i = " + i + " Status: " + WriterSet[i].isAlive());
            }
            for (j = 0; j < mNumberOfReaders; ++j) {
                if (ReaderSet[j] != null) {
                    ReaderSet[j].pleaseStop();
                }
                System.out.println("asked to stop readers: j = " + j + " Status: " + ReaderSet[j].isAlive());
            }
            int k = 0;
            do {
                ++k;
                areRAlive = false;
                areWAlive = false;
                for (i = 0; i < mNumberOfWriters; ++i) {
                    if (WriterSet[i] == null) continue;
                    areWAlive |= WriterSet[i].isAlive();
                    Thread.sleep(200L);
                }
                for (j = 0; j < mNumberOfReaders; ++j) {
                    if (ReaderSet[j] == null) continue;
                    areRAlive |= ReaderSet[j].isAlive();
                    Thread.sleep(200L);
                }
            } while ((areWAlive || areRAlive) && k < 100);
            System.out.println("Writers: " + areWAlive + "   Readers: " + areRAlive);
            if (areWAlive || areRAlive) {
                throw new TestCaseException("Not all threads stopped");
            }
            MultiUserTemplateLc.printInfo(2, MultiUserTemplateLc.getTestClassId(), "All threads stopped...");
        }
        catch (Exception e) {
            this.handleExceptions(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        block22: {
            try {
                try {
                    this.setStatus("createConnections");
                    MultiUserTemplateLc.createConnections();
                    this.setStatus("Multi Users on DB");
                    this.startingMultipleThreads(MultiUserTemplateLc.mStartDistance, MultiUserTemplateLc.mWaitTimeAfterStart);
                }
                catch (Exception e) {
                    this.handleExceptions(e);
                    var3_2 = null;
                    try {
                        MultiUserTemplateLc.printInfo(2, MultiUserTemplateLc.getTestClassId(), "Closing all statements!");
                        MultiUserTemplateLc.mMainStatement.close();
                        for (i = 0; i < MultiUserTemplateLc.mNumberOfConcurrentUsers; ++i) {
                            MultiUserTemplateLc.mStatements[i].close();
                        }
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    try {
                        MultiUserTemplateLc.printInfo(2, MultiUserTemplateLc.getTestClassId(), "Closing all connections!");
                        MultiUserTemplateLc.mMainConnection.commit();
                        MultiUserTemplateLc.mMainConnection.close();
                        i = 0;
                        while (i < MultiUserTemplateLc.mNumberOfConcurrentUsers) {
                            MultiUserTemplateLc.mConnections[i].commit();
                            MultiUserTemplateLc.mConnections[i].close();
                            ++i;
                        }
                        return;
                    }
                    catch (Exception e) {
                        return;
                    }
                }
                var3_1 = null;
            }
            catch (Throwable var2_16) {
                block21: {
                    var3_3 = null;
                    ** try [egrp 2[TRYBLOCK] [4 : 51->95)] { 
lbl42:
                    // 1 sources

                    MultiUserTemplateLc.printInfo(2, MultiUserTemplateLc.getTestClassId(), "Closing all statements!");
                    MultiUserTemplateLc.mMainStatement.close();
                    for (i = 0; i < MultiUserTemplateLc.mNumberOfConcurrentUsers; ++i) {
                        MultiUserTemplateLc.mStatements[i].close();
                    }
                    break block21;
lbl48:
                    // 1 sources

                    catch (Exception e) {
                        // empty catch block
                    }
                }
                ** try [egrp 3[TRYBLOCK] [5 : 97->164)] { 
lbl52:
                // 1 sources

                MultiUserTemplateLc.printInfo(2, MultiUserTemplateLc.getTestClassId(), "Closing all connections!");
                MultiUserTemplateLc.mMainConnection.commit();
                MultiUserTemplateLc.mMainConnection.close();
                i = 0;
                while (i < MultiUserTemplateLc.mNumberOfConcurrentUsers) {
                    MultiUserTemplateLc.mConnections[i].commit();
                    MultiUserTemplateLc.mConnections[i].close();
                    ++i;
                }
                throw var2_16;
lbl62:
                // 1 sources

                catch (Exception e) {
                    // empty catch block
                }
                throw var2_16;
            }
            ** try [egrp 2[TRYBLOCK] [4 : 51->95)] { 
lbl67:
            // 1 sources

            MultiUserTemplateLc.printInfo(2, MultiUserTemplateLc.getTestClassId(), "Closing all statements!");
            MultiUserTemplateLc.mMainStatement.close();
            for (i = 0; i < MultiUserTemplateLc.mNumberOfConcurrentUsers; ++i) {
                MultiUserTemplateLc.mStatements[i].close();
            }
            break block22;
lbl73:
            // 1 sources

            catch (Exception e) {
                // empty catch block
            }
        }
        ** try [egrp 3[TRYBLOCK] [5 : 97->164)] { 
lbl77:
        // 1 sources

        MultiUserTemplateLc.printInfo(2, MultiUserTemplateLc.getTestClassId(), "Closing all connections!");
        MultiUserTemplateLc.mMainConnection.commit();
        MultiUserTemplateLc.mMainConnection.close();
        i = 0;
        while (i < MultiUserTemplateLc.mNumberOfConcurrentUsers) {
            MultiUserTemplateLc.mConnections[i].commit();
            MultiUserTemplateLc.mConnections[i].close();
            ++i;
        }
        return;
lbl87:
        // 1 sources

        catch (Exception e) {}
    }

    static {
        mRandomGenerator = new Random();
    }

    class LCReader
    extends TestActor {
        boolean keepRunning = true;
        String nameR;
        int numberR;
        int StmtCount;
        int connectionR;

        LCReader(int readerNo, int conNo) {
            this.nameR = "LCReader" + readerNo;
            this.numberR = readerNo;
            this.connectionR = conNo;
            this.StmtCount = 0;
            this.start();
            MultiUserTemplateLc.printInfo(5, MultiUserTemplateLc.getTestClassId(), this.nameR + " just started!");
        }

        public void check() {
            System.out.println("in check");
        }

        public void run() {
            Connection con = null;
            try {
                MultiUserTemplateLc.printInfo(2, MultiUserTemplateLc.getTestClassId(), this.nameR + " uses Connection number " + this.connectionR);
                con = mConnections[this.connectionR];
                while (this.keepRunning) {
                    ++this.StmtCount;
                    this.executeLCReadingOps(con, this.numberR);
                    Thread.sleep(50L);
                }
            }
            catch (Exception e) {
                System.out.println("Exception: \nlocalized Message: \t " + e.getLocalizedMessage() + e.getMessage());
                MultiUserTemplateLc.this.handleException(e);
            }
        }

        public void pleaseStop() {
            MultiUserTemplateLc.printInfo(2, MultiUserTemplateLc.getTestClassId(), this.nameR + " asking thread to please stop!");
            this.keepRunning = false;
        }

        private void executeLCReadingOps(Connection pConnection, int user) throws TestCaseException {
            block5: {
                int CurrentCycle = 0;
                Object mList = null;
                this.mRunning = true;
                try {
                    while (this.keepRunning) {
                        if (CurrentCycle % 20 == 0) {
                            System.out.println(this.nameR + ": CurrentCycle = " + CurrentCycle);
                        }
                        pConnection.commit();
                        LCReader.sleep(25L);
                        if (mNoOfCycles != -1 && ++CurrentCycle > mNoOfCycles) {
                            MultiUserTemplateLc.printInfo(2, MultiUserTemplateLc.getTestClassId(), this.nameR + ": Finished <" + (CurrentCycle - 1) + "> cycles");
                            this.keepRunning = false;
                            this.setStatus(1);
                        }
                        if (!this.mShouldStop) continue;
                        MultiUserTemplateLc.printInfo(2, MultiUserTemplateLc.getTestClassId(), this.nameR + ": Soft interrupted at " + (CurrentCycle - 1) + " cycles");
                        this.keepRunning = false;
                        this.setStatus(2, "Interrupted by master thread at " + (CurrentCycle - 1) + " cycles");
                    }
                }
                catch (Exception e) {
                    MultiUserTemplateLc.addGlobalMessage((String)("Thread " + this.nameR + ": Method executeCmd "), (char)'E', (String)(" execute failed: " + ((SQLException)e).getErrorCode()));
                    if (((SQLException)e).getErrorCode() != -807) break block5;
                    this.keepRunning = false;
                }
            }
        }
    }

    class LCWriter
    extends TestActor {
        boolean keepRunning = true;
        String nameW;
        int numberW;
        int StmtCount;
        int connectionW;

        LCWriter(int writerNo, int conNo) {
            this.nameW = "LCWriter" + writerNo;
            this.numberW = writerNo;
            this.connectionW = conNo;
            this.StmtCount = 0;
            this.start();
            MultiUserTemplateLc.printInfo(5, MultiUserTemplateLc.getTestClassId(), this.nameW + " just started!");
        }

        public void check() {
            System.out.println("check: does not do anything yet");
        }

        public void run() {
            Connection con = null;
            try {
                MultiUserTemplateLc.printInfo(2, MultiUserTemplateLc.getTestClassId(), this.nameW + " uses Connection number " + this.connectionW);
                con = mConnections[this.connectionW];
                while (this.keepRunning) {
                    ++this.StmtCount;
                    this.executeLCWritingOps(con, this.numberW);
                    Thread.sleep(50L);
                }
            }
            catch (Exception e) {
                System.out.println("Exception: \n localized Message: \t " + e.getLocalizedMessage() + e.getMessage());
                MultiUserTemplateLc.this.handleException(e);
            }
        }

        public void pleaseStop() {
            MultiUserTemplateLc.printInfo(2, MultiUserTemplateLc.getTestClassId(), this.nameW + " asking thread to please stop!");
            this.keepRunning = false;
        }

        private void executeLCWritingOps(Connection pConnection, int user) throws TestCaseException {
            int CurrentCycle = 0;
            boolean inException = false;
            this.mRunning = true;
            try {
                while (this.keepRunning) {
                    if (CurrentCycle % 20 == 0) {
                        System.out.println(this.nameW + ": CurrentCycle = " + CurrentCycle);
                    }
                    pConnection.commit();
                    LCWriter.sleep(25L);
                    if (mNoOfCycles != -1 && ++CurrentCycle > mNoOfCycles) {
                        MultiUserTemplateLc.printInfo(2, MultiUserTemplateLc.getTestClassId(), this.nameW + ": Finished <" + (CurrentCycle - 1) + "> cycles");
                        this.keepRunning = false;
                        this.setStatus(1);
                    }
                    if (!this.mShouldStop) continue;
                    MultiUserTemplateLc.printInfo(2, MultiUserTemplateLc.getTestClassId(), this.nameW + ": Soft interrupted at " + (CurrentCycle - 1) + " cycles");
                    this.keepRunning = false;
                    this.setStatus(2, "Interrupted by master thread at " + (CurrentCycle - 1) + " cycles");
                }
            }
            catch (InterruptedException e) {
                System.out.println(this.nameW + ": Hard interrupted");
                this.setStatus(2);
                inException = true;
            }
            catch (Exception e) {
                System.out.println(this.nameW + ": ** ERROR **  General exception: " + e.getMessage());
                this.setStatus(-3, "Exception: " + e.getMessage());
                inException = true;
            }
        }
    }
}

