/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sapdb.lctest;

import com.sap.sapdb.lctest.LiveCacheConstants;
import com.sap.sapdb.testframe.driver.TestDatabase;
import com.sap.sapdb.testframe.driver.TestDatabaseException;
import com.sap.sapdb.testframe.driver.TestDatabaseSap;
import com.sap.sapdb.testframe.driver.TestDriver;
import com.sap.sapdb.testframe.testcase.TestCase;
import com.sap.sapdb.testframe.testcase.TestCaseException;
import com.sap.sapdb.testframe.testcase.TestStatement;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Properties;

public class LVC_Container
extends TestCase
implements LiveCacheConstants {
    private static final String sVersion = "1.1";
    private static final int TEST_DELETEALL_INS_ROLLBACK = 1;
    private static final int TEST_DELETEALL_UPD_ROLLBACK = 2;
    private static final int TEST_DELETEALL_INS_COMMIT = 3;
    private static final int TEST_DELETEALL_UPD_COMMIT = 4;
    private static final int TEST_SHARE_LOCK = 5;
    private static final int TEST_LOCK_1 = 6;
    private static final int TEST_LOCK_2 = 7;
    private static final int TEST_LOCK_3 = 8;
    private static int m_tasks = 0;
    private static boolean m_runTimeLimit = false;
    private static volatile boolean m_stop = false;
    private static int m_sqlError = 0;
    private static String m_sqlErrorMsg;
    private static boolean m_consoleMsg;
    private static int m_maxRunTime;

    public static void abort() {
        m_sqlError = -11111;
        m_sqlErrorMsg = "Test aborted";
    }

    private static void checkLiveCache(Connection con) throws TestCaseException {
        try {
            TestStatement stmt = new TestStatement(null, con, 1005, 1007);
            stmt.executeQuery("select * from dbparameters where value = 'LVC'");
            if (stmt.getResultCounter() != 1) {
                LVC_Container.addGlobalMessage((String)"checkLiveCache", (char)'E', (String)"database instance must be a liveCache");
                throw new TestCaseException("Error during preparation: no liveCache");
            }
        }
        catch (SQLException e) {
            if (-4004 == e.getErrorCode()) {
                LVC_Container.addGlobalMessage((String)"checkLiveCache", (char)'E', (String)"system tables not loaded");
                throw new TestCaseException("Error during preparation: system tables not loaded");
            }
            LVC_Container.addGlobalMessage((String)"checkLiveCache", (char)'E', (String)("SQL error" + e.getErrorCode()));
            throw new TestCaseException("Error during preparation: SQL error " + e.getErrorCode());
        }
    }

    public static void cleanUp() throws TestCaseException {
    }

    public static Connection connect() throws TestDatabaseException {
        Properties conp = new Properties();
        conp.put("user", "LVC_TST");
        conp.put("password", "LVC_TST");
        conp.put("autocommit", "off");
        Connection con = LVC_Container.getDatabase().connect(conp);
        return con;
    }

    private static void createDBProcedure(Connection con, String DBProcName, String PackageName) throws SQLException {
        Statement stmt = con.createStatement();
        try {
            stmt.execute("DROP DBPROC " + DBProcName);
        }
        catch (SQLException e) {
            // empty catch block
        }
        String CallString = "CREATE DBPROC " + DBProcName + " IN " + PackageName + " EXECUTE INPROC";
        stmt.execute(CallString);
        LVC_Container.Trace(m_consoleMsg, CallString);
    }

    private static void createDBProcedures(Connection con, String PackageName) throws SQLException {
        LVC_Container.createDBProcedure(con, "LVCC_RECREATE_SCHEMA", PackageName);
        LVC_Container.createDBProcedure(con, "LVCC_REGISTER_ALL_CLASSES", PackageName);
        LVC_Container.createDBProcedure(con, "LVCC_CREATE_KEYED_OBJECTS", PackageName);
        LVC_Container.createDBProcedure(con, "LVCC_UPDATE_KEYED_OBJECTS", PackageName);
        LVC_Container.createDBProcedure(con, "LVCC_DELETE_ALL", PackageName);
        try {
            if (TestDriver.compareRelease((String)((TestDatabaseSap)LVC_Container.getDatabase()).getKernelVersion(), (String)">", (String)"7.4.03")) {
                LVC_Container.createDBProcedure(con, "LVCC_DELETE_ALL_WITH_SUBTRANS", PackageName);
                LVC_Container.createDBProcedure(con, "LVCC_COUNT_KEYED_OBJS", PackageName);
                LVC_Container.createDBProcedure(con, "LVCC_CREATE_OBJECTS", PackageName);
            }
            if (!TestDriver.compareRelease((String)((TestDatabaseSap)LVC_Container.getDatabase()).getKernelVersion(), (String)"<", (String)"7.6.00")) {
                LVC_Container.createDBProcedure(con, "LVCC_CREATE_KEYED_OBJECT", PackageName);
                LVC_Container.createDBProcedure(con, "LVCC_LOCK_SHARE_OBJECT_BY_KEY", PackageName);
                LVC_Container.createDBProcedure(con, "LVCC_LOCK_EXCL_OBJECT_BY_KEY", PackageName);
                LVC_Container.createDBProcedure(con, "LVCC_LOCK_EXCL_WITH_TIMEOUT", PackageName);
                LVC_Container.createDBProcedure(con, "LVCC_LOCK_SHARE_WITH_TIMEOUT", PackageName);
                LVC_Container.createDBProcedure(con, "LVCC_LOCK_EXCL_NEW_CONSVIEW", PackageName);
                LVC_Container.createDBProcedure(con, "LVCC_RAND_INS_DETAIL", PackageName);
                LVC_Container.createDBProcedure(con, "LVCC_RAND_UPD_DETAIL", PackageName);
                LVC_Container.createDBProcedure(con, "LVCC_RAND_DEL_DETAIL", PackageName);
                LVC_Container.createDBProcedure(con, "LVCC_RAND_INS_MASTER", PackageName);
                LVC_Container.createDBProcedure(con, "LVCC_RAND_DEL_MASTER", PackageName);
                LVC_Container.createDBProcedure(con, "LVCC_RAND_UPD_MASTER", PackageName);
                LVC_Container.createDBProcedure(con, "LVCC_CREATE_VERSION", PackageName);
                LVC_Container.createDBProcedure(con, "LVCC_DROP_VERSION", PackageName);
                LVC_Container.createDBProcedure(con, "LVCC_ISHISTORYUSED", PackageName);
                LVC_Container.createDBProcedure(con, "LVCC_DEL_KEYED_OBJECT_BY_OID", PackageName);
                LVC_Container.createDBProcedure(con, "LVCC_DEL_KEYED_OBJECT_BY_KEY", PackageName);
                LVC_Container.createDBProcedure(con, "LVCC_GET_KEYED_OBJECT_BY_OID", PackageName);
                LVC_Container.createDBProcedure(con, "LVCC_GET_KEYED_OBJECT_BY_KEY", PackageName);
            }
        }
        catch (TestDatabaseException testDatabaseException) {
            // empty catch block
        }
        con.commit();
    }

    private static void createLvccTestUser(Connection con) throws SQLException {
        TestStatement stmt = new TestStatement(null, con);
        try {
            stmt.enableExceptions(false);
            stmt.executeUpdate("DROP USER LVC_TST");
            stmt.enableExceptions(true);
            stmt.executeUpdate("CREATE USER LVC_TST PASSWORD LVC_TST DBA NOT EXCLUSIVE");
        }
        catch (SQLException e) {
            LVC_Container.addGlobalMessage((String)"User creation", (char)'E', (String)"Could not create user LVC_CONT_TEST");
            throw e;
        }
        finally {
            con.commit();
            con.close();
        }
    }

    private static void createPackageWithFile(Connection con, String PackageName, String ProgId) throws SQLException {
        Statement stmt = con.createStatement();
        try {
            stmt.execute("DROP PACKAGE " + PackageName);
        }
        catch (SQLException e) {
            // empty catch block
        }
        stmt.execute("CREATE PACKAGE " + PackageName + " FILE '" + ProgId + "' INPROC");
    }

    private static void createPackage(Connection con, String PackageName, String ProgId) throws SQLException {
        Statement stmt = con.createStatement();
        try {
            stmt.execute("DROP PACKAGE " + PackageName);
        }
        catch (SQLException e) {
            // empty catch block
        }
        stmt.execute("CREATE PACKAGE " + PackageName + " AS '" + ProgId + "' INPROC");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void decRunningTasks() {
        LVC_Container lVC_Container = this;
        synchronized (lVC_Container) {
            --m_tasks;
        }
    }

    private static void enableVtrace(Connection con) throws SQLException {
        TestStatement stmt = new TestStatement(null, con);
        stmt.executeUpdate("DIAGNOSE VTRACE DEFAULT ON");
        stmt.executeUpdate("DIAGNOSE VTRACE OBJECT ON");
        try {
            if (TestDriver.compareRelease((String)((TestDatabaseSap)LVC_Container.getDatabase()).getKernelVersion(), (String)"<", (String)"7.6.0")) {
                stmt.executeUpdate("DIAGNOSE VTRACE CHECK 'LOG' ON");
            }
        }
        catch (TestDatabaseException testDatabaseException) {
            // empty catch block
        }
        stmt.close();
    }

    private static void evalTestSettings() {
    }

    synchronized int getRunningTasks() {
        return m_tasks;
    }

    public static String getTestClassId() {
        return "LVC_Container";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void incRunningTask() {
        LVC_Container lVC_Container = this;
        synchronized (lVC_Container) {
            ++m_tasks;
        }
    }

    public static boolean isReferenceEnabled() {
        return false;
    }

    public static boolean isSapOnly() {
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void prepare() throws TestCaseException {
        Connection con = null;
        try {
            try {
                LVC_Container.readParameters();
                String DBAUser = LVC_Container.getDatabase().getDBAUser();
                String DBAPassword = LVC_Container.getDatabase().getDBAPassword();
                TestDatabase database = LVC_Container.getDatabase();
                con = database.connect(DBAUser, DBAPassword);
                LVC_Container.enableVtrace(con);
                LVC_Container.checkLiveCache(con);
                LVC_Container.createLvccTestUser(con);
                LVC_Container.testProlog();
            }
            catch (Exception e) {
                System.out.println("Exception in prepare():" + e.getMessage());
                LVC_Container.addGlobalMessage((String)"Method prepare", (char)'E', (String)"preparation failed");
                throw new TestCaseException("Error during preparation: " + e.getClass() + e.getMessage());
            }
            Object var5_5 = null;
            if (null == con) return;
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            if (null == con) throw throwable;
            try {
                con.close();
                throw throwable;
            }
            catch (Exception e) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (Exception e) {}
        con.close();
        return;
    }

    private static void readParameters() {
        System.out.println("->readParameters");
        System.out.println("<-readParameters");
    }

    private static void restartLvccTest(Connection con) throws SQLException {
        CallableStatement call = con.prepareCall("CALL RESTART");
        call.execute();
        call.close();
    }

    public void run() {
        try {
            System.out.println("Running test LVC_Container 1.1 LiveCache " + ((TestDatabaseSap)LVC_Container.getDatabase()).getKernelVersion());
            LVC_Container.Trace(m_consoleMsg, "Running test LVC_Container 1.1 LiveCache " + ((TestDatabaseSap)LVC_Container.getDatabase()).getKernelVersion());
        }
        catch (TestDatabaseException tbe) {
            // empty catch block
        }
        MaxRunTimeTimer RunTimeTimer = new MaxRunTimeTimer(m_maxRunTime);
        this.runTest();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private boolean runTest() {
        boolean ok;
        block94: {
            Connection con;
            block87: {
                CallableStatement call1;
                Connection con2;
                block93: {
                    CallableStatement call2;
                    block92: {
                        block91: {
                            block90: {
                                block89: {
                                    block88: {
                                        CallableStatement callcount;
                                        con = null;
                                        con2 = null;
                                        PreparedStatement SelectStatement = null;
                                        ok = true;
                                        LVC_Container.evalTestSettings();
                                        this.setLcParameters();
                                        con = LVC_Container.connect();
                                        LVC_Container.enableVtrace(con);
                                        TestStatement stmt = new TestStatement(null, con);
                                        LVC_Container.Trace(m_consoleMsg, "CALL LVCC_RECREATE_SCHEMA");
                                        stmt.execute("CALL LVCC_RECREATE_SCHEMA");
                                        LVC_Container.Trace(m_consoleMsg, "CALL LVCC_REGISTER_ALL_CLASSES");
                                        stmt.execute("CALL LVCC_REGISTER_ALL_CLASSES");
                                        int numOfObj = 10000;
                                        CallableStatement callcreate = con.prepareCall("CALL LVCC_CREATE_KEYED_OBJECTS(?)");
                                        callcreate.registerOutParameter(1, 4);
                                        callcreate.setInt(1, numOfObj);
                                        LVC_Container.Trace(m_consoleMsg, "CALL LVCC_CREATE_KEYED_OBJECTS(10000)");
                                        callcreate.execute();
                                        LVC_Container.Trace(m_consoleMsg, "COMMIT");
                                        con.commit();
                                        LVC_Container.Trace(m_consoleMsg, "TEST1 >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>");
                                        LVC_Container.Trace(m_consoleMsg, "      CALL LVCC_CREATE_KEYED_OBJECTS(10000)");
                                        callcreate.execute();
                                        if (TestDriver.compareRelease((String)((TestDatabaseSap)LVC_Container.getDatabase()).getKernelVersion(), (String)">", (String)"7.4.03")) {
                                            CallableStatement callcreate2 = con.prepareCall("CALL LVCC_CREATE_OBJECTS(?)");
                                            callcreate2.registerOutParameter(1, 4);
                                            callcreate2.setInt(1, numOfObj);
                                            LVC_Container.Trace(m_consoleMsg, "      CALL LVCC_CREATE_OBJECTS(10000)");
                                            callcreate2.execute();
                                            callcount = con.prepareCall("CALL LVCC_COUNT_KEYED_OBJS(?)");
                                        } else {
                                            callcount = con.prepareCall("CALL LVCC_CREATE_KEYED_OBJECTS(?)");
                                        }
                                        if (TestDriver.compareRelease((String)((TestDatabaseSap)LVC_Container.getDatabase()).getKernelVersion(), (String)">", (String)"7.4.03")) {
                                            callcount.registerOutParameter(1, 4);
                                            callcount.setInt(1, numOfObj);
                                        }
                                        int monLcDelete = 0;
                                        int monLcDeleteStart = 0;
                                        int monLcDeleteEnd = 0;
                                        SelectStatement = con.prepareStatement("select sum(\"LC_Delete\") as DELETED from monitor_oms");
                                        ResultSet rs = SelectStatement.executeQuery();
                                        rs.next();
                                        monLcDeleteStart = rs.getInt("DELETED");
                                        Thread t = Thread.currentThread();
                                        m_stop = false;
                                        LVC_Container.Trace(m_consoleMsg, "      Start a tasks to do inserts in parallel + ROLLBACK ...");
                                        this.startTask(0, 1, m_maxRunTime * 60);
                                        LVC_Container.Trace(m_consoleMsg, "      Started ...");
                                        Thread.sleep(500L);
                                        CallableStatement calldelete = con.prepareCall("CALL LVCC_DELETE_ALL(?)");
                                        calldelete.registerOutParameter(1, 4);
                                        calldelete.setInt(1, numOfObj);
                                        LVC_Container.Trace(m_consoleMsg, "      execute LVCC_DELETE_ALL(?)");
                                        calldelete.execute();
                                        LVC_Container.Trace(m_consoleMsg, "      execute LVCC_DELETE_ALL terminated OK");
                                        while (this.getRunningTasks() > 0) {
                                            Thread.sleep(500L);
                                        }
                                        rs = SelectStatement.executeQuery();
                                        rs.next();
                                        monLcDeleteEnd = rs.getInt("DELETED");
                                        monLcDelete = monLcDeleteEnd - monLcDeleteStart;
                                        int expected_objcount = 2 * numOfObj;
                                        if (TestDriver.compareRelease((String)((TestDatabaseSap)LVC_Container.getDatabase()).getKernelVersion(), (String)">", (String)"7.4.03")) {
                                            expected_objcount = 3 * numOfObj;
                                        }
                                        if (monLcDelete != expected_objcount) {
                                            System.out.println("###omsDeleteAll Error");
                                            LVC_Container.addGlobalMessage((String)"omsDeleteAll", (char)'E', (String)"LC_Delete count is wrong");
                                            throw new TestCaseException("omsDeleteAll(1) Error expected:" + expected_objcount + " counted:" + monLcDelete);
                                        }
                                        while (this.getRunningTasks() > 0) {
                                            Thread.sleep(900L);
                                            if (m_runTimeLimit) {
                                                m_stop = true;
                                                break;
                                            }
                                            if (0 == this.sqlError()) continue;
                                            ok = false;
                                            m_stop = true;
                                            break;
                                        }
                                        m_stop = true;
                                        while (this.getRunningTasks() > 0) {
                                            Thread.sleep(900L);
                                        }
                                        if (0 != this.sqlError()) {
                                            ok = false;
                                            this.addMessage("", 'E', "SQL Error in coordinator : " + m_sqlError + " " + m_sqlErrorMsg);
                                            throw new SQLException(m_sqlErrorMsg, "", m_sqlError);
                                        }
                                        if (TestDriver.compareRelease((String)((TestDatabaseSap)LVC_Container.getDatabase()).getKernelVersion(), (String)">", (String)"7.4.03")) {
                                            callcount.execute();
                                            numOfObj = callcount.getInt(1);
                                            LVC_Container.Trace(m_consoleMsg, "      CALL LVCC_COUNT_KEYED_OBJS(?) returns:" + numOfObj);
                                        }
                                        LVC_Container.Trace(m_consoleMsg, "      ROLLBACK");
                                        con.rollback();
                                        if (TestDriver.compareRelease((String)((TestDatabaseSap)LVC_Container.getDatabase()).getKernelVersion(), (String)">", (String)"7.4.03")) {
                                            callcount.execute();
                                            numOfObj = callcount.getInt(1);
                                            LVC_Container.Trace(m_consoleMsg, "      CALL LVCC_COUNT_KEYED_OBJS(?) returns:" + numOfObj);
                                        }
                                        LVC_Container.Trace(m_consoleMsg, "TEST1 <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<");
                                        LVC_Container.Trace(m_consoleMsg, "TEST2 >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>");
                                        LVC_Container.Trace(m_consoleMsg, "      CALL LVCC_CREATE_KEYED_OBJECTS(10000)");
                                        callcreate.execute();
                                        t = Thread.currentThread();
                                        m_stop = false;
                                        LVC_Container.Trace(m_consoleMsg, "      Start a tasks to do inserts in parallel + COMMIT ...");
                                        this.startTask(0, 3, m_maxRunTime * 60);
                                        Thread.sleep(500L);
                                        try {
                                            LVC_Container.Trace(m_consoleMsg, "      execute LVCC_DELETE_ALL(?)");
                                            calldelete.execute();
                                        }
                                        catch (SQLException e) {
                                            if (-28819 != e.getErrorCode()) {
                                                throw e;
                                            }
                                            LVC_Container.Trace(m_consoleMsg, "      execute LVCC_DELETE_ALL (-28819) Obj has been updated by another trans");
                                        }
                                        LVC_Container.Trace(m_consoleMsg, "      execute LVCC_DELETE_ALL terminated OK");
                                        while (this.getRunningTasks() > 0) {
                                            Thread.sleep(1000L);
                                            if (m_runTimeLimit) {
                                                m_stop = true;
                                                break;
                                            }
                                            if (0 == this.sqlError()) continue;
                                            ok = false;
                                            m_stop = true;
                                            break;
                                        }
                                        m_stop = true;
                                        while (this.getRunningTasks() > 0) {
                                            Thread.sleep(500L);
                                        }
                                        if (0 != this.sqlError()) {
                                            ok = false;
                                            this.addMessage("", 'E', "SQL Error in coordinator : " + m_sqlError + " " + m_sqlErrorMsg);
                                            throw new SQLException(m_sqlErrorMsg, "", m_sqlError);
                                        }
                                        if (TestDriver.compareRelease((String)((TestDatabaseSap)LVC_Container.getDatabase()).getKernelVersion(), (String)">", (String)"7.4.03")) {
                                            callcount.execute();
                                            numOfObj = callcount.getInt(1);
                                            LVC_Container.Trace(m_consoleMsg, "      CALL LVCC_COUNT_KEYED_OBJS(?) returns:" + numOfObj);
                                        }
                                        LVC_Container.Trace(m_consoleMsg, "      ROLLBACK");
                                        con.rollback();
                                        if (TestDriver.compareRelease((String)((TestDatabaseSap)LVC_Container.getDatabase()).getKernelVersion(), (String)">", (String)"7.4.03")) {
                                            callcount.execute();
                                            numOfObj = callcount.getInt(1);
                                            LVC_Container.Trace(m_consoleMsg, "      CALL LVCC_COUNT_KEYED_OBJS(?) returns:" + numOfObj);
                                        }
                                        LVC_Container.Trace(m_consoleMsg, "TEST2 <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<");
                                        LVC_Container.Trace(m_consoleMsg, "TEST3 >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>");
                                        LVC_Container.Trace(m_consoleMsg, "      CALL LVCC_CREATE_KEYED_OBJECTS(10000)");
                                        callcreate.execute();
                                        t = Thread.currentThread();
                                        m_stop = false;
                                        LVC_Container.Trace(m_consoleMsg, "      Start a tasks to do updates in parallel + ROLLBACK ...");
                                        this.startTask(0, 2, m_maxRunTime * 60);
                                        Thread.sleep(500L);
                                        calldelete = con.prepareCall("CALL LVCC_DELETE_ALL(?)");
                                        calldelete.registerOutParameter(1, 4);
                                        calldelete.setInt(1, numOfObj);
                                        try {
                                            LVC_Container.Trace(m_consoleMsg, "      execute LVCC_DELETE_ALL(?)");
                                            calldelete.execute();
                                            LVC_Container.Trace(m_consoleMsg, "      execute LVCC_DELETE_ALL terminated OK");
                                        }
                                        catch (SQLException e) {
                                            if (-28819 != e.getErrorCode()) {
                                                throw e;
                                            }
                                            LVC_Container.Trace(m_consoleMsg, "      execute LVCC_DELETE_ALL (-28819) Obj has been updated by another trans OK");
                                        }
                                        while (this.getRunningTasks() > 0) {
                                            Thread.sleep(1000L);
                                            if (m_runTimeLimit) {
                                                m_stop = true;
                                                break;
                                            }
                                            if (0 == this.sqlError()) continue;
                                            ok = false;
                                            m_stop = true;
                                            break;
                                        }
                                        m_stop = true;
                                        while (this.getRunningTasks() > 0) {
                                            Thread.sleep(500L);
                                        }
                                        if (0 != this.sqlError()) {
                                            ok = false;
                                            this.addMessage("", 'E', "SQL Error in coordinator : " + m_sqlError + " " + m_sqlErrorMsg);
                                            throw new SQLException(m_sqlErrorMsg, "", m_sqlError);
                                        }
                                        if (TestDriver.compareRelease((String)((TestDatabaseSap)LVC_Container.getDatabase()).getKernelVersion(), (String)">", (String)"7.4.03")) {
                                            callcount.execute();
                                            numOfObj = callcount.getInt(1);
                                            LVC_Container.Trace(m_consoleMsg, "      CALL LVCC_COUNT_KEYED_OBJS(?) returns:" + numOfObj);
                                        }
                                        LVC_Container.Trace(m_consoleMsg, "      ROLLBACK");
                                        con.rollback();
                                        if (TestDriver.compareRelease((String)((TestDatabaseSap)LVC_Container.getDatabase()).getKernelVersion(), (String)">", (String)"7.4.03")) {
                                            callcount.execute();
                                            numOfObj = callcount.getInt(1);
                                            LVC_Container.Trace(m_consoleMsg, "      CALL LVCC_COUNT_KEYED_OBJS(?) returns:" + numOfObj);
                                        }
                                        LVC_Container.Trace(m_consoleMsg, "TEST3 <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<");
                                        LVC_Container.Trace(m_consoleMsg, "TEST4 >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>");
                                        LVC_Container.Trace(m_consoleMsg, "      CALL LVCC_CREATE_KEYED_OBJECTS(10000)");
                                        callcreate.execute();
                                        t = Thread.currentThread();
                                        m_stop = false;
                                        LVC_Container.Trace(m_consoleMsg, "      Start a tasks to do updates in parallel + COMMIT ...");
                                        this.startTask(0, 4, m_maxRunTime * 60);
                                        Thread.sleep(500L);
                                        calldelete = con.prepareCall("CALL LVCC_DELETE_ALL(?)");
                                        calldelete.registerOutParameter(1, 4);
                                        calldelete.setInt(1, numOfObj);
                                        try {
                                            LVC_Container.Trace(m_consoleMsg, "      execute LVCC_DELETE_ALL(?)");
                                            calldelete.execute();
                                        }
                                        catch (SQLException e) {
                                            if (-28819 != e.getErrorCode()) {
                                                throw e;
                                            }
                                            LVC_Container.Trace(m_consoleMsg, "      execute LVCC_DELETE_ALL (-28819) Obj has been updated by another trans");
                                        }
                                        LVC_Container.Trace(m_consoleMsg, "      execute LVCC_DELETE_ALL terminated OK");
                                        while (this.getRunningTasks() > 0) {
                                            Thread.sleep(1000L);
                                            if (m_runTimeLimit) {
                                                m_stop = true;
                                                break;
                                            }
                                            if (0 == this.sqlError()) continue;
                                            ok = false;
                                            m_stop = true;
                                            break;
                                        }
                                        m_stop = true;
                                        while (this.getRunningTasks() > 0) {
                                            Thread.sleep(500L);
                                        }
                                        if (0 != this.sqlError()) {
                                            ok = false;
                                            this.addMessage("", 'E', "SQL Error in coordinator : " + m_sqlError + " " + m_sqlErrorMsg);
                                            throw new SQLException(m_sqlErrorMsg, "", m_sqlError);
                                        }
                                        if (TestDriver.compareRelease((String)((TestDatabaseSap)LVC_Container.getDatabase()).getKernelVersion(), (String)">", (String)"7.4.03")) {
                                            callcount.execute();
                                            numOfObj = callcount.getInt(1);
                                            LVC_Container.Trace(m_consoleMsg, "      CALL LVCC_COUNT_KEYED_OBJS(?) returns:" + numOfObj);
                                        }
                                        LVC_Container.Trace(m_consoleMsg, "      ROLLBACK");
                                        con.rollback();
                                        if (TestDriver.compareRelease((String)((TestDatabaseSap)LVC_Container.getDatabase()).getKernelVersion(), (String)">", (String)"7.4.03")) {
                                            callcount.execute();
                                            numOfObj = callcount.getInt(1);
                                            LVC_Container.Trace(m_consoleMsg, "      CALL LVCC_COUNT_KEYED_OBJS(?) returns:" + numOfObj);
                                        }
                                        LVC_Container.Trace(m_consoleMsg, "TEST4 <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<");
                                        if (!TestDriver.compareRelease((String)((TestDatabaseSap)LVC_Container.getDatabase()).getKernelVersion(), (String)">", (String)"7.4.03")) break block87;
                                        LVC_Container.Trace(m_consoleMsg, "TEST5 >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>");
                                        int numObjCount = 0;
                                        numOfObj = 0;
                                        callcount.execute();
                                        numObjCount = numOfObj = callcount.getInt(1);
                                        callcount.execute();
                                        numOfObj = callcount.getInt(1);
                                        LVC_Container.Trace(m_consoleMsg, "      CALL LVCC_COUNT_KEYED_OBJS(?) returns:" + numOfObj);
                                        numOfObj = 0;
                                        CallableStatement calldeleteWST = con.prepareCall("CALL LVCC_DELETE_ALL_WITH_SUBTRANS(?)");
                                        calldeleteWST.registerOutParameter(1, 4);
                                        calldeleteWST.setInt(1, numOfObj);
                                        LVC_Container.Trace(m_consoleMsg, "      execute LVCC_DELETE_ALL_WITH_SUBTRANS(?)");
                                        calldeleteWST.execute();
                                        LVC_Container.Trace(m_consoleMsg, "      execute LVCC_DELETE_ALL_WITH_SUBTRANS terminated OK");
                                        numOfObj = 0;
                                        callcount.execute();
                                        numOfObj = callcount.getInt(1);
                                        LVC_Container.Trace(m_consoleMsg, "      CALL LVCC_COUNT_KEYED_OBJS(?) returns:" + numOfObj);
                                        LVC_Container.Trace(m_consoleMsg, "      execute LVCC_DELETE_ALL(?)");
                                        calldelete.execute();
                                        LVC_Container.Trace(m_consoleMsg, "      execute LVCC_DELETE_ALL terminated OK");
                                        callcount.execute();
                                        numOfObj = callcount.getInt(1);
                                        LVC_Container.Trace(m_consoleMsg, "      CALL LVCC_COUNT_KEYED_OBJS(?) returns:" + numOfObj);
                                        LVC_Container.Trace(m_consoleMsg, "      ROLLBACK");
                                        con.rollback();
                                        callcount.execute();
                                        numOfObj = callcount.getInt(1);
                                        LVC_Container.Trace(m_consoleMsg, "      CALL LVCC_COUNT_KEYED_OBJS(?) returns:" + numOfObj);
                                        if (numObjCount != numOfObj) {
                                            ok = false;
                                            LVC_Container.Trace(m_consoleMsg, "Test omsDeleteAll Error: ObjCount before:" + numObjCount + " after:" + numOfObj);
                                            this.addMessage("", 'E', "Rollback Error: ObjCount before:" + numObjCount + " after:" + numOfObj);
                                            throw new SQLException(m_sqlErrorMsg, "", m_sqlError);
                                        }
                                        LVC_Container.Trace(m_consoleMsg, "Test omsDeleteAll and omsRollbackSubtrans OK  Object count:" + numObjCount);
                                        LVC_Container.Trace(m_consoleMsg, "TEST5 <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<");
                                        LVC_Container.Trace(m_consoleMsg, "TEST6 >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>");
                                        numObjCount = 0;
                                        numOfObj = 0;
                                        callcount.execute();
                                        numObjCount = numOfObj = callcount.getInt(1);
                                        LVC_Container.Trace(m_consoleMsg, "      CALL LVCC_COUNT_KEYED_OBJS(?) returns:" + numOfObj);
                                        t = Thread.currentThread();
                                        m_stop = false;
                                        LVC_Container.Trace(m_consoleMsg, "      Start a tasks to do updates in parallel + ROLLBACK ...");
                                        this.startTask(0, 2, m_maxRunTime * 60);
                                        Thread.sleep(500L);
                                        numOfObj = 0;
                                        try {
                                            LVC_Container.Trace(m_consoleMsg, "      execute LVCC_DELETE_ALL_WITH_SUBTRANS(?)");
                                            calldeleteWST.execute();
                                            LVC_Container.Trace(m_consoleMsg, "      execute LVCC_DELETE_ALL_WITH_SUBTRANS terminated OK");
                                        }
                                        catch (SQLException e) {
                                            if (-28819 != e.getErrorCode()) {
                                                throw e;
                                            }
                                            LVC_Container.Trace(m_consoleMsg, "      execute LVCC_DELETE_ALL_WITH_SUBTRANS (-28819) Obj has been updated by another trans OK");
                                        }
                                        while (this.getRunningTasks() > 0) {
                                            Thread.sleep(1000L);
                                            if (m_runTimeLimit) {
                                                m_stop = true;
                                                break;
                                            }
                                            if (0 == this.sqlError()) continue;
                                            ok = false;
                                            m_stop = true;
                                            break;
                                        }
                                        m_stop = true;
                                        while (this.getRunningTasks() > 0) {
                                            Thread.sleep(500L);
                                        }
                                        numOfObj = 0;
                                        callcount.execute();
                                        numOfObj = callcount.getInt(1);
                                        LVC_Container.Trace(m_consoleMsg, "      CALL LVCC_COUNT_KEYED_OBJS(?) returns:" + numOfObj);
                                        LVC_Container.Trace(m_consoleMsg, "      ROLLBACK");
                                        con.rollback();
                                        callcount.execute();
                                        numOfObj = callcount.getInt(1);
                                        LVC_Container.Trace(m_consoleMsg, "      CALL LVCC_COUNT_KEYED_OBJS(?) returns:" + numOfObj);
                                        if (numObjCount != numOfObj) {
                                            ok = false;
                                            LVC_Container.Trace(m_consoleMsg, "Test omsDeleteAll Error: ObjCount before:" + numObjCount + " after:" + numOfObj);
                                            this.addMessage("", 'E', "Rollback Error: ObjCount before:" + numObjCount + " after:" + numOfObj);
                                            throw new SQLException(m_sqlErrorMsg, "", m_sqlError);
                                        }
                                        LVC_Container.Trace(m_consoleMsg, "TEST6 <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<");
                                        LVC_Container.Trace(m_consoleMsg, "TEST7 >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>");
                                        numObjCount = 0;
                                        numOfObj = 0;
                                        callcount.execute();
                                        numObjCount = numOfObj = callcount.getInt(1);
                                        LVC_Container.Trace(m_consoleMsg, "      CALL LVCC_COUNT_KEYED_OBJS(?) returns:" + numOfObj);
                                        t = Thread.currentThread();
                                        m_stop = false;
                                        LVC_Container.Trace(m_consoleMsg, "      Start a tasks to do inserts in parallel + COMMIT ...");
                                        this.startTask(0, 3, m_maxRunTime * 60);
                                        Thread.sleep(500L);
                                        numOfObj = 0;
                                        try {
                                            LVC_Container.Trace(m_consoleMsg, "      execute LVCC_DELETE_ALL_WITH_SUBTRANS(?)");
                                            calldeleteWST.execute();
                                            LVC_Container.Trace(m_consoleMsg, "      execute LVCC_DELETE_ALL_WITH_SUBTRANS terminated OK");
                                        }
                                        catch (SQLException e) {
                                            if (-28819 != e.getErrorCode()) {
                                                throw e;
                                            }
                                            LVC_Container.Trace(m_consoleMsg, "      execute LVCC_DELETE_ALL_WITH_SUBTRANS (-28819) Obj has been updated by another trans OK");
                                        }
                                        while (this.getRunningTasks() > 0) {
                                            Thread.sleep(1000L);
                                            if (m_runTimeLimit) {
                                                m_stop = true;
                                                break;
                                            }
                                            if (0 == this.sqlError()) continue;
                                            ok = false;
                                            m_stop = true;
                                            break;
                                        }
                                        m_stop = true;
                                        while (this.getRunningTasks() > 0) {
                                            Thread.sleep(500L);
                                        }
                                        numOfObj = 0;
                                        callcount.execute();
                                        numOfObj = callcount.getInt(1);
                                        LVC_Container.Trace(m_consoleMsg, "      CALL LVCC_COUNT_KEYED_OBJS(?) returns:" + numOfObj);
                                        LVC_Container.Trace(m_consoleMsg, "      ROLLBACK");
                                        con.rollback();
                                        callcount.execute();
                                        numOfObj = callcount.getInt(1);
                                        LVC_Container.Trace(m_consoleMsg, "      CALL LVCC_COUNT_KEYED_OBJS(?) returns:" + numOfObj);
                                        if (numObjCount + 2000 != numOfObj) {
                                            ok = false;
                                            LVC_Container.Trace(m_consoleMsg, "Test omsDeleteAll Error: ObjCount before:" + numObjCount + " after:" + numOfObj);
                                            this.addMessage("", 'E', "Rollback Error: ObjCount before:" + numObjCount + " after:" + numOfObj);
                                            throw new SQLException(m_sqlErrorMsg, "", m_sqlError);
                                        }
                                        LVC_Container.Trace(m_consoleMsg, "TEST7 <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<");
                                        if (TestDriver.compareRelease((String)((TestDatabaseSap)LVC_Container.getDatabase()).getKernelVersion(), (String)"<", (String)"7.6.0")) break block87;
                                        LVC_Container.Trace(m_consoleMsg, "TEST8 >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>");
                                        con2 = LVC_Container.connect();
                                        LVC_Container.Trace(m_consoleMsg, "session 1 - CALL LVCC_CREATE_KEYED_OBJECT(1,?)");
                                        call1 = con.prepareCall("CALL LVCC_CREATE_KEYED_OBJECT(1,?)");
                                        call1.setInt(1, 1);
                                        try {
                                            call1.execute();
                                        }
                                        catch (SQLException e) {
                                            if (-28810 == e.getErrorCode()) break block88;
                                            throw e;
                                        }
                                    }
                                    call1.close();
                                    con.commit();
                                    LVC_Container.Trace(m_consoleMsg, "session 1 - CALL LVCC_LOCK_EXCL_OBJECT_BY_KEY(1)");
                                    call1 = con.prepareCall("CALL LVCC_LOCK_EXCL_OBJECT_BY_KEY(?)");
                                    call1.setInt(1, 1);
                                    call1.execute();
                                    LVC_Container.Trace(m_consoleMsg, "session 2 - CALL LVCC_LOCK_EXCL_WITH_TIMEOUT(1,1)");
                                    call2 = con2.prepareCall("CALL LVCC_LOCK_EXCL_WITH_TIMEOUT(?,?)");
                                    call2.setInt(1, 1);
                                    call2.setInt(2, 1);
                                    try {
                                        call2.execute();
                                    }
                                    catch (SQLException e) {
                                        if (-51 == e.getErrorCode()) break block89;
                                        ok = false;
                                        LVC_Container.Trace(m_consoleMsg, "LVCC_LOCK_EXCL_WITH_TIMEOUT(?,?) Error:" + e.getErrorCode());
                                        this.addMessage("", 'E', "LVCC_LOCK_EXCL_WITH_TIMEOUT(?,?) Error:" + e.getErrorCode());
                                        throw e;
                                    }
                                }
                                call2.close();
                                LVC_Container.Trace(m_consoleMsg, "session 2 - CALL LVCC_LOCK_SHARE_WITH_TIMEOUT(1,1)");
                                call2 = con2.prepareCall("CALL LVCC_LOCK_SHARE_WITH_TIMEOUT(?,?)");
                                call2.setInt(1, 1);
                                call2.setInt(2, 1);
                                try {
                                    call2.execute();
                                }
                                catch (SQLException e) {
                                    if (-51 == e.getErrorCode()) break block90;
                                    ok = false;
                                    LVC_Container.Trace(m_consoleMsg, "LVCC_LOCK_EXCL_WITH_TIMEOUT(?,?) Error:" + e.getErrorCode());
                                    this.addMessage("", 'E', "LVCC_LOCK_SHARE_WITH_TIMEOUT(?,?) Error:" + e.getErrorCode());
                                    throw e;
                                }
                            }
                            call2.close();
                            call1.close();
                            con.rollback();
                            con2.rollback();
                            LVC_Container.Trace(m_consoleMsg, "session 1 + 2 - ROLLBACK");
                            LVC_Container.Trace(m_consoleMsg, "session 1 - CALL LVCC_LOCK_SHARE_OBJECT_BY_KEY(1)");
                            call1 = con.prepareCall("CALL LVCC_LOCK_SHARE_OBJECT_BY_KEY(?)");
                            call1.setInt(1, 1);
                            call1.execute();
                            LVC_Container.Trace(m_consoleMsg, "session 2 - CALL LVCC_LOCK_EXCL_WITH_TIMEOUT(1,1)");
                            call2 = con2.prepareCall("CALL LVCC_LOCK_EXCL_WITH_TIMEOUT(?,?)");
                            call2.setInt(1, 1);
                            call2.setInt(2, 1);
                            try {
                                call2.execute();
                            }
                            catch (SQLException e) {
                                if (-51 == e.getErrorCode()) break block91;
                                ok = false;
                                LVC_Container.Trace(m_consoleMsg, "LVCC_LOCK_EXCL_WITH_TIMEOUT(?,?) Error:" + e.getErrorCode());
                                this.addMessage("", 'E', "LVCC_LOCK_EXCL_WITH_TIMEOUT(?,?) Error:" + e.getErrorCode());
                                throw e;
                            }
                        }
                        call2.close();
                        LVC_Container.Trace(m_consoleMsg, "session 2 - CALL LVCC_LOCK_SHARE_WITH_TIMEOUT(1,1)");
                        call2 = con2.prepareCall("CALL LVCC_LOCK_SHARE_WITH_TIMEOUT(?,?)");
                        call2.setInt(1, 1);
                        call2.setInt(2, 1);
                        try {
                            call2.execute();
                        }
                        catch (SQLException e) {
                            ok = false;
                            LVC_Container.Trace(m_consoleMsg, "LVCC_LOCK_EXCL_WITH_TIMEOUT(?,?) Error:" + e.getErrorCode());
                            this.addMessage("", 'E', "LVCC_LOCK_SHARE_WITH_TIMEOUT(?,?) Error:" + e.getErrorCode());
                            throw e;
                        }
                        call2.close();
                        LVC_Container.Trace(m_consoleMsg, "session 2 - CALL LVCC_LOCK_EXCL_WITH_TIMEOUT(1,1)");
                        call2 = con2.prepareCall("CALL LVCC_LOCK_EXCL_WITH_TIMEOUT(?,?)");
                        call2.setInt(1, 1);
                        call2.setInt(2, 1);
                        try {
                            call2.execute();
                        }
                        catch (SQLException e) {
                            if (-51 == e.getErrorCode()) break block92;
                            ok = false;
                            LVC_Container.Trace(m_consoleMsg, "LVCC_LOCK_EXCL_WITH_TIMEOUT(?,?) Error:" + e.getErrorCode());
                            this.addMessage("", 'E', "LVCC_LOCK_EXCL_WITH_TIMEOUT(?,?) Error:" + e.getErrorCode());
                            throw e;
                        }
                    }
                    call2.close();
                    call1.close();
                    LVC_Container.Trace(m_consoleMsg, "session 1 - ROLLBACK");
                    con.rollback();
                    LVC_Container.Trace(m_consoleMsg, "session 1 - CALL LVCC_LOCK_EXCL_WITH_TIMEOUT(1,1)");
                    call1 = con.prepareCall("CALL LVCC_LOCK_EXCL_WITH_TIMEOUT(?,?)");
                    call1.setInt(1, 1);
                    call1.setInt(2, 1);
                    try {
                        call1.execute();
                    }
                    catch (SQLException e) {
                        if (-51 == e.getErrorCode()) break block93;
                        ok = false;
                        LVC_Container.Trace(m_consoleMsg, "LVCC_LOCK_EXCL_WITH_TIMEOUT(?,?) Error:" + e.getErrorCode());
                        this.addMessage("", 'E', "LVCC_LOCK_EXCL_WITH_TIMEOUT(?,?) Error:" + e.getErrorCode());
                        throw e;
                    }
                }
                LVC_Container.Trace(m_consoleMsg, "session 1 - CALL LVCC_LOCK_SHARE_OBJECT_BY_KEY(1)");
                call1 = con.prepareCall("CALL LVCC_LOCK_SHARE_OBJECT_BY_KEY(?)");
                call1.setInt(1, 1);
                call1.execute();
                call1.close();
                LVC_Container.Trace(m_consoleMsg, "session 1 + 2 - ROLLBACK");
                con.rollback();
                con2.rollback();
                LVC_Container.Trace(m_consoleMsg, "TEST9 share locks  >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>");
                m_stop = false;
                if (!m_stop) {
                    for (int i = 0; i < 5; ++i) {
                        LVC_Container.Trace(m_consoleMsg, "      Start a tasks " + i + " to check share-locks ...");
                        this.startTask(i, 5, m_maxRunTime);
                    }
                    while (this.getRunningTasks() > 0) {
                        Thread.sleep(100L);
                        if (m_runTimeLimit) {
                            m_stop = true;
                            break;
                        }
                        if (0 == this.sqlError()) continue;
                        ok = false;
                        m_stop = true;
                        break;
                    }
                    m_stop = true;
                }
                while (this.getRunningTasks() > 0) {
                    Thread.sleep(100L);
                }
                LVC_Container.Trace(m_consoleMsg, "TEST8 share locks  <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<");
            }
            Object var23_39 = null;
            try {
                if (con != null && !con.isClosed()) {
                    con.close();
                }
                break block94;
            }
            catch (Exception e2) {}
            break block94;
            {
                catch (Exception e) {
                    m_stop = true;
                    int maxLoops = 100;
                    while (this.getRunningTasks() > 0 && maxLoops > 0) {
                        --maxLoops;
                        try {
                            Thread.sleep(500L);
                        }
                        catch (Exception any) {}
                    }
                    ok = false;
                    e.printStackTrace();
                    LVC_Container.abort();
                    this.handleExceptions(e);
                    Object var23_40 = null;
                    try {
                        if (con != null && !con.isClosed()) {
                            con.close();
                        }
                        break block94;
                    }
                    catch (Exception e2) {}
                }
            }
            catch (Throwable throwable) {
                Object var23_41 = null;
                try {
                    if (con != null && !con.isClosed()) {
                        con.close();
                    }
                }
                catch (Exception e2) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        return ok;
    }

    synchronized void setGlobalSqlError(SQLException e) {
        if (0 == m_sqlError) {
            m_sqlError = e.getErrorCode();
            m_sqlErrorMsg = e.getMessage();
        }
    }

    private void setLcParameters() throws TestDatabaseException {
    }

    synchronized int sqlError() {
        return m_sqlError;
    }

    void startGarbageCollectors(Connection con) throws SQLException {
        TestStatement stmt = new TestStatement(null, con);
        stmt.executeUpdate("DELETE OBJECT STORAGE");
    }

    private void startTask(int processId, int test, int sleepDuration) throws SQLException, TestDatabaseException {
        this.incRunningTask();
        Task task = new Task(processId, test, sleepDuration);
    }

    private static void testProlog() throws SQLException, TestDatabaseException {
        Connection con = LVC_Container.connect();
        String Package2 = "LVCC_CONTAINER";
        if (TestDriver.compareRelease((String)((TestDatabaseSap)TestCase.getDatabase()).getKernelVersion(), (String)">=", (String)"7.4.4")) {
            LVC_Container.createPackageWithFile(con, Package2, "lccontainer");
        } else {
            LVC_Container.createPackage(con, Package2, "livecache.lccontainer.V001");
        }
        LVC_Container.createDBProcedures(con, Package2);
        con.commit();
        con.close();
    }

    private static void Trace(boolean consoleMsg, String msg) {
        if (consoleMsg) {
            System.out.println(msg);
        }
        LVC_Container.addGlobalMessage((String)"", (char)'I', (String)msg);
    }

    private void TraceError(String msg) {
        if (m_consoleMsg) {
            System.out.println(msg);
        }
        this.addMessage("Error", 'E', msg);
    }

    static {
        m_consoleMsg = true;
        m_maxRunTime = 4;
    }

    class Task
    extends LvccTest
    implements Runnable {
        Task(int processId, int test, int sleepDuration) throws SQLException, TestDatabaseException {
            Thread t = new Thread(this);
            this.m_processId = processId;
            this.m_test = test;
            if (sleepDuration <= 0) {
                sleepDuration = 1;
            }
            this.m_sleep = sleepDuration;
            t.setDaemon(true);
            t.start();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                Thread t = Thread.currentThread();
                this.threadConnect();
                CallableStatement call = null;
                TestStatement stmt = new TestStatement(null, this.m_connection);
                stmt.execute("CALL LVCC_REGISTER_ALL_CLASSES");
                switch (this.m_test) {
                    case 5: 
                    case 6: 
                    case 7: 
                    case 8: {
                        boolean bCommit = true;
                        int i = 0;
                        boolean j = false;
                        try {
                            while (!m_stop) {
                                if (++i > 15) {
                                    i = 1;
                                }
                                switch (i) {
                                    case 1: 
                                    case 13: {
                                        call = this.m_connection.prepareCall("CALL LVCC_RAND_UPD_MASTER(?)");
                                        call.setInt(1, 3);
                                        call.execute();
                                        break;
                                    }
                                    case 3: {
                                        call = this.m_connection.prepareCall("CALL LVCC_RAND_INS_MASTER(?)");
                                        call.setInt(1, 2);
                                        call.execute();
                                        break;
                                    }
                                    case 5: 
                                    case 8: 
                                    case 11: {
                                        call = this.m_connection.prepareCall("CALL LVCC_RAND_INS_DETAIL(?)");
                                        call.setInt(1, 20);
                                        call.execute();
                                        break;
                                    }
                                    case 4: 
                                    case 7: 
                                    case 15: {
                                        call = this.m_connection.prepareCall("CALL LVCC_RAND_DEL_DETAIL(?)");
                                        call.setInt(1, 20);
                                        call.execute();
                                        break;
                                    }
                                    default: {
                                        call = this.m_connection.prepareCall("CALL LVCC_RAND_UPD_DETAIL(?,?)");
                                        call.setInt(1, 20);
                                        call.registerOutParameter(1, 4);
                                        call.execute();
                                    }
                                }
                                if (bCommit) {
                                    this.m_connection.commit();
                                    bCommit = false;
                                    continue;
                                }
                                this.m_connection.rollback();
                                bCommit = true;
                            }
                            break;
                        }
                        catch (SQLException sql_e) {
                            if (sql_e.getErrorCode() == -708) break;
                            this.setSqlError(sql_e);
                            break;
                        }
                    }
                    case 1: 
                    case 3: {
                        call = this.m_connection.prepareCall("CALL LVCC_CREATE_KEYED_OBJECTS(?)");
                        call.registerOutParameter(1, 4);
                        call.setInt(1, 1000);
                        LVC_Container.Trace(m_consoleMsg, " -TI- CALL LVCC_CREATE_KEYED_OBJECTS(1000)");
                        call.execute();
                        Thread.sleep(5L);
                        LVC_Container.Trace(m_consoleMsg, " -TI- CALL LVCC_CREATE_KEYED_OBJECTS(1000)");
                        call.execute();
                        if (1 == this.m_test) {
                            LVC_Container.Trace(m_consoleMsg, " -TI- ROLLBACK");
                            this.m_connection.rollback();
                            break;
                        }
                        LVC_Container.Trace(m_consoleMsg, " -TI- COMMIT");
                        this.m_connection.commit();
                        break;
                    }
                    case 2: 
                    case 4: {
                        call = this.m_connection.prepareCall("CALL LVCC_UPDATE_KEYED_OBJECTS");
                        LVC_Container.Trace(m_consoleMsg, " -TU- CALL LVCC_UPDATE_KEYED_OBJECTS(1000)");
                        call.execute();
                        Thread.sleep(5L);
                        LVC_Container.Trace(m_consoleMsg, " -TU- CALL LVCC_UPDATE_KEYED_OBJECTS(1000)");
                        call.execute();
                        if (2 == this.m_test) {
                            LVC_Container.Trace(m_consoleMsg, " -TU- ROLLBACK");
                            this.m_connection.rollback();
                            break;
                        }
                        LVC_Container.Trace(m_consoleMsg, " -TU- COMMIT");
                        this.m_connection.commit();
                    }
                }
                this.m_connection.close();
            }
            catch (SQLException sql_e) {
                this.setSqlError(sql_e);
            }
            catch (Exception e) {
                this.exceptionHandler(e);
            }
            finally {
                this.closeConnection();
            }
        }
    }

    class MaxRunTimeTimer
    implements Runnable {
        private int m_intervall = 0;
        private Thread m_thread = null;

        MaxRunTimeTimer(int intervall) {
            this.m_intervall = intervall * 60000;
            this.start();
        }

        public void run() {
            try {
                Thread.sleep(this.m_intervall);
            }
            catch (Exception exception) {
                // empty catch block
            }
            m_runTimeLimit = true;
        }

        public void start() {
            this.m_thread = new Thread(this);
            this.m_thread.setDaemon(true);
            this.m_thread.start();
        }
    }

    abstract class LvccTest {
        Connection m_connection = null;
        int m_processId = -1;
        int m_sleep = 0;
        int m_test = 0;
        private String m_currVersion = "DummyVersion";

        LvccTest() {
        }

        protected void exceptionHandler(Exception e) {
            LVC_Container.this.TraceError("Unknown exception in task " + this.m_processId + " " + e.getClass() + " " + e.getMessage());
            e.printStackTrace();
            LVC_Container.abort();
        }

        protected void setSqlError(SQLException e) {
            LVC_Container.this.TraceError("SQL Error in Task " + this.m_processId + " : " + e.getErrorCode() + " " + e.getMessage() + " " + e.getSQLState());
            LVC_Container.this.setGlobalSqlError(e);
        }

        protected void closeConnection() {
            try {
                if (null != this.m_connection) {
                    this.m_connection.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            LVC_Container.this.decRunningTasks();
        }

        protected boolean sqlExecuteCall(CallableStatement call) throws SQLException {
            boolean ok = true;
            try {
                call.execute();
            }
            catch (SQLException e) {
                ok = false;
                int error = e.getErrorCode();
                throw e;
            }
            return ok;
        }

        protected void threadConnect() throws TestDatabaseException, SQLException {
            try {
                this.m_connection = LVC_Container.connect();
            }
            catch (Exception e) {
                this.exceptionHandler(e);
            }
        }
    }
}

