/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sapdb.lctest;

import com.sap.sapdb.lctest.LCRecoverTest;
import com.sap.sapdb.testframe.driver.TestDatabaseException;
import com.sap.sapdb.testframe.driver.TestDatabaseSap;
import com.sap.sapdb.testframe.driver.TestDriver;
import com.sap.sapdb.testframe.testcase.TestCaseException;
import java.sql.SQLException;

public class LCRecoverTest1
extends LCRecoverTest {
    public static void cleanUp() throws TestCaseException {
        LCRecoverTest.cleanUp();
    }

    public static void prepare() throws TestCaseException {
        LCRecoverTest.prepare();
    }

    public void run() {
        try {
            int key = this.getNextKey();
            String schemaName = "LCSCHEMA1";
            int containerNumber = 1;
            TestDatabaseSap sapdb = (TestDatabaseSap)LCRecoverTest1.getDatabase();
            this.executeDBMCmd("util_connect");
            this.executeDBMCmd("backup_media_put lcrt1 lcrt1 FILE DATA 0 8 YES NO ");
            this.executeDBMCmd("util_release");
            LCRecoverTest1.addGlobalMessage((String)"LCRecoverTest1", (char)'I', (String)"--> Just created backup media (FILE lcrt1)!");
            this.prDropSchema(1, schemaName, 0);
            this.prCommit(1);
            LCRecoverTest1.addGlobalMessage((String)"LCRecoverTest1", (char)'I', (String)"--> Creating schema!");
            this.prCreateSchema(1, schemaName);
            LCRecoverTest1.addGlobalMessage((String)"LCRecoverTest1", (char)'I', (String)"--> Creating keyed container!");
            this.prCreateKeyedContainer(1, schemaName, containerNumber);
            this.prCommit(1);
            this.executeDBMCmd("util_connect");
            this.executeDBMCmd("backup_save lcrt1 DATA");
            this.executeDBMCmd("util_release");
            LCRecoverTest1.addGlobalMessage((String)"LCRecoverTest1", (char)'I', (String)"--> Just performed backup_save lcrt1 DATA!");
            LCRecoverTest1.addGlobalMessage((String)"LCRecoverTest1", (char)'I', (String)"--> Creating 50 keyed objects!");
            this.prCreateKeyedObjects(1, schemaName, 50);
            this.prCommit(1);
            LCRecoverTest1.addGlobalMessage((String)"LCRecoverTest1", (char)'I', (String)"--> Deleting 50 keyed objects!");
            this.prDeleteKeyedObjects(1, schemaName, containerNumber, 50);
            this.prCommit(1);
            LCRecoverTest1.addGlobalMessage((String)"LCRecoverTest1", (char)'I', (String)"--> Creating 100 keyed objects!");
            this.prCreateKeyedObjects(1, schemaName, 100);
            this.prCommit(1);
            LCRecoverTest1.addGlobalMessage((String)"LCRecoverTest1", (char)'I', (String)"--> Updating 100 keyed objects!");
            this.prUpdateKeyedObjects(1, schemaName, containerNumber, 100, 20);
            this.prCommit(1);
            LCRecoverTest1.addGlobalMessage((String)"LCRecoverTest1", (char)'I', (String)"LCRecoverTest1 --> Going to check checksums!");
            this.prSumAllKeyedObjects(1, schemaName, containerNumber, 2000, 0);
            this.executeDBMCmd("db_offline");
            LCRecoverTest1.addGlobalMessage((String)"LCRecoverTest1", (char)'I', (String)"--> Just performed db_offline!");
            this.executeDBMCmd("db_warm -" + sapdb.getKernelMode());
            LCRecoverTest1.addGlobalMessage((String)"LCRecoverTest1", (char)'I', (String)("--> Just performed db_warm -" + sapdb.getKernelMode() + "!"));
            this.prReconnect(1);
            this.prCreateKeyedContainer(1, schemaName, containerNumber);
            LCRecoverTest1.addGlobalMessage((String)"LCRecoverTest1", (char)'I', (String)"--> Going to check checksums after NORMAL restart!");
            this.prSumAllKeyedObjects(1, schemaName, containerNumber, 2000, 0);
            this.executeDBMCmd("db_offline");
            LCRecoverTest1.addGlobalMessage((String)"LCRecoverTest1", (char)'I', (String)"--> Just performed db_offline!");
            this.executeDBMCmd("db_cold");
            LCRecoverTest1.addGlobalMessage((String)"LCRecoverTest1", (char)'I', (String)"--> Just performed db_cold!");
            this.executeDBMCmd("util_connect");
            LCRecoverTest1.addGlobalMessage((String)"LCRecoverTest1", (char)'I', (String)"--> Just performed util_connect!");
            this.executeDBMCmd("util_execute diagnose vtrace default on");
            LCRecoverTest1.addGlobalMessage((String)"LCRecoverTest1", (char)'I', (String)"--> Just performed util_execute diagnose vtrace default on!");
            this.executeDBMCmd("util_execute diagnose vtrace object on");
            LCRecoverTest1.addGlobalMessage((String)"LCRecoverTest1", (char)'I', (String)"--> Just performed util_execute diagnose vtrace object on!");
            this.executeDBMCmd("backup_restore lcrt1 DATA");
            LCRecoverTest1.addGlobalMessage((String)"LCRecoverTest1", (char)'I', (String)"--> Just performed backup_restore lcrt1 DATA!");
            if (!TestDriver.compareRelease((String)((TestDatabaseSap)LCRecoverTest1.getDatabase()).getKernelVersion(), (String)">=", (String)"7.6.0")) {
                this.executeDBMCmd("util_execute diagnose vtrace topic 'log' on");
                LCRecoverTest1.addGlobalMessage((String)"LCRecoverTest1", (char)'I', (String)"--> Just performed util_execute diagnose vtrace topic 'log' on ");
            }
            this.executeDBMCmd("db_warm -" + sapdb.getKernelMode());
            LCRecoverTest1.addGlobalMessage((String)"LCRecoverTest1", (char)'I', (String)("--> Just performed db_warm -" + sapdb.getKernelMode() + "!"));
            this.executeDBMCmd("util_release");
            LCRecoverTest1.addGlobalMessage((String)"LCRecoverTest1", (char)'I', (String)"--> Just performed util_release!");
            this.prReconnect(1);
            this.prCreateKeyedContainer(1, schemaName, containerNumber);
            LCRecoverTest1.addGlobalMessage((String)"LCRecoverTest1", (char)'I', (String)"--> Going to check checksums after BACKUP restart!");
            this.prSumAllKeyedObjects(1, schemaName, containerNumber, 2000, 0);
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
        }
    }
}

