/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sapdb.lctest;

import com.sap.sapdb.testframe.driver.TestDatabaseException;
import com.sap.sapdb.testframe.driver.TestDriver;
import com.sap.sapdb.testframe.testcase.TestCase;
import com.sap.sapdb.testframe.testcase.TestCaseException;
import com.sap.sapdb.testframe.utilities.Execute;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.ListIterator;

public class AbapStream
extends TestCase {
    private static String sTestCaller;
    private static String sFileSep;
    private static boolean sTrace;
    private static int sTimeout;
    private static ArrayList sTableSizeList;

    private int execSingleTest() {
        int rc;
        String cmd = sTestCaller;
        StringBuffer sb = sTrace ? new StringBuffer() : null;
        Execute exc = new Execute(cmd, null, sb);
        exc.setErrPrefix("STDERR ");
        exc.setOutPrefix("STDOUT ");
        exc.setTimeout(sTimeout);
        exc.exec();
        if (exc.isDestroyed()) {
            this.addMessage("", 'W', "Subprocess: " + cmd + " has been destroyed after timeout");
            System.out.println(" Subprocess: has been destroyed after timeout");
        }
        if ((rc = exc.getExitValue()) == 0) {
            this.addMessage("", 'I', cmd + " successful!");
        } else {
            this.addMessage("", 'E', cmd + " => RC = " + rc);
            System.out.println(" => RC = " + rc);
        }
        if (sb != null) {
            this.addMessage("", 'I', sb.toString());
        }
        return rc;
    }

    private int execSingleTest(String pCmd, int pNumber, int pMaxNumber) {
        int rc;
        String cmd = sTestCaller + " -s " + pCmd;
        System.out.print("Running " + pNumber + "(" + pMaxNumber + "): Table size " + pCmd);
        StringBuffer sb = sTrace ? new StringBuffer() : null;
        Execute exc = new Execute(cmd, null, sb);
        exc.setErrPrefix("STDERR ");
        exc.setOutPrefix("STDOUT ");
        exc.setTimeout(sTimeout);
        exc.exec();
        if (exc.isDestroyed()) {
            this.addMessage("", 'W', "Subprocess: " + cmd + " has been destroyed after timeout");
            System.out.println(" Subprocess: has been destroyed after timeout");
        }
        if ((rc = exc.getExitValue()) == 0) {
            this.addMessage("", 'I', cmd + " successful!");
            System.out.println(" successful!");
        } else {
            this.addMessage("", 'E', cmd + " => RC = " + rc);
            System.out.println(" => RC = " + rc);
        }
        if (sb != null) {
            this.addMessage("", 'I', sb.toString());
        }
        return rc;
    }

    public static void prepare() throws TestCaseException {
        String jtestRoot = TestDriver.getJTestRoot();
        String trace = AbapStream.getParameterString((String)"TRACE", (String)"ON");
        sTrace = trace.equalsIgnoreCase("ON") ? Boolean.TRUE.booleanValue() : Boolean.FALSE.booleanValue();
        sTimeout = AbapStream.getParameterInt((String)"TIMEOUT", (int)3000);
        sTableSizeList = AbapStream.getUnnamedParameterList();
        sFileSep = System.getProperty("file.separator");
        StringBuffer sb = new StringBuffer();
        sb.append(jtestRoot);
        sb.append(sFileSep);
        sb.append("tests");
        sb.append(sFileSep);
        sb.append("lcparamtest");
        sb.append(" -d ");
        sb.append(AbapStream.getDatabase().getName());
        sb.append(" -n ");
        sb.append(AbapStream.getDatabase().getHost());
        sb.append(":");
        sb.append(AbapStream.getDatabase().getPort());
        sb.append(" -u ");
        sb.append(AbapStream.getDatabase().getDBAUser().toUpperCase());
        sb.append(',');
        sb.append(AbapStream.getDatabase().getDBAPassword().toUpperCase());
        sTestCaller = sb.toString();
    }

    public void run() {
        if (sTableSizeList == null) {
            this.execSingleTest();
        } else if (sTableSizeList.isEmpty()) {
            this.execSingleTest();
        } else {
            ListIterator it = sTableSizeList.listIterator();
            int counter = 0;
            int totalNumber = sTableSizeList.size();
            while (it.hasNext()) {
                this.execSingleTest(((String)it.next()).trim(), ++counter, totalNumber);
            }
        }
    }

    static {
        sTrace = false;
        sTimeout = 0;
        sTableSizeList = null;
    }
}

