/*
 * Decompiled with CFR 0.152.
 */
package com.stevesoft.pat.wrap;

import com.stevesoft.pat.BasicStringBufferLike;
import com.stevesoft.pat.Regex;
import com.stevesoft.pat.StringLike;
import com.stevesoft.pat.wrap.StringBufferWrap;
import java.io.IOException;
import java.io.RandomAccessFile;

public class RandomAccessFileWrap
implements StringLike {
    long offset;
    RandomAccessFile raf;
    int i0;
    int iend;
    byte[] buf = new byte[1024];

    public void setOffset(long l) {
        this.offset = l;
        this.iend = 0;
        this.i0 = 0;
    }

    public long getOffset() {
        return this.offset;
    }

    public int getBufferSize() {
        return this.buf.length;
    }

    public void setBufferSize(int n) {
        this.buf = new byte[n];
        this.iend = 0;
        this.i0 = 0;
    }

    public RandomAccessFileWrap(String string) throws IOException {
        this.raf = new RandomAccessFile(string, "r");
    }

    public RandomAccessFileWrap(RandomAccessFile randomAccessFile) {
        this.raf = randomAccessFile;
    }

    public char charAt(int n) {
        if (n >= this.i0 && n < this.iend) {
            return (char)this.buf[n - this.i0];
        }
        try {
            this.i0 = n - 5;
            if (this.i0 < 0) {
                this.i0 = 0;
            }
            this.raf.seek((long)this.i0 + this.offset);
            this.iend = this.i0 + this.raf.read(this.buf, 0, this.buf.length);
            if (n >= this.i0 && n < this.iend) {
                return (char)this.buf[n - this.i0];
            }
        }
        catch (Throwable throwable) {}
        throw new ArrayIndexOutOfBoundsException("Out of bounds for file: i=" + n + ", Final Buffer: i0=" + this.i0 + " iend=" + this.iend);
    }

    public String toString() {
        throw new Error("Not implemented");
    }

    public int length() {
        try {
            long l = this.raf.length() - this.offset;
            if (l > Integer.MAX_VALUE) {
                return Integer.MAX_VALUE;
            }
            return (int)l;
        }
        catch (IOException iOException) {
            return 0;
        }
    }

    public String substring(int n, int n2) {
        StringBuffer stringBuffer = new StringBuffer();
        int n3 = n;
        while (n3 < n2) {
            stringBuffer.append(this.charAt(n3));
            ++n3;
        }
        return stringBuffer.toString();
    }

    public Object unwrap() {
        return this.raf;
    }

    public static void main(String[] stringArray) throws IOException {
        int n = 0;
        while (n < stringArray.length) {
            RandomAccessFileWrap randomAccessFileWrap = new RandomAccessFileWrap(new RandomAccessFile(stringArray[n], "r"));
            Regex regex = new Regex("toString\\(\\) *(?@{})");
            regex.setGFlag(true);
            regex.optimize();
            System.out.print(String.valueOf(stringArray[n]) + " ");
            int n2 = 0;
            do {
                if (regex.searchFrom(randomAccessFileWrap, n2)) {
                    System.out.println("Matched at index: " + regex.matchedFrom());
                    n2 = regex.matchedTo();
                } else {
                    System.out.println("not found");
                }
                System.out.println(regex.stringMatched());
            } while (regex.didMatch());
            ++n;
        }
    }

    public BasicStringBufferLike newStringBufferLike() {
        return new StringBufferWrap();
    }

    public int indexOf(char c) {
        int n = 0;
        while (n < this.length()) {
            if (this.charAt(n) == c) {
                return n;
            }
            ++n;
        }
        return -1;
    }
}

