/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dbtechtest.jdbc.types;

import com.sap.dbtechtest.jdbc.types.myInputStream;
import com.sap.dbtechtest.util.options.OptionDesc;
import com.sap.dbtechtest.util.testdriver.Test;
import java.io.InputStream;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

public class EndlessInputStream
extends Test {
    private static final String help = "help for EndlessInputStream";
    private static final OptionDesc[] optdesc = new OptionDesc[0];

    public EndlessInputStream(String[] stringArray) throws SQLException {
        super(optdesc, help, stringArray);
    }

    public EndlessInputStream(Test test) throws SQLException {
        super(test);
    }

    public void testRun() throws SQLException {
        String string = "EndlessInputStream";
        String string2 = this.getUnicodeIdentifier(string);
        this.dropTable(string2);
        this.stmt.execute("CREATE TABLE " + string2 + " (a long byte, b long ascii)");
        PreparedStatement preparedStatement = this.connection.prepareStatement("Insert into " + string2 + " values (?,?)");
        preparedStatement.setBinaryStream(1, (InputStream)new myInputStream(), 10);
        preparedStatement.setAsciiStream(2, (InputStream)new myInputStream(), 10);
        preparedStatement.executeUpdate();
        preparedStatement.setBinaryStream(1, (InputStream)new myInputStream(), -1);
        preparedStatement.setAsciiStream(2, (InputStream)new myInputStream(), -1);
        preparedStatement.executeUpdate();
        this.connection.commit();
        ResultSet resultSet = this.stmt.executeQuery("Select * from " + string2);
        resultSet.next();
        this.log.addDifference(string, "Checking length of long value", new Long(10L), new Long(resultSet.getBlob(1).length()));
        this.log.addDifference(string, "Checking length of long value", new Long(10L), new Long(resultSet.getClob(2).length()));
        resultSet.next();
        this.log.addDifference(string, "Checking length of long value", new Long(100L), new Long(resultSet.getBlob(1).length()));
        this.log.addDifference(string, "Checking length of long value", new Long(100L), new Long(resultSet.getClob(2).length()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] stringArray) throws SQLException {
        EndlessInputStream endlessInputStream = new EndlessInputStream(stringArray);
        try {
            endlessInputStream.runInner();
        }
        finally {
            endlessInputStream.connection.close();
        }
        if (endlessInputStream.log.hasErrors()) {
            System.exit(5);
        }
    }
}

