/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dbtechtest.jdbc.types;

import com.sap.dbtechtest.jdbc.types.ConversionTest;
import com.sap.dbtechtest.jdbc.types.ConversionTestCase;
import com.sap.dbtechtest.jdbc.types.EqualityTestCase;
import com.sap.dbtechtest.jdbc.types.InputConversionFailureCase;
import com.sap.dbtechtest.jdbc.types.OutputConversionFailureCase;
import com.sap.dbtechtest.util.options.OptionDesc;
import com.sap.dbtechtest.util.options.StringOption;
import com.sap.dbtechtest.util.testdriver.Test;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;

public class DateTest
extends ConversionTest {
    private static final String help = "help for DateTest";
    private static final OptionDesc[] optdesc = new OptionDesc[]{new StringOption("sqlcol", "sql column definition", "DATE", null)};
    private final ConversionTestCase[] insertTests = new ConversionTestCase[]{new EqualityTestCase("Array", null).setInsertException(JDBCDriverExceptionClass), new EqualityTestCase("BigDecimal", null), new InputConversionFailureCase("BigDecimal", new BigDecimal(1.0)), new InputConversionFailureCase("Boolean", Boolean.TRUE), new InputConversionFailureCase("Boolean", Boolean.FALSE), new InputConversionFailureCase("Byte", new Byte(1)), (ConversionTestCase)new EqualityTestCase("Bytes", "2000-01-01".getBytes()).knownBug(""), new EqualityTestCase("Date", new Date(100, 0, 1)), (ConversionTestCase)new EqualityTestCase("Date", new Date(-901, 0, 1)).bugFixed("PTS1111441"), new InputConversionFailureCase("Double", new Double(1.1)), new InputConversionFailureCase("Float", new Float(111.111f)), new InputConversionFailureCase("Int", new Integer(3)), new InputConversionFailureCase("Long", new Long(4L)), new EqualityTestCase("Object", "2000-01-01", new Date(100, 0, 1)), new EqualityTestCase("Object", new Date(100, 0, 1)), new EqualityTestCase("Ref", null).setInsertException(JDBCDriverExceptionClass), new InputConversionFailureCase("Short", new Short(5)), new EqualityTestCase("String", "2000-01-01", new Date(100, 0, 1)), (ConversionTestCase)new EqualityTestCase("String", "2000-02-30", new Date(100, 2, 0)).setInsertException(ConversionExceptionClass).knownBug(""), new InputConversionFailureCase("Time", new Time(12, 0, 0)), new EqualityTestCase("Timestamp", new Timestamp(100, 0, 1, 0, 0, 0, 0), new Date(100, 0, 1)), new EqualityTestCase("Timestamp", new Timestamp(100, 0, 1, 12, 0, 0, 500), new Date(100, 0, 1))};
    private final ConversionTestCase[] fetchTests = new ConversionTestCase[]{new EqualityTestCase("Array", null).setFetchException(JDBCDriverExceptionClass), new OutputConversionFailureCase("BigDecimal", new Date(100, 0, 1)), new OutputConversionFailureCase("Boolean", new Date(100, 0, 1)), new OutputConversionFailureCase("Byte", new Date(100, 0, 1)), new OutputConversionFailureCase("Bytes", new Date(100, 0, 1)), new EqualityTestCase("Date", new Date(100, 0, 1)), new EqualityTestCase("Date", new Date(-1, 0, 1)), (ConversionTestCase)new EqualityTestCase("Date", new Date(-901, 0, 1)).knownBug("PTS1111441 PTS1111442"), new OutputConversionFailureCase("Double", new Date(100, 0, 1)), new OutputConversionFailureCase("Float", new Date(100, 0, 1)), new OutputConversionFailureCase("Int", new Date(100, 0, 1)), new OutputConversionFailureCase("Long", new Date(100, 0, 1)), new EqualityTestCase("Ref", null).setFetchException(JDBCDriverExceptionClass), new OutputConversionFailureCase("Short", new Date(100, 0, 1)), new EqualityTestCase("String", new Date(100, 0, 1), "2000-01-01"), new EqualityTestCase("String", new Date(-1, 0, 1), "1899-01-01"), new EqualityTestCase("String", new Date(-901, 0, 1), "0999-01-01"), new OutputConversionFailureCase("Time", new Date(100, 0, 1)), new EqualityTestCase("Timestamp", new Timestamp(100, 0, 1, 0, 0, 0, 0))};

    public DateTest(String[] stringArray) throws SQLException {
        super(optdesc, help, stringArray);
    }

    public DateTest(Test test) throws SQLException {
        super(test);
        this.options.addExtraOptions(optdesc);
    }

    protected ConversionTestCase[] getInputTestCases() {
        return this.insertTests;
    }

    protected ConversionTestCase[] getFetchTestCases() {
        return this.fetchTests;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] stringArray) throws SQLException {
        DateTest dateTest = new DateTest(stringArray);
        try {
            dateTest.runInner();
        }
        finally {
            dateTest.connection.close();
        }
        if (dateTest.log.hasErrors()) {
            System.exit(5);
        }
    }
}

