/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dbtechtest.jdbc.statement;

import com.sap.dbtechtest.util.options.OptionDesc;
import com.sap.dbtechtest.util.testdriver.Test;
import com.sap.dbtechtest.xlog.Failure;
import java.sql.SQLException;

public class ResultCount
extends Test {
    private static final String help = "Test that the big decimal scale is correctly set.";
    private static final OptionDesc[] optdesc = new OptionDesc[0];

    public ResultCount(String[] stringArray) throws SQLException {
        super(optdesc, help, stringArray);
    }

    public ResultCount(Test test) throws SQLException {
        super(test);
    }

    public void testRun() throws SQLException {
        String string = this.getUnicodeIdentifier("RSCOUNTTEST");
        this.dropTable(string);
        int n = this.stmt.executeUpdate("CREATE TABLE " + string + " (A INTEGER)");
        if (n != 0) {
            this.log.addFailure(new Failure("Expected result count of 0, got " + n));
        }
        this.stmt.execute("INSERT INTO " + string + " VALUES(1)");
        this.stmt.execute("INSERT INTO " + string + " VALUES(2)");
        this.stmt.execute("INSERT INTO " + string + " VALUES(3)");
        n = this.stmt.executeUpdate("UPDATE " + string + " SET A=17");
        if (n != 3) {
            this.log.addFailure(new Failure("Expected result count of 3, got " + n));
        }
        for (int i = 0; i < 1000; ++i) {
            this.stmt.execute("INSERT INTO " + string + " VALUES(" + i + ")");
        }
        n = this.stmt.executeUpdate("DELETE FROM " + string);
        if (n != -1 && n != 1003) {
            this.log.addFailure(new Failure("Expected result count of -1, got " + n));
        }
        this.connection.commit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] stringArray) throws SQLException {
        ResultCount resultCount = new ResultCount(stringArray);
        try {
            resultCount.runInner();
        }
        finally {
            resultCount.connection.close();
        }
        if (resultCount.log.hasErrors()) {
            System.exit(5);
        }
    }
}

