/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dbtechtest.jdbc.statement;

import com.sap.dbtechtest.util.options.OptionDesc;
import com.sap.dbtechtest.util.testdriver.Test;
import com.sap.dbtechtest.xlog.Failure;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

public class MassBlobUpdate
extends Test {
    private static final String help = "help for MassBlobUpdate";
    private static final OptionDesc[] optdesc = new OptionDesc[0];

    public MassBlobUpdate(String[] stringArray) throws SQLException {
        super(optdesc, help, stringArray);
    }

    public MassBlobUpdate(Test test) throws SQLException {
        super(test);
    }

    public void testRun() throws SQLException {
        if (!this.checkVersion("7.6.0")) {
            return;
        }
        String string = "MassBlobUpdate";
        String string2 = this.getUnicodeIdentifier(string);
        this.dropTable(string2);
        this.stmt.execute("CREATE TABLE " + string2 + " ( k int, l1 long,  l2 longfile,  t3 longfile,  t4 long,  I int)");
        String string3 = this.makeRandomString(16384);
        this.stmt.execute("Insert into " + string2 + " values (1, NULL, NULL, NULL, NULL, 1)");
        this.stmt.execute("Insert into " + string2 + " values (2, 'kurzer l1-long', 'kurzer l2-long', 'kurzer l3-long', 'kurzer l4-long', 2)");
        this.stmt.execute("Insert into " + string2 + " values (3, 'auch noch kurzer l1-long', 'auch noch kurzer l2-long', 'auch noch kurzer l3-long', 'auch noch kurzer l4-long', 3)");
        PreparedStatement preparedStatement = this.connection.prepareStatement("Insert into " + string2 + " values (4, ?, ?, ?, ?, 4) ");
        preparedStatement.setString(1, string3);
        preparedStatement.setString(2, string3);
        preparedStatement.setString(3, string3);
        preparedStatement.setString(4, string3);
        preparedStatement.execute();
        ResultSet resultSet = this.stmt.executeQuery("Select * from " + string2);
        this.log.addDifference(string, "Fetch next", Boolean.TRUE, new Boolean(resultSet.next()));
        this.checkLong(string, null, resultSet.getString("l1"));
        this.checkLong(string, null, resultSet.getString("l2"));
        this.checkLong(string, null, resultSet.getString("t3"));
        this.checkLong(string, null, resultSet.getString("t4"));
        this.log.addDifference(string, "Fetch next", Boolean.TRUE, new Boolean(resultSet.next()));
        this.checkLong(string, "kurzer l1-long", resultSet.getString("l1"));
        this.checkLong(string, "kurzer l2-long", resultSet.getString("l2"));
        this.checkLong(string, "kurzer l3-long", resultSet.getString("t3"));
        this.checkLong(string, "kurzer l4-long", resultSet.getString("t4"));
        this.log.addDifference(string, "Fetch next", Boolean.TRUE, new Boolean(resultSet.next()));
        this.checkLong(string, "auch noch kurzer l1-long", resultSet.getString("l1"));
        this.checkLong(string, "auch noch kurzer l2-long", resultSet.getString("l2"));
        this.checkLong(string, "auch noch kurzer l3-long", resultSet.getString("t3"));
        this.checkLong(string, "auch noch kurzer l4-long", resultSet.getString("t4"));
        this.log.addDifference(string, "Fetch next", Boolean.TRUE, new Boolean(resultSet.next()));
        this.checkLong(string, string3, resultSet.getString("l1"));
        this.checkLong(string, string3, resultSet.getString("l2"));
        this.checkLong(string, string3, resultSet.getString("t3"));
        this.checkLong(string, string3, resultSet.getString("t4"));
        String string4 = this.makeRandomString(42);
        String string5 = this.makeRandomString(200000);
        preparedStatement = this.connection.prepareStatement("Update " + string2 + " set l1 = ?,t4 = ?, t3= ?");
        preparedStatement.setString(1, string4);
        preparedStatement.setString(2, string4);
        preparedStatement.setString(3, string5);
        preparedStatement.execute();
        resultSet = this.stmt.executeQuery("Select * from " + string2);
        for (int i = 0; i < 4; ++i) {
            this.log.addDifference(string, "Fetch next", Boolean.TRUE, new Boolean(resultSet.next()));
            this.checkLong(string, string4, resultSet.getString("l1"));
            this.checkLong(string, string4, resultSet.getString("t4"));
            this.checkLong(string, string5, resultSet.getString("t3"));
        }
    }

    private void checkLong(String string, String string2, String string3) throws SQLException {
        int n = 10;
        if (string3 == null) {
            if (string2 == null) {
                return;
            }
            this.log.addFailure(new Failure(string, "retrieved value is null"));
        }
        this.log.addDifference(string, "Size of values must be equal", new Integer(string2.length()), new Integer(string3.length()));
        for (int i = 0; i < string2.length(); ++i) {
            if (string2.charAt(i) != string3.charAt(i)) {
                --n;
                this.log.addDifference(string, "Check content at pos: " + i, new Character(string2.charAt(i)), new Character(string3.charAt(i)));
            }
            if (n > 0) continue;
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] stringArray) throws SQLException {
        MassBlobUpdate massBlobUpdate = new MassBlobUpdate(stringArray);
        try {
            massBlobUpdate.runInner();
        }
        finally {
            massBlobUpdate.connection.close();
        }
        if (massBlobUpdate.log.hasErrors()) {
            System.exit(5);
        }
    }
}

