/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dbtechtest.jdbc.resultset;

import com.sap.dbtechtest.util.options.OptionDesc;
import com.sap.dbtechtest.util.testdriver.Test;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Time;

public class UpdatableResultSetbyName
extends Test {
    private static final String help = "help for UpdatableResultSetSapDB";
    private static final OptionDesc[] optdesc = new OptionDesc[0];

    public UpdatableResultSetbyName(String[] stringArray) throws SQLException {
        super(optdesc, help, stringArray);
    }

    public UpdatableResultSetbyName(Test test) throws SQLException {
        super(test);
    }

    public void testRun() throws SQLException {
        String string = "UpdatableResultSetSapDB";
        String string2 = this.getUnicodeIdentifier(string);
        this.dropTable(string2);
        this.stmt.execute("CREATE TABLE \"Countries\"(CountryNb       INTEGER,\"CountryName\" CHAR(70),\"Reisedatum\"  Date,\"Reisezeit\"   Time,\"LongVal\" VARCHAR(30))");
        this.stmt.execute("Insert into " + string2 + " values (1,'Berlin','2002-04-03', '11:04:40.000','abc')");
        Statement statement = this.connection.createStatement(1005, 1008);
        ResultSet resultSet = statement.executeQuery("Select * from " + string2 + "");
        resultSet.next();
        resultSet.updateString("LongVal", "LongVal");
        resultSet.updateInt("CountryNb", 2);
        resultSet.updateString("CountryName", "Hamburg");
        resultSet.updateTime("Reisezeit", new Time(System.currentTimeMillis()));
        resultSet.updateDate("Reisedatum", new Date(System.currentTimeMillis()));
        resultSet.updateRow();
        this.connection.commit();
        resultSet = statement.executeQuery("Select * from " + string2 + "");
        resultSet.next();
        this.log.addDifference(string, "Check updated values", new String("Hamburg"), resultSet.getString("CountryName"));
        this.log.addDifference(string, "Check updated values", new String("LongVal"), resultSet.getString("LongVal"));
        this.log.addDifference(string, "Check updated values", new Integer(2), new Integer(resultSet.getInt("CountryNb")));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] stringArray) throws SQLException {
        UpdatableResultSetbyName updatableResultSetbyName = new UpdatableResultSetbyName(stringArray);
        try {
            updatableResultSetbyName.runInner();
        }
        finally {
            updatableResultSetbyName.connection.close();
        }
        if (updatableResultSetbyName.log.hasErrors()) {
            System.exit(5);
        }
    }
}

