/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dbtechtest.jdbc.resultset;

import com.sap.dbtechtest.util.options.OptionDesc;
import com.sap.dbtechtest.util.testdriver.Test;
import com.sap.dbtechtest.xlog.Failure;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

public class SelectForUpdate3
extends Test {
    private static final String help = "Test that the big decimal scale is correctly set.";
    private static final OptionDesc[] optdesc = new OptionDesc[0];

    public SelectForUpdate3(String[] stringArray) throws SQLException {
        super(optdesc, help, stringArray);
    }

    public SelectForUpdate3(Test test) throws SQLException {
        super(test);
    }

    public void testRun() throws SQLException {
        String string = "TEST_NONUPDATABLE";
        String string2 = this.getUnicodeIdentifier(string);
        this.dropTable(string2);
        String string3 = "CREATE TABLE " + string2 + " ( ID   FIXED (10,0)  DEFAULT  SERIAL (1), DATA VARCHAR(40))";
        this.stmt.execute(string3);
        this.stmt.execute("INSERT INTO " + string2 + " (DATA) VALUES ('AAA')");
        Statement statement = this.connection.createStatement(1005, 1008);
        ResultSet resultSet = statement.executeQuery("SELECT * FROM " + string2 + "");
        resultSet.last();
        String string4 = resultSet.getString(2);
        if (!string4.equals("AAA")) {
            this.log.addFailure(new Failure("Test setup failed."));
        }
        resultSet.updateString(2, "NEW VALUE");
        resultSet.updateRow();
        resultSet.refreshRow();
        resultSet.last();
        if (!resultSet.getString(2).equals("NEW VALUE")) {
            this.log.addFailure(new Failure("Updated row not found."));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] stringArray) throws SQLException {
        SelectForUpdate3 selectForUpdate3 = new SelectForUpdate3(stringArray);
        try {
            selectForUpdate3.runInner();
        }
        finally {
            selectForUpdate3.connection.close();
        }
        if (selectForUpdate3.log.hasErrors()) {
            System.exit(5);
        }
    }
}

