/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dbtechtest.jdbc.resultset;

import com.sap.dbtechtest.util.options.OptionDesc;
import com.sap.dbtechtest.util.testdriver.Test;
import com.sap.dbtechtest.xlog.Failure;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;

public class FetchForward
extends Test {
    private static final String help = "help for FetchForward";
    private static final OptionDesc[] optdesc = new OptionDesc[0];

    public FetchForward(String[] stringArray) throws SQLException {
        super(optdesc, help, stringArray);
    }

    public FetchForward(Test test) throws SQLException {
        super(test);
    }

    public void testRun() throws SQLException {
        boolean bl;
        if (!this.checkVersion("7.6.0")) {
            return;
        }
        String string = "FetchForward";
        String string2 = this.getUnicodeIdentifier(string);
        this.dropTable(string2);
        int n = 800;
        int n2 = 0;
        try {
            n2 = this.getDBParameterAsInt("PACKET_SIZE") + 1;
        }
        catch (SQLException sQLException) {
            n2 = this.getDBParameterAsInt("_PACKET_SIZE") + 1;
        }
        int n3 = n2 / n;
        this.stmt.execute("CREATE TABLE " + string2 + " (a varchar (" + n + "))");
        PreparedStatement preparedStatement = this.connection.prepareStatement("insert into " + string2 + " values (?)");
        for (int i = 0; i < n3; ++i) {
            preparedStatement.setString(1, String.valueOf(i));
            preparedStatement.addBatch();
        }
        preparedStatement.executeBatch();
        this.connection.commit();
        preparedStatement = this.connection.prepareStatement("Select A from " + string2);
        ResultSet resultSet = preparedStatement.executeQuery();
        for (int i = 0; i < n3; ++i) {
            bl = resultSet.next();
            this.log.addDifference(string, "Fetch Next", Boolean.TRUE, bl);
            this.log.addDifference(string, "Check value", new Integer(i), new Integer(resultSet.getInt(1)));
        }
        this.log.addDifference(string, "Fetch Next after \"Row not found\"", Boolean.FALSE, resultSet.next());
        try {
            resultSet.first();
            this.log.addFailure(new Failure(string, "Expected Exception not occured"));
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        try {
            resultSet.last();
            this.log.addFailure(new Failure(string, "Expected Exception not occured"));
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        try {
            resultSet.absolute(1);
            this.log.addFailure(new Failure(string, "Expected Exception not occured"));
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        try {
            resultSet.relative(1);
            this.log.addFailure(new Failure(string, "Expected Exception not occured"));
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        try {
            resultSet.relative(-1);
            this.log.addFailure(new Failure(string, "Expected Exception not occured"));
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        try {
            resultSet.previous();
            this.log.addFailure(new Failure(string, "Expected Exception not occured"));
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        resultSet.close();
        this.connection.isClosed();
        this.connection.isClosed();
        preparedStatement = this.connection.prepareStatement("Select A from " + string2);
        resultSet = preparedStatement.executeQuery();
        for (int i = 0; i < n2 / n; ++i) {
            bl = resultSet.next();
            this.log.addDifference(string, "Fetch Next", Boolean.TRUE, bl);
            this.log.addDifference(string, "Check value", new Integer(i), new Integer(resultSet.getInt(1)));
        }
        String string3 = resultSet.getCursorName();
        Statement statement = this.connection.createStatement();
        ResultSet resultSet2 = statement.executeQuery("SELECT tablename FROM domain.tables WHERE tabletype = 'RESULT' AND tablename = '" + string3 + "'");
        this.log.addDifference(string, "1. the cursor " + string3 + " should be already closed", Boolean.FALSE, resultSet2.next());
        resultSet.close();
        this.connection.isClosed();
        this.connection.isClosed();
        resultSet2 = statement.executeQuery("SELECT tablename FROM domain.tables WHERE tabletype = 'RESULT' AND tablename = '" + string3 + "'");
        this.log.addDifference(string, "2. the cursor " + string3 + " should be already closed", Boolean.FALSE, resultSet2.next());
        ResultSetMetaData resultSetMetaData = resultSet2.getMetaData();
        System.out.println("colcnt: " + resultSetMetaData.getColumnCount());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] stringArray) throws SQLException {
        FetchForward fetchForward = new FetchForward(stringArray);
        try {
            fetchForward.runInner();
        }
        finally {
            fetchForward.connection.close();
        }
        if (fetchForward.log.hasErrors()) {
            System.exit(5);
        }
    }
}

