/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dbtechtest.jdbc.rest;

import com.sap.dbtech.util.MessageTranslator;
import com.sap.dbtechtest.util.options.OptionDesc;
import com.sap.dbtechtest.util.testdriver.Test;
import java.lang.reflect.Field;
import java.sql.SQLException;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class LocalizedMessages
extends Test {
    private static final String help = "Test that tests for localisation.";
    private static final OptionDesc[] optdesc = new OptionDesc[0];
    private boolean debug = false;
    private String[][] locales = new String[][]{{"en", "US"}, {"de", "DE"}};
    static /* synthetic */ Class class$com$sap$dbtech$util$MessageKey;

    public LocalizedMessages(String[] stringArray) throws SQLException {
        super(optdesc, help, stringArray);
    }

    public LocalizedMessages(Test test) throws SQLException {
        super(test);
    }

    public void testRun() throws SQLException {
        int n;
        for (n = 0; n < this.locales.length; ++n) {
            this.checkLocalePresent(this.locales[n]);
        }
        for (n = 0; n < this.locales.length; ++n) {
            this.checkLocaleComplete(this.locales[n]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkLocalePresent(String[] stringArray) throws SQLException {
        Locale locale = Locale.getDefault();
        Locale locale2 = new Locale(stringArray[0], stringArray[1]);
        String string = stringArray[0] + "_" + stringArray[1];
        if (this.debug) {
            System.err.println("Checking presence of locale " + string + ".");
        }
        try {
            Locale.setDefault(locale2);
            String string2 = MessageTranslator.translate((String)"sapdb.locale");
            if (!string2.equals(stringArray[0])) {
                if (this.debug) {
                    System.err.println("sapdb.locale was looked up as '" + string2 + "', but should be '" + string + "'");
                }
                throw new SQLException("sapdb.locale was looked up as '" + string2 + "', but should be '" + string + "'");
            }
        }
        finally {
            Locale.setDefault(locale);
        }
    }

    public void checkLocaleComplete(String[] stringArray) throws SQLException {
        Locale locale = Locale.getDefault();
        Locale locale2 = new Locale(stringArray[0], stringArray[1]);
        String string = stringArray[0] + "_" + stringArray[1];
        boolean bl = false;
        StringBuffer stringBuffer = new StringBuffer();
        if (this.debug) {
            System.err.println("Checking key completeness of locale " + string + ".");
        }
        try {
            Locale.setDefault(locale2);
            Field[] fieldArray = (class$com$sap$dbtech$util$MessageKey == null ? (class$com$sap$dbtech$util$MessageKey = LocalizedMessages.class$("com.sap.dbtech.util.MessageKey")) : class$com$sap$dbtech$util$MessageKey).getFields();
            ResourceBundle resourceBundle = MessageTranslator.getMessages();
            if (this.debug) {
                System.err.println("Checking " + fieldArray.length + " messages.");
            }
            for (int i = 0; i < fieldArray.length; ++i) {
                try {
                    String string2 = resourceBundle.getString((String)fieldArray[i].get(null));
                    continue;
                }
                catch (MissingResourceException missingResourceException) {
                    String string3 = "Field " + fieldArray[i].getName() + " with value " + fieldArray[i].get(null) + " was not found for locale " + string + ".";
                    if (this.debug) {
                        System.err.println(string3);
                    }
                    stringBuffer.append(string3);
                    stringBuffer.append("\n");
                    bl = true;
                }
            }
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new SQLException(illegalAccessException.getMessage());
        }
        finally {
            Locale.setDefault(locale);
        }
        if (bl) {
            throw new SQLException(stringBuffer.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] stringArray) throws SQLException {
        stringArray = Test.addOptions(stringArray, new String[]{"-P:cache=all?"});
        LocalizedMessages localizedMessages = new LocalizedMessages(stringArray);
        try {
            localizedMessages.runInner();
        }
        finally {
            localizedMessages.connection.close();
        }
        if (localizedMessages.log.hasErrors()) {
            System.exit(5);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

