/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dbtechtest.jdbc.prepared;

import com.sap.dbtechtest.util.options.OptionDesc;
import com.sap.dbtechtest.util.testdriver.Test;
import java.sql.CallableStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

public class DBProcWithLongParameters
extends Test {
    private static final String help = "help for DBProcWithLongParameters";
    private static final OptionDesc[] optdesc = new OptionDesc[0];

    public DBProcWithLongParameters(String[] stringArray) throws SQLException {
        super(optdesc, help, stringArray);
    }

    public DBProcWithLongParameters(Test test) throws SQLException {
        super(test);
    }

    public void testRun() throws SQLException {
        String string = "DBProcWithLongParameters";
        if (!this.checkVersion("7.6.0")) {
            return;
        }
        String string2 = this.getUnicodeIdentifier("DBProcWithLongs1");
        String string3 = this.getUnicodeIdentifier("DBProcWithLongs2");
        this.dropTable(string2);
        this.dropTable(string3);
        try {
            this.stmt.execute("DROP DBPROC " + string2);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.stmt.execute("CREATE TABLE " + string2 + " ( i int PRIMARY KEY, l1 long, l2 long , l3 long , l4 long)");
        this.stmt.execute("CREATE TABLE " + string3 + " ( i int PRIMARY KEY, l1 long, l2 long )");
        this.stmt.execute("create DBPROC " + string2 + " ( IN i int, IN l1 LONG, IN l2 LONG, IN l3 LONG, IN l4 LONG) AS " + " VAR ix2 INTEGER; " + " insert into " + this.getUsername() + "." + string2 + " set \ti = :i, " + "\t\tl1 = :l1, " + "\t\tl2 = :l2, " + "\t\tl3 = :l3, " + "\t\tl4 = :l4; ");
        CallableStatement callableStatement = this.connection.prepareCall("CALL " + string2 + " ( ?, ?, ?, ?, ?)");
        callableStatement.setInt(1, 1);
        callableStatement.setString(2, "ANGUS DAS FRETTCHEN");
        callableStatement.setString(3, "CLAY");
        callableStatement.setString(4, "ANGUS DAS FRETTCHEN");
        callableStatement.setString(5, "CLAY");
        callableStatement.execute();
        this.connection.commit();
        ResultSet resultSet = this.stmt.executeQuery("SELECT * from " + string2);
        this.log.addDifference(string, "check fetch next", Boolean.TRUE, new Boolean(resultSet.next()));
        this.log.addDifference(string, "check col1", new Integer(1), new Integer(resultSet.getInt(1)));
        this.log.addDifference(string, "check col2", "ANGUS DAS FRETTCHEN", resultSet.getString(2));
        this.log.addDifference(string, "check col3", "CLAY", resultSet.getString(3));
        this.log.addDifference(string, "check col4", "ANGUS DAS FRETTCHEN", resultSet.getString(4));
        this.log.addDifference(string, "check col5", "CLAY", resultSet.getString(5));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] stringArray) throws SQLException {
        DBProcWithLongParameters dBProcWithLongParameters = new DBProcWithLongParameters(stringArray);
        try {
            dBProcWithLongParameters.runInner();
        }
        finally {
            dBProcWithLongParameters.connection.close();
        }
        if (dBProcWithLongParameters.log.hasErrors()) {
            System.exit(5);
        }
    }
}

