/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dbtechtest.jdbc.connection;

import com.sap.dbtech.util.Tracer;
import com.sap.dbtechtest.util.options.OptionDesc;
import com.sap.dbtechtest.util.testdriver.Test;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

public class RowExclusiveLock
extends Test {
    private Statement stmt2;
    public final Thread myThread = new Thread(){

        public void run() {
            try {
                System.out.println("\nCONNECTION 2 EXECUTE \"SELECT * FROM RowExclusiveLock WHERE a = 1\"");
                RowExclusiveLock.this.stmt2.executeQuery("SELECT * FROM RowExclusiveLock WHERE a = 1");
            }
            catch (SQLException sQLException) {
                sQLException.printStackTrace();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    };
    private static final String help = "help for RowExclusiveLock";
    private static final OptionDesc[] optdesc = new OptionDesc[0];

    public RowExclusiveLock(String[] stringArray) throws SQLException {
        super(optdesc, help, stringArray);
    }

    public RowExclusiveLock(Test test) throws SQLException {
        super(test);
    }

    public void testRun() throws SQLException {
        String string = "RowExclusiveLock";
        this.dropTable("RowExclusiveLock");
        System.out.println("CREATE TABLE RowExclusiveLock (a int , b char (6000))");
        this.stmt.execute("CREATE TABLE RowExclusiveLock (a int , b char (6000))");
        System.out.println("CREATE UNIQUE INDEX RowExclIndex ON RowExclusiveLock (a)");
        this.stmt.execute("CREATE UNIQUE INDEX RowExclIndex ON RowExclusiveLock (a)");
        System.out.println("INSERT into RowExclusiveLock values (1 -1000, 'abc')");
        PreparedStatement preparedStatement = this.connection.prepareStatement("INSERT into RowExclusiveLock values (?, 'abc')");
        for (int i = 1; i <= 1000; ++i) {
            preparedStatement.setInt(1, i);
            preparedStatement.addBatch();
        }
        preparedStatement.executeBatch();
        System.out.println("Update RowExclusiveLock set b = rfill(b,'x',6000)");
        this.stmt.executeUpdate("Update RowExclusiveLock set b = rfill(b,'x',6000)");
        this.stmt.executeUpdate("Update Statistics RowExclusiveLock");
        System.out.println("COMMIT");
        this.connection.commit();
        Connection connection = this.connect();
        Statement statement = connection.createStatement();
        Connection connection2 = this.connect();
        this.stmt2 = connection2.createStatement();
        System.out.println("\nCONNECTION 1 EXECUTE \"UPDATE RowExclusiveLock SET b = 'xyz' WHERE a = 1\"");
        statement.executeUpdate("UPDATE RowExclusiveLock SET b = 'xyz' WHERE a = 1");
        this.CheckLocks("CHECKING Locks after Update on CONNECTION 1");
        this.myThread.start();
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        System.out.println("\nCONNECTION 1 EXECUTE \"COMMIT\"");
        connection.commit();
        if (this.CheckLocks("CHECKING Locks after Commit on CONNECTION 1")) {
            System.out.println("\nTest unsuccessfully: no locks should exist");
        } else {
            System.out.println("\nTest successfully");
        }
    }

    private boolean CheckLocks(String string) throws SQLException {
        boolean bl = false;
        Tracer.dumpLocks((Connection)this.connection);
        System.out.println("\n" + string);
        ResultSet resultSet = this.stmt.executeQuery("SELECT TABLENAME, TABLEID, LOCKMODE, ROWIDHEX, ROWID FROM LOCKS");
        if (resultSet.next()) {
            bl = true;
            System.out.println("TABLENAME        |   TABLEID  |  LOCKMODE |  ROWIDHEX |  ROWID");
            do {
                System.out.println(resultSet.getString(1) + " | " + this.printasHex(resultSet.getBytes(2)) + " | " + resultSet.getString(3) + " | " + this.printasHex(resultSet.getBytes(4)) + " | " + resultSet.getString(5));
            } while (resultSet.next());
        } else {
            System.out.println("no locks found");
        }
        resultSet.close();
        this.connection.commit();
        return bl;
    }

    public String printasHex(byte[] byArray) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < byArray.length; ++i) {
            stringBuffer.append(Integer.toString(byArray[i] & 0xFF, 16));
        }
        return stringBuffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] stringArray) throws SQLException {
        RowExclusiveLock rowExclusiveLock = new RowExclusiveLock(stringArray);
        try {
            rowExclusiveLock.runInner();
        }
        finally {
            rowExclusiveLock.connection.close();
        }
        if (rowExclusiveLock.log.hasErrors()) {
            System.exit(5);
        }
    }
}

